<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}




// echo shortcode content for listing pages
function citybook_addons_filter_the_content_callback($content){
    global $post;
    if(is_admin()) return $content;

    $submit_page_id = citybook_addons_get_option('submit_page');
    $edit_page_id = citybook_addons_get_option('edit_page');
    $dashboard_page_id = citybook_addons_get_option('dashboard_page');
    $payment_page_id = citybook_addons_get_option('payment_page');

    $checkout_page_id = citybook_addons_get_option('checkout_page');


    // $current_user = wp_get_current_user();


    
    switch ($post->ID) {
        case $submit_page_id:
            return citybook_addons_get_template_part('shortcodes/submit') . $content;
            break;
        case $edit_page_id:
            return citybook_addons_get_template_part('shortcodes/edit') . $content;
            break;
        case $dashboard_page_id:

            return citybook_addons_get_template_part('shortcodes/dashboard') . $content;
            break;
        case $payment_page_id:
            return citybook_addons_get_template_part('shortcodes/payment') . $content;
            break;
        case $checkout_page_id:
            return citybook_addons_get_template_part('shortcodes/checkout') . $content;
            break;
        default:
            return $content;
            break;
    }
    // var_dump($submit_page_id);
    // var_dump($edit_page_id);
    // if($post->ID == $submit_page_id) {
    //     return citybook_addons_get_template_part('shortcodes/submit');
    // }else{
    //     return $content;
    // }

    
}

// add_filter( 'the_content', 'citybook_addons_filter_the_content_callback' , 99 );

// redirect page for dashboard
function citybook_addons_dashboard_page_template_redirect()
{
    $dashboard_page_id = citybook_addons_get_option('dashboard_page');
    $edit_page_id = citybook_addons_get_option('edit_page');
    $submit_page_id = citybook_addons_get_option('submit_page');
    $checkout_page_id = citybook_addons_get_option('checkout_page');
    
    // if( is_page( $dashboard_page_id ) && ! is_user_logged_in() )
    if( ($dashboard_page_id && is_page( $dashboard_page_id )) || ($checkout_page_id && is_page( $checkout_page_id )) )
    {
        if (! is_user_logged_in()) {
            wp_redirect( home_url( '/' ) );
            die;
        }
            
    }elseif($edit_page_id && is_page($edit_page_id)){
        $listing_id = get_query_var('listing_id');
        if( ($listing_id == '' || !is_numeric($listing_id)) || ! current_user_can( 'edit_post' , $listing_id ) ){
            wp_redirect( home_url( '/' ) );
            die;
        }
    }elseif($submit_page_id && is_page($submit_page_id)){
        if( !citybook_addons_current_user_can('submit_listing') ){
            // wp_die(__( "You don't have permission to submit a listing. Please consider being a Listing Author or extend your membership subscription.<br>Contact us for more details.", 'citybook-add-ons' ));

            wp_redirect( home_url( '/' ) );
            die;
        }
    }
    // elseif(is_singular( 'listing' )){ // redirect to home page for expired listing
    //     global $post;
        
    //     wp_redirect( home_url( '/' ) );
    //     die;
    // }
}
add_action( 'template_redirect', 'citybook_addons_dashboard_page_template_redirect' );

add_action( 'wp_footer', function(){
    $dashboard_page_id = citybook_addons_get_option('dashboard_page');
    if( $dashboard_page_id && is_page( $dashboard_page_id ) ){
        $dashboard = get_query_var('dashboard');

        if($dashboard == 'messages') citybook_addons_get_template_part('shortcodes/tmpls-reply-msg-modal');
        if($dashboard == 'invoices') citybook_addons_get_template_part('shortcodes/tmpls-view-invoice-modal');
        if($dashboard == 'ads') citybook_addons_get_template_part('shortcodes/tmpls-new-campaign-modal');

    }
    if(is_singular('listing')){
        citybook_addons_get_template_part('shortcodes/tmpls-reply-msg-modal');
    }
} );

/*
https://wordpress.stackexchange.com/questions/192360/current-user-can-edit-post-post-id-does-not-work-for-contributer-but-for
https://codex.wordpress.org/Function_Reference/map_meta_cap
https://developer.wordpress.org/reference/hooks/map_meta_cap/
https://wordpress.stackexchange.com/questions/108338/capabilities-and-custom-post-types
https://wordpress.stackexchange.com/questions/65418/admins-cant-edit-each-others-posts
*/
function citybook_addons_map_meta_cap( $caps, $cap, $user_id, $args ){
    if ( 'edit_post' == $cap ) {
        $post = get_post( $args[0] );
        $post_type = get_post_type_object( $post->post_type );
        $caps = array();
        if ( $user_id == $post->post_author )
            $caps[] = $post_type->cap->edit_posts;
        else
            $caps[] = $post_type->cap->edit_others_posts;
    }
    return $caps;
}
add_filter( 'map_meta_cap', 'citybook_addons_map_meta_cap', 10, 4 );



function citybook_addons_maintenance_mode() {
    global $pagenow;
    $mode = citybook_addons_get_option('maintenance_mode');
    $demo_mode = isset($_GET['demo_mode'])? $_GET['demo_mode'] : '';
    if ( $pagenow !== 'wp-login.php' && ! current_user_can( 'manage_options' ) && ! is_admin() && ($mode == 'maintenance'||$mode=='coming_soon'||$demo_mode =='maintenance'||$demo_mode =='coming_soon') ) {
        // wp_redirect( home_url( ) );// redirect to home page first
        header( $_SERVER["SERVER_PROTOCOL"] . __( ' 503 Service Temporarily Unavailable', 'citybook-add-ons' ), true, 503 );
        header( 'Content-Type: text/html; charset=utf-8' );
        if($mode == 'coming_soon'||$demo_mode =='coming_soon'){
            citybook_addons_get_template_part('templates/coming_soon');
        }else{
            header( 'Retry-After: 3600' );
            citybook_addons_get_template_part('templates/maintenance');
        } 
        die();
    }
}

add_action( 'wp_loaded', 'citybook_addons_maintenance_mode' );

if(!function_exists('citybook_addons_login_logout_sc')){
    function citybook_addons_login_logout_sc($atts, $content = ''){

        extract(shortcode_atts(array(
               'show_register' =>esc_html_x( 'no', 'Show register button: yes or no', 'citybook-add-ons' ),
               'show_register_when_logged_in'=>'no',
               'style'=>'two',
               'extraclass'=>''
         ), $atts));

        

        ob_start();
        // check if the user already login - the correct way is using is_user_logged_in()
        $current_user = wp_get_current_user();
        if ( 0 == $current_user->ID ) {
            // Not logged in.
            ?>
            <?php if($show_register == 'yes'){ ?>
            <div class="show-reg-form logreg-modal-open"><?php _e('<i class="fa fa-lock"></i>Register','citybook-add-ons');?></div>
            <?php } ?>
            <div class="show-reg-form logreg-modal-open"><?php _e('<i class="fa fa-sign-in"></i>Sign In','citybook-add-ons');?></div>
        <?php
        } else {
            // Logged in.
            $dashboard_page_id = citybook_addons_get_option('dashboard_page');
            ?>
            <div class="header-user-menu user-menu-<?php echo $style;?>">
                <div class="header-user-name user-name-<?php echo $style;?>">
                    <span class="au-avatar"><?php 
                        echo get_avatar($current_user->user_email,'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', $current_user->display_name );
                    ?></span>
                    <?php if($style != 'two'): ?>
                    <span class="au-name"><?php echo esc_html__( 'Hello , ',  'citybook-add-ons' ) . $current_user->display_name ; ?></span>
                    <?php endif; ?>
                </div>
                <ul>
                    <?php if($style == 'two'): 
                        global $wp_roles;
                        $role = array_shift($current_user->roles);
                    ?>
                    <li><div class="au-name-li">
                        <h2 class="au-name"><?php echo esc_html__( 'Hello , ',  'citybook-add-ons' ) . $current_user->display_name ; ?></h2>
                        <div class="au-role"><?php echo $wp_roles->roles[$role]['name'] ; ?></div>
                    </div></li>
                    <?php endif; ?>
                    <li><a href="<?php echo get_permalink( $dashboard_page_id );?>"><?php _e( 'Dashboard', 'citybook-add-ons' );?></a></li>
                <?php if( citybook_addons_current_user_can('view_listings_dashboard') ): ?>
                    <li><a href="<?php echo citybook_addons_get_submit_link();?>"><?php _e( 'Add Listing', 'citybook-add-ons' );?></a></li>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookings';?>"><?php _e( 'Bookings', 'citybook-add-ons' );?></a></li>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=reviews';?>"><?php _e( 'Reviews', 'citybook-add-ons' );?></a></li>
                <?php else : ?>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=bookings';?>"><?php _e( 'Bookings', 'citybook-add-ons' );?></a></li>
                    <li><a href="<?php echo get_the_permalink( $dashboard_page_id ).'?dashboard=messages';?>"><?php _e( 'Messages', 'citybook-add-ons' );?></a></li>
                <?php endif; ?>
                    <li><a href="<?php echo wp_logout_url( citybook_addons_get_current_url() ); ?>"><?php _e('Log Out','citybook-add-ons');?></a></li>
                </ul>
            </div>
        <?php
        }
        $output = ob_get_clean();

        if ( 0 == $current_user->ID ) add_action( 'wp_footer', 'citybook_addons_print_login_modal' );

        return $output;

    }

    add_shortcode( 'citybook_login', 'citybook_addons_login_logout_sc' ); 
}

function citybook_addons_print_login_modal(){
    ?>
    <!--register form -->
    <div class="main-register-wrap ctb-modal" id="ctb-logreg-modal">
        <div class="main-overlay"></div>
        <div class="main-register-holder">
            <div class="main-register fl-wrap">
                <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
                <h3><?php _e( 'Sign In ', 'citybook-add-ons' );?><span><?php bloginfo( 'name' );?></span></h3>
                <div class="prelog-message"></div>
                <?php 
                $logreg_form_before = citybook_addons_get_option('logreg_form_before');
                if ( $logreg_form_before != '' ): ?>
                <div class="soc-log fl-wrap">
                    <?php echo do_shortcode( $logreg_form_before ); ?>
                </div>
                <?php 
                    _e( '<div class="log-separator fl-wrap"><span>or</span></div>', 'citybook-add-ons' );
                endif; ?>
                <div class="tabs-wrapper">

                    <ul class="tabs-menu">
                        <li class="tab-menu current"><a href="#tab-login"><?php _e( 'Login', 'citybook-add-ons' );?></a></li>
                        <li class="tab-menu"><a href="#tab-register"><?php _e( 'Register', 'citybook-add-ons' );?></a></li>
                    </ul>
                    <div class="tabs-content">
                        
                        <div id="tab-login" class="tab-content current">
                            <div class="custom-form clearfix">
                                <form method="post" id="citybook-login">
                                    <div class="log-message"></div>
                                    <label for="user_login"><?php _e( 'Username or Email Address * ', 'citybook-add-ons' );?></label>
                                    <input id="user_login" name="log" type="text" onClick="this.select()" value="" required>

                                    <label for="user_pass"><?php _e( 'Password * ', 'citybook-add-ons' );?></label>
                                    <input id="user_pass" name="pwd" type="password" onClick="this.select()" value="" required>

                                    <?php citybook_addons_display_recaptcha('loginCaptcha'); ?>

                                    <button type="submit" id="log-submit" class="log-submit-btn"><span><?php _e( 'Log In', 'citybook-add-ons' );?><i class="fa fa-spinner fa-pulse"></i></span></button>

                                    <div class="clearfix"></div>
                                    <div class="filter-tags">
                                        <input name="rememberme" id="rememberme" value="true" type="checkbox">
                                        <label for="rememberme"><?php _e('Remember me','citybook-add-ons');?></label>
                                    </div>
                                    <?php
                                        // this prevent automated script for unwanted spam
                                        if ( function_exists( 'wp_nonce_field' ) ) 
                                            wp_nonce_field( 'citybook-login', '_loginnonce' );
                                    ?>
                                    <?php 
                                    $login_redirect_page = citybook_addons_get_option('login_redirect_page');
                                    if($login_redirect_page != 'cth_current_page' && is_numeric($login_redirect_page) )
                                        $login_redirect_url = get_permalink( $login_redirect_page );
                                    else 
                                        $login_redirect_url = citybook_addons_get_current_url();

                                    ?>
                                    <input type="hidden" name="redirection" value="<?php echo $login_redirect_url; ?>" />
                                </form>
                                <div class="lost_password">
                                    <a class="lost-password" href="<?php echo wp_lostpassword_url( citybook_addons_get_current_url() ); ?>"><?php _e('Lost Your Password?','citybook-add-ons');?></a>
                                </div>
                            </div>
                        </div>
                        <!-- end tab-content -->
                        <div id="tab-register" class="tab-content">
                            <div class="custom-form">
                                <form method="post" class="main-register-form" id="citybook-register">
                                    <div class="reg-message"></div>

                                    <p><?php esc_html_e( 'Account details will be confirmed via email.', 'citybook-add-ons' ); ?></p>

                                    <label for="reg_username"><?php _e( 'Username *', 'citybook-add-ons' );?></label>
                                    <input id="reg_username" name="username" type="text"  onClick="this.select()" value="" required>

                                    <label for="reg_email"><?php _e( 'Email Address *', 'citybook-add-ons' );?></label>
                                    <input id="reg_email" name="email" type="email"  onClick="this.select()" value="" required>
                                    <?php if(citybook_addons_get_option('register_password') == 'yes'): ?>
                                    <label for="reg_password"><?php _e( 'Password *', 'citybook-add-ons' );?></label>
                                    <input id="reg_password" name="password" type="password" onClick="this.select()" value="" required>
                                    <?php endif; ?>
                                    <div class="terms_wrap">
                                        <?php if(citybook_addons_get_option('register_term_text') != ''): ?>
                                        <div class="filter-tags">
                                            <input id="accept_term" name="accept_term" value="1" type="checkbox" required="required">
                                            <label for="accept_term"><?php echo citybook_addons_get_option('register_term_text');?></label>
                                        </div>
                                        <?php endif; ?>
                                        <?php if(citybook_addons_get_option('register_consent_data_text') != ''): ?>
                                        <div class="filter-tags">
                                            <input id="consent_data" name="consent_data" value="1" type="checkbox" required="required">
                                            <label for="consent_data"><?php echo citybook_addons_get_option('register_consent_data_text');?></label>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="clearfix"></div>

                                    <?php citybook_addons_display_recaptcha('regCaptcha'); ?>
                                    
                                    <button type="submit" id="reg-submit" class="log-submit-btn"><span><?php _e( 'Register', 'citybook-add-ons' );?><i class="fa fa-spinner fa-pulse"></i></span></button>

                                    <?php
                                        // this prevent automated script for unwanted spam
                                        if ( function_exists( 'wp_nonce_field' ) ) 
                                            wp_nonce_field( 'citybook-register', '_regnonce' );
                                    ?>

                                    <input type="hidden" name="redirection" value="<?php echo citybook_addons_get_current_url(); ?>" />

                                </form>
                            </div>
                        </div>
                        <!-- end tab-content -->
                    </div>
                    <!-- end tabs-content -->
                </div>
                <!-- end tabs-wrapper -->

            </div>
        </div>
    </div>
    <!--register form end -->

    <div class="ctb-modal-wrap ctb-modal" id="ctb-resetpsw-modal">
        <div class="ctb-modal-holder">
            <div class="ctb-modal-inner">
                <div class="ctb-modal-close"><i class="fa fa-times"></i></div>
                <h3><?php _e( 'Reset <span>Your Password</span>', 'citybook-add-ons' );?></h3>
                <div class="ctb-modal-content">
                    
                    <form class="reset-password-form custom-form" action="#" method="post">
                        
                        <fieldset>
                            <label for="user_reset"><?php _e( 'Username or Email Address *', 'citybook-add-ons' );?></label>
                            <input id="user_reset" name="user_login" type="text"  value="" required>
                        </fieldset>
                        <input class="btn color-bg" type="submit" value="<?php esc_attr_e( 'Get New Password', 'citybook-add-ons' ); ?>">

                    </form>
                </div>
                <!-- end modal-content -->
            </div>
        </div>
    </div>
    <!-- end reset password modal --> 

    <?php
}


if(!function_exists('citybook_addons_submit_button_sc')){
    function citybook_addons_submit_button_sc($atts, $content = ''){

        if( !citybook_addons_current_user_can('submit_listing') && citybook_addons_get_option('always_show_submit') != 'yes' ) return;
        ob_start();
        ?>
        <a href="<?php echo citybook_addons_get_submit_link();?>" class="add-list"><?php _e( 'Add Listing <span><i class="fa fa-plus"></i></span>', 'citybook-add-ons' );?></a>
        <?php
        $output = ob_get_clean();
        return $output;

    }

    add_shortcode( 'citybook_submit_button', 'citybook_addons_submit_button_sc' ); 
}


if(!function_exists('citybook_addons_search_header_sc')){
    function citybook_addons_search_header_sc($atts, $content = ''){
        ob_start();
        ?>
        <div class="header-search vis-header-search">
            <form role="search" method="get" action="<?php echo esc_url(home_url( '/' ) ); ?>" class="list-search-header-form">
                <div class="header-search-input-item">
                    <input name="search_term" type="text" class="search" placeholder="<?php echo esc_attr__( 'Keywords','citybook-add-ons' ) ?>" value="<?php echo get_search_query() ?>"/>
                </div>
                <?php
                $listing_cats = citybook_addons_get_listing_categories(citybook_addons_get_option('search_cat_level'));
                $search_cats = array();
                if(isset($_GET['lcats'])&&is_array($_GET['lcats'])) $search_cats = array_filter($_GET['lcats']);
                ?>
                <div class="header-search-select-item">
                    <select data-placeholder="<?php esc_attr_e( 'All Categories',  'citybook-add-ons' );?>" class="chosen-select" name="lcats[]">
                        <option value=""><?php esc_html_e( 'All Categories',  'citybook-add-ons' );?></option>
                        <?php 
                        foreach ($listing_cats as $cat) {
                            if(in_array($cat['id'], $search_cats)){
                                echo '<option value="'.$cat['id'].'" selected>'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                            }else{
                                echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                            }
                            
                        }
                        ?>
                    </select>
                </div>
                <button class="header-search-button" type="submit"><?php esc_html_e( 'Search', 'citybook-add-ons' );?></button>
                <input type="hidden" name="post_type" value="listing">
                <?php 
                if(defined('ICL_LANGUAGE_CODE')){
                    echo '<input type="hidden" name="lang" value="'.ICL_LANGUAGE_CODE.'">';
                }
                ?>
            </form>
        </div>
        <div class="show-search-button"><?php _e( '<i class="fa fa-search"></i> <span>Search</span>', 'citybook-add-ons' ); ?></div>

        <?php
        $output = ob_get_clean();

        
        return $output;

    }

    add_shortcode( 'citybook_search_header', 'citybook_addons_search_header_sc' ); 
}

// submit page shortcode
if(!function_exists('citybook_addons_listing_submit_page_sc')){
    function citybook_addons_listing_submit_page_sc($atts, $content = ''){
        ob_start();

        citybook_addons_get_template_part('shortcodes/submit');
        
        $output = ob_get_clean();

        return $output;
    }

    add_shortcode( 'listing_submit_page', 'citybook_addons_listing_submit_page_sc' ); 
}

// edit page shortcode
if(!function_exists('citybook_addons_listing_edit_page_sc')){
    function citybook_addons_listing_edit_page_sc($atts, $content = ''){
        ob_start();

        citybook_addons_get_template_part('shortcodes/edit');
        
        $output = ob_get_clean();

        return $output;
    }

    add_shortcode( 'listing_edit_page', 'citybook_addons_listing_edit_page_sc' ); 
}


// dashboard page shortcode
if(!function_exists('citybook_addons_listing_dashboard_page_sc')){
    function citybook_addons_listing_dashboard_page_sc($atts, $content = ''){
        ob_start();

        citybook_addons_get_template_part('shortcodes/dashboard');
        
        $output = ob_get_clean();

        return $output;
    }

    add_shortcode( 'listing_dashboard_page', 'citybook_addons_listing_dashboard_page_sc' ); 
}

// dashboard page shortcode
if(!function_exists('citybook_addons_listing_checkout_page_sc')){
    function citybook_addons_listing_checkout_page_sc($atts, $content = ''){
        ob_start();

        citybook_addons_get_template_part('shortcodes/checkout');
        
        $output = ob_get_clean();

        return $output;
    }

    add_shortcode( 'listing_checkout_page', 'citybook_addons_listing_checkout_page_sc' ); 
}

// add new field to submit form
function citybook_addons_submit_addfields_callback($listing_id = 0, $is_edit = false){
    $content_addfields = citybook_addons_get_option('content_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        ?>
        <!-- profile-edit-container--> 
        <div class="profile-edit-container add-list-container listing-additional-content-widget-<?php echo sanitize_title( $widget['widget_title'] );?>">
            <div class="profile-edit-header fl-wrap">
                <h4><?php echo $widget['widget_title'];?></h4>
            </div>
            <div class="custom-form">
                <div class="listing-additional-fields">
                <?php 
                $name_prefix = 'add_fields_';
                $add_fields_arr = array();
                if(!empty($widget['fields'])){
                    foreach ((array)$widget['fields'] as $key => $field) {
                        $add_fields_arr[] = array(
                            'type' => $field['field_type'],
                            'name' => $field['field_name'],
                            'label' => $field['field_label'],
                            'value' => '',
                            'lvalue'    => ($is_edit? get_post_meta( $listing_id, P_META_PREFIX.$name_prefix.$field['field_name'], true ) : ''),
                        );
                    }
                }
                foreach ($add_fields_arr as $addfield) {
                    citybook_addons_get_template_part('templates-inner/add-field-frontend',false,array('name_prefix'=> $name_prefix,'addfield'=>$addfield));
                }
                ?>
                </div>
            </div>
        </div>
        <!-- profile-edit-container end-->  
    <?php
    }
    ?>
    
    <?php
}
add_action( 'citybook-addons-submit-addfields', 'citybook_addons_submit_addfields_callback', 10, 2 );

function citybook_addons_submit_widget_addfields_callback($listing_id = 0, $is_edit = false){
    $content_addfields = citybook_addons_get_option('widget_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        ?>
        <!-- profile-edit-container--> 
        <div class="profile-edit-container add-list-container listing-additional-widget-widget-<?php echo sanitize_title( $widget['widget_title'] );?>">
            <div class="profile-edit-header fl-wrap">
                <h4><?php echo $widget['widget_title'];?></h4>
            </div>
            <div class="custom-form">
                <div class="listing-additional-fields">
                <?php 
                $name_prefix = 'add_fields_';
                $add_fields_arr = array();
                if(!empty($widget['fields'])){
                    foreach ((array)$widget['fields'] as $key => $field) {
                        $add_fields_arr[] = array(
                            'type' => $field['field_type'],
                            'name' => $field['field_name'],
                            'label' => $field['field_label'],
                            'value' => '',
                            'lvalue'    => ($is_edit? get_post_meta( $listing_id, P_META_PREFIX.$name_prefix.$field['field_name'], true ) : ''),
                        );
                    }
                }
                foreach ($add_fields_arr as $addfield) {
                    citybook_addons_get_template_part('templates-inner/add-field-frontend',false,array('name_prefix'=> $name_prefix,'addfield'=>$addfield));
                }
                ?>
                </div>
            </div>
        </div>
        <!-- profile-edit-container end-->  
    <?php
    }
    ?>
    
    <?php
}
add_action( 'citybook-addons-submit-widget-addfields', 'citybook_addons_submit_widget_addfields_callback', 10, 2 );



// for saving custom fields
function citybook_addons_save_addfields_callback($listing_id){
    $content_addfields = citybook_addons_get_option('content_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        $name_prefix = 'add_fields_';
        $add_fields_arr = array();
        if(!empty($widget['fields'])){
            foreach ((array)$widget['fields'] as $key => $field) {
                $add_fields_arr[] = $name_prefix.$field['field_name'];
            }
        }

        foreach ($add_fields_arr as $addfield) {
            if(isset($_POST[$addfield])){
                $old_val = get_post_meta( $listing_id, P_META_PREFIX.$addfield, true );
                if($old_val != $_POST[$addfield]) update_post_meta( $listing_id, P_META_PREFIX.$addfield, $_POST[$addfield] );
            }
            
        }

    }
}
add_action( 'citybook-addons-save-addfields', 'citybook_addons_save_addfields_callback', 10, 1 );

function citybook_addons_save_addfields_widget_callback($listing_id){
    $content_addfields = citybook_addons_get_option('widget_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        $name_prefix = 'add_fields_';
        $add_fields_arr = array();
        if(!empty($widget['fields'])){
            foreach ((array)$widget['fields'] as $key => $field) {
                $add_fields_arr[] = $name_prefix.$field['field_name'];
            }
        }

        foreach ($add_fields_arr as $addfield) {
            if(isset($_POST[$addfield])){
                $old_val = get_post_meta( $listing_id, P_META_PREFIX.$addfield, true );
                if($old_val != $_POST[$addfield]) update_post_meta( $listing_id, P_META_PREFIX.$addfield, $_POST[$addfield] );
            }
            
        }

    }
}
add_action( 'citybook-addons-save-addfields', 'citybook_addons_save_addfields_widget_callback', 10, 1 );

// for display custom content fields
function citybook_addons_single_content_order_callback($listing_id = 0, $order = 0){
    $content_addfields = citybook_addons_get_option('content_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        $widget_position = isset($widget['widget_position']) ? $widget['widget_position'] : 0;
        $name_prefix = 'add_fields_';
        $add_fields_arr = array();
        if(!empty($widget['fields'])){
            foreach ((array)$widget['fields'] as $key => $field) {
                $add_fields_arr[] = array(
                    'type' => $field['field_type'],
                    'name' => $name_prefix.$field['field_name'],
                    'label' => $field['field_label'],
                );
                // $add_fields_arr[] = $name_prefix.$field['field_name'];
            }
        }

        
        if($order == $widget_position):
        ?>
        <div class="list-single-main-item fl-wrap" id="sec_addfield_<?php echo esc_attr( $order );?>">
            <?php if(!empty($widget['widget_title'])): ?>
            <div class="list-single-main-item-title fl-wrap">
                <h3><?php echo $widget['widget_title']; ?></h3>
            </div>
            <?php endif; ?>
            <!-- gallery-items   -->
            <div class="content_addwidgets-wrap">
                <?php 
                foreach ($add_fields_arr as $addfield) {
                    echo '<div class="content-add-field-label add-field-'.$addfield['type'].'">'.$addfield['label'].'</div>';
                    echo do_shortcode(get_post_meta( $listing_id, P_META_PREFIX.$addfield['name'], true ));
                    
                }
                ?>
            </div>
            <!-- end gallery items -->                                 
        </div>
        <!-- list-single-main-item end --> 
        <?php
        endif; // end check correct order
    }
}
add_action( 'citybook-addons-single-content-order', 'citybook_addons_single_content_order_callback', 10, 2 );

// for display custom content fields
function citybook_addons_single_widget_order_callback($listing_id = 0, $order = 0){
    $content_addfields = citybook_addons_get_option('widget_addwidgets');
    if(empty($content_addfields) || !is_array($content_addfields)) return;
    foreach ($content_addfields as $widget) {
        $widget_position = isset($widget['widget_position']) ? $widget['widget_position'] : 0;
        $name_prefix = 'add_fields_';
        $add_fields_arr = array();
        if(!empty($widget['fields'])){
            foreach ((array)$widget['fields'] as $key => $field) {
                $add_fields_arr[] = array(
                    'type' => $field['field_type'],
                    'name' => $name_prefix.$field['field_name'],
                    'label' => $field['field_label'],
                );

                // $add_fields_arr[] = $name_prefix.$field['field_name'];
            }
        }

        
        if($order == $widget_position):
        ?>
        <!--box-widget-item -->
        <div class="box-widget-item fl-wrap" id="widget_addfield_<?php echo esc_attr( $order );?>">
            <?php if(!empty($widget['widget_title'])): ?>
            <div class="box-widget-item-header">
                <h3><?php echo $widget['widget_title']; ?></h3>
            </div>
            <?php endif; ?>
            <div class="box-widget additional-fields">
                <div class="box-widget-content">
                    <?php 
                    foreach ($add_fields_arr as $addfield) {
                        echo '<div class="widget-add-field-label add-field-'.$addfield['type'].'">'.$addfield['label'].'</div>';
                        echo do_shortcode(get_post_meta( $listing_id, P_META_PREFIX.$addfield['name'], true ));
                    }
                    ?>
                </div>
            </div>
        </div>
        <!--box-widget-item end -->  
        <?php
        endif; // end check correct order
    }
}
add_action( 'citybook-addons-single-widget-order', 'citybook_addons_single_widget_order_callback', 10, 2 );



// add_action('wp_ajax_nopriv_citybook_addons_cats_subcats', 'citybook_addons_cats_subcats_callback');
// add_action('wp_ajax_citybook_addons_cats_subcats', 'citybook_addons_cats_subcats_callback');

function citybook_addons_cats_subcats_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    // wp_send_json($json );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if(isset($_POST['cats'])) $listing_cats = $_POST['cats'];

    if(!is_array($listing_cats)) {
        $json['data'] = esc_html__( 'Invalid listing category list - it must be array [50,51]', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $cats_subcats = array();

    foreach ($listing_cats as $listing_cat) {
        
        if(!is_numeric($listing_cat)) {
            $json['data'] = esc_html__( 'Invalid listing category', 'citybook-add-ons' ) ;
            wp_send_json($json );
        }

        $sub_cats = get_terms( array(
            'taxonomy'      => 'listing_cat',
            // 'hide_empty'    => false,
            'parent'        => $listing_cat,
        ) );

        if ( ! empty( $sub_cats ) && ! is_wp_error( $sub_cats ) ){
            foreach ( $sub_cats as $sub_cat ) {
                $cats_subcats[] = array(
                    'id'            => $sub_cat->term_id,
                    'slug'          => $sub_cat->slug,
                    'name'          => $sub_cat->name,
                );
            }
        }
    }
    // end foreach 
    $json['success'] = true;
    $json['data']['subcats'] = $cats_subcats;

    wp_send_json($json );

}




