<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



$listing_id = get_query_var('listing_id');


$listing_post_obj = get_post($listing_id);

if(null == $listing_post_obj) return;

$cur_cats = array();
$cats = get_the_terms( $listing_id , 'listing_cat' );    
// var_dump($cats);
if ( $cats && ! is_wp_error( $cats ) ){
    foreach ( $cats as $cat ) {
        $cur_cats[] = $cat->term_id;
    }
}
// features
$cur_feas = array();
$feas = get_the_terms( $listing_id , 'listing_feature' );    
// var_dump($cats);
if ( $feas && ! is_wp_error( $feas ) ){
    foreach ( $feas as $fea ) {
        $cur_feas[] = $fea->term_id;
    }
}                
//additional features
$add_feas = get_post_meta( $listing_id, P_META_PREFIX.'add-features', true );


wp_localize_script( 'citybook-addons', '_citybook_submit', array(
    'id'        =>  $listing_id,
    'mode'      => 'edit',
    'feas'      => $cur_feas,
    'addfeas'   => $add_feas,

) );



$listing_cats_arr = citybook_addons_get_listing_categories(); 

$get_tags = get_the_tags($listing_id);
$listing_tags = '';
if ( $get_tags && ! is_wp_error( $get_tags ) ){
    foreach ($get_tags as $tag) {
        $listing_tags .= $tag->name.',';
    }
    
}

// get listing location
// features
$cur_locs = '';
$locs = get_the_terms( $listing_id , 'listing_location' );    
// var_dump($cats);
if ( $locs && ! is_wp_error( $locs ) ){
    foreach ( $locs as $loc ) {
        $cur_locs .= $loc->name.',';
    }
}  

?>

<!--section --> 
<section id="sec1">
    <!-- container -->
    <div class="container">
        <!-- profile-edit-wrap -->
        <div class="profile-edit-wrap">
            <div class="profile-edit-page-header">
                <h2><?php the_title();?></h2>
                <?php citybook_addons_breadcrumbs();?>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php citybook_addons_get_template_part('template-parts/dashboard-sidebar');?>
                </div>
                <div class="col-md-9">
                    <div id="submit-listing-view">
                    <!-- #submit-listing-view -->
                        <div id="submit-listing-message"></div>
                        <!-- #listing-submission-form-->
                        <form id="listing-submission-form" action="#">

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <!-- <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'User Login', 'citybook-add-ons' );?></h4>
                                </div> -->
                                <?php 
                                $current_user = wp_get_current_user();
                                if ( 0 == $current_user->ID ) {
                                    ?>
                                <div class="account-box">
                                    <span><?php _e( 'If you don\'t have an account, you can create one by entering your email address bellow. <br>Account details will be confirmed via email.', 'citybook-add-ons' );?></span>
                                    <a href="" class="btn color-bg logreg-modal-open"><?php _e( 'Sign In', 'citybook-add-ons' );?></a>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Your Email ', 'citybook-add-ons' );?><i class="fa fa-envelope"></i></label>
                                    <input type="email" class="has-icon" name="user_email" placeholder="<?php esc_attr_e( 'Enter your email address', 'citybook-add-ons' );?>" value="" required data-msg="<?php esc_attr_e( 'Please enter your email address.', 'citybook-add-ons' ); ?>"/>
                                </div>
                                <?php
                                }else{
                                    ?>
                                <div class="account-box">
                                    <span><?php echo sprintf(__('You are currently signed in as <strong>%s</strong>, <a href="%s">Sign out</a> or continue below.','citybook-add-ons'), $current_user->display_name, wp_logout_url( citybook_addons_get_current_url() ) ) ;?></span>
                                </div>
                                <?php
                                }
                                ?>
                                
                            </div>
                            <!-- profile-edit-container end--> 

                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Basic Information', 'citybook-add-ons' );?></h4>
                                    <a class="btn color-bg lpreview-btn" href="<?php echo esc_url( get_permalink( $listing_id ) ); ?>" target="_blank"><?php esc_html_e( 'Preview ', 'citybook-add-ons' ); ?><i class="fa fa-eye"></i></a>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Listing Title <i class="fa fa-briefcase"></i>', 'citybook-add-ons' );?></label>
                                    <input type="text" class="has-icon" name="title" placeholder="<?php esc_attr_e( 'Name of your business', 'citybook-add-ons' ); ?>" value="<?php echo $listing_post_obj->post_title;?>" required data-msg="<?php esc_attr_e( 'Please enter listing title.', 'citybook-add-ons' ); ?>"/>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <label><?php _e( 'Category', 'citybook-add-ons' );?></label>
                                            <select id="listing_cats" name="listing_cats[]" data-placeholder="<?php esc_attr_e( 'Select Category', 'citybook-add-ons' );?>" required<?php if( citybook_addons_get_option('multiple_cat') == 'yes' ) echo ' multiple="multiple"'; ?> data-msg="<?php esc_attr_e( 'Please select at least one category.', 'citybook-add-ons' ); ?>">
                                                <option><?php _e( 'Select Category', 'citybook-add-ons' );?></option>
                                                <?php 
                                                    if(count($listing_cats_arr)){
                                                        foreach ($listing_cats_arr as $cat) {

                                                            if(in_array($cat['id'], $cur_cats)){
                                                                echo '<option value="'.$cat['id'].'" selected>'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                                                            }else{
                                                                echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).$cat['name'].'</option>';
                                                            }

                                                            
                                                                //echo '<option value="'.$cat['id'].'">'.str_repeat('-', $cat['level']).' '.$cat['name'].'</option>';
                                                      
                                                            
                                                        }
                                                    }
                                                ?>
                                            </select>
                                        </div>
                                        <?php if( false == citybook_addons_check_package_field('hide_tags') ): ?>   
                                        <div class="col-md-6">
                                            <label><?php _e( 'Keywords <i class="fa fa-key"></i>', 'citybook-add-ons' );?></label>
                                            <input class="has-icon" type="text" id="listing_tags" name="listing_tags" placeholder="<?php esc_attr_e( 'Maximum 15, should be separated by commas', 'citybook-add-ons' );?>" value="<?php echo trim($listing_tags,',');?>"/>
                                        </div>
                                        <?php endif;?>
                                        <?php
                                        // echo '<pre>';
                                        // var_dump($add_feas);
                                        // var_dump($cur_feas);
                                        $cats_features = array();
                                        $cats_add_features = array();
                                        if(!empty($cur_cats)){
                                            foreach ($cur_cats as $cat) {
                                                // $term_meta = get_option("_cth_tax_listing_cat_{$cat}");
                                                $term_meta = get_term_meta( $cat, P_META_PREFIX.'term_meta', true );
                                                
                                                if(isset($term_meta['features']) && !empty($term_meta['features'])){
                                                    foreach ($term_meta['features'] as $fea_id) {
                                                        $feature = get_term( $fea_id, 'listing_feature' );
                                                        if ( $feature != null && ! is_wp_error( $feature ) ){
                                                            $cats_features[] = array(
                                                                'type' => 'feature', // is features field
                                                                'label' => $feature->name,
                                                                'value' => $fea_id,
                                                                'lvalue' => in_array($fea_id, $cur_feas)? $fea_id : ''
                                                            );
                                                        }
                                                    }
                                                    // end foreach
                                                }
                                                // end if $term_meta['features']
                                                if(isset($term_meta['add-features']) && !empty($term_meta['add-features'])){
                                                    foreach ($term_meta['add-features'] as $addfea_field) {

                                                        $addfea_field['lvalue'] = array_key_exists($addfea_field['name'], $add_feas)? $add_feas[$addfea_field['name']] : '';
                                                        $cats_add_features[] = $addfea_field;
                                                    }
                                                    // end foreach


                                                }
                                                // end if $term_meta['add-features']
                                            }
                                            // end foreach $cur_cats
                                        }
                                        // end if $cur_cats
                                        ?>

                                        <div class="col-md-12 listing-features-view">
                                            <h4 class="field-head"><?php esc_html_e( 'Features', 'citybook-add-ons' );?></h4>
                                            <div class="listing-features">
                                                <?php 
                                                foreach ($cats_features as $fea) {
                                                    citybook_addons_get_template_part('templates-inner/feature',false,array('fea'=>$fea));
                                                }
                                                ?>
                                            </div>
                                            <h4 class="field-head"><?php esc_html_e( 'Additional Info', 'citybook-add-ons' );?></h4>
                                            <div class="listing-additional-features">
                                                <?php 
                                                foreach ($cats_add_features as $addfea) {
                                                    citybook_addons_get_template_part('templates-inner/add-feature',false,array('addfea'=>$addfea));
                                                }
                                                ?>
                                            </div>
                                        </div>

                                        <!-- <div class="col-md-12 listing-features-view" id="listing-features-view"></div> -->

                                        

                                    </div>
                                </div>
                            </div>
                            <!-- profile-edit-container end--> 
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Location /  Contacts', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">

                                    <?php 
                                    citybook_addons_get_template_part(
                                        'template-parts/location-contacts', 
                                        false, 
                                        array(
                                            'location'=>trim($cur_locs,','), 
                                            'contact_infos'=> array(
                                                'address' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_address', true ),
                                                'latitude' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_latitude', true ),
                                                'longitude' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_longitude', true ),
                                                'phone' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_phone', true ),
                                                'email' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_email', true ),
                                                'website' => get_post_meta( $listing_id, P_META_PREFIX.'contact_infos_website', true ),
                                            )
                                        ) 
                                    );
                                    ?>

                                </div>
                            </div>
                            <!-- profile-edit-container end-->  
                            <?php if( false == citybook_addons_check_package_field('hide_price_opt') ): ?>  
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Price Options', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <div class="row">
                                        <div class="col-md-4">
                                            
                                            <label for="price_range"><?php esc_html_e( 'Price Range', 'citybook-add-ons' );?></label>
                                            <select id="price_range" class="fwcl chosen-select" name="price_range">
                                                <?php 
                                                $price_range = get_post_meta( $listing_id, P_META_PREFIX.'price_range', true );
                                                foreach (citybook_addons_get_listing_price_range() as $range => $title) {
                                                    echo '<option value="'.$range.'" '.selected( $range, $price_range, false ).'>'.$title.'</option>';
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-md-4">
                                            <label for="price_from"><?php esc_html_e( 'Price From', 'citybook-add-ons' );?></label>
                                            <input type="text" id="price_from" name="price_from" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'price_from', true );?>">
                                        </div>
                                        <div class="col-md-4">
                                            <label for="price_to"><?php esc_html_e( 'Price To', 'citybook-add-ons' );?></label>
                                            <input type="text" id="price_to" name="price_to" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'price_to', true );?>">
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <!-- profile-edit-container end--> 
                            <?php endif; ?> 

                            <?php do_action( 'citybook-addons-submit-addfields', $listing_id, true ); ?>                                   
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Media', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    <label for=""><?php _e( 'Featured Image', 'citybook-add-ons' );?></label>
                                    <?php 
                                    $img_data = array();
                                    if(has_post_thumbnail($listing_id)){
                                        // $id = get_post_thumbnail_id( $listing_id );
                                        $img_data = array(
                                            // get_post_thumbnail_id( $listing_id ) => get_the_post_thumbnail_url( $listing_id, 'full' )
                                            get_post_thumbnail_id( $listing_id )
                                        );

                                        // var_dump($img_data);
                                    }
                                    // $headerimgs = get_post_meta( $listing_id, P_META_PREFIX.'headerimgs', true );
                                    // var_dump($headerimgs);
                                    citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'is_single' => true, 'name'=>'featured', 'datas'=> $img_data ) );
                                    ?>
                                    
                                    <?php 
                                    if( false == citybook_addons_check_package_field('hide_head_background') || false == citybook_addons_check_package_field('hide_head_carousel') || false == citybook_addons_check_package_field('hide_head_video') ):

                                        $lcol_cls = 'col-md-8';
                                        $rcol_cls = 'col-md-4';
                                        $incol_cls = 'col-md-6';
                                        if( citybook_addons_check_package_field('hide_head_video') ){
                                            $lcol_cls = 'col-md-12';
                                            if( citybook_addons_check_package_field('hide_head_background') || citybook_addons_check_package_field('hide_head_carousel') ){
                                                $incol_cls = 'col-md-12';
                                            }
                                        }else{
                                            if( citybook_addons_check_package_field('hide_head_background') && citybook_addons_check_package_field('hide_head_carousel') ){
                                                $rcol_cls = 'col-md-12';
                                            }elseif( citybook_addons_check_package_field('hide_head_background') || citybook_addons_check_package_field('hide_head_carousel') ){
                                                $lcol_cls = 'col-md-6';
                                                $rcol_cls = 'col-md-6';
                                                $incol_cls = 'col-md-12';
                                            }
                                        }

                                    ?>
                                    <label for=""><?php _e( 'Header Media', 'citybook-add-ons' );?></label>
                                    <div class="row">
                                        <!--col --> 
                                        <?php 
                                        if( false == citybook_addons_check_package_field('hide_head_background') || false == citybook_addons_check_package_field('hide_head_carousel') ):
                                        ?>
                                        <div class="<?php echo esc_attr( $lcol_cls ); ?>">
                                        <?php  // endif; ?>
                                            <div class="row">
                                                <?php 
                                                if( false == citybook_addons_check_package_field('hide_head_background') ):
                                                ?>
                                                <!--col --> 
                                                <div class="<?php echo esc_attr( $incol_cls ); ?>">
                                                    <?php 
                                                    citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgimage', 'checked' => get_post_meta( $listing_id, P_META_PREFIX.'headertype', true ), 'label' => __( 'Background Image', 'citybook-add-ons' ) ) );
                                                    ?>
                                                </div>
                                                <!--col-md-6 end--> 
                                                <?php endif; ?>
                                                <?php 
                                                if( false == citybook_addons_check_package_field('hide_head_carousel') ):
                                                ?>
                                                <!--col --> 
                                                <div class="<?php echo esc_attr( $incol_cls ); ?>">
                                                    <?php 
                                                    citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'carousel', 'checked' => get_post_meta( $listing_id, P_META_PREFIX.'headertype', true ), 'label' => __( 'Carousel', 'citybook-add-ons' ) ) );
                                                    ?>
                                                </div>
                                                <!--col-md-6 end--> 
                                                <?php endif; ?>
                                            </div>

                                            <?php 
                                            // $headerimgs = get_post_meta( $listing_id, P_META_PREFIX.'headerimgs', true );
                                            // var_dump($headerimgs);
                                            citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'headerimgs', 'datas'=> get_post_meta( $listing_id, P_META_PREFIX.'headerimgs', true ) ) );
                                            ?>
                                            
                                        </div>
                                        <!--col-md-8 end --> 
                                        <?php endif; ?>
                                        <?php 
                                        if( false == citybook_addons_check_package_field('hide_head_video') ):
                                        ?>
                                        <!--col --> 
                                        <div class="<?php echo esc_attr( $rcol_cls ); ?>">
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgvideo', 'checked' => get_post_meta( $listing_id, P_META_PREFIX.'headertype', true ), 'label' => __( 'Video Background', 'citybook-add-ons' ) ) );
                                            ?>
                                            <div class="add-list-media-wrap">
                                                <label><?php _e( 'Youtube Video ID  <i class="fa fa-youtube"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="headerbg_youtube" type="text" placeholder="<?php esc_html_e( 'Ex: Hg5iNVSp2z8', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'headerbg_youtube', true );?>"/> 

                                                <label><?php _e( 'Or Vimeo Video ID <i class="fa fa-vimeo"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="headerbg_vimeo" type="text" placeholder="<?php esc_html_e( 'Ex: 97871257', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'headerbg_vimeo', true );?>"/> 

                                                <label><?php _e( 'Or Vimeo URL (.MP4) <i class="fa fa-video-camera"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="headerbg_mp4" type="text" placeholder="<?php esc_html_e( 'Ex: domain.com/wp-content/uploads/2018/04/1.mp4', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'headerbg_mp4', true );?>"/> 


                                                
                                            </div>
                                        </div>
                                        <!--col-md-4 end-->   
                                        <?php endif; // end hide background video ?>                                                
                                    </div>
                                    <?php endif; // end hide all header media ?>
                                </div>
                            </div>
                            <!-- profile-edit-container end-->                                         
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Detailed Information', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form-editor">
                                    <label><?php _e( 'Description', 'citybook-add-ons' );?></label>
                                    
                                    <?php 
                                    // https://codex.wordpress.org/Function_Reference/wp_editor
                                    wp_editor( $listing_post_obj->post_content, 'listing_content', array('textarea_rows'=>10) ); 
                                    ?>
                                </div>
                                <div class="custom-form">
                                    <label><?php _e( 'Custom Excerpt', 'citybook-add-ons' );?></label>
                                    <textarea name="post_excerpt" cols="30" rows="3"><?php echo $listing_post_obj->post_excerpt ?></textarea>
                                </div>
                            </div>
                            <!-- profile-edit-container end-->
                            <?php 
                            if( false == citybook_addons_check_package_field('hide_content_video') || false == citybook_addons_check_package_field('hide_content_gallery') || false == citybook_addons_check_package_field('hide_content_slider') || false == citybook_addons_check_package_field('hide_faqs_opt') ):

                            ?>                                      
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <?php 
                                if( false == citybook_addons_check_package_field('hide_content_video') || false == citybook_addons_check_package_field('hide_content_gallery') || false == citybook_addons_check_package_field('hide_content_slider') ):

                                ?>

                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Content Widgets', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <div class="submit-widgets-wrap">
                                        <?php if( false == citybook_addons_check_package_field('hide_content_video') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Promo video', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'is_single' => true, 'name'=>'promo_bg', 'datas'=> get_post_meta( $listing_id, P_META_PREFIX.'promo_bg', true ) ) );
                                            ?>
                                            <div class="add-list-media-wrap">
                                                
                                                <label><?php _e( 'Video URL :  <i class="fa fa-video-camera"></i>', 'citybook-add-ons' );?></label>
                                                <input class="has-icon" name="promovideo_url" type="text" placeholder="https://www.youtube.com/" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'promovideo_url', true );?>"/>   
                                            </div>
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                        <?php if( false == citybook_addons_check_package_field('hide_content_gallery') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Gallery Thumbnails', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'gallery_imgs', 'datas'=> get_post_meta( $listing_id, P_META_PREFIX.'gallery_imgs', true ) ) );
                                            ?>
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                        <?php if( false == citybook_addons_check_package_field('hide_content_slider') ): ?>
                                        <!-- act-widget--> 
                                        <div class="act-widget fl-wrap">
                                            <div class="act-widget-header">
                                                <h4><?php _e( 'Slider', 'citybook-add-ons' );?></h4>
                                            </div>
                                            <?php 
                                            citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'slider_imgs', 'datas'=> get_post_meta( $listing_id, P_META_PREFIX.'slider_imgs', true ) ) );
                                            ?>
                                        </div>
                                        <!-- act-widget end-->
                                        <?php endif; ?>
                                    </div>
                                    <!-- submit-widgets-wrap end -->


                                </div>
                                <?php endif; // end all content widgets ?>

                                <?php if( false == citybook_addons_check_package_field('hide_faqs_opt') ): ?>  
                                <?php 
                                $lFAQs = get_post_meta( $listing_id, P_META_PREFIX.'lfaqs', true );
                                ?>
                                <div class="custom-form">
                                    <div class="list-faqs-wrap">
                                        <label for=""><?php esc_html_e( 'Frequently Asked Questions', 'citybook-add-ons' ); ?></label>
                                        <div class="repeater-fields-wrap repeater-fields-faqs"  data-tmpl="tmpl-faq">
                                            <div class="repeater-fields">
                                            <?php 
                                            if(!empty($lFAQs)){
                                                foreach ($lFAQs as $key => $lfaq) {
                                                    citybook_addons_get_template_part('templates-inner/faq',false, array('index'=>$key,'title'=>$lfaq['title'],'content'=>$lfaq['content']));
                                                }
                                            }
                                            ?>
                                            </div>
                                            <button class="btn addfield" type="button"><?php  esc_html_e( 'Add FAQ','citybook-add-ons' );?></button>
                                        </div>
                                    </div>
                                    <!-- list-faqs-wrap end -->
                                </div>
                                <?php endif; ?>

                            </div>
                            <!-- profile-edit-container end-->
                            <?php endif; // end all content widgets - faqs ?>

                            <?php if( false ==citybook_addons_check_package_field('hide_counter_opt') || false == citybook_addons_check_package_field('hide_workinghours_opt') ): ?>                                  
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container add-list-container">
                                <div class="profile-edit-header fl-wrap">
                                    <h4><?php _e( 'Sidebar Widgets', 'citybook-add-ons' );?></h4>
                                </div>
                                <div class="custom-form">
                                    
                                    <?php if( false == citybook_addons_check_package_field('hide_counter_opt') ): ?>
                                    <!-- act-widget--> 
                                    <div class="act-widget fl-wrap">
                                        <div class="act-widget-header">
                                            <h4><?php _e( 'Event Counter', 'citybook-add-ons' );?></h4>
                                            
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="datepicker has-icon" data-max-year="2050" data-min-year="2016"  data-large-mode="true" data-large-default="true" data-format="Y-m-d" data-init-set="false" name="levent_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'levent_date', true );?>"/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event Time<i class="fa fa-clock-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="timepicker has-icon" name="levent_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'levent_time', true );?>"/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event End Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="datepicker has-icon" data-max-year="2050" data-min-year="2016" data-large-mode="true" data-large-default="true" data-format="Y-m-d" data-init-set="false" name="levent_end_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'levent_end_date', true );?>"/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                            <div class="col-md-6">
                                                <label><?php _e( 'Event End Time<i class="fa fa-clock-o"></i>', 'citybook-add-ons' );?></label>
                                                <div class="dtpicker-wrap fl-wrap">
                                                    <input class="timepicker has-icon" name="levent_end_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $listing_id, P_META_PREFIX.'levent_end_time', true );?>"/>
                                                    <span class="remove-date-time"><i class="fa fa-trash"></i></span>
                                                </div>
                                                    
                                            </div>
                                        </div>
    
                                    </div>
                                    <!-- act-widget end--> 
                                    <?php endif; ?>
                                    
                                    
                                    <?php if( false == citybook_addons_check_package_field('hide_workinghours_opt') ): ?>
                                    <!-- act-widget--> 
                                    <div class="act-widget fl-wrap">
                                        <div class="act-widget-header">
                                            <h4><?php _e( 'Working Hours', 'citybook-add-ons' );?></h4>
                                        </div>
                                        <?php 

                                        // citybook_addons_get_template_part('template-parts/working-hours', false, array('post_working_hours'=>get_post_meta( $listing_id, P_META_PREFIX.'working_hours', true )));
                                        citybook_addons_get_template_part('template-parts/working-hours', false, array('post_working_hours'=> citybook_addons_get_listing_working_hours_data($listing_id) ));
                                        ?>
                                    
                                    </div>
                                    <!-- act-widget end--> 
                                    <?php endif; ?>

                                    

                                </div>
                            </div>
                            <!-- profile-edit-container end-->    
                            <?php endif; // end sidebar widget options ?>

                            <?php do_action( 'citybook-addons-submit-widget-addfields', $listing_id, true ); ?>  
                            
                            <!-- profile-edit-container--> 
                            <div class="profile-edit-container mt-30">
                                <?php if( false == citybook_addons_check_package_field('hide_socials_opt') ): ?> 
                                <div class="profile-edit-header fl-wrap" style="margin-top:30px">
                                    <h4><?php _e( 'Socials', 'citybook-add-ons' );?></h4>
                                </div>

                                <?php 
                                $socials = get_post_meta( $listing_id, P_META_PREFIX.'socials', true );
                                ?>
                                <div class="custom-form">
                                    <div class="repeater-fields-wrap"  data-tmpl="tmpl-user-social">
                                        <div class="repeater-fields">
                                        <?php 
                                        if(!empty($socials)){
                                            foreach ($socials as $key => $social) {
                                                citybook_addons_get_template_part('templates-inner/social',false, array('index'=>$key,'name'=>$social['name'],'url'=>$social['url']));
                                            }
                                        }
                                        ?>
                                        </div>
                                        <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Social','citybook-add-ons' );?></button>
                                    </div>

                                    
                                </div>
                            <?php endif; ?>

                                <?php citybook_addons_display_recaptcha('submitCaptcha'); ?>

                                <div class="custom-form">
                                    <button type="submit" id="submit-listing-btn" value="1" class="btn big-btn color-bg flat-btn"><?php _e( 'Save Changes ', 'citybook-add-ons' );?> <i class="fa fa-angle-right"></i></button>
                                </div>
                                
                            </div>
                            <!-- profile-edit-container end--> 

                            <!-- <input type="submit" value="Submit form">  -->

                        </form>
                        <!-- #listing-submission-form end--> 
                        
                    </div>
                    <!-- #submit-listing-view -->
                </div>
            </div>
        </div>
        <!--profile-edit-wrap end -->
    </div>
    <!--container end -->
</section>
<!-- section end -->    
<div class="limit-box fl-wrap"></div>

<?php //include CITYBOOK_ADD_ONS_DIR . 'shortcodes/tmpls.php';

citybook_addons_get_template_part('shortcodes/tmpls');
// template for social
citybook_addons_get_template_part('shortcodes/tmpls-dashboard');
?>
