<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$dashboard = get_query_var('dashboard');

?>
<!--section --> 
<section>
    <!-- container -->
    <div class="container">
        <!-- profile-edit-wrap -->
        <div class="profile-edit-wrap">
            <div class="profile-edit-page-header">
                <h2><?php echo citybook_addons_get_dashboard_subpage($dashboard);?></h2>
                <?php citybook_addons_breadcrumbs();?>
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php citybook_addons_get_template_part('template-parts/dashboard-sidebar');?>
                </div>
                <?php
                switch ($dashboard) {
                    case 'changepass':
                        citybook_addons_get_template_part('shortcodes/dashboard-changepass');
                        break;
                    case 'packages':
                        if( citybook_addons_get_option('db_hide_packages') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-packages');
                        break;
                    case 'ads':
                        if( citybook_addons_get_option('db_hide_ads') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-ads');
                        break;
                    case 'invoices':
                        if( citybook_addons_get_option('db_hide_invoices') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-invoices');
                        break;
                    case 'listings':
                        citybook_addons_get_template_part('shortcodes/dashboard-listings');
                        break;
                    case 'reviews':
                        if( citybook_addons_get_option('db_hide_reviews') != 'yes' )citybook_addons_get_template_part('shortcodes/dashboard-reviews');
                        break;
                    case 'messages':
                        if( citybook_addons_get_option('db_hide_messages') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-messages');
                        break;
                    case 'bookings':
                        if( citybook_addons_get_option('db_hide_bookings') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-bookings');
                        break;  
                    case 'bookmarks':
                        if( citybook_addons_get_option('db_hide_bookmarks') != 'yes' ) citybook_addons_get_template_part('shortcodes/dashboard-bookmarks');
                        break;  
                         
                    case 'profile':
                        citybook_addons_get_template_part('shortcodes/dashboard-profile');
                        break; 
                    default:
                        citybook_addons_get_template_part('shortcodes/dashboard-dashboard');
                        break;

                }
                ?>
                
            </div>
        </div>
        <!--profile-edit-wrap end -->
    </div>
    <!--container end -->
</section>
<!-- section end -->
<div class="limit-box fl-wrap"></div>

<?php // if($dashboard == 'listings') citybook_addons_get_template_part('shortcodes/tmpls-cplan-modal'); ?>
<?php // if($dashboard == 'messages') citybook_addons_get_template_part('shortcodes/tmpls-reply-msg-modal'); ?>
<?php // if($dashboard == 'invoices') citybook_addons_get_template_part('shortcodes/tmpls-view-invoice-modal'); ?>
<?php // if($dashboard == 'ads') citybook_addons_get_template_part('shortcodes/tmpls-new-campaign-modal'); ?>


