<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// don't show on customer dashboard
// if( !citybook_addons_current_user_can('submit_listing') ) return;

$current_user = wp_get_current_user();                     

$args = array(
    'fields'        => 'ids',
    'post_type'     =>  'listing', 
    'author'        =>  $current_user->ID, 
    'orderby'       =>  'post_date',
    'order'         =>  'ASC',
    'posts_per_page' => -1 // no limit
);
$listings = get_posts( $args );

$listings_IDs = array();

if(!empty($listings)){
    foreach ($listings as $list_ID) {
        $listings_IDs[] = $list_ID;
    }
}


?>
<div class="col-md-9 dashboard-content-col">
    <div class="dashboard-list-box fl-wrap">
        <div class="dashboard-header fl-wrap">
            <h3><?php esc_html_e( 'Reviews','citybook-add-ons' );?></h3>
        </div>
        <div class="reviews-comments-wrap">
            <?php 

            if(empty($listings_IDs)){
            ?>
            <div id="review-no" class="review-no-list">
                <?php _e( 'You have no review yet!', 'citybook-add-ons' ); ?>
            </div>
            <?php
            }else{

                //Gather comments for a specific page/post 
                // https://codex.wordpress.org/Function_Reference/get_comments
                $comments = get_comments(array(
                    'post__in' => $listings_IDs,
                    // 'status' => 'approve' //Change this to the type of comments to be displayed
                ));

                // https://codex.wordpress.org/Function_Reference/wp_set_comment_status

                // https://codex.wordpress.org/Function_Reference/wp_list_comments
                $com_args = array(
                    'walker'            => null,
                    'max_depth'         => '',
                    'style'             => 'div',
                    'callback'          => 'citybook_addons_comments',
                    'end-callback'      => null,
                    'type'              => 'all',
                    'reply_text'        => esc_html__('Reply','citybook-add-ons'),
                    'page'              => '',
                    'per_page'          => '',
                    'avatar_size'       => 50,
                    'reverse_top_level' => false, //Show the oldest comments at the top of the list
                    'reverse_children'  => '',
                    'format'            => 'html5', //or xhtml if no HTML5 theme support
                    'short_ping'        => false, // @since 3.6,
                    'echo'              => true, // boolean, default is true
                );

                //Display the list of comments
                wp_list_comments($com_args, $comments);

            }
            ?>
        </div>
        <!-- reviews-comments-wrap end -->
        
    </div>
</div>