<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$current_user = wp_get_current_user(); 
?>
<div class="col-md-9 dashboard-content-col">
    <form id="user-info-form" action="#" method="POST">
        <div class="row">
            
            <div class="col-md-9">
                
                    <!-- profile-edit-container--> 
                    <div class="profile-edit-container">
                        <div class="profile-edit-header fl-wrap">
                            <h4><?php esc_html_e( 'Account Info', 'citybook-add-ons' );?></h4>
                        </div>
                        <div class="edit-profile-msg"></div>
                        <div class="custom-form">
                            <label><?php esc_html_e( 'Display Name', 'citybook-add-ons' );?><i class="fa fa-user-o"></i></label>
                            <input name="display_name" class="has-icon" type="text" placeholder="<?php esc_attr_e( 'Display Name', 'citybook-add-ons' ); ?>" value="<?php echo $current_user->display_name;?>"/>

                            <label><?php esc_html_e( 'First Name', 'citybook-add-ons' );?></label>
                            <input name="first_name" type="text" placeholder="<?php esc_attr_e( 'First Name', 'citybook-add-ons' ); ?>" value="<?php echo $current_user->first_name;?>"/>

                            <label><?php esc_html_e( 'Last Name', 'citybook-add-ons' );?></label>
                            <input name="last_name" type="text" placeholder="<?php esc_attr_e( 'Last Name', 'citybook-add-ons' ); ?>" value="<?php echo $current_user->last_name;?>"/>
                            
                            <label><?php esc_html_e( 'Email Address', 'citybook-add-ons' );?></label>
                            <input type="text" value="<?php echo $current_user->user_email;?>" disabled="disabled">

                            <label><?php esc_html_e( 'Website', 'citybook-add-ons' );?><i class="fa fa-globe"></i>  </label>
                            <input name="user_url" class="has-icon" type="text" placeholder="<?php esc_attr_e( 'http://website.com', 'citybook-add-ons' ); ?>" value="<?php echo $current_user->user_url;?>"/>

                            <label><?php esc_html_e( 'Phone', 'citybook-add-ons' );?><i class="fa fa-phone"></i></label>
                            <input name="phone" class="has-icon" type="text" placeholder="<?php esc_attr_e( '+7(123)987654', 'citybook-add-ons' ); ?>" value="<?php echo get_user_meta($current_user->ID,  '_cth_phone', true );?>"/>

                            <label><?php esc_html_e( 'Address', 'citybook-add-ons' );?><i class="fa fa-map-marker"></i>  </label>
                            <input name="address" class="has-icon" type="text" placeholder="<?php esc_attr_e( 'USA 27TH Brooklyn NY', 'citybook-add-ons' ); ?>" value="<?php echo get_user_meta($current_user->ID,  '_cth_address', true );?>"/>

                            <label><?php esc_html_e( 'Description', 'citybook-add-ons' );?></label>                                              
                            <textarea cols="40" rows="3" name="description" placeholder="<?php esc_attr_e( 'About Me', 'citybook-add-ons' ); ?>"><?php echo $current_user->description;?></textarea>
                        </div>
                    </div>
                    <!-- profile-edit-container end--> 
                    <!-- profile-edit-container--> 
                    <div class="profile-edit-container">
                        <div class="profile-edit-header fl-wrap">
                            <h4><?php esc_html_e( 'Socials', 'citybook-add-ons' );?></h4>
                        </div>
                        <?php 
                        $socials = get_user_meta($current_user->ID,  '_cth_socials', true );
                        ?>
                        <div class="custom-form">
                            <div class="repeater-fields-wrap"  data-tmpl="tmpl-user-social">
                                <div class="repeater-fields">
                                <?php 
                                if(!empty($socials)){
                                    foreach ($socials as $key => $social) {
                                        citybook_addons_get_template_part('templates-inner/social',false, array('index'=>$key,'name'=>$social['name'],'url'=>$social['url']));
                                    }
                                }
                                ?>
                                </div>
                                <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Social','citybook-add-ons' );?></button>
                            </div>

                            <button id="edit-profile-submit" class="btn big-btn color-bg flat-btn" type="submit"><?php esc_html_e( 'Save Changes', 'citybook-add-ons' );?><i class="fa fa-angle-right"></i></button>

                        </div>
                    </div>
                    <!-- profile-edit-container end-->  
                                      
            </div>
            <div class="col-md-3">
                <div class="edit-profile-photo fl-wrap">
                    <div class="profile-photo-wrap"><?php 
                        // https://wordpress.stackexchange.com/questions/7620/how-to-change-users-avatar
                        echo get_avatar($current_user->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $current_user->display_name );
                    ?>
                    </div> 
                    <div class="change-photo-btn">
                        <div class="photoUpload">
                            <span><i class="fa fa-upload"></i><?php _e( ' Upload Photo', 'citybook-add-ons' ); ?></span>
                            <?php 
                            if( current_user_can( 'upload_files' ) ){
                                $avatar_data = get_user_meta($current_user->ID,  P_META_PREFIX.'custom_avatar', true );
                                if(is_array($avatar_data) && count($avatar_data)){
                                    $custom_ava_id = reset($avatar_data);
                                    if(!is_numeric($custom_ava_id)) $avatar_data = array(key($avatar_data));
                                }
                                citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'is_single' => true, 'name'=>'custom_avatar', 'datas'=> $avatar_data ) );
                            }else{ ?>
                                <input type="file" class="upload cth-avatar-upload" name="custom_avatar_upload">
                            <?php
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
                 
                 
        </div>
    </form>
    <!-- user-info-form end--> 
</div>
<script type="text/template" id="tmpl-imageslist">
    <?php citybook_addons_get_template_part('templates-inner/image');?>
</script>
<?php
//citybook_addons_get_template_part('shortcodes/tmpls');
citybook_addons_get_template_part('shortcodes/tmpls-dashboard');


