<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


$current_user = wp_get_current_user(); 
$lat_chat_id = 0;
$to_user_id = 0;
$first_user_id = 0;
?>
<div class="col-md-9 dashboard-content-col dashboard-chat">
    <div class="dashboard-list-box fl-wrap">
        <div class="dashboard-header fl-wrap">
            <h3><?php esc_html_e( 'Messages', 'citybook-add-ons' );?></h3>
        </div>

        <div id="chat-wrapper" class="row">
            <!-- chat-contacts--> 
            <div class="col-sm-4 chat-contacts-wrap">
                <div id="chat-contacts" class="chat-contacts fl-wrap">
                    <?php 
                    $user_chats = citybook_addons_get_chats( $current_user->ID ); 
                    if( !empty($user_chats) ){
                        foreach ($user_chats as $key => $chat) {
                            if($key == 0){
                                $lat_chat_id = $chat->cid;
                                $to_user_id = $chat->touid;
                                $first_user_id = $chat->user_one;
                            }
                            citybook_addons_get_template_part( 'templates-inner/chat', '', array('data'=>$chat, 'active' => $key == 0  ) );
                        }
                    }
                    ?>                                      
                </div>
            </div>
            <!-- chat-contacts end--> 

            <!-- chat-box--> 
            <div class="col-sm-8 chat-box-wrap">
                <div id="chat-box" class="chat-box fl-wrap grey-blue-bg loading-replies">
                </div>
                <div class="chat-replies-loading">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <div id="chat-input-wrap" class="message-input fl-wrap">
                    <form action="#" id="author-chat-form">
                        <textarea name="chat-msg" placeholder="<?php esc_attr_e( 'Type Message', 'citybook-add-ons' ); ?>" required></textarea>                                                 
                        <button type="submit"><i class="fa fa-paper-plane-o"></i></button>

                        <input type="hidden" name="cid" value="<?php echo $lat_chat_id; ?>">
                        <input type="hidden" name="touid" value="<?php echo $to_user_id; ?>">
                        <input type="hidden" name="fuid" value="<?php echo $first_user_id; ?>">
                    </form>
                </div>
            </div>
            <!-- chat-box end--> 
            
        </div>
    </div>
</div>