<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// don't show on customer dashboard
// if( !citybook_addons_current_user_can('submit_listing') ) return;
citybook_addons_reset_user_notification_type('listing_publish');

$current_user = wp_get_current_user();    

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}                 

$args = array(
    'post_type'     =>  'listing', 
    'author'        =>  $current_user->ID, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'paged'         => $paged,
    // 'posts_per_page' => -1 // no limit

    'post_status'   => array( 'publish', 'pending', 'draft', 'future' ),
);

// The Query
$posts_query = new WP_Query( $args );

?>
<div class="col-md-9 dashboard-content-col">
    <?php 
    if($posts_query->have_posts()) : ?>
    <div class="dashboard-list-box fl-wrap">
        <div class="dashboard-header fl-wrap">
            <h3><?php esc_html_e( 'Listings', 'citybook-add-ons' );?></h3>
        </div>
    <?php 
        while($posts_query->have_posts()) : $posts_query->the_post(); 
        
    ?>
        <div id="listing-<?php the_ID(); ?>" <?php post_class('dashboard-list'); ?>>
            <div class="dashboard-list-inner">
                <span class="new-dashboard-item"><?php echo citybook_addons_get_post_status(get_post_status(get_the_ID()));?></span>
                <?php
                if(has_post_thumbnail( )){ ?>
                <div class="dashboard-listing-table-image">
                    <a href="<?php echo esc_url( get_permalink() );?>"><?php the_post_thumbnail('listing-featured',array('class'=>'respimg') ); ?></a>
                </div>
                <?php } ?>
                <div class="dashboard-listing-table-text">
                    <?php
                    the_title( '<h4 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
                    ?>
                    <?php
                    $contact_infos = get_post_meta( get_the_ID(), '_cth_contact_infos', true );
                    if(isset($contact_infos['latitude'])&&isset($contact_infos['longitude'])&&isset($contact_infos['address'])) : 
                        // https://developers.google.com/maps/documentation/urls/guide#citybook-view-action
                    ?>
                    <div class="dashboard-listing-table-address"><i class="fa fa-map-marker"></i><a href="https://www.google.com/maps/search/?api=1&query=<?php echo $contact_infos['latitude'].','.$contact_infos['longitude'];?>" target="_blank"><?php echo esc_html( $contact_infos['address'] );?></a></div>
                    <?php 
                    endif;?>
                    <p><?php echo get_post_meta( get_the_ID(), '_cth_contact_infos_address', true ); ?></p>
                    <?php citybook_addons_get_template_part( 'templates-inner/listing-rating');?>
                    <ul class="dashboard-listing-table-opt  fl-wrap">
                        <li><a href="<?php echo esc_url( citybook_addons_get_edit_listing_url( ) );?>"><?php esc_html_e( 'Edit ', 'citybook-add-ons' );?><i class="fa fa-pencil-square-o"></i></a></li>
                        
                        <!-- <li><a data-listing="<?php echo esc_attr( get_the_ID() ); ?>" class="cplan-modal-open" href="#"><?php esc_html_e( 'Change Plan ', 'citybook-add-ons' );?><i class="fa fa-usd"></i></a></li> -->
                        
                        <li><a href="#" class="set-lfeatured<?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'featured', true ) == '1' ) echo ' lfeatured' ;?>" data-id="<?php echo get_the_ID();?>"><span class="lfeatured-loading"><i class="fa fa-spinner fa-pulse"></i></span><span class="as-lfeatured"><?php esc_html_e( 'Set as featured', 'citybook-add-ons' );?></span><span class="lfeatured"><?php esc_html_e( 'Featured', 'citybook-add-ons' );?></span></a></li>



                        <li><a href="#" class="del-btn del-listing" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><?php esc_html_e( 'Delete ', 'citybook-add-ons' );?><i class="fa fa-trash-o"></i></a></li>

                        
                    </ul>
                </div>
            </div>
        </div>
        <!-- dashboard-list end-->
    <?php endwhile; 
    ?>
    </div>
    <?php
        echo citybook_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
    
        /* Restore original Post Data 
         * NB: Because we are using new WP_Query we aren't stomping on the 
         * original $wp_query and it does not need to be reset with 
         * wp_reset_query(). We just need to set the post data back up with
         * wp_reset_postdata().
         */
        wp_reset_postdata();

    ?> 
    <?php else: ?>
    <div class="dashboard-list-box fl-wrap">
        <div class="dashboard-header fl-wrap">
            <h3><?php esc_html_e( 'Listings', 'citybook-add-ons' );?></h3>
        </div>
        <div id="listing-no" class="dashboard-list">
            <div class="dashboard-list-inner">
                <?php _e( 'You have no listing yet!', 'citybook-add-ons' ); ?>
            </div>
        </div>
        <!-- dashboard-list end-->
    </div>
    <?php
    endif; ?>
    
</div>

    