<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// don't show on customer dashboard
// if( !citybook_addons_current_user_can('submit_listing') ) return;

citybook_addons_reset_user_notification_type('new_invoice');

$current_user = wp_get_current_user();    

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}                 

$args = array(
    'post_type'     =>  'cthinvoice', 
    'author'        =>  $current_user->ID, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'paged'         => $paged,
    // 'posts_per_page' => -1 // no limit

    // double test for user invoice
    'meta_key'      => P_META_PREFIX.'user_id',
    'meta_value'    => $current_user->ID,

    'post_status'   => array( 'publish', 'pending', 'draft', 'future' ),
);

// The Query
$posts_query = new WP_Query( $args );

?>
<div class="col-md-9 dashboard-content-col">
    <table class="cth-table table-invoice">
        <thead>
            <tr>
                <th><?php _e( 'Title', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'Plan', 'citybook-add-ons' ); ?></th>
                
                <th><?php _e( 'Date', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'End', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'Amount', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'Action', 'citybook-add-ons' ); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php 
        if($posts_query->have_posts()) :
            while($posts_query->have_posts()) : $posts_query->the_post(); ?>
            <tr id="invoice-<?php the_ID(); ?>" <?php post_class('dashboard-list'); ?>>
                <td><?php the_title( '<h4 class="entry-title">', '</h4>' );;?></td>
                <td><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'plan_title', true); ?></td>
                
                <td><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'from_date', true); ?></td>
                <td><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'end_date', true); ?></td>
                <td><?php echo citybook_addons_get_price_formated( get_post_meta( get_the_ID(), P_META_PREFIX.'amount', true ) );?></td>
                <td><a href="#" class="btn color-bg view-invoice-btn" data-invoice="<?php the_ID(); ?>"><?php _e( 'View', 'citybook-add-ons' ); ?></a></td>
            </tr>
        
        <?php endwhile; 
            
        else:
        ?>
        <tr id="invoice-no" class="dashboard-list">
            <td colspan="6">
                <?php _e( 'You have no invoice yet!', 'citybook-add-ons' ); ?>
            </td>
        </tr>
        <?php
        endif; ?> 
        </tbody>
    </table>
    <?php 
    echo citybook_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
        
    /* Restore original Post Data 
     * NB: Because we are using new WP_Query we aren't stomping on the 
     * original $wp_query and it does not need to be reset with 
     * wp_reset_query(). We just need to set the post data back up with
     * wp_reset_postdata().
     */
    wp_reset_postdata(); ?>
    

</div>

    