<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



$current_user = wp_get_current_user(); 

$args = array(
    'fields'            => 'ids',
    'posts_per_page'    => 1000,
    'post_type'         => 'listing',
    'author'            => $current_user->ID,
    'post_status'       => array('publish','pending','future','private'),
);
// $customPosts = new WP_Query($args);
// echo "Last SQL-Query: {$customPosts->request}";

// die;

$listings_array = get_posts( $args );

// var_dump($listings_array);die;

$views_count = 0;
$comments_count = 0;
$reviews_count = 0;
$bookmarks_count = 0;
if(!empty($listings_array)){
    foreach ($listings_array as $listing_ID) {
        $views_count += citybook_addons_get_post_views($listing_ID);
        $comments_count += get_comments_number($listing_ID);
        $reviews = citybook_addons_get_average_ratings($listing_ID);
        if($reviews) $reviews_count += $reviews['count'];

        // bookmarks 
        $bookmarks = get_post_meta( $listing_ID, P_META_PREFIX.'bookmarks', true );
        if($bookmarks != '') $bookmarks_count += $bookmarks;
    }
}

$notifications = get_user_meta( $current_user->ID, P_META_PREFIX.'notifications', true );

$new_notifications = '';
if(!empty($notifications) && is_array($notifications)){
    $new_notifications = array_reverse($notifications);
}


?>
<div class="col-md-9 dashboard-content-col">
    <!-- profile-edit-container--> 
    <div class="profile-edit-container">
        <div class="profile-edit-header fl-wrap" style="margin-top:30px">
            <?php echo sprintf(__( '<h4>Hello, <span>%s</span></h4>', 'citybook-add-ons' ), $current_user->display_name); ?>
        </div>
        <?php 
        if(is_array($new_notifications)): 
            $first_msg = reset($new_notifications);
            $first_key = key($new_notifications);
        ?>
        <div class="notification success fl-wrap notification-item">
            <p><?php echo $first_msg; ?></p>
            <a class="notification-close delete-notification" href="#" data-notification="<?php echo esc_attr( $first_key ); ?>"><i class="fa fa-times"></i></a>
        </div>     
        <?php endif; ?>   
        <?php if(  citybook_addons_current_user_can('view_listings_dashboard') ): ?>                                
        <!-- statistic-container--> 
        <div class="statistic-container fl-wrap">
        	<!-- statistic-item-wrap--> 
        	<div class="statistic-item-wrap"> 
	        	<div class="statistic-item gradient-bg fl-wrap">
	            	<i class="fa fa-map-marker"></i>
	                <div class="statistic-item-numder"><?php echo count($listings_array); ?></div>
	                <h5><?php _e( 'Active Listings', 'citybook-add-ons' ); ?></h5>
	            </div>
            </div>
	        <!-- statistic-item-wrap end-->                                            
	        <!-- statistic-item-wrap--> 
        	<div class="statistic-item-wrap"> 
	        	<div class="statistic-item gradient-bg fl-wrap">
	            	<i class="fa fa fa-eye"></i>
	                <div class="statistic-item-numder"><?php echo $views_count; ?></div>
	                <h5><?php _e( 'Listing Views', 'citybook-add-ons' ); ?></h5>
	            </div>
            </div>
	        <!-- statistic-item-wrap end-->                                             
	        <!-- statistic-item-wrap--> 
        	<div class="statistic-item-wrap"> 
	        	<div class="statistic-item gradient-bg fl-wrap">
	            	<i class="fa fa-comments-o"></i>
	                <div class="statistic-item-numder"><?php echo $reviews_count; ?></div>
	                <h5><?php _e( 'Total Reviews', 'citybook-add-ons' ); ?></h5>
	            </div>
            </div>
	        <!-- statistic-item-wrap end-->                                            
	        <!-- statistic-item-wrap--> 
        	<div class="statistic-item-wrap"> 
	        	<div class="statistic-item gradient-bg fl-wrap">
	            	<i class="fa fa-heart-o"></i>
	                <div class="statistic-item-numder"><?php echo $bookmarks_count; ?></div>
	                <h5><?php _e( 'Times Bookmarked', 'citybook-add-ons' ); ?></h5>
	            </div>
            </div>
        	<!-- statistic-item-wrap end-->  
        </div>
		<!-- statistic-container end--> 
        <?php endif; ?>
    </div>
    <!-- profile-edit-container end-->  
    
    <div class="dashboard-list-box fl-wrap activities">
        <div class="dashboard-header fl-wrap">
            <h3><?php _e( 'Recent Activities', 'citybook-add-ons' ); ?></h3>
        </div>
        <?php 
        if(is_array($new_notifications)):  
        array_shift($new_notifications);
        foreach ($new_notifications as $key => $message) {
            $noti_type = citybook_addons_get_notification_type($key);
            $noti_icon = '';
            switch ($noti_type) {
                case 'listing_submitted':
                case 'order_completed':
                case 'listing_publish':
                    $noti_icon = '<i class="fa fa-check"></i> ';
                    break;
                case 'new_bookmarks':
                case 'bookmarked':
                    $noti_icon = '<i class="fa fa-bookmark"></i> ';
                    break;
                case 'review':
                    $noti_icon = '<i class="fa fa-comments-o"></i> ';
                    break;
                case 'delete_listing':
                    $noti_icon =  '<i class="fa fa-exclamation-triangle"></i> '; // '<i class="fa fa-eye-slash"></i> ';
                    break;
                case 'role_change':
                    $noti_icon = '<i class="fa fa-unlock-alt"></i> ';
                    break;
                case 'ad_completed':
                    $noti_icon = '<i class="fa fa-bullhorn"></i> ';
                    break;
                case 'password_changed':
                case 'edit_profile':
                    $noti_icon = '<i class="fa fa-edit"></i> ';
                    break;
                case 'booking_approved':
                    $noti_icon = '<i class="fa fa-check-square-o"></i> ';
                    break;
                    
                    
                    
                    
             }
        ?>  
        <div class="dashboard-list notification-item">
            <div class="dashboard-message">
                <span class="new-dashboard-item delete-notification" data-notification="<?php echo esc_attr( $key ); ?>"><i class="fa fa-times"></i></span>
                <div class="dashboard-message-text">
                    <p><?php echo $noti_icon . $message; ?></p>
                </div>
            </div>
        </div>
        <!-- dashboard-list end-->    
        <?php } ?>

        <?php else: ?> 
        <div class="dashboard-list">
            <div class="dashboard-message">
                <div class="dashboard-message-text">
                    <p><?php echo _e( 'You have no activity.', 'citybook-add-ons' ); ?></p>
                </div>
            </div>
        </div>
        <!-- dashboard-list end-->  
        <?php endif; ?> 
    </div>
                                          
                                          
</div>


