<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */





$current_user = wp_get_current_user(); 

// author listings
$au_listings = get_posts( array(
    'fields'                => 'ids',
    'post_type'             =>  'listing', 
    'author'                =>  $current_user->ID, 
    'orderby'               =>  'date',
    'order'                 =>  'DESC',
    'post_status'           => 'publish',
    'posts_per_page'        => -1, // no limit
) );
$au_listing_ids = array();
foreach ( $au_listings as $post_ID ) {
   $au_listing_ids[] = $post_ID;
}   
if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}  

$meta_queries = array(
    // show user bookings
    array(
        'relation' => 'AND',
        array(
            'key'     => P_META_PREFIX.'lb_email',
            'value'   => $current_user->user_email,
        ),
        array(
            'key'     => P_META_PREFIX.'lb_status',
            'value'   => 'canceled',
            'compare' => '!='
        )  
    ),
);   
if(!empty($au_listing_ids))  {
    $meta_queries['relation'] = 'OR';
    $meta_queries[] = array(
        'key'     => P_META_PREFIX.'listing_id',
        'value'   => $au_listing_ids,
        'compare' => 'IN',
        'type' => 'NUMERIC',
    );
}          

$args = array(
    'post_type'     =>  'lbooking', 
    // 'author'        =>  0, 
    'orderby'       =>  'date',
    'order'         =>  'DESC',
    'paged'         => $paged,
    'post_status'   => 'publish',
    // 'posts_per_page' => -1, // no limit
    // 'posts_per_page' => 1,
    'meta_query' => $meta_queries
    
);
// The Query
$posts_query = new WP_Query( $args );

?>
<div class="col-md-9 dashboard-content-col">
    <div class="dashboard-list-box fl-wrap">
        <div class="dashboard-header fl-wrap">
            <h3><?php esc_html_e( 'Bookings', 'citybook-add-ons' );?></h3>
        </div>

    <?php 
    if($posts_query->have_posts()) :
        while($posts_query->have_posts()) : $posts_query->the_post(); 
            $listing = get_post( get_post_meta( get_the_ID(), P_META_PREFIX.'listing_id', true ) );
            $lb_email = get_post_meta( get_the_ID(), P_META_PREFIX.'lb_email', true );
            $lb_phone = get_post_meta( get_the_ID(), P_META_PREFIX.'lb_phone', true );

            // var_dump( get_post_meta( get_the_ID(), P_META_PREFIX.'lb_status', true ) );
        ?>
        <div id="booking-<?php the_ID(); ?>" <?php post_class('dashboard-list booking-item'); ?>>
            <div class="dashboard-message">
                <?php if($current_user->user_email == $lb_email){ ?>
                    <span class="you-booked"><?php _e( 'Your booked', 'citybook-add-ons' ); ?></span>
                <?php }elseif(get_post_meta( get_the_ID(), P_META_PREFIX.'lb_status', true ) == 'pending'){ ?>
                    <span class="new-dashboard-item"><?php _e( 'New', 'citybook-add-ons' ); ?></span>
                <?php } ?>
                <div class="dashboard-message-avatar">
                    <?php echo get_avatar($lb_email,'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_post_meta( get_the_ID(), P_META_PREFIX.'lb_name', true ) ); ?>
                </div>
                <div class="dashboard-message-text">
                    <?php echo sprintf( __( '<h4 class="booking-title">Booking by <strong>%1$s</strong> - <span>%2$s</span></h4>', 'citybook-add-ons' ) , get_the_title(  ), get_the_date(get_option( 'date_format' )) ); ?>
                    <div class="booking-details fl-wrap">
                        <span class="booking-title"><?php esc_html_e( 'Listing Item: ', 'citybook-add-ons' ); ?></span>
                        <span class="booking-text"><a href="<?php echo esc_url( get_permalink( $listing ) ); ?>" target="_blank"><?php echo esc_html($listing->post_title); ?></a></span>
                    </div>
                    <div class="booking-details fl-wrap">
                        <span class="booking-title"><?php esc_html_e( 'Quantity (Persons): ', 'citybook-add-ons' ); ?></span>
                        <span class="booking-text"><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'lb_quantity', true ); ?></span>
                    </div>
                    <div class="booking-details fl-wrap">
                        <span class="booking-title"><?php esc_html_e( 'Booking Date: ', 'citybook-add-ons' ); ?></span>
                        <span class="booking-text"><?php echo sprintf(__( '%1$s at %2$s', 'citybook-add-ons' ), get_post_meta( get_the_ID(), P_META_PREFIX.'lb_date', true ), get_post_meta( get_the_ID(), P_META_PREFIX.'lb_time', true ) ); ?></span>
                    </div>
                    <div class="booking-details fl-wrap">                                                               
                        <span class="booking-title"><?php esc_html_e( 'Mail: ', 'citybook-add-ons' ); ?></span>
                        <span class="booking-text"><a href="mailto:<?php echo $lb_email; ?>"><?php echo $lb_email; ?></a></span>
                    </div>
                    <div class="booking-details fl-wrap">
                        <span class="booking-title"><?php esc_html_e( 'Phone: ', 'citybook-add-ons' ); ?></span>
                        <span class="booking-text"><a href="tel:<?php echo $lb_phone; ?>"><?php echo $lb_phone; ?></a></span>
                    </div>
                    <?php echo wpautop( get_post_meta( get_the_ID(), P_META_PREFIX.'lb_add_info', true ), true ); ?>
                    <div class="booking-btns">
                        <?php if($current_user->user_email == $lb_email ): ?>
                            <?php 
                            if( get_post_meta( get_the_ID(), P_META_PREFIX.'lb_status', true ) == 'completed' ): ?>
                            <span class="btn circle-btn color-bg flat-btn"><?php esc_html_e( 'Approved', 'citybook-add-ons' ); ?><i class="fa fa-check-square-o"></i></span>
                            <?php endif; ?>
                            <?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'lb_status', true ) == 'pending' || citybook_addons_get_option('booking_approved_cancel') == 'yes' ): ?>
                                <a href="#" class="btn circle-btn flat-btn cancel-booking" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><?php esc_html_e( 'Cancel', 'citybook-add-ons' ); ?></a>
                            <?php endif; ?>
                        <?php else: ?>
                            <?php 
                            if( get_post_meta( get_the_ID(), P_META_PREFIX.'lb_status', true ) == 'completed' ): ?>
                            <span class="btn circle-btn color-bg flat-btn"><?php esc_html_e( 'Approved', 'citybook-add-ons' ); ?><i class="fa fa-check-square-o"></i></span>
                            <?php else: ?>
                            <a href="#" class="btn circle-btn color-bg flat-btn approve-booking" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><span><?php esc_html_e( 'Approve', 'citybook-add-ons' ); ?></span><i class="fa fa-check-square-o"></i></a>
                            <?php endif; ?>

                            <?php if( citybook_addons_get_option('booking_author_delete') == 'yes' ): ?>
                                <a href="#" class="btn circle-btn flat-btn del-btn del-booking" data-id="<?php echo get_the_ID();?>" data-title="<?php echo esc_attr( get_the_title() ); ?>"><?php esc_html_e( 'Delete', 'citybook-add-ons' ); ?><i class="fa fa-trash-o"></i></a>
                            <?php endif; ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- dashboard-list end--> 
    <?php endwhile; ?>
    </div>
    <?php
        echo citybook_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
        /* Restore original Post Data 
         * NB: Because we are using new WP_Query we aren't stomping on the 
         * original $wp_query and it does not need to be reset with 
         * wp_reset_query(). We just need to set the post data back up with
         * wp_reset_postdata().
         */
        wp_reset_postdata();
    else:
    ?> 
        <div id="booking-no" class="dashboard-list">
            <div class="dashboard-message">
                <?php _e( 'You have no booking yet!', 'citybook-add-ons' ); ?>
            </div>
        </div>
    </div>
    <?php
    endif; ?> 
    
</div>