<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// don't show on customer dashboard
// if( !citybook_addons_current_user_can('submit_listing') ) return;

citybook_addons_reset_user_notification_type('ad_completed');

$current_user = wp_get_current_user();    

if(is_front_page()) {
    $paged = (get_query_var('page')) ? get_query_var('page') : 1;
} else {
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
}                 

$args = array(
    'post_type'         =>  'cthads', 
    'author'            =>  $current_user->ID, 
    'orderby'           =>  'date',
    'order'             =>  'DESC',
    'paged'             => $paged,

    'post_status'       => array( 'publish', 'pending', 'draft', 'future' ),

    'meta_query' => array(
        // 'relation' => 'AND',
        array(
            'key'     => P_META_PREFIX.'user_id',
            'value'   => $current_user->ID,
        ),
        // array(
        //     'key' => P_META_PREFIX.'order_type',
        //     'value'   => 'listing_ad',
        // ),
    ),

);

// The Query
$posts_query = new WP_Query( $args );

?>
<div class="col-md-9 dashboard-content-col">
    <div class="new-campaign">
        <a href="#" class="btn color-bg new-campaign-btn open-new-campaign-modal"><?php _e( 'Add new campaign', 'citybook-add-ons' ); ?></a>
    </div>
    <?php
    //if($posts_query->have_posts()) : ?>
    <table class="cth-table table-ads">
        <thead>
            <tr>
                <th><?php _e( 'ID', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'AD Package', 'citybook-add-ons' ); ?></th>
                <!-- <th><?php _e( 'Payment Type', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'Payment Count', 'citybook-add-ons' ); ?></th> -->
                <th><?php _e( 'Listing', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'End', 'citybook-add-ons' ); ?></th>
                <th><?php _e( 'Status', 'citybook-add-ons' ); ?></th>
            </tr>
        </thead>
        <tbody>
        <?php
        if($posts_query->have_posts()) : 
            while($posts_query->have_posts()) : $posts_query->the_post(); 
                $status = get_post_meta( get_the_ID(), P_META_PREFIX.'status', true );
                $time_status = citybook_addons_get_package_time_status(get_the_ID());
                $plan_id = get_post_meta( get_the_ID(), P_META_PREFIX.'plan_id', true);
            ?>
            <tr id="lad-<?php the_ID(); ?>" <?php post_class('dashboard-list'); ?>>
                <td><?php the_ID();?></td>
                <td><?php 
                $ad_package = get_term( $plan_id, 'cthads_package' );
                // check if the ad package is deleted
                if ( ! empty( $ad_package ) && ! is_wp_error( $ad_package ) ){
                    echo $ad_package->name;
                }
                ?></td>
                <!-- <td><?php echo citybook_addons_get_order_type( get_post_meta( get_the_ID(), P_META_PREFIX.'is_recurring_plan', true) ); ?></td>
                <td><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'payment_count', true); ?></td> -->
                <td><?php echo get_the_title( get_post_meta( get_the_ID(), P_META_PREFIX.'listing_id', true) ); ?></td>
                <td><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'end_date', true); ?></td>
                <td><span class="ad-status"><?php echo citybook_addons_get_package_status($status.'_'.$time_status);?></span></td>
            </tr>
        
        <?php 
            endwhile; 
        else: ?>
            <tr id="lad-no" class="dashboard-list">
                <td colspan="5"><p><?php echo _e( 'You have no ad campaign.', 'citybook-add-ons' ); ?></p></td>
            </tr>
        <?php
        endif;?> 
        </tbody>
    </table>

    <?php
        echo citybook_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
    
        /* Restore original Post Data 
         * NB: Because we are using new WP_Query we aren't stomping on the 
         * original $wp_query and it does not need to be reset with 
         * wp_reset_query(). We just need to set the post data back up with
         * wp_reset_postdata().
         */
        wp_reset_postdata();

    //endif; ?>

</div>

    