<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
$current_user = wp_get_current_user(); 

$checkout_type = 'default';

$trial_text = __( 'No', 'citybook-add-ons' );
// check for new ad
if(isset($_POST['new-ad-submit']) && isset($_POST['ad-package']) && isset($_POST['ad-listing']) ){
    $checkout_type = 'for_ad';
    // listing post
    $listing_post = get_post($_POST['ad-listing']);
    // display none on incorrect plan
    if(null == $listing_post ){
        return;
    }

    // ad package term
    $ad_package = get_term( $_POST['ad-package'], 'cthads_package' );

    if ( empty( $ad_package ) || is_wp_error( $ad_package ) ){
        return;
    }

    $raw_price = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_price', true );
    $plan_title = $ad_package->name;
    $var_plan_id = $ad_package->term_id;

    $prices = citybook_addons_get_plan_prices(0, $raw_price);

    // listing submission limit
    $limit_text = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_limit', true ) != '' ? get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_limit', true ) : 1 ;
    $plan_interval = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_interval', true );
    $plan_period = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_period', true );
    if($plan_interval){
        $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
    }else{
        $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
    }

    // for stripe button data
    $stripe_btn_data = array(
        'amount' => citybook_addons_get_stripe_amount( $prices['total'] ),
        'plan' => $plan_title,
        'email' => $current_user->user_email,
        'is_recurring' => get_term_meta( $ad_package->term_id , P_META_PREFIX.'is_recurring', true )? true : false,
    );

    // include listing name to plan title
    $plan_title .= sprintf(__( ' For <strong>%s</strong> listing', 'citybook-add-ons' ), $listing_post->post_title);


}elseif(( isset($_POST['change_plan']) || isset($_POST['lplan_select']) ) && isset($_POST['plan_id'])){
    $checkout_type = 'for_membership';

    // $listing_post = get_post($_POST['listing_id']);
    // // display none on incorrect listing or not authorize listing item
    // if(null == $listing_post || $listing_post->post_author != $current_user->ID) return;

    // plan post
    $plan_post = get_post($_POST['plan_id']);
    // display none on incorrect plan
    if(null == $plan_post ){
        return;
    }

    $raw_price = get_post_meta( $plan_post->ID, P_META_PREFIX.'price', true );
    $plan_title = $plan_post->post_title;

    $var_plan_id = $plan_post->ID;

    $prices = citybook_addons_get_plan_prices($plan_post->ID);

    // listing submission limit
    $limit_text = get_post_meta( $plan_post->ID , P_META_PREFIX.'lunlimited', true )? __( 'Unlimited', 'citybook-add-ons' ) : get_post_meta( $plan_post->ID , P_META_PREFIX.'llimit', true );
    $plan_interval = get_post_meta( $plan_post->ID, P_META_PREFIX.'interval', true );
    $plan_period = get_post_meta( $plan_post->ID, P_META_PREFIX.'period', true );
    if($plan_interval){
        $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
    }else{
        $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
    }
    if(  get_post_meta( $plan_post->ID, P_META_PREFIX.'lnever_expire', true ) ) $expire = __( 'Never', 'citybook-add-ons' );

    // for stripe button data
    $stripe_btn_data = array(
        'amount' => citybook_addons_get_stripe_amount( $prices['total'] ),
        'plan' => $plan_post->post_title,
        'email' => $current_user->user_email,
        'is_recurring' => get_post_meta( $plan_post->ID , P_META_PREFIX.'is_recurring', true )? true : false,
    );

    $trial_interval = get_post_meta( $plan_post->ID , P_META_PREFIX.'trial_interval', true );
    $trial_period = get_post_meta( $plan_post->ID , P_META_PREFIX.'trial_period', true );
    if(!empty($trial_interval) && !empty($trial_period)){
        $trial_text = citybook_add_ons_get_plan_trial_text( $trial_interval, $trial_period );
    }
}else{
    return;
}
?>
<!--section --> 
<section>
    <!-- container -->
    <div class="container">
        <!-- profile-edit-wrap -->
        <div class="profile-edit-wrap">
            <div class="profile-edit-page-header">
                <h2><?php the_title();?></h2>
                <?php citybook_addons_breadcrumbs();?>
            </div>
            <div class="row">

                <div class="col-md-12">
                    <form autocomplete="off" class="listing-payment-form row" id="listing-payment-form" method="POST" name="listing-payment-form">
                        <?php if(empty($prices['total'])): ?>
                        <div class="col-md-12 payment-details">
                        <?php else: ?>
                        <div class="col-md-8 payment-details">
                        <?php endif; ?>
                            <div class="payment-details-wrap">
                                <h4><?php esc_html_e( 'Details', 'citybook-add-ons' ); ?></h4>
                                
                                <div class="plan-details">
                                    
                                    <table>
                                        <thead>
                                            <tr>
                                                <th><?php _e( 'Price', 'citybook-add-ons' ); ?></th>
                                                <th><?php _e( 'Listings', 'citybook-add-ons' ); ?></th>
                                                <th><?php _e( 'Period', 'citybook-add-ons' ); ?></th>
                                                <th><?php _e( 'Expired', 'citybook-add-ons' ); ?></th>
                                                <th><?php _e( 'Trial', 'citybook-add-ons' ); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td><?php echo citybook_addons_get_price_formated( $raw_price ); ?></td>
                                                <td><?php echo $limit_text; ?></td>
                                                
                                                <td><?php echo citybook_add_ons_get_plan_period_text( $plan_interval, $plan_period ); ?></td>
                                                <td><?php echo $expire; ?></td>
                                                <td><?php echo $trial_text; ?></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            <?php 
                            if($checkout_type === 'for_ad'): ?>
                                <input type="hidden" name="listing-id" value="<?php echo esc_attr( $listing_post->ID );?>">
                                <input type="hidden" name="ad-package" value="<?php echo esc_attr( $var_plan_id );?>">
                                <input type="hidden" name="ad_checkout" value="AD Checkout">
                            <?php else: ?>
                                <input type="hidden" name="listing-id" value="0">
                                <input type="hidden" name="plan-id" value="<?php echo esc_attr( $var_plan_id );?>">
                                <input type="hidden" name="membership_checkout" value="Membership Checkout">
                            <?php endif; ?>
                                
                            </div>
                            <div class="payment-total-wrap">
                                <table>
                                    <thead>
                                        <tr>
                                            <th><?php esc_html_e( 'Product', 'citybook-add-ons' ); ?></th>
                                            <th><?php esc_html_e( 'Total', 'citybook-add-ons' ); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo $plan_title;?></td>
                                            <td><?php echo citybook_addons_get_price_formated($prices['price']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><?php esc_html_e( 'Tax (VAT)', 'citybook-add-ons' ); ?></td>
                                            <td><?php echo citybook_addons_get_price_formated($prices['tax']); ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong><?php esc_html_e( 'Total', 'citybook-add-ons' ); ?></strong></td>
                                            <td><strong><?php echo citybook_addons_get_price_formated($prices['total']); ?></strong></td>
                                        </tr>
                                    </tbody>
                                </table>
                                
                            </div>  
                            <div class="process-checkout-wrap">
                                <input data-lplan="<?php echo esc_attr( rawurlencode( json_encode( $stripe_btn_data ) ) ); ?>" class="btn color-bg" type="submit" id="lcheckout_btn" value="<?php esc_attr_e( 'Place Order', 'citybook-add-ons' ); ?>">
                                <?php wp_nonce_field( 'listing-checkout', '_wpnonce', true, true ); ?>
                            </div>
                        </div>
                        <!-- .payment-details end -->
                        <?php if(empty($prices['total'])): ?>
                            <input type="hidden" name="payment-method" value="free">
                        <?php else: ?>
                        <div class="col-md-4 payment-methods">
                            <div class="payment-methods-wrap custom-form">
                                <h4><?php esc_html_e( 'Payment Method', 'citybook-add-ons' ); ?></h4>
                                <?php 
                                $idx = 0;
                                foreach (citybook_addons_get_payment_methods() as $method => $data) {
                                ?>
                                <div class="payment-method-item payment-method-<?php echo $method;?>">
                                    <label for="payment-<?php echo $method;?>">
                                        <input type="radio" name="payment-method" id="payment-<?php echo $method;?>" data-btn="<?php echo $data['checkout_text'];?>" value="<?php echo $method;?>" required="required" <?php //if($idx == 0) echo ' checked="checked"'; ?>>
                                        <img src="<?php echo $data['icon'];?>" alt="<?php echo $data['title'];?>">
                                        <span class="payment-desc"><?php echo $data['desc'];?></span>
                                    </label>
                                </div>
                                <!-- end <?php echo $method;?> -->
                                <?php
                                $idx++;
                                } ?>
                                
                            </div>
                        </div>
                        <!-- .payment-methods end -->
                        <?php endif; ?>
                    </form>
                    
                </div>
                <!-- end col -->

            </div>
        </div>
        <!--profile-edit-wrap end -->
    </div>
    <!--container end -->
</section>
<!-- section end -->
<div class="limit-box fl-wrap"></div>

