<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




// for ajax search

add_action('wp_ajax_nopriv_citybook_addons_ajax_search', 'citybook_addons_ajax_search_callback');
add_action('wp_ajax_citybook_addons_ajax_search', 'citybook_addons_ajax_search_callback');

function citybook_addons_ajax_search_callback() {
    // global $wp_query;
    $json = array(
        'success' => true,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    // wp_send_json($json );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;

        // die ( '<p class="error">Security checked!, Cheatn huh?</p>' );

        wp_send_json($json );
    }

    // track for ajax request
    $json['data']['ajax_count']     = $_POST['ajax_count'];
    $post_args = array();


    $tax_queries = array();
    $merge_lcats = array();
    if(isset($_POST['lcats'])) $merge_lcats = array_merge( $merge_lcats, array_filter($_POST['lcats']) );
    if(isset($_POST['filter_subcats']) && !empty($_POST['filter_subcats'])) $merge_lcats =  array_filter($_POST['filter_subcats']);
    // if( isset($_POST['lcats']) && !empty( array_filter($_POST['lcats']) ) ){
    if( !empty( $merge_lcats ) ){
        $tax_queries[] =    array(
                                'taxonomy' => 'listing_cat',
                                'field'    => 'term_id',
                                'terms'    => $merge_lcats,
                                // 'include_children'  => false, // default true
                                // 'operator' => 'AND', // default IN
                            );
    }
    if( isset($_POST['lfeas']) && !empty( array_filter($_POST['lfeas']) ) ){
        $tax_queries[] =    array(
                                'taxonomy' => 'listing_feature',
                                'field'    => 'term_id',
                                'terms'    => $_POST['lfeas'],
                                'operator' => 'AND', // default IN
                            );
    }
    if( isset($_POST['llocs']) && !empty($_POST['llocs'] ) ){
        $tax_queries[] =    array(
                                'taxonomy' => 'listing_location',
                                'field'    => 'slug',
                                // 'terms'    => sanitize_title($_POST['llocs']),
                                'terms'    => $_POST['llocs'],
                            );
    }
    if( isset($_POST['ltags']) && !empty( array_filter($_POST['ltags']) ) ){
        $tax_queries[] =    array(
                                'taxonomy' => 'post_tag',
                                'field'    => 'term_id',
                                'terms'    => $_POST['ltags'],
                                'operator' => 'AND', // default IN
                            );
    }

    if(!empty($tax_queries)){
        if( count($tax_queries) > 1 ) $tax_queries['relation'] = citybook_addons_get_option('search_tax_relation');
        $post_args['tax_query'] = $tax_queries;
    } 

    // custom field query
    $meta_queries = array();
    
    // address_add value
    // if( isset($_POST['address_add']) && !empty($_POST['address_add'] ) ){
    //     $address_q = explode(",", $_POST['address_add']);
    //     $addes_qr = array();
    //     foreach ($address_q as $add_r) {
    //         $addes_qr[] =    array(
    //                             'key' => P_META_PREFIX.'contact_infos_address',
    //                             'value'    => trim($add_r),
    //                             'compare' => 'LIKE',
    //                         );
    //     }
    //     if(count($addes_qr)> 1) $addes_qr['relation'] = 'OR';
        
    //     $meta_queries[] = $addes_qr;
    // }

    // price_range filter
    if( isset($_POST['price_range']) && !empty($_POST['price_range'] ) ){
        $meta_queries[] =    array(
                                    'key' => P_META_PREFIX.'price_range',
                                    'value'    => $_POST['price_range'],
                                );
    }

    // query by date
    
    if( isset($_POST['event_date']) && !empty($_POST['event_date'] ) ){
        $meta_queries[] =    array(
                                        'key'       => P_META_PREFIX.'levent_date',
                                        'value'     => $_POST['event_date'],
                                        'compare'   => '>=',
                                        'type'      => 'DATE'
                                    );
    }
    if( isset($_POST['event_time']) && !empty($_POST['event_time'] ) ){
        $meta_queries[] =    array(
                                        'key'       => P_META_PREFIX.'levent_time',
                                        'value'     => $_POST['event_time'],
                                        'compare'   => '>=',
                                        'type'      => 'TIME'
                                    );
    }

        
    

    if(!empty($meta_queries)){
        if(count($meta_queries)> 1) $meta_queries['relation'] = 'AND';
        $post_args['meta_query'] = $meta_queries;
    } 

    
    $post_args['post_type'] = 'listing';
    $post_args['post_status'] = 'publish';
    $post_args['posts_per_page'] = citybook_addons_get_option('listings_count');
    $post_args['orderby'] = citybook_addons_get_option('listings_orderby');
    $post_args['order'] = citybook_addons_get_option('listings_order');

    if( isset($_POST['lposts_per_page']) ) $post_args['posts_per_page'] = $_POST['lposts_per_page'];
    if( isset($_POST['lorderby']) ) $post_args['orderby'] = $_POST['lorderby'];
    if( isset($_POST['lorder']) ) $post_args['order'] = $_POST['lorder'];
    
    if( ( isset($_POST['lorderby']) && $_POST['lorderby'] == 'listing_featured' ) || citybook_addons_get_option('listings_orderby') == 'listing_featured'){
        $post_args['meta_key'] = P_META_PREFIX.'featured';
        $post_args['orderby'] = 'meta_value_num';
    }

    if(citybook_addons_get_option('listings_orderby') == 'event_start_date'){
        $post_args['meta_key'] = P_META_PREFIX.'levent_date';
        $post_args['meta_type'] = 'DATE';
        $post_args['orderby'] = 'meta_value_date';
    }


    $post_args['suppress_filters'] = false; // for additional wpdb query
    $post_args['cthqueryid'] = 'ajax-search';
    $post_args['paged'] = 1;
    if( isset($_POST['paged']) && is_numeric($_POST['paged']) ) $post_args['paged'] = $_POST['paged'];

    // meta prder
    if( isset($_POST['morderby']) && !empty($_POST['morderby'] ) ){
        switch ($_POST['morderby']) {
            case 'most_reviewed':
                $post_args['orderby'] = 'comment_count';
                $post_args['order'] = 'DESC';
                break;
            case 'most_viewed':
                $post_args['meta_key'] = P_META_PREFIX.'post_views_count';
                $post_args['orderby'] = 'meta_value_num';
                $post_args['order'] = 'DESC';
                break;
            case 'most_liked':
                $post_args['meta_key'] = P_META_PREFIX.'post_like_count';
                $post_args['orderby'] = 'meta_value_num';
                $post_args['order'] = 'DESC';
                break;
            case 'highest_rated':
                $post_args['meta_key'] = P_META_PREFIX.'rating_average';
                $post_args['orderby'] = 'meta_value_num';
                $post_args['order'] = 'DESC';
                break;
            case 'price_desc':
                $post_args['meta_key'] = '_price';
                $post_args['orderby'] = 'meta_value_num';
                $post_args['order'] = 'DESC';
                break;
            case 'price_asc':
                $post_args['meta_key'] = '_price';
                $post_args['orderby'] = 'meta_value_num';
                $post_args['order'] = 'ASC';
                break;
                
        }
    }
    

    
    // if(isset($_POST['status']) && $_POST['status'] == 'open'){
    //     $get_post_args = $post_args;
    //     $get_post_args['suppress_filters'] = true;
    //     // $get_post_args['offset'] = 0;

    //     $get_post_args['fields'] = 'ids';
    //     $get_post_args['posts_per_page'] = -1;
        
    //     $open_posts_list = get_posts( $get_post_args );
    //     $open_posts = array();
    //     foreach ( $open_posts_list as $post_ID ) {
    //         $wkhour = citybook_addons_get_working_hours($post_ID);
    //         if($wkhour['status'] === 'opening') $open_posts[] = $post_ID;
    //     }
    //     $json['data']['open_posts'] = $open_posts;
    //     if(!empty($open_posts)){
    //         $post_args['post__in'] = $open_posts;
    //     }else{
    //         $json['data']['posts'] = array();
    //         $json['data']['pagination'] = '';
    //         wp_send_json($json );
    //     }
    // }

    // add filter for custom filter field
    $post_args = apply_filters( 'citybook_addons_ajax_search_args', $post_args );
    
    // $json['data']['posts_query_after'] = $post_args;
    

    $posts_query = new WP_Query($post_args);

    // $json['data']['custom_sql'] = $posts_query->request;

    $json['data']['posts'] = array();
    if($posts_query->have_posts()): 
        while($posts_query->have_posts()) : $posts_query->the_post();
            $json['data']['posts'][] = citybook_addons_get_listing_post_data();
        endwhile;
    endif;
    ob_start(); 
    citybook_addons_ajax_pagination( $posts_query->max_num_pages,$range = 2, $posts_query );
    $json['data']['pagination'] = ob_get_clean();

    wp_reset_postdata();
    // https://premium.wpmudev.org/blog/load-posts-ajax/
    wp_send_json($json );

}


add_filter( 'posts_clauses', 'citybook_addons_posts_clauses_callback', 999, 2 );

function citybook_addons_posts_clauses_callback($clauses, $query_obj){
    global $wpdb;
    if($query_obj->get('cthqueryid') == 'ajax-search' || $query_obj->get('cthqueryid') == 'main-search') {
        $fields = '';
        $joins = '';
        $having = array();
        $wheres = array();
        if( isset($_POST['nearme-filter']) && $_POST['nearme-filter'] == 'yes' && isset($_POST['address_lat']) && !empty($_POST['address_lat'] ) && isset($_POST['address_lng']) && !empty($_POST['address_lng'] ) && isset($_POST['ldistance']) && $_POST['ldistance'] ){
            $fields .= $wpdb->prepare(
                ", ( 6371 * acos( cos( radians( %s ) ) * cos( radians( distance_lat.meta_value ) ) * cos( radians( distance_lng.meta_value ) - radians( %s ) ) + sin( radians( %s ) ) * sin( radians( distance_lat.meta_value ) ) ) ) AS listing_distance ",
                $_POST['address_lat'], 
                $_POST['address_lng'], 
                $_POST['address_lat']
            );
            $joins .= $wpdb->prepare(
                " INNER JOIN $wpdb->postmeta distance_lat ON distance_lat.post_id = {$wpdb->posts}.ID AND distance_lat.meta_key = %s"
                . " INNER JOIN  $wpdb->postmeta distance_lng ON distance_lng.post_id = {$wpdb->posts}.ID AND distance_lng.meta_key = %s ",
                '_cth_contact_infos_latitude',
                '_cth_contact_infos_longitude'
            );

            $having[] = "listing_distance < '{$_POST['ldistance']}'";
        }

        // https://stackoverflow.com/questions/14950466/how-to-split-the-name-string-in-mysql
        // https://stackoverflow.com/questions/12344795/count-the-number-of-occurrences-of-a-string-in-a-varchar-field

        if( isset($_REQUEST['search_term']) && !empty($_REQUEST['search_term'] ) ){
            $address_q = explode(",", $_REQUEST['search_term']);
            $address_qr = array();
            foreach ($address_q as $add_r) {
                $address_qr[] =   $wpdb->prepare("laddress_meta.meta_value LIKE %s", '%' . $wpdb->esc_like(trim($add_r)) . '%');
            }
            $address_qr = "( ".implode(" OR ", $address_qr)." )";
            $joins .= $wpdb->prepare(
                " LEFT JOIN $wpdb->postmeta AS laddress_meta ON laddress_meta.post_id = {$wpdb->posts}.ID AND laddress_meta.meta_key = %s",
                '_cth_contact_infos_address'
                
            );
            $search_term_esc = '%' . $wpdb->esc_like($_REQUEST['search_term']) . '%';
            $post_tag_like = '';
            if(citybook_addons_get_option('search_include_tag', 'yes') == 'yes'){
                $post_tag_like = $wpdb->prepare( " OR EXISTS (
                        SELECT 1
                        FROM $wpdb->term_relationships
                        INNER JOIN $wpdb->term_taxonomy
                        ON $wpdb->term_taxonomy.term_taxonomy_id = $wpdb->term_relationships.term_taxonomy_id
                        INNER JOIN $wpdb->terms 
                        ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id AND $wpdb->terms.name LIKE %s 
                        WHERE $wpdb->term_taxonomy.taxonomy = %s
                        AND $wpdb->term_relationships.object_id = {$wpdb->posts}.ID
                    )", $search_term_esc, 'post_tag' );
            }
            $wheres[] = $wpdb->prepare(
                "({$wpdb->posts}.post_title LIKE %s OR {$wpdb->posts}.post_content LIKE %s) OR $address_qr $post_tag_like", 
                $search_term_esc, 
                $search_term_esc
            );

        }

        // for open check
        if(isset($_POST['status']) && $_POST['status'] == 'open'){

            $prev_day_check = $wpdb->prepare(
                "(
                    CASE wk_status_meta_prev.meta_value
                        WHEN 'enterHours' THEN 
                            (
                                CASE
                                    WHEN TRIM(wk_hours_meta_prev.meta_value) !='' THEN 
                                        (
                                            CASE 
                                                WHEN ( 
                                                    CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta_prev.meta_value), ' ', -1)), '-', 1) AS TIME) > CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta_prev.meta_value), ' ', -1)), '-', -1) AS TIME) 
                                                    AND 
                                                    CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) < CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta_prev.meta_value), ' ', -1)), '-', -1) AS TIME) 
                                                    ) THEN 'YES'
                                                ELSE 'NO'
                                            END
                                        )
                                    ELSE 'NO'
                                END
                            )
                        ELSE 'NO'
                    END
                )",
                current_time('mysql', 1)
            );

            $hour_one = $wpdb->prepare(
                "CASE 
                    WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME)) THEN
                        IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                    ELSE
                        IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                END",
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1)
            );

            $hour_two = $wpdb->prepare(
                "CASE 
                    (
                        CASE 
                            WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME)) THEN
                                IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                            ELSE
                                IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                        END
                    )
                    WHEN 'YES' THEN 'YES'
                    ELSE 
                        (
                            CASE 
                                WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', -1) AS TIME)) THEN
                                    IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                                ELSE
                                    IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                            END
                        )
                END
                ",
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1), // end first hour
                current_time('mysql', 1), 
                current_time('mysql', 1),
                current_time('mysql', 1)
            );

            $hour_three = $wpdb->prepare(
                "CASE 
                    (
                        CASE 
                            WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME)) THEN
                                IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                            ELSE
                                IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                        END
                    )
                    WHEN 'YES' THEN 'YES'
                    ELSE 
                        (
                            CASE
                                (  
                                    CASE 
                                        WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 2)), ' ', -1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 2)), ' ', -1)), '-', -1) AS TIME)) THEN
                                            IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 2)), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 2)), ' ', -1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                                        ELSE
                                            IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', 2)), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                                    END
                                )
                                WHEN 'YES' THEN 'YES'
                                ELSE 
                                    (
                                        CASE 
                                            WHEN (CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', -1) AS TIME)) THEN
                                                IF( ( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) AND CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', -1) AS TIME) >= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ),'YES', 'NO' )
                                            ELSE
                                                IF( CAST(SUBSTRING_INDEX(TRIM(SUBSTRING_INDEX(TRIM(wk_hours_meta.meta_value), ' ', -1)), '-', 1) AS TIME) <= CAST(DATE_FORMAT(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), '%H:%i') AS TIME) ,'YES', 'NO' )
                                        END
                                    )
                            END
                        )
                END
                ",
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1), // utc date and time - need to change with client date time to utc
                current_time('mysql', 1), // end first hour
                current_time('mysql', 1), 
                current_time('mysql', 1),
                current_time('mysql', 1), // end second hour
                current_time('mysql', 1),
                current_time('mysql', 1), 
                current_time('mysql', 1)
            );

            $fields .= //$wpdb->prepare(
                ",  (
                        CASE $prev_day_check
                            WHEN 'YES' THEN 'YES'
                            ELSE 
                                (CASE wk_status_meta.meta_value
                                    WHEN 'openAllDay' THEN 'YES'
                                    WHEN 'closeAllDay' THEN 'NO'
                                    WHEN 'enterHours' THEN 
                                        (CASE
                                            WHEN TRIM(wk_hours_meta.meta_value) !='' THEN 
                                                (
                                                    CASE (
                                                            SELECT ROUND (   
                                                                (
                                                                    LENGTH(TRIM(wk_hours_meta.meta_value))
                                                                    - LENGTH( REPLACE ( TRIM(wk_hours_meta.meta_value), ' ', '') ) 
                                                                ) / LENGTH(' ')        
                                                            ) 
                                                        )
                                                        WHEN 0 THEN (
                                                            $hour_one
                                                        )
                                                        WHEN 1 THEN (
                                                            $hour_two
                                                        )
                                                        WHEN 2 THEN (
                                                            $hour_three
                                                        )
                                                        
                                                    END
                                                )
                                            ELSE 'NO'
                                          END)
                                    ELSE 'NO'
                                END)
                        END
                    ) as isOpen";//,
            //     $hour_one
            // );
            $joins .= $wpdb->prepare(
                " INNER JOIN $wpdb->postmeta wk_tz_offset ON wk_tz_offset.post_id = {$wpdb->posts}.ID AND wk_tz_offset.meta_key = %s"
                ." INNER JOIN $wpdb->postmeta wk_status_meta ON wk_status_meta.post_id = {$wpdb->posts}.ID AND wk_status_meta.meta_key = REPLACE('_cth_wkh_status_WDAY', 'WDAY', DAYNAME(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value)))"
                ." INNER JOIN $wpdb->postmeta wk_hours_meta ON wk_hours_meta.post_id = {$wpdb->posts}.ID AND wk_hours_meta.meta_key = REPLACE('_cth_wkh_hours_WDAY', 'WDAY', DAYNAME(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value)))"
                ." INNER JOIN $wpdb->postmeta wk_status_meta_prev ON wk_status_meta_prev.post_id = {$wpdb->posts}.ID AND wk_status_meta_prev.meta_key = REPLACE('_cth_wkh_status_WDAY', 'WDAY', DAYNAME(DATE_SUB(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), INTERVAL 1 DAY)))"
                ." INNER JOIN $wpdb->postmeta wk_hours_meta_prev ON wk_hours_meta_prev.post_id = {$wpdb->posts}.ID AND wk_hours_meta_prev.meta_key = REPLACE('_cth_wkh_hours_WDAY', 'WDAY', DAYNAME(DATE_SUB(CONVERT_TZ(%s,'+00:00',wk_tz_offset.meta_value), INTERVAL 1 DAY)))",
                '_cth_wkh_tz_utc_offset',
                current_time('mysql', 1),
                current_time('mysql', 1),
                current_time('mysql', 1),
                current_time('mysql', 1) // need to change to utc timezone
            );
            $having[] = "isOpen = 'YES'";

            

        }

        // https://stackoverflow.com/questions/14950466/how-to-split-the-name-string-in-mysql
        // https://stackoverflow.com/questions/12344795/count-the-number-of-occurrences-of-a-string-in-a-varchar-field

        $clauses[ 'fields' ] .= $fields ;
        $clauses[ 'join' ] .= $joins ;

        if(!empty($having)){
            $distance_groupby = '';
            if(empty($clauses[ 'groupby' ])) $distance_groupby = "{$wpdb->posts}.ID";

            $clauses[ 'groupby' ] .= " $distance_groupby HAVING ".implode(" AND ", $having);
        }

        if(!empty($wheres)){
            $clauses[ 'where' ] .= " AND ".implode(" AND ", $wheres);
        }
            
    }

    return $clauses;
}

