<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// process listing checkout
function citybook_addons_process_listing_checkout(){
    // if(isset($_POST['plan-id'])){
    //     echo '<pre>';
    //     var_dump($_POST);
    //     die;
    // }
    if(isset($_POST['listing_checkout']) && isset($_POST['listing-id']) && isset($_POST['plan-id']) && isset($_POST['payment-method']) && isset($_POST['_wpnonce'])){
        // process checkout
        if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'listing-checkout' ) ){ 
            die ( '<p class="error">Security checked!, Cheatn huh?</p>' );
        }
        $listing_id = $_POST['listing-id'];
        $plan_id = $_POST['plan-id'];

        $current_user = wp_get_current_user(); 

	    $listing_post = get_post($listing_id);
	    // display none on incorrect listing or not authorize listing item
	    if(null == $listing_post ) return;
	    // plan post
	    $plan_post = get_post($plan_id);
	    // display none on incorrect plan
	    if(null == $plan_post ) return;
	    $prices = citybook_addons_get_plan_prices($plan_post->ID);

	    // add new order to back-end
	    $order_datas = array();
		$order_datas['post_title'] = $current_user->display_name;
		$order_datas['post_content'] = '';
		//$order_datas['post_author'] = '0';// default 0 for no author assigned
		$order_datas['post_status'] = 'publish';
		$order_datas['post_type'] = 'lorder';

		do_action( 'citybook_addons_insert_order_before', $order_datas );

		$lorder_id = wp_insert_post($order_datas ,true );

		if (!is_wp_error($lorder_id)) {
			// modify paypal args for this payment
       //      $paypal_args = array(
       //      	'item_name' 		=> sprintf(__( 'For %s with %s plan', 'citybook-add-ons' ), $listing_post->post_title, $plan_post->post_title),
       //      	'item_number' 		=> $listing_post->ID, // listing id
       //      	'amount' 			=> $prices['total'],
       //      	'quantity' 			=> 1,
		    	// 'currency_code' 	=> citybook_addons_get_option('currency','USD'),
		    	// 'custom' 			=> $plan_post->ID .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no',
		    	// 'business' 			=> citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
		    	// 'email' 			=> $current_user->user_email,
		    	// 'first_name'		=> $current_user->user_firstname,
		    	// 'last_name'			=> $current_user->user_lastname,
		    
       //      );

            $order_metas = array(
                'listing_id'          			=> $listing_post->ID, // listing id
                'plan_id'          				=> $plan_post->ID, // plan id
                'amount'          				=> $prices['total'],
                'quantity'       				=> 1,
                'currency_code'          		=> citybook_addons_get_option('currency','USD'),
                'custom' 						=> $lorder_id .'|'. $listing_post->ID .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no',
                'user_id'                       => $current_user->ID,
                'email' 						=> $current_user->user_email,
		    	'first_name'					=> $current_user->user_firstname,
                'last_name'                     => $current_user->user_lastname,
		    	'display_name'					=> $current_user->display_name,
		    	'payment_method'				=> $_POST['payment-method'], // banktransfer - paypal - stripe
            );
            $order_metas['status'] = 'pending'; // pending - completed - failed - refunded

            // $cmb_prefix = '_cth_';
            foreach ($order_metas as $key => $value) {
                // https://codex.wordpress.org/Function_Reference/update_post_meta
                // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
                // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                if ( !update_post_meta( $lorder_id, P_META_PREFIX.$key,  $value  ) ) {
                    // $json['data'][] = sprintf(__('Insert order %s meta failure or existing meta value','citybook-add-ons'),$key);
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). sprintf(__('Insert order %s meta failure or existing meta value','citybook-add-ons'),$key) . PHP_EOL, 3, CTH_LOG_FILE);
                    // wp_send_json($json );
                }
            }


            do_action( 'citybook_addons_insert_order_after', $lorder_id, $listing_id, $plan_id );

            $payment_method = $_POST['payment-method']; // banktransfer - paypal - stripe
	        if($payment_method === 'paypal'){
	            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';

	            $payment_class = new CTH_Payment_Paypal();

	            // modify paypal args for this payment
	            $paypal_args = array(
	            	'item_name' 		=> sprintf(__( 'For %s with %s plan', 'citybook-add-ons' ), $listing_post->post_title, $plan_post->post_title),
	            	'item_number' 		=> $plan_post->ID, // plan id
	            	'amount' 			=> $prices['total'],
	            	'quantity' 			=> 1,
			    	'currency_code' 	=> citybook_addons_get_option('currency','USD'),
			    	'custom' 			=> $lorder_id .'|'. $listing_post->ID .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no',
			    	'business' 			=> citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
			    	'email' 			=> $current_user->user_email,
			    	'first_name'		=> $current_user->user_firstname,
			    	'last_name'			=> $current_user->user_lastname,
			    
	            );
	            $paypal_redirect = $payment_class->processBuyNow($paypal_args);

	            // redirect to Paypal
	            wp_redirect( $paypal_redirect ); 
	            exit;
	        }



		}else{
            
			if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert order post error: " . $lorder_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);

		    // throw new Exception($lorder_id->get_error_message());

		}
		// end add new order
	    
    }

    // membership order
    // test for GET: http://localhost:8888/citybook/?membership_checkout=dfsdf&plan-id=2320&listing-id=0&payment-method=stripe&stripeToken=tok_1CMh8dFZdAGAQjnSAfuQ038B&stripeEmail=test@gmail.com
    if(isset($_POST['membership_checkout']) && isset($_POST['listing-id']) && isset($_POST['plan-id']) && isset($_POST['payment-method']) && isset($_POST['_wpnonce'])){
    // if(isset($_GET['membership_checkout']) && isset($_GET['listing-id']) && isset($_GET['plan-id']) && isset($_GET['payment-method']) ){
        // process checkout
        if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'listing-checkout' ) ){ 
            die ( '<p class="error">Security checked!, Cheatn huh?</p>' );
        }
        $listing_id = $_POST['listing-id']? $_POST['listing-id'] : 0;
        $plan_id = $_POST['plan-id'];

        $current_user = wp_get_current_user(); 

        // $listing_post = get_post($listing_id);
        // // display none on incorrect listing or not authorize listing item
        // if(null == $listing_post ) return;
        // plan post
        $plan_post = get_post($plan_id);
        // display none on incorrect plan
        if(null == $plan_post ) return;
        $prices = citybook_addons_get_plan_prices($plan_post->ID);

        // add new order to back-end
        $order_datas = array();
        $order_datas['post_title'] = $current_user->display_name;
        $order_datas['post_content'] = '';
        //$order_datas['post_author'] = '0';// default 0 for no author assigned
        $order_datas['post_status'] = 'publish';
        $order_datas['post_type'] = 'lorder';

        do_action( 'citybook_addons_insert_order_before', $order_datas );

        $lorder_id = wp_insert_post($order_datas ,true );

        if (!is_wp_error($lorder_id)) {

            // increase plan pm_count - payment count
            $plan_pm_count = get_post_meta( $plan_post->ID , P_META_PREFIX.'pm_count', true );
            $plan_pm_count += 1;
            update_post_meta( $plan_post->ID , P_META_PREFIX.'pm_count', $plan_pm_count );

            $is_recurring_plan = get_post_meta( $plan_post->ID , P_META_PREFIX.'is_recurring', true );
           
            $order_metas = array(
                // 'listing_id'                    => $listing_post->ID, // listing id
                'listing_id'                    => $listing_id, // listing id
                'plan_id'                       => $plan_post->ID, // plan id
                'amount'                        => $prices['total'],
                'quantity'                      => 1,
                'currency_code'                 => citybook_addons_get_option('currency','USD'),
                'custom'                        => $lorder_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no',
                'user_id'                       => $current_user->ID,
                'email'                         => $current_user->user_email,
                'first_name'                    => $current_user->user_firstname,
                'last_name'                     => $current_user->user_lastname,
                'display_name'                  => $current_user->display_name,



                'payment_method'                => $_POST['payment-method'], // banktransfer - paypal - stripe


                'is_recurring_plan'             => $is_recurring_plan, // is recurring plan



                'is_per_listing_sub'            => 'no', // is per listing subscription

                'end_date'                      => citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') ),
            );
            $order_metas['status'] = 'pending'; // pending - completed - failed - refunded
            $order_metas['payment_count'] = '0';

            $trial_interval = get_post_meta( $plan_post->ID , P_META_PREFIX.'trial_interval', true );
            $trial_period = get_post_meta( $plan_post->ID , P_META_PREFIX.'trial_period', true );
            if(!empty($trial_interval) && !empty($trial_period)){
                $order_metas['trial_interval'] = $trial_interval;
                $order_metas['trial_period'] = $trial_period;

                // update trialling
                $order_metas['status'] = 'trialing'; // pending - completed - failed - refunded
            }


            // $cmb_prefix = '_cth_';
            foreach ($order_metas as $key => $value) {
                // https://codex.wordpress.org/Function_Reference/update_post_meta
                // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
                // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                if ( !update_post_meta( $lorder_id, P_META_PREFIX.$key,  $value  ) ) {
                    // $json['data'][] = sprintf(__('Insert order %s meta failure or existing meta value','citybook-add-ons'),$key);
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). sprintf(__('Insert order %s meta failure or existing meta value','citybook-add-ons'),$key) . PHP_EOL, 3, CTH_LOG_FILE);
                    // wp_send_json($json );
                }
            }


            // checkout success page
            $checkout_success_redirect = home_url('/');
            if(citybook_addons_get_option('checkout_success_page') !== 'none') $checkout_success_redirect = get_permalink( citybook_addons_get_option('checkout_success_page') );
            


            do_action( 'citybook_addons_insert_order_after', $lorder_id, $listing_id, $plan_id );
            // check for free plan
            if(empty($prices['total'])){

                if(citybook_addons_get_option('auto_active_free_sub') == 'yes'){
                    $plan_period = get_post_meta( $plan_post->ID, P_META_PREFIX.'period', true );
                    $plan_interval = get_post_meta( $plan_post->ID, P_META_PREFIX.'interval', true );
                    if($plan_interval){
                        $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
                    }else{
                        $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
                    }

                    $data = array(
                        'pm_status'                 => 'completed',
                        'user_id'                   => $current_user->ID,
                        'item_number'               => $plan_post->ID, // this is listing plan id
                        'pm_date'                   => current_time('mysql', 1), // Time at which the object was created. Measured in seconds since the Unix epoch.
                        'order_id'                  => $lorder_id,
                        'recurring_subscription'    => false, // not used

                        'txn_id'                    => uniqid('free_sub'), // invoice id

                        // for stripe period
                        'payment_method'            => __( 'Free Subscription', 'citybook-add-ons' ),
                        'period_start'              => current_time('mysql', 1),
                        'period_end'                => $expire,

                    );
                    citybook_add_ons_active_membership($data, false);
                }
                // redirect to Paypal
                wp_redirect( $checkout_success_redirect );
                exit;

            }else{
            // process payment if not free

                $payment_method = $_POST['payment-method']; // banktransfer - paypal - stripe

                // for paypal method payment
                if($payment_method === 'paypal'){
                    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';

                    $payment_class = new CTH_Payment_Paypal();


                    // modify paypal args for this payment
                    // for recurring - subscription payment
                    if( $is_recurring_plan ){
                        // https://developer.paypal.com/docs/classic/paypal-payments-standard/integration-guide/Appx_websitestandard_htmlvariables/#recurring-payment-variables
                        $paypal_args = array(
                            'cmd'               => '_xclick-subscriptions', // Subscribe button
                            'item_name'         => sprintf(__( 'Payment for %s subscription plan', 'citybook-add-ons' ), $plan_post->post_title),
                            'item_number'       => $plan_post->ID, // plan id

                            // subscribe
                            'a3'                => $prices['total'], // Regular subscription price.
                            'p3'                => citybook_add_ons_get_paypal_duration( get_post_meta( $plan_post->ID , P_META_PREFIX.'interval', true ), get_post_meta( $plan_post->ID , P_META_PREFIX.'period', true ) ), // Subscription duration
                            't3'                => citybook_add_ons_get_paypal_duration_unit( get_post_meta( $plan_post->ID , P_META_PREFIX.'period', true ) ), // Regular subscription units of duration.
                            /*
                            D. Days. Valid range for p3 is 1 to 90.
                            W. Weeks. Valid range for p3 is 1 to 52.
                            M. Months. Valid range for p3 is 1 to 24.
                            Y. Years. Valid range for p3 is 1 to 5.
                            */
                            'src'               => 1, // Recurring payments. Subscription payments recur unless subscribers cancel their subscriptions before the end of the current billing cycle or you limit the number of times that payments recur with the value that you specify for srt.
                            // 'srt'               => 52, //Recurring times.
                            // 'sra'               => 1, // Reattempt on failure. If a recurring payment fails, PayPal attempts to collect the payment two more times before canceling the subscription.

                            'no_note'           => 1, // Do not prompt buyers to include a note with their payments. Valid value is from Subscribe buttons: For Subscribe buttons, always set no_note to 1.
                            'modify'            => 0, // Modification behavior.
                            /*
                            Valid value is:
                            0. Enables subscribers only to sign up for new subscriptions.
                            1. Enables subscribers to sign up for new subscriptions and modify their current subscriptions.
                            2. Enables subscribers to modify only their current subscriptions.
                            The default value is 0.
                            */




                            // 'amount'            => $prices['total'],
                            // 'quantity'          => 1,
                            'currency_code'     => citybook_addons_get_option('currency','USD'),
                            'custom'            => $lorder_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no|subscription_yes',
                            'business'          => citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
                            
                            'email'             => $current_user->user_email,
                            'first_name'        => $current_user->user_firstname,
                            'last_name'         => $current_user->user_lastname,

                            'notify_url'        => home_url('/?action=cth_mem_ppipn'),
                            'return'            => $checkout_success_redirect,
                        
                        );
                        
                        if(!empty($trial_interval) && !empty($trial_period)){
                            $paypal_args['a1'] = 0;// 0 for free trial
                            $paypal_args['p1'] = citybook_add_ons_get_paypal_duration( $trial_interval, $trial_period );
                            $paypal_args['t1'] = citybook_add_ons_get_paypal_duration_unit( $trial_period );

                        }
                    }else{
                        $paypal_args = array(
                            'cmd'               => '_xclick',
                            'item_name'         => sprintf(__( 'Payment for %s plan', 'citybook-add-ons' ), $plan_post->post_title),
                            'item_number'       => $plan_post->ID, // plan id
                            'amount'            => $prices['total'],
                            'quantity'          => 1,
                            'currency_code'     => citybook_addons_get_option('currency','USD'),
                            'custom'            => $lorder_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no',
                            'business'          => citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
                            'email'             => $current_user->user_email,
                            'first_name'        => $current_user->user_firstname,
                            'last_name'         => $current_user->user_lastname,

                            'notify_url'        => home_url('/?action=cth_mem_ppipn'),
                            'return'            => $checkout_success_redirect,
                        
                        );
                    }

                        
                    $paypal_redirect = $payment_class->processBuyNow($paypal_args);

                    // redirect to Paypal
                    wp_redirect( $paypal_redirect ); 
                    exit;
                }elseif($payment_method === 'stripe'){

                    $stripe_local = CTH_DEBUG && ($_SERVER['SERVER_NAME'] == 'localhost' || $_SERVER['SERVER_NAME'] == '192.168.0.100');

                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Stripe Local: " . $stripe_local . PHP_EOL, 3, CTH_LOG_FILE);
                    
                    // for stripe payment method
                    // load the stripe libraries
                    // require_once CITYBOOK_ADD_ONS_DIR .'inc/classes/stripe-php/init.php';

                    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';
                    $payment_class = new CTH_Payment_Stripe();

                    $stripeEmail = $_POST['stripeEmail'];
                    // for recurring - subscription payment
                    if( $is_recurring_plan && get_post_meta( $plan_post->ID , P_META_PREFIX.'stripe_plan_id', true ) != '' ){

                        $subscription_metas = array(
                            'ctb_plan_id'               => $plan_post->ID, // make unique meta key for site identifing
                            'listing_id'                => $listing_id,
                            'order_id'                  => $lorder_id,
                            'user_id'                   => $current_user->ID,
                            'user_email'                => $current_user->user_email,
                            'renew'                     => 'no',
                            'subscription'              => 'yes'
                        );
                        $stripe_args = array(
                            'items' => array(
                                array(
                                    'plan' => get_post_meta( $plan_post->ID , P_META_PREFIX.'stripe_plan_id', true ),
                                    'quantity'  => 1
                                ),
                            ),
                            // 'metadata'      => $subscription_metas
                        );
                        
                        if(!empty($trial_interval) && !empty($trial_period)){
                            $stripe_args['trial_period_days'] = citybook_add_ons_get_stripe_duration( $trial_interval, $trial_period );

                            $subscription_metas['trial_interval']   = $trial_interval;
                            $subscription_metas['trial_period']     = $trial_period;
                        }
                        $stripe_args['metadata'] = $subscription_metas;
                        $subscription_obj = $payment_class->processRecurring($stripe_args);

                        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert order post error: " . json_encode($subscription_obj) . PHP_EOL, 3, CTH_LOG_FILE);
                        /*
                        [2018-05-01 07:10 UTC] Insert order post error: 
                        {
                            "id":"sub_CmRV9HQctFsbd3",
                            "object":"subscription",
                            "application_fee_percent":null,
                            "billing":"charge_automatically",
                            "billing_cycle_anchor":1525158607,
                            "cancel_at_period_end":false,
                            "canceled_at":null,
                            "created":1525158607,
                            "current_period_end":1525245007,
                            "current_period_start":1525158607,
                            "customer":"cus_CmRVNpaELB1QxT",
                            "days_until_due":null,
                            "discount":null,
                            "ended_at":null,
                            "items":{"object":"list","data":[{"id":"si_CmRV1OxYE2IxyM","object":"subscription_item","created":1525158608,"metadata":[],"plan":{"id":"ctb-daily","object":"plan","aggregate_usage":null,"amount":1000,"billing_scheme":"per_unit","created":1525154642,"currency":"usd","interval":"day","interval_count":1,"livemode":false,"metadata":[],"name":"CityBook Daily","nickname":"Daily","product":"prod_CmQR85Xo3HDSbS","statement_descriptor":"Author Subscription","tiers":null,"tiers_mode":null,"transform_usage":null,"trial_period_days":null,"usage_type":"licensed"},"quantity":1,"subscription":"sub_CmRV9HQctFsbd3"}],"has_more":false,"total_count":1,"url":"\/v1\/subscription_items?subscription=sub_CmRV9HQctFsbd3"},"livemode":false,
                            "metadata":{"ctb_plan_id":"2319","listing_id":"0","order_id":"2405","user_id":"2","user_email":"test@gmail.com","renew":"no","subscription":"yes"},
                            "plan":{"id":"ctb-daily","object":"plan","aggregate_usage":null,"amount":1000,"billing_scheme":"per_unit","created":1525154642,"currency":"usd","interval":"day","interval_count":1,"livemode":false,"metadata":[],"name":"CityBook Daily","nickname":"Daily","product":"prod_CmQR85Xo3HDSbS","statement_descriptor":"Author Subscription","tiers":null,"tiers_mode":null,"transform_usage":null,"trial_period_days":null,"usage_type":"licensed"},
                            "quantity":1,
                            "start":1525158607,
                            "status":"active",
                            "tax_percent":null,
                            "trial_end":null,
                            "trial_start":null
                        }
                        */
                        // for local test only
                        if($stripe_local && isset($subscription_obj->status) /*&& $subscription_obj->status === 'active'*/ ){ // or trialing for in trial period
                            citybook_add_ons_active_membership(
                                array(
                                    'pm_status'                 => $subscription_obj->status,
                                    'user_id'                   => $current_user->ID,
                                    'item_number'               =>  $plan_post->ID, // this is listing plan id
                                    'pm_date'                   => $subscription_obj->created, // or use start for correction
                                    'order_id'                  => $lorder_id,
                                    'recurring_subscription'    => true, // not used

                                    'txn_id'                    => $subscription_obj->id,
                                    'subscription_id'           => $subscription_obj->id,
                                ), 
                                true
                            );
                            // this shortcode should be added in success payment page
                            // do_shortcode( '[affiliate_conversion_script amount="10" description="My Description" context="CityBook-Add-Ons" reference="'.$lorder_id.'" status="pending"]' );
                        }

                    } // end stripe recurring subscription
                    else{
                        
                        $charge_metas = array(
                            'ctb_plan_id'               => $plan_post->ID, // make unique meta key for site identifing
                            'listing_id'                => $listing_id,
                            'order_id'                  => $lorder_id,
                            'user_id'                   => $current_user->ID,
                            'user_email'                => $current_user->user_email,
                            'renew'                     => 'no',
                            'subscription'              => 'no'
                        );
                        $stripe_args = array(
                            // 'customer'   => $customer->id, // will be added from the class
                            'amount'        => citybook_addons_get_stripe_amount( $prices['total'] ),
                            // 'currency'   => citybook_addons_get_option('currency','USD'), // lowercase will be added from the class
                            'description'   => sprintf( __( 'Payment from %s', 'citybook-add-ons' ), $stripeEmail ), 
                            'receipt_email' => $stripeEmail,
                            'metadata'      => $charge_metas
                        );

                        $charge_obj = $payment_class->processOneTime($stripe_args);
                        // for local test only
                        if($stripe_local && isset($charge_obj->status) && $charge_obj->status === 'succeeded'){
                            citybook_add_ons_active_membership(
                                array(
                                    'pm_status'  => 'completed',
                                    'user_id' => $current_user->ID,
                                    'item_number' =>  $plan_post->ID, // this is listing plan id
                                    'pm_date' => $charge_obj->created, // or use start for correction
                                    'order_id' => $lorder_id,
                                    'recurring_subscription' => false, // not used
                                    // update order transactions
                                    // for one time payment is balance_transaction data
                                    'txn_id'                    => $charge_obj->balance_transaction

                                ), 
                                true
                            );
                        }
                    }


                        
                    /*
                    // check if charge succeeded - charge status: succeeded, pending, or failed.
                    if(isset($charge_obj->status) && $charge_obj->status === 'succeeded'){

                        //The payment has been completed, and the funds have been added successfully to your account balance.

                        // need to update user to listing author membership

                        $user_id_new = wp_update_user( array( 'ID' => $current_user->ID, 'role' => 'listing_author' ) );
                        if ( is_wp_error( $user_id_new ) ) {
                            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update user role to listing_author" . PHP_EOL, 3, CTH_LOG_FILE);
                        }
                        
                        
                        if ( !update_user_meta( $current_user->ID, P_META_PREFIX.'member_plan',  $plan_post->ID ) ) {
                            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update user membership plan id failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
                        }
                        // payment date $pm_datas['pm_date']
                        if ( !update_user_meta( $current_user->ID, P_META_PREFIX.'payment_date',  citybook_add_ons_charge_date( $charge_obj->created ) ) ) {
                            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update payment_date user data" . PHP_EOL, 3, CTH_LOG_FILE);
                        }


             
                        // update order status
                        if ( !update_post_meta( $lorder_id, P_META_PREFIX.'status',  'completed' ) ) {
                            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to completed failure" . PHP_EOL, 3, CTH_LOG_FILE);
                        }
                        // update payment count - useful for check recurring payment
                        $payment_count = get_post_meta( $lorder_id, P_META_PREFIX.'payment_count', true );
                        if(!$payment_count) $payment_count = 1;
                        else $payment_count += 1;
                        if ( !update_post_meta( $lorder_id, P_META_PREFIX.'payment_count',  $payment_count ) ) {
                            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order payment_count to $payment_count failure" . PHP_EOL, 3, CTH_LOG_FILE);
                        }
                        // for recurring subscription
                        // if($pm_datas['recurring_subscription']){
                        //     // to do tasks
                        // }

                        do_action( 'citybook_addons_order_completed', $lorder_id );

                    }
                    // end check for charge successed

                    */

                    // redirect to home page
                    wp_redirect( $checkout_success_redirect ); 
                    // wp_redirect( 'https://citybook.cththemes.com' ); 
                    exit;

                    // $returnsss = array(
                    //     'POST' => $_POST
                    // );

                    // wp_send_json( $returnsss );

                    // die('dfsdfds');

                }elseif($payment_method==='payfast'){
                    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-payfast.php';
                    $payment_class = new CTH_Payment_Payfast();
                    $payfast_args = array(
                        'item_name' => sprintf(__( 'Payment for %s plan', 'citybook-add-ons' ), $plan_post->post_title), //plan title,

                        'amount' => $prices['total'], // plan price

                        'custom_int1'   => $plan_post->ID,
                        'custom_int2'   =>  $lorder_id,
                        'custom_int3'   =>  $current_user->ID,
                        'custom_int4'   =>  $listing_id,
                        'merchant_id'   =>  citybook_addons_get_option('payments_payfast_merchant_id'),

                        'merchant_key'  =>  citybook_addons_get_option('payments_payfast_merchant_key'),

                        'return_url'    =>  $checkout_success_redirect,

                        // 'cancel_url'    =>  home_url(),
                        
                        'notify_url'    =>  home_url('/?action=cth_pfipn'),

                        'name_first'    =>  $current_user->user_firstname,

                        'name_last'     =>  $current_user->user_lastname,

                        'email_address' =>  $current_user->user_email,

                        'item_description'  =>  ''
                    );
                    $payfast_redirect = $payment_class->processBuyNow($payfast_args);
                    // redirect to Paypal
                    wp_redirect( $payfast_redirect ); 
                    exit;
                }
                // end stripe payment method process
                else{
                    wp_redirect( $checkout_success_redirect );
                    exit;

                }
                // end bank transfer method

            }
            // end check for free plan

        }else{
            
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert order post error: " . $lorder_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);

            // throw new Exception($lorder_id->get_error_message());

        }
        // end add new order
        
    }
    // paypal ipn
    if(isset($_GET['action'])){
        if($_GET['action'] === 'cth_ppipn'){
            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';
            $payment_class = new CTH_Payment_Paypal();
            $pm_datas = $payment_class->extractPaymentData();
            // var_dump($pm_datas);

            // if($payment_class->validateIPN()){
                
            // }
            if ($pm_datas['pm_status'] === 'Completed') {
                //The payment has been completed, and the funds have been added successfully to your account balance.

                
                // if($receiver_email !== $params->get('paypal_email','') ){
                //     if( $test_mode  == '1' ){  
                //         JLog::add("You pays for wrong people.", JLog::WARNING);
                //     }
                // }
                
                // update listing status to publish if enabled
                if(citybook_addons_get_option('auto_publish_paid_listings','no') == 'yes'){
                    
                    $listing_post = array(
                        'ID'            => $pm_datas['listing_id'],
                        'post_status'       => 'publish',
                    );
                    $listing_id = wp_update_post( $listing_post, true );                          
                    if (CTH_DEBUG && is_wp_error($listing_id)) {
                        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update listing post error: " . $listing_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
                    }
                }
                // update order status
                $order_id = $pm_datas['order_id'];
                if ( !update_post_meta( $order_id, P_META_PREFIX.'status',  'completed' ) ) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to completed failure" . PHP_EOL, 3, CTH_LOG_FILE);
                }

                do_action( 'citybook_addons_order_completed', $order_id );

            }elseif($pm_datas['pm_status'] === 'Refunded'){
                //The payment has been refunded


                $order_id = $pm_datas['order_id'];
                if ( !update_post_meta( $order_id, P_META_PREFIX.'status',  'refunded' ) ) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to refunded failure" . PHP_EOL, 3, CTH_LOG_FILE);
                }
                do_action( 'citybook_addons_order_refunded', $order_id );
            }else{
                //The payment has other status include false (boolean)
            }

        }
        // end listing payment paypal ipn

        // membership paypal payment ipn
        if($_GET['action'] === 'cth_mem_ppipn'){
            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';
            $payment_class = new CTH_Payment_Paypal();
            $pm_datas = $payment_class->extractPaymentData();
            // var_dump($pm_datas);

            // 

            // if($payment_class->validateIPN()){
                
            // }
            if( $pm_datas['pm_status'] === 'Trialing' ){
                // active trial membership
                $pm_datas['pm_status'] = 'trialing';
                citybook_add_ons_active_membership($pm_datas, false);
            }elseif ($pm_datas['pm_status'] === 'Completed') {
                //The payment has been completed, and the funds have been added successfully to your account balance.
                $pm_datas['pm_status'] = 'completed';
                citybook_add_ons_active_membership($pm_datas, false);

            }elseif($pm_datas['pm_status'] === 'Refunded'){
                //The payment has been refunded


                $order_id = $pm_datas['order_id'];
                if ( !update_post_meta( $order_id, P_META_PREFIX.'status',  'refunded' ) ) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to refunded failure" . PHP_EOL, 3, CTH_LOG_FILE);
                }
                do_action( 'citybook_addons_order_refunded', $order_id );
            }else{
                //The payment has other status include false (boolean)
            }

        }
        // end membership paypal payment ipn

        // membership stripe payment webhook
        if($_GET['action'] === 'cth_stripewebhook'){
        // server https://citybook.cththemes.com/?action=cth_stripewebhook

            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';
            $payment_class = new CTH_Payment_Stripe();

            $payment_class->checkWebHooks();

            // $pm_datas = $payment_class->extractPaymentData();
            

        }
        // end membership stripe payment webhook
    
        if($_GET['action'] === 'cth_booking_ppipn'){

            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';

            $payment_class = new CTH_Payment_Paypal();

            $pm_datas = $payment_class->extractPaymentData();
            
            citybook_addons_active_booking($pm_datas);
        }

        if($_GET['action']==='cth_pfipn'){

            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-payfast.php';

            $payment_class = new CTH_Payment_Payfast();

            $pm_datas = $payment_class->extractPaymentData();
            
            citybook_add_ons_active_membership($pm_datas, false);
        }
    }
    // end paypal ipn


        
}

add_action( 'init', 'citybook_addons_process_listing_checkout' );

// manually change order status to completed
function citybook_addons_lorder_change_status_to_completed_callback($order_id = 0){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){

            $plan_id = get_post_meta( $order_post->ID, P_META_PREFIX.'plan_id', true );

            $plan_period = get_post_meta( $plan_id, P_META_PREFIX.'period', true );
            $plan_interval = get_post_meta( $plan_id, P_META_PREFIX.'interval', true );
            if($plan_interval){
                $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
            }else{
                $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
            }

            $data = array(
                'pm_status'                 => 'completed',
                'user_id'                   => get_post_meta( $order_post->ID, P_META_PREFIX.'user_id', true ),
                'item_number'               => $plan_id, // this is listing plan id
                'pm_date'                   => current_time('mysql', 1), // Time at which the object was created. Measured in seconds since the Unix epoch.
                'order_id'                  => $order_post->ID,
                'recurring_subscription'    => false, // not used

                'txn_id'                    => uniqid('manual_sub'), // invoice id

                // for stripe period
                'payment_method'            => __( 'Manual Subscription', 'citybook-add-ons' ),
                'period_start'              => current_time('mysql', 1),
                'period_end'                => $expire,

            );
            citybook_add_ons_active_membership($data, false);

        }
    }

                
}
add_action( 'citybook_addons_lorder_change_status_to_completed', 'citybook_addons_lorder_change_status_to_completed_callback', 10, 1 );

// active author membership after success
function citybook_add_ons_active_membership($pm_datas = array(), $stripe_date = false){

    $plan_post = get_post( $pm_datas['item_number'] );
    $order_id = $pm_datas['order_id'];
    // check if the plan is deleted
    if(null == $plan_post ){
        if(get_post_meta( $order_id, P_META_PREFIX.'plan_period', true ) == '') return;  // also need check for plan datas attached to order in case of deleted plan post
    }
    $from_date = $stripe_date === 'utc' ? $pm_datas['pm_date'] : ( $stripe_date ? citybook_add_ons_charge_date( $pm_datas['pm_date'] ) : citybook_add_ons_payment_date( $pm_datas['pm_date'] ) );

    // need to update user to listing author membership
    // with $pm_datas['item_number'] -> plan_id
    // with $pm_datas['listing_id'] -> listing_id
    $user_id = $pm_datas['user_id'];



    // update role for subscriber and listing customer only 
    $current_role = citybook_addons_get_user_role($user_id);
    // only update role if lower role
    if(in_array($current_role, array( 'author', 'contributor', 'subscriber', 'l_customer' ))){
        $user_id_new = wp_update_user( array( 'ID' => $user_id, 'role' => 'listing_author' ) );
        if ( is_wp_error( $user_id_new ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update user role to listing_author" . PHP_EOL, 3, CTH_LOG_FILE);
        }

        citybook_addons_user_add_notification($user_id, array(
            'type' => 'role_change',
            'message' => __( 'Your role has changed to <strong>Listing Author</strong>.', 'citybook-add-ons' )
        ));
    }

    if ( !update_user_meta( $user_id, P_META_PREFIX.'member_plan',  $pm_datas['item_number'] ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update user membership plan id failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
    }else{
        citybook_addons_user_add_notification($user_id, array(
            'type' => 'plan_change',
            'message' => sprintf(__( 'Your subscription plan has changed to <strong>%s</strong>.', 'citybook-add-ons' ), get_the_title( $pm_datas['item_number'] ) )
        ));
    }
    // payment date $pm_datas['pm_date']
    
    if ( !update_user_meta( $user_id, P_META_PREFIX.'payment_date',  $from_date ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update payment_date user data" . PHP_EOL, 3, CTH_LOG_FILE);
    }

    // update user order/subscription ids array
    $user_orders = get_user_meta($user_id,  P_META_PREFIX.'subscriptions', true );
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "User orders before" . json_encode($user_orders). PHP_EOL, 3, CTH_LOG_FILE);
    if( is_array($user_orders) ){
        if( !in_array($order_id, $user_orders) ) $user_orders[] = $order_id;
    }else{
        $user_orders = array($order_id);
    }
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "User orders after" . json_encode($user_orders). PHP_EOL, 3, CTH_LOG_FILE);
    if ( !update_user_meta( $user_id, P_META_PREFIX.'subscriptions',  $user_orders ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update subscriptions user data" . PHP_EOL, 3, CTH_LOG_FILE);
    }



    
    // update listing status to publish if enabled
    // if(citybook_addons_get_option('auto_publish_paid_listings','no') == 'yes'){
        
    //     $listing_post = array(
    //         'ID'            => $pm_datas['listing_id'],
    //         'post_status'       => 'publish',
    //     );
    //     $listing_id = wp_update_post( $listing_post, true );                          
    //     if (CTH_DEBUG && is_wp_error($listing_id)) {
    //         if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update listing post error: " . $listing_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
    //     }
    // }
    // update order status
    
    if ( !update_post_meta( $order_id, P_META_PREFIX.'status',  $pm_datas['pm_status'] ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to {$pm_datas['pm_status']} failure" . PHP_EOL, 3, CTH_LOG_FILE);
    }else{
        if( citybook_addons_get_option('db_hide_packages') != 'yes' ) {
            citybook_addons_user_add_notification($user_id, array(
                'type' => 'order_completed',
                'message' => sprintf(__( 'Your subscription order has marked as complete. So you can submit listings now.', 'citybook-add-ons' ), $order_id )
            ));
        }
    }
    // update payment count - useful for check recurring payment
    $payment_count = get_post_meta( $order_id, P_META_PREFIX.'payment_count', true );
    if(!$payment_count) $payment_count = 1;
    else $payment_count += 1;
    if ( !update_post_meta( $order_id, P_META_PREFIX.'payment_count',  $payment_count ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order payment_count to $payment_count failure" . PHP_EOL, 3, CTH_LOG_FILE);
    }

    /// ALSO USE ORDER AS AUTHOR SUBSCRIPTION RECORD
    if ( !update_post_meta( $order_id, P_META_PREFIX.'plan_id',  $pm_datas['item_number'] ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update order/subscription plan id failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
    }
    // valid date from - only add active date for newly created order - not for next payment
    if(get_post_meta( $order_id, P_META_PREFIX.'from_date', true ) == ''){
        if ( !update_post_meta( $order_id, P_META_PREFIX.'from_date',  $from_date ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update from_date order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }
    // add plan datas to order/subscription
    $plan_period = get_post_meta( $pm_datas['item_number'], P_META_PREFIX.'period', true );
    $plan_interval = get_post_meta( $pm_datas['item_number'], P_META_PREFIX.'interval', true );
    if($plan_period){
        if ( !update_post_meta( $order_id, P_META_PREFIX.'plan_period',  $plan_period ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update order/subscription plan period failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        if ( !update_post_meta( $order_id, P_META_PREFIX.'plan_interval',  $plan_interval ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update order/subscription plan interval failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        
        // calculate expired date
        
        if ( !update_post_meta( $order_id, P_META_PREFIX.'end_date',  citybook_add_ons_cal_next_date($from_date, $plan_period, $plan_interval) ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update end_date order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }

        // listing submission limit
        $limit = get_post_meta( $pm_datas['item_number'] , P_META_PREFIX.'lunlimited', true )? 'unlimited' : get_post_meta( $pm_datas['item_number'] , P_META_PREFIX.'llimit', true );
        if ( !update_post_meta( $order_id, P_META_PREFIX.'plan_llimit',  $limit ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update plan_llimit order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        
    }
    if( get_post_meta( $pm_datas['item_number'], P_META_PREFIX.'lnever_expire', true ) ){
        update_post_meta( $order_id, P_META_PREFIX.'end_date',  'NEVER' );
    }
    // update trial end date 
    if($pm_datas['pm_status'] == 'trialing'){
        $trial_interval = get_post_meta( $order_id , P_META_PREFIX.'trial_interval', true );
        $trial_period = get_post_meta( $order_id , P_META_PREFIX.'trial_period', true );

        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Order trial_interval: $trial_interval" . PHP_EOL, 3, CTH_LOG_FILE);
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Order trial_period: $trial_period" . PHP_EOL, 3, CTH_LOG_FILE);


        if ( !update_post_meta( $order_id, P_META_PREFIX.'end_date',  citybook_add_ons_cal_next_date($from_date, $trial_period, $trial_interval) ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update end_date order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }
    // check for existing purchase code
    if(get_post_meta( $order_id, P_META_PREFIX.'purchase_code', true ) == ''){
        if ( !update_post_meta( $order_id, P_META_PREFIX.'purchase_code',  citybook_addons_create_purchase_code() ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update purchase_code order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }

    // check for existing listings item
    $order_listings = get_post_meta( $order_id, P_META_PREFIX.'listings', true );
    if($order_listings === ''){
        update_post_meta( $order_id, P_META_PREFIX.'listings',  array() );
    }elseif(is_array($order_listings)){

        // update listing status to publish if enabled
        if(citybook_addons_get_option('auto_publish_paid_listings','no') == 'yes'){
            foreach ($order_listings as $lis_id) {
                $lis_args = array(
                    'ID'                => $lis_id,
                    'post_status'       => 'publish',
                );
                $lis_id = wp_update_post( $lis_args, true );                          
                if (CTH_DEBUG && is_wp_error($lis_id)) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Publish listing (ID: $lis_id) after active subscription error: " . $lis_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
                }else{
                    $lis_post = get_post($lis_id);
                    citybook_addons_user_add_notification($user_id, array(
                        'type' => 'listing_publish',
                        'message' => sprintf(__( 'Your listing <a href="%s">%s</a> has been approved!', 'citybook-add-ons' ), get_the_permalink($lis_id), $lis_post->post_title )
                    ));
                }
            }
               
        }

    }

    // update order/subscription transaction ids array - paypal: txn_id
    if(isset($pm_datas['txn_id']) && $pm_datas['txn_id'] != ''){
        // create new invoice post
        
        $required_data = array(
            'order_id'  => $order_id,
            'user_id'  => $user_id,
            'user_name'  => __( 'No user', 'citybook-add-ons' ),
            'user_email'  => __( 'No user email', 'citybook-add-ons' ),
            'from_date'  => get_post_meta( $order_id, P_META_PREFIX.'from_date', true ),
            'end_date'  => get_post_meta( $order_id, P_META_PREFIX.'end_date', true ),
            'payment'  => get_post_meta( $order_id, P_META_PREFIX.'payment_method', true ),
            'txn_id'  => $pm_datas['txn_id'],

            'plan_title'  => get_the_title( $pm_datas['item_number'] ),
            'quantity'  => get_post_meta( $order_id, P_META_PREFIX.'quantity', true ),
            'amount'  => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
            'tax'  => 0, // maybe change in the future
            'charged_to'  => '', // maybe change in the future
        );
        $user_datas = get_user_by( 'ID', $user_id );
        if( $user_datas ){
            $required_data['user_name'] = $user_datas->display_name;
            $required_data['user_email'] = $user_datas->user_email;
            $required_data['charged_to'] = $user_datas->user_email;
        }

        $new_invoice = citybook_addons_create_invoice($required_data);
        if($new_invoice != false){
            $order_transactions = get_post_meta($order_id,  P_META_PREFIX.'transactions', true );
            if( is_array($order_transactions) ){

                if(!array_search($new_invoice, $order_transactions)){
                    $order_transactions[] = $new_invoice;
                }

                // if (!array_key_exists($pm_datas['txn_id'],$order_transactions)){
                //     $order_transactions[$pm_datas['txn_id']] = array(
                //         'txn_id' => $pm_datas['txn_id'],
                //         'quantity' => get_post_meta( $order_id, P_META_PREFIX.'quantity', true ),
                //         'amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                //         'plan_id' => get_post_meta( $order_id, P_META_PREFIX.'plan_id', true ),
                //     );
                // }
            }else{
                $order_transactions = array($new_invoice);
                // $order_transactions = array();
                // $order_transactions[$pm_datas['txn_id']] = array(
                //     'txn_id' => $pm_datas['txn_id'],
                //     'quantity' => get_post_meta( $order_id, P_META_PREFIX.'quantity', true ),
                //     'amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                //     'plan_id' => get_post_meta( $order_id, P_META_PREFIX.'plan_id', true ),
                    
                // );
            }
            if ( !update_post_meta( $order_id, P_META_PREFIX.'transactions',  $order_transactions ) ) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update transactions order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
            }
        }

            
    }

    // will create new linvoice post type to store user invoices

    if(get_post_meta( $order_id, P_META_PREFIX.'is_recurring_plan', true ) == 'on' && isset($pm_datas['subscription_id'])){

        if( !update_post_meta( $order_id, P_META_PREFIX.'subscription_id',  $pm_datas['subscription_id'] ) ){
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update order subscription_id data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }

    // for recurring subscription
    if($pm_datas['recurring_subscription']){
        // to do tasks
    }

    do_action( 'citybook_addons_order_completed', $order_id );

}
function citybook_addons_active_booking($pm_datas = array()){
    $booking_post = get_post($pm_datas['item_number']);
    update_post_meta($booking_post->ID, P_META_PREFIX.'lb_status', 'completed');
}
function citybook_addons_create_purchase_code($suffix = '')
{
    if (function_exists('com_create_guid'))
    {
        if($suffix != '') 
            return trim(com_create_guid(), '{}').'-'.$suffix;
        else
            return trim(com_create_guid(), '{}');
    }

    $format = '%04X%04X-%04X-%04X-%04X-%04X%04X%04X';
    if($suffix != '') $format .= '-'.$suffix;
    return sprintf($format, mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535));
}
// update order transactions with stripe invoice id
function citybook_add_ons_update_order_transactions($pm_datas = array(), $stripe_data = true){
    $order_id = $pm_datas['order_id'];
    if(isset($pm_datas['txn_id']) && $pm_datas['txn_id'] != ''){
        $order_transactions = get_post_meta($order_id,  P_META_PREFIX.'transactions', true );
        if( is_array($order_transactions) ){
            if( !in_array($pm_datas['txn_id'], $order_transactions) ) $order_transactions[] = $pm_datas['txn_id'];
        }else{
            $order_transactions = array($pm_datas['txn_id']);
        }
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Order transactions: " .json_encode($order_transactions) . PHP_EOL, 3, CTH_LOG_FILE);
        if ( !update_post_meta( $order_id, P_META_PREFIX.'transactions',  $order_transactions ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update transactions order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }

}
// create new invoice
function citybook_addons_create_invoice($data){

    // $required_data = array(
    //     'order_id',
    //     'user_id',
    //     'user_name',
    //     'user_email',
    //     'from_date',
    //     'end_date',
    //     'payment',
    //     'txn_id',

    //     'plan_title',
    //     'quantity',
    //     'amount',
    //     'tax',
    //     'charged_to',
    // );

    $invoice_datas                      = array();
    $invoice_datas['post_title']        = sprintf(__( 'Invoice for package #%s', 'citybook-add-ons' ), $data['order_id']);
    $invoice_datas['post_content']      = '';
    $invoice_datas['post_author']       = $data['user_id'];
    $invoice_datas['post_status']       = 'publish';
    $invoice_datas['post_type']         = 'cthinvoice';

    do_action( 'citybook_addons_insert_invoice_before', $invoice_datas );

    $cthinvoice_id = wp_insert_post($invoice_datas ,true );

    if (!is_wp_error($cthinvoice_id)) {
        if( citybook_addons_get_option('db_hide_invoices') != 'yes' ){
            citybook_addons_user_add_notification($data['user_id'], array(
                'type'          => 'new_invoice',
                'message'       => sprintf(__( 'You have a new invoice. ID: %s', 'citybook-add-ons' ), $cthinvoice_id ),
                'object'        => $cthinvoice_id
            ));
        }
            

        $meta_datas = array(
            'order_id'                  => $data['order_id'],

            'user_id'                   => $data['user_id'],
            'user_name'                 => $data['user_name'],
            'user_email'                => $data['user_email'],
            
            'from_date'                 => $data['from_date'],
            'end_date'                  => $data['end_date'],
            'payment'                   => $data['payment'],
            'txn_id'                    => $data['txn_id'],

            'plan_title'                => $data['plan_title'],
            'quantity'                  => $data['quantity'],
            'amount'                    => $data['amount'], // will be order total - 
            'tax'                       => $data['tax'], // maybe not needed
            'charged_to'                => $data['charged_to'], // if want to display card number

            'for_listing_ad'            => (isset($data['for_listing_ad']) && $data['for_listing_ad'] == 'yes') ? 'yes' : 'no',
        );

        foreach ($meta_datas as $key => $value){
            if ( !update_post_meta( $cthinvoice_id, P_META_PREFIX.$key, $value ) ) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). sprintf(__('Insert invoice %s meta failure or existing meta value','citybook-add-ons'),$key) . PHP_EOL, 3, CTH_LOG_FILE);
            }
        }

        do_action( 'citybook_addons_new_invoice', $cthinvoice_id );

        return $cthinvoice_id;

    }

    return false;

}

// for testing only
add_action('wp_ajax_nopriv_stripe_submit', 'citybook_addons_stripe_submit_callback');
add_action('wp_ajax_stripe_submit', 'citybook_addons_stripe_submit_callback');

function citybook_addons_stripe_submit_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_wpnonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'listing-checkout' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $current_user = wp_get_current_user(); 

    try {
        require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';

        $stripeEmail = $_POST['stripeEmail'];
        $charge_metas = array(
            'ctb_plan_id'               => $_POST['plan-id'], // make unique meta key for site identifing
            'listing_id'                => $_POST['listing-id'],
            // 'order_id'                  => $lorder_id,
            'user_id'                   => $current_user->ID,
            'user_email'                => $current_user->user_email,
            'renew'                     => 'no',
            'subscription'              => 'no'
        );

        $payment_class = new CTH_Payment_Stripe();

        $stripe_args = array(
            // 'customer'   => $customer->id, // will be added from the class
            'amount'        => citybook_addons_get_stripe_amount( 53.90 ),
            // 'currency'   => citybook_addons_get_option('currency','USD'), // lowercase will be added from the class
            'description'   => sprintf( __( 'Payment from %s', 'citybook-add-ons' ), $stripeEmail ), 
            'receipt_email' => $stripeEmail,
            'metadata'      => $charge_metas
        );

        $json['data']['charge_obj'] = $payment_class->processOneTime($stripe_args);
    } catch (Exception $e) {
        $json['data']['error'] = $e->getMessage();
    }

    wp_send_json($json );

}
