<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class CTH_Payment_Payfast{

	protected $ipn_data = array();

	protected $debug_file;    

	protected $debug = CTH_DEBUG;

	function __construct(){

		$this->payfast_url = citybook_addons_get_option('payments_test_mode') == 'yes'? 'https://sandbox.payfast.co.za/eng/process/?' : 'https://www.payfast.co.za/eng/process/?';

		$this->debug_file = './payfast.log';
	}

	function processBuyNow($args = array()){
		$payfast_redirect = $this->payfast_url;
		$payfast_args = array(
		    'item_name' => 'Listing Title', //plan title,
		    'amount' => '22', // plan price

		    'merchant_id'	=>	'',

		    'merchant_key'	=>	'',

		    'return_url'	=>	'',

		    'name_first'	=>	'',

		    'name_last'		=>	'',

		    'email_address'	=>	'',

		    'item_description'	=>	''
		  
		);

        // merge with $args array
        $payfast_args = array_merge($payfast_args,$args);

        // get price in ZAR
        // If multicurrency system its conversion has to be done before building this array
        $payfast_args['amount'] = number_format( sprintf( "%.2f", $payfast_args['amount'] ), 2, '.', '' );
        // Create parameter string
        $pfOutput = '';
        foreach( $payfast_args as $key => $val ){
            if(!empty($val)){
                $pfOutput .= $key .'='. urlencode( trim( $val ) ) .'&';
            }
        }
        // Remove last ampersand
        $getString = substr( $pfOutput, 0, -1 );
        //Uncomment the next line and add a passphrase if there is one set on the account 
        //$passPhrase = '';
        if( isset( $passPhrase ) ){
            $getString .= '&passphrase='. urlencode( trim( $passPhrase ) );
        }   
        // $payfast_args['signature'] = md5( $getString );
        $payfast_redirect .= $getString;
		return $payfast_redirect;

	}

	function validateIPN() {
        // step 1
        $pfHost = citybook_addons_get_option('payments_test_mode')=='yes' ? 'sandbox.payfast.co.za' : 'www.payfast.co.za';
        // Posted variables from ITN
        $pfData = $_POST;

        // Strip any slashes in data
        foreach( $pfData as $key => $val )
        {
            $pfData[$key] = stripslashes( $val );
        }

        $this->ipn_data = $pfData;

        if($this->debug){
            $debug_text = "New IPN POST Vars from Payfast:\n";
            foreach($pfData as $key => $value) {
                $debug_text .= "$key=$value\n";
            }
            // Write to log
            error_log( $debug_text . PHP_EOL, 3, $this->debug_file );
        }
        // step 2
        // $pfData includes of ALL fields posted through from PayFast, plus the empty strings
        $pfData = $_POST;
        $pfParamString = '';

        // Construct variables 
        foreach( $pfData as $key => $val ){
            if( $key != 'signature' )
            {
                $pfParamString .= $key .'='. urlencode( $val ) .'&';
            }
        }

        // Remove the last '&' from the parameter string
        $pfParamString = substr( $pfParamString, 0, -1 );
        $pfTempParamString = $pfParamString;
        // Passphrase stored in website database
        $passPhrase = '';

        if( !empty( $passPhrase ) ){
            $pfTempParamString .= '&passphrase='.urlencode( $passPhrase );
        }
        $signature = md5( $pfTempParamString );

        if($signature != $pfData['signature']){
            if($this->debug) error_log( 'Invalid Signature' . PHP_EOL, 3, $this->debug_file );
            return false;
        }
        // step 3
        // Variable initialization
        $validHosts = array(
            'www.payfast.co.za',
            'sandbox.payfast.co.za',
            'w1w.payfast.co.za',
            'w2w.payfast.co.za',
        );

        $validIps = array();

        foreach( $validHosts as $pfHostname ){
            $ips = gethostbynamel( $pfHostname );
            if( $ips !== false )
            {
                $validIps = array_merge( $validIps, $ips );
            }
        }

        // Remove duplicates
        $validIps = array_unique( $validIps );

        if( !in_array( $_SERVER['REMOTE_ADDR'], $validIps ) ){
            if($this->debug) error_log( 'Source IP not Valid' . PHP_EOL, 3, $this->debug_file );
            return false;
        }

        // Security step three
        // $cartTotal = xxxx; // This amount needs to be sourced from your application
        // if( abs( floatval( $cartTotal ) - floatval( $pfData['amount_gross'] ) ) > 0.01 ){
        //     error_log( 'Amounts Mismatch' . PHP_EOL, 3, $this->debug_file );
        //     return false;
        // }

        // Security step four
        // Variable initialization
        $url = 'https://'. $pfHost .'/eng/query/validate';

        // Create default cURL object
        $ch = curl_init();

        // Set cURL options - Use curl_setopt for greater PHP compatibility
        // Base settings
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_HEADER, false );      
        curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 2 );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 1 );

        // Standard settings
        curl_setopt( $ch, CURLOPT_URL, $url );
        curl_setopt( $ch, CURLOPT_POST, true );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, $pfParamString );

        // Execute CURL
        $response = curl_exec( $ch );
        curl_close( $ch );

        $lines = explode( "\r\n", $response );
        $verifyResult = trim( $lines[0] );

        if( strcasecmp( $verifyResult, 'VALID' ) != 0 ){
            if($this->debug) error_log( 'Payfast Data not valid' . PHP_EOL, 3, $this->debug_file );
            return false;
        }
        // Step three
        // Query your database and compare the pf_payment_id in order to verify that the order hasn’t already been processed on your system.
        $pfPaymentId = $pfData['pf_payment_id'];

        // Step four
        // Once you have completed these tests and the data received is valid, check the payment status and handle appropriately.
        if( $pfData ['payment_status'] == 'COMPLETE' ){
            // If complete, update your application
            if($this->debug) error_log( 'Payfast - One-Time payment status complete' . PHP_EOL, 3, $this->debug_file );
            return true;
        }else{
            // If unknown status, do nothing (which is the safest course of action)
            if($this->debug) error_log( 'unknown status, do nothing (which is the safest course of action)' . PHP_EOL, 3, $this->debug_file );
            return false;
        }

        // For Recurring billing only:
        // switch( $pfData['payment_status'] ){
        //     case 'COMPLETE':
        //     // If complete, update your application
        //        break;
        //     case 'CANCEL':
        //     // If cancel, then cancel subscription
        //        break;
        //     default:
        //     // If unknown status, do nothing (which is the safest course of action)
        //        break;
        // }
	  
	}
	function extractPaymentData(){
		$return = array('pm_status'=>false);
		if($this->validateIPN()){

			// New IPN POST Vars from Payfast:
			// m_payment_id=
			// pf_payment_id=744478
			// payment_status=COMPLETE
			// item_name=Payment for Extended plan
			// item_description=
			// amount_gross=108.90
			// amount_fee=-2.51
			// amount_net=106.39
			// custom_str1=
			// custom_str2=
			// custom_str3=
			// custom_str4=
			// custom_str5=
			// custom_int1=2319
			// custom_int2=
			// custom_int3=
			// custom_int4=
			// custom_int5=
			// name_first=Glue
			// name_last=Down
			// email_address=dev.cththemes@gmail.com
			// merchant_id=10011532
			// signature=970aae3cfa49c1573391ba68a64f9a83
			$payfast_data 		= $this->ipn_data;
			$return = array(
				'pm_status'   				=> $payfast_data['payment_status'],
				// related to subscription controller
				// 'pm_invoice'				=> $payfast_data['invoice'],
				//Customer's first name - Length: 64 characters
				'first_name'				=> urldecode( $payfast_data['name_first'] ),
				//Customer's last name - Length: 64 characters
				'last_name'					=> urldecode( $payfast_data['name_last'] ),
				//Item name as passed by you, the merchant - plan title
				'item_name'					=> urldecode( $payfast_data['item_name'] ),
				//Pass-through variable for you to track purchases.
				'item_number'				=> $payfast_data['custom_int1'], //listing id
				//Full amount of the customer's payment, before transaction fee is subtracted. Equivalent to payment_gross for USD payments. If this amount is negative, it signifies a refund or reversal, and either of those payment statuses can be for the full or partial amount of the original transaction.
				'pm_amount'   				=> $payfast_data['amount_gross'],
				//Transaction fee associated with the payment. mc_gross minus mc_fee equals the amount deposited into the receiver_email account. Equivalent to payment_fee for USD payments. If this amount is negative, it signifies a refund or reversal, and either of those payment statuses can be for the full or partial amount of the original transaction fee.
				// 'pm_fee'   					=> $payfast_data['mc_fee'],
				// For payment IPN notifications, this is the currency of the payment.
				// 'pm_currency'   			=> $payfast_data['mc_currency'],
				// The merchant's original transaction identification number for the payment from the buyer, against which the case was registered.
				// 'txn_id'   					=> $payfast_data['txn_id'],
				// Primary email address of the payment recipient (that is, the merchant). If the payment is sent to a non-primary email address on your PayPal account, the receiver_email is still your primary email.
				// 'receiver_email'   			=> urldecode( $payfast_data['receiver_email'] ),
				// Customer's primary email address. Use this email to provide any credits. 
				'payer_email'   			=> urldecode( $payfast_data['email_address'] ),
				// Quantity as entered by your customer or as passed by you, the merchant. If this is a shopping cart transaction, PayPal appends the number of the item 
				// 'quantity'   				=> $payfast_data['quantity'],
				// Time/Date stamp generated by PayPal, in the following format: HH:MM:SS Mmm DD, YYYY PDT
				'pm_date'   				=> date("Y-m-d"),

				// Custom value as passed by you, the merchant. These are pass-through variables that are never presented to your customer 
				'order_id' 					=> $payfast_data['custom_int2'],
				'listing_id' 				=> $payfast_data['custom_int4'],
				'user_id' 					=> $payfast_data['custom_int3'],
				'user_email' 				=> $payfast_data['email_address'],
				
				// 'renew_subscription' 		=> $renew_subscription,
				// for recurring subscription
				// 'recurring_subscription' 	=> $recurring_subscription,

				// 'subscription_id'			=> (isset($payfast_data['subscr_id']) ? $payfast_data['subscr_id'] : ''),
				// https://code.tutsplus.com/tutorials/how-to-set-up-recurring-payments--net-30168

				// for listing ad campaign
				// 'for_listing_ad' 			=> $for_listing_ad,
			);
		}
		return $return;
	}
}