<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



function citybook_addons_wp_mail_from_name( $name ) {
    return citybook_addons_get_option('emails_name')? citybook_addons_get_option('emails_name'): $name;
}

function citybook_addons_wp_mail_from( $email ) {
    return citybook_addons_get_option('emails_email')? citybook_addons_get_option('emails_email'): $email;
}
// string|array $to, string $subject, string $message, string|array $headers = '', string|array $attachments = array()
function citybook_addons_do_wp_mail( $to, $subject='', $message='', $headers = array(), $attachments = array() ){

    // return 'dfdsfsdf';

    // $headers = array();
    if(citybook_addons_get_option('emails_ctype') == 'html'){
        $headers[] = 'Content-Type: text/html; charset=UTF-8';
    }
    //$headers[] = 'From: '. $sender_option.' ' . '<'.$sender_email_option.'>';
    add_filter( 'wp_mail_from_name', 'citybook_addons_wp_mail_from_name' );
    add_filter('wp_mail_from', 'citybook_addons_wp_mail_from');
    $headers[] = 'Reply-To: '. citybook_addons_wp_mail_from_name(__( 'Sender Name', 'citybook-add-ons' )) .' ' . '<'.citybook_addons_wp_mail_from(__( 'senderemail@gmail.com', 'citybook-add-ons' )).'>';

    $email_sent = wp_mail( $to, $subject , $message , $headers, $attachments );

    remove_filter( 'wp_mail_from_name', 'citybook_addons_wp_mail_from_name' );
    remove_filter('wp_mail_from', 'citybook_addons_wp_mail_from');

    return $email_sent;
}

// process email template
function citybook_addons_process_email_template($email_template = '', $email_vars = array()){
    $email_vars = array_merge($email_vars,array('site_title' => get_bloginfo('name')));
    // get allow variables
    $allow_field_names = array_keys($email_vars);
    // extract variables, skip if existing
    extract($email_vars, EXTR_SKIP);

    if(preg_match_all("/{([\w-_]+)[^\w-_]*}/", $email_template, $matches) != FALSE){
        $fieldsPattern = array();//$matches[0];
        $fieldsReplace = array();
        foreach ($matches[1] as $key => $fn) {
            $fieldsPattern[] = "/{(".$fn.")[^\w-_]*}/";
            if( isset($$fn) && in_array($fn, $allow_field_names ) ){
                $fieldsReplace[] = $$fn;  //'['.$fn.']';
            }else{
                $fieldsReplace[] = '{'.$fn.'}';
            } 
        }
        $email_template = preg_replace($fieldsPattern, $fieldsReplace, $email_template);
    }
    return $email_template;
}

// submit listing emails
add_action( 'citybook_addons_insert_listing_after', 'citybook_addons_insert_listing_after_action_callback', 10, 2 );
function citybook_addons_insert_listing_after_action_callback($listing_id = 0, $is_editing_listing = true){
    if($is_editing_listing == false){
        $listing_post = get_post($listing_id);
        if (null != $listing_post){
            $cats = array();
            $terms = get_the_terms($listing_post,'listing_cat');
            if ( $terms && ! is_wp_error( $terms ) ){
                
                foreach ( $terms as $term ) {
                    $cats[] = $term->name;
                }
            }
            $current_user = wp_get_current_user();

            // send admin notification email
            if(citybook_addons_get_option('emails_admin_new_listing_enable') == 'yes'){
                
                $subj_args = array(
                    'listing_number' => $listing_post->ID,
                    'listing_title' => $listing_post->post_title,
                    'listing_date' => $listing_post->post_date,
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_listing_subject'), $subj_args);
                $temp_args = array(
                    'listing_number' => $listing_post->ID,
                    'listing_author' => $current_user->display_name,
                    'listing_title' => $listing_post->post_title,
                    'listing_category' => implode(", ", $cats),
                    'listing_excerpt' => $listing_post->post_excerpt,
                    'listing_date' => $listing_post->post_date,
                    'author_email' => $current_user->user_email,
                    
                );
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_listing_temp'), $temp_args);
                $email_recipients = citybook_addons_get_option('emails_admin_new_listing_recipients') ? citybook_addons_get_option('emails_admin_new_listing_recipients') : get_bloginfo('admin_email') ;
                citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
            }
            // end new listing author email
            // send listing author email
            if(citybook_addons_get_option('emails_auth_new_listing_enable') == 'yes'){
                
                $subj_args = array(
                    'listing_title' => $listing_post->post_title,
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_listing_subject'), $subj_args);
                $temp_args = array(
                    'listing_number' => $listing_post->ID,
                    'listing_author' => $current_user->display_name,
                    'listing_title' => $listing_post->post_title,
                    'listing_category' => implode(", ", $cats),
                    'listing_dashboard' => get_permalink(citybook_addons_get_option('dashboard_page')),
                );
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_listing_temp'), $temp_args);
                citybook_addons_do_wp_mail( $current_user->user_email, $email_subject, $email_template);
            }
            // end new listing author email
                
        }
        // if is correct listing
    }
    // send email for submit new listing only
}

// new order emails
add_action( 'citybook_addons_insert_order_after', 'citybook_addons_insert_order_after_action_callback', 10, 3 );
function citybook_addons_insert_order_after_action_callback($order_id = 0, $listing_id = 0, $plan_id = 0){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){
            $listing_post = get_post($listing_id);
            if (null != $listing_post){
                $cats = array();
                $terms = get_the_terms($listing_post,'listing_cat');
                if ( $terms && ! is_wp_error( $terms ) ){
                    
                    foreach ( $terms as $term ) {
                        $cats[] = $term->name;
                    }
                }
                // need to check if the order is for ad campaign
                
                // send admin notification email
                if(citybook_addons_get_option('emails_admin_new_order_enable') == 'yes'){
                    
                    $subj_args = array(
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_order_subject'), $subj_args);
                    $temp_args = array(
                        'author' => get_post_meta( $order_id, P_META_PREFIX.'display_name', true ),
                        'order_amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                        'order_currency' => get_post_meta( $order_id, P_META_PREFIX.'currency_code', true ),
                        'order_method' => citybook_addons_get_order_method_text(get_post_meta( $order_id, P_META_PREFIX.'payment_method', true )),
                        'order_title' => $order_post->post_title,
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                        'listing_title' => $listing_post->post_title,
                        'listing_category' => implode(", ", $cats),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_order_temp'), $temp_args);
                    $email_recipients = citybook_addons_get_option('emails_admin_new_order_recipients') ? citybook_addons_get_option('emails_admin_new_order_recipients') : get_bloginfo('admin_email') ;
                    citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
                }
                // end new order admi email
            }
            // end if listing_post
        }
        // end if order_post
    }
}
// completed order emails

add_action( 'citybook_addons_order_completed', 'citybook_addons_order_completed_action_callback' );
function citybook_addons_order_completed_action_callback($order_id = 0){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){
            $listing_post = get_post(get_post_meta( $order_id, P_META_PREFIX.'listing_id', true ));
            if (null != $listing_post){
                $cats = array();
                $terms = get_the_terms($listing_post,'listing_cat');
                if ( $terms && ! is_wp_error( $terms ) ){
                    
                    foreach ( $terms as $term ) {
                        $cats[] = $term->name;
                    }
                }
                $listing_author_email = get_post_meta( $order_id, P_META_PREFIX.'email', true );
                // send admin notification email
                if(citybook_addons_get_option('emails_admin_order_completed_enable') == 'yes'){
                    
                    $subj_args = array(
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_order_completed_subject'), $subj_args);
                    $temp_args = array(
                        'author' => get_post_meta( $order_id, P_META_PREFIX.'display_name', true ),
                        'order_amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                        'order_currency' => get_post_meta( $order_id, P_META_PREFIX.'currency_code', true ),
                        'order_method' => citybook_addons_get_order_method_text(get_post_meta( $order_id, P_META_PREFIX.'payment_method', true )),
                        'order_title' => $order_post->post_title,
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                        'listing_title' => $listing_post->post_title,
                        'listing_category' => implode(", ", $cats),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_order_completed_temp'), $temp_args);
                    $email_recipients = citybook_addons_get_option('emails_admin_order_completed_recipients') ? citybook_addons_get_option('emails_admin_order_completed_recipients') : get_bloginfo('admin_email') ;
                    citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
                }
                // end new order admin email

                // send author notification email
                if(citybook_addons_get_option('emails_auth_order_completed_enable') == 'yes' && $listing_author_email !=''){
                    
                    $subj_args = array(
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_order_completed_subject'), $subj_args);
                    $temp_args = array(
                        'author' => get_post_meta( $order_id, P_META_PREFIX.'display_name', true ),
                        'order_amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                        'order_currency' => get_post_meta( $order_id, P_META_PREFIX.'currency_code', true ),
                        'order_method' => citybook_addons_get_order_method_text(get_post_meta( $order_id, P_META_PREFIX.'payment_method', true )),
                        'order_title' => $order_post->post_title,
                        'order_number' => $order_post->ID,
                        'order_date' => $order_post->post_date,
                        'listing_title' => $listing_post->post_title,
                        'listing_category' => implode(", ", $cats),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_order_completed_temp'), $temp_args);
                    
                    citybook_addons_do_wp_mail( $listing_author_email, $email_subject, $email_template);
                }
                // end new order author email
            }
            // end if listing_post
        }
        // end if order_post
    }
}



// send claim emails
function citybook_addons_cthclaim_approved_callback($claim_id = 0, $listing_id = 0, $user_id = 0){
    if(is_numeric($claim_id)&&(int)$claim_id > 0){
        $listing_id                     = get_post_meta( $claim_id, P_META_PREFIX.'listing_id', true );
        $user_id                        = get_post_meta( $claim_id, P_META_PREFIX.'user_id', true );
        
        $listing_post = get_post($listing_id);
        $user_info = get_userdata($user_id);

        $subject = apply_filters( 'citybook-addons-claim-approved-subject', __( 'Claim listing approved', 'citybook-add-ons' ) );
        $body = apply_filters( 'citybook-addons-claim-approved-body', sprintf(__( '{site_title}<br>Your claimed listing <a href="%2$s">%1$s</a> is approved.<br>Thank you.', 'citybook-add-ons' ), $listing_post->post_title, get_permalink($listing_post->ID) ) );

        
        citybook_addons_do_wp_mail( $user_info->user_email, $subject, citybook_addons_process_email_template($body,array()));
    }

}
add_action( 'citybook_addons_cthclaim_approved', 'citybook_addons_cthclaim_approved_callback', 10, 3 );

// decline claim
function citybook_addons_lclaim_change_status_to_decline_callback($claim_id = 0){

    if(is_numeric($claim_id)&&(int)$claim_id > 0){
        $listing_id                     = get_post_meta( $claim_id, P_META_PREFIX.'listing_id', true );
        $user_id                        = get_post_meta( $claim_id, P_META_PREFIX.'user_id', true );
        
        $listing_post = get_post($listing_id);
        $user_info = get_userdata($user_id);

        $subject = apply_filters( 'citybook-addons-claim-declined-subject', __( 'Claim listing declined', 'citybook-add-ons' ) );
        $body = apply_filters( 'citybook-addons-claim-declined-body', sprintf(__( '{site_title}<br>Your claimed listing for %s is declined.<br>Thank you.', 'citybook-add-ons' ), $listing_post->post_title, get_permalink($listing_post->ID) ) );

        
        citybook_addons_do_wp_mail( $user_info->user_email, $subject, citybook_addons_process_email_template($body,array()));
    }


    
    
}
add_action( 'citybook_addons_lclaim_change_status_to_decline', 'citybook_addons_lclaim_change_status_to_decline_callback', 10, 1 );



// submit booking emails
add_action( 'citybook_addons_insert_booking_after', 'citybook_addons_insert_booking_after_action_callback');

function citybook_addons_insert_booking_after_action_callback($booking_id = 0){
    if(is_numeric($booking_id)&&(int)$booking_id > 0){
        $booking_post = get_post($booking_id);
        if (null != $booking_post){
            $listing_id = get_post_meta( $booking_id, P_META_PREFIX.'listing_id', true );
            $listing_post = get_post($listing_id);
            if (null != $listing_post){
                $lb_email = get_post_meta( $booking_id, P_META_PREFIX.'lb_email', true );
                $listing_author = get_user_by( 'ID', $listing_post->post_author );
                if(citybook_addons_get_option('emails_section_auth_booking_insert_enable') == 'yes'){
                    $email_recipients = array();
                    
                    if(!$listing_author) $email_recipients[] = $listing_author->user_email;
                    // also send to site owner
                    $email_recipients[] = get_bloginfo('admin_email');
                    $subj_args = array(
                        'listing_title' => $listing_post->post_title,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_auth_booking_insert_subject'), $subj_args);
                    $temp_args = array(
                        'author' => $listing_author->display_name,
                        'name' => get_post_meta( $booking_id, P_META_PREFIX.'lb_name', true ),
                        'email' => $lb_email,
                        'phone' => get_post_meta( $booking_id, P_META_PREFIX.'lb_phone', true ),
                        'quantity' => get_post_meta( $booking_id, P_META_PREFIX.'lb_quantity', true ),
                        'date' => get_post_meta( $booking_id, P_META_PREFIX.'lb_date', true ),
                        'time' => get_post_meta( $booking_id, P_META_PREFIX.'lb_time', true ),
                        'listing_title' => $listing_post->post_title,
                        'info' => get_post_meta( $booking_id, P_META_PREFIX.'lb_add_info', true ),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_auth_booking_insert_temp'), $temp_args);
            
                    citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
                }
                // listing author/admin emails

                

                if(citybook_addons_get_option('emails_section_customer_booking_insert_enable') == 'yes' && $lb_email != '' ){
                    
                    $subj_args = array(
                        'listing_title' => $listing_post->post_title,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_customer_booking_insert_subject'), $subj_args);
                    $temp_args = array(
                        'author' => $listing_author->display_name,
                        'name' => get_post_meta( $booking_id, P_META_PREFIX.'lb_name', true ),
                        'email' => $lb_email,
                        'phone' => get_post_meta( $booking_id, P_META_PREFIX.'lb_phone', true ),
                        'quantity' => get_post_meta( $booking_id, P_META_PREFIX.'lb_quantity', true ),
                        'date' => get_post_meta( $booking_id, P_META_PREFIX.'lb_date', true ),
                        'time' => get_post_meta( $booking_id, P_META_PREFIX.'lb_time', true ),
                        'listing_title' => $listing_post->post_title,
                        'info' => get_post_meta( $booking_id, P_META_PREFIX.'lb_add_info', true ),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_customer_booking_insert_temp'), $temp_args);
            
                    citybook_addons_do_wp_mail( $lb_email, $email_subject, $email_template);
                }
                // listing customer email
            }
            // end if is valid listing
        }
        // end if is valid booking

    }
}
// booking approved email
add_action( 'citybook_addons_edit_booking_approved', 'citybook_addons_edit_booking_approved_action_callback' );
function citybook_addons_edit_booking_approved_action_callback($booking_id = 0){
    if(is_numeric($booking_id)&&(int)$booking_id > 0){
        $booking_post = get_post($booking_id);
        if (null != $booking_post){
            $listing_id = get_post_meta( $booking_id, P_META_PREFIX.'listing_id', true );
            $listing_post = get_post($listing_id);
            if (null != $listing_post){
                $lb_email = get_post_meta( $booking_id, P_META_PREFIX.'lb_email', true );
                $listing_author = get_user_by( 'ID', $listing_post->post_author );
                if(citybook_addons_get_option('emails_section_customer_booking_approved_enable') == 'yes' && $lb_email != '' ){
                    
                    $subj_args = array(
                        'listing_title' => $listing_post->post_title,
                    );
                    $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_customer_booking_approved_subject'), $subj_args);
                    $temp_args = array(
                        'author' => $listing_author->display_name,
                        'name' => get_post_meta( $booking_id, P_META_PREFIX.'lb_name', true ),
                        'email' => $lb_email,
                        'phone' => get_post_meta( $booking_id, P_META_PREFIX.'lb_phone', true ),
                        'quantity' => get_post_meta( $booking_id, P_META_PREFIX.'lb_quantity', true ),
                        'date' => get_post_meta( $booking_id, P_META_PREFIX.'lb_date', true ),
                        'time' => get_post_meta( $booking_id, P_META_PREFIX.'lb_time', true ),
                        'listing_title' => $listing_post->post_title,
                        'info' => get_post_meta( $booking_id, P_META_PREFIX.'lb_add_info', true ),
                        
                    );
                    $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_section_customer_booking_approved_temp'), $temp_args);
            
                    citybook_addons_do_wp_mail( $lb_email, $email_subject, $email_template);
                }
                // listing customer email
            }
            // end if is valid listing
        }
        // end if is valid booking

    }
}
// new invoice emails
add_action( 'citybook_addons_new_invoice', 'citybook_addons_new_invoice_callback' );
function citybook_addons_new_invoice_callback($invoice_id = 0){
    if(is_numeric($invoice_id)&&(int)$invoice_id > 0){
        $invoice_post = get_post($invoice_id);
        if (null != $invoice_post){

            $listing_author_email = get_post_meta( $invoice_id, P_META_PREFIX.'user_email', true );
            // send admin notification email
            if(citybook_addons_get_option('emails_admin_new_invoice_enable') == 'yes'){
                
                $subj_args = array(
                    'number' => $invoice_post->ID,
                    'date' => $invoice_post->post_date,
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_invoice_subject'), $subj_args);
                $temp_args = citybook_addons_get_invoice_datas_array($invoice_post);
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_invoice_temp'), $temp_args);
                $email_recipients = citybook_addons_get_option('emails_admin_new_invoice_recipients') ? citybook_addons_get_option('emails_admin_new_invoice_recipients') : get_bloginfo('admin_email') ;
                citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
            }
            // end new order admin email

            // send author notification email
            if(citybook_addons_get_option('emails_auth_new_invoice_enable') == 'yes' && $listing_author_email !=''){
                
                $subj_args = array(
                    'number' => $invoice_post->ID,
                    'date' => $invoice_post->post_date,
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_invoice_subject'), $subj_args);
                // citybook_addons_get_invoice_datas_array from citybook-invoice.php file
                $temp_args = citybook_addons_get_invoice_datas_array($invoice_post);
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_invoice_temp'), $temp_args);
                
                citybook_addons_do_wp_mail( $listing_author_email, $email_subject, $email_template);
            }
            // end new order author email


        }
        // end if invoice_post
    }

}


//ask for fee
function citybook_addons_lclaim_change_status_to_asked_charge_callback($claim_id = 0){
    if(is_numeric($claim_id)&&(int)$claim_id > 0){
        $claim_post = get_post($claim_id);
        if (null != $claim_post){

            $user_info = get_userdata( get_post_meta( $claim_id, P_META_PREFIX.'user_id', true ) );
            $listing_id = get_post_meta( $claim_id, P_META_PREFIX.'listing_id', true );

            $subj_args = array(
                'id' => $claim_id,
                'date' => current_time( get_option('date_format') ),
            );
            $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_claim_subject'), $subj_args);
            $temp_args = array(
                'author'            => $user_info->display_name,
                'date'              => date_i18n( get_option( 'date_format' ), strtotime( $claim_post->post_date ) ),
                'listing_id'        => $listing_id,
                'listing_title'     => get_the_title( $listing_id ),
                'listing_url'       => get_the_permalink( $listing_id ),
                'add_to_cart'       => citybook_addons_get_add_to_cart_url($claim_id)
            );

            $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_claim_temp'), $temp_args);
            
            citybook_addons_do_wp_mail( $user_info->user_email , $email_subject, $email_template);

        }// end check post object
    }// end check id
}// end function
add_action( 'citybook_addons_lclaim_change_status_to_asked_charge', 'citybook_addons_lclaim_change_status_to_asked_charge_callback', 10, 1 );


// new invoice emails
add_action( 'citybook_addons_insert_cthclaim_after', 'citybook_addons_insert_cthclaim_after_callback' );
function citybook_addons_insert_cthclaim_after_callback($post_id = 0){
    if(is_numeric($post_id)&&(int)$post_id > 0){
        $post_obj = get_post($post_id);
        if (null != $post_obj){

            $listing_id = get_post_meta( $post_id, P_META_PREFIX.'listing_id', true );
            $user_info = get_userdata( get_post_meta( $post_id, P_META_PREFIX.'user_id', true ) );
            // send admin notification email
            if(citybook_addons_get_option('emails_admin_new_claim_enable') == 'yes'){
                
                $subj_args = array(
                    'id' => $post_id,
                    'date' => current_time( get_option('date_format') ),
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_claim_subject'), $subj_args);
                $temp_args = array(
                    'author'            => $user_info->display_name,
                    'date'              => date_i18n( get_option( 'date_format' ), strtotime( $claim_post->post_date ) ),
                    'listing_id'        => $listing_id,
                    'listing_title'     => get_the_title( $listing_id ),
                    'listing_url'       => get_the_permalink( $listing_id ),
                );
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_admin_new_claim_temp'), $temp_args);
                $email_recipients = citybook_addons_get_option('emails_admin_new_claim_recipients') ? citybook_addons_get_option('emails_admin_new_claim_recipients') : get_bloginfo('admin_email') ;
                citybook_addons_do_wp_mail( $email_recipients, $email_subject, $email_template);
            }
            // end new order admin email

            // send author notification email
            if(citybook_addons_get_option('emails_auth_new_claim_enable') == 'yes' ){
                
                $subj_args = array(
                    'id' => $post_id,
                    'date' => current_time( get_option('date_format') ),
                );
                $email_subject = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_claim_subject'), $subj_args);
                $temp_args = array(
                    'author'            => $user_info->display_name,
                    'date'              => date_i18n( get_option( 'date_format' ), strtotime( $claim_post->post_date ) ),
                    'listing_id'        => $listing_id,
                    'listing_title'     => get_the_title( $listing_id ),
                    'listing_url'       => get_the_permalink( $listing_id ),
                );
                $email_template = citybook_addons_process_email_template(citybook_addons_get_option('emails_auth_new_claim_temp'), $temp_args);
                
                citybook_addons_do_wp_mail( $user_info->user_email, $email_subject, $email_template);
            }
            // end new order author email


        }
        // end if post_obj
    }

}


add_action( 'citybook_addons_insert_order_after', function($order_id, $listing_id, $plan_id){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){
            $plan_post = get_post($plan_id);
            if (null != $plan_post){
                $listing_author_email = get_post_meta( $order_id, P_META_PREFIX.'email', true );

                $subj_args = array(
                    'order_number' => $order_post->ID,
                    'order_date' => $order_post->post_date,
                );
                $email_subject = citybook_addons_process_email_template( 'Your order has been received', $subj_args);
                $temp_args = array(
                    'author' => get_post_meta( $order_id, P_META_PREFIX.'display_name', true ),
                    'order_amount' => get_post_meta( $order_id, P_META_PREFIX.'amount', true ),
                    'order_currency' => get_post_meta( $order_id, P_META_PREFIX.'currency_code', true ),
                    'order_method' => citybook_addons_get_order_method_text(get_post_meta( $order_id, P_META_PREFIX.'payment_method', true )),
                    'order_title' => $order_post->post_title,
                    'order_number' => $order_post->ID,
                    'order_date' => $order_post->post_date,
                    'listing_title' => $plan_post->post_title,
                    
                );
                $email_template = citybook_addons_process_email_template('Hello {author}, Your order has been received. We will check and contact with you soon.', $temp_args);
                
                citybook_addons_do_wp_mail( $listing_author_email, $email_subject, $email_template);
            }
        }
    }
            

}, 10, 3 );

