<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_Listing_Plan() {
    
    $labels = array( 
        'name' => __( 'Plan', 'citybook-add-ons' ),
        'singular_name' => __( 'Plan', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Plan', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Plan', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Plan', 'citybook-add-ons' ),
        'new_item' => __( 'New Plan', 'citybook-add-ons' ),
        'view_item' => __( 'View Plan', 'citybook-add-ons' ),
        'search_items' => __( 'Search Plans', 'citybook-add-ons' ),
        'not_found' => __( 'No Plans found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Plans found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Plan:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Plans', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => 'List Plans',
        'supports' => array( 'title', 'editor', 'thumbnail'/*, 'post-formats'*/),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-tickets-alt',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => false,
        'can_export' => true,
        'rewrite' => array( 'slug' => __('plan','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'lplan', $args );
}

//Register Booking 
add_action( 'init', 'citybook_addons_register_cpt_Listing_Plan' );

// modify booking columns
function citybook_addons_lplan_columns_head($defaults) {
    unset($defaults['date']);
    $defaults['ID']             = __('ID','citybook-add-ons');
    $defaults['price']          = __('Price','citybook-add-ons');
    $defaults['pm_count']       = __('Subscribes Count','citybook-add-ons');
    return $defaults;
}

function citybook_addons_lplan_columns_content($column_name, $post_ID) {
    if ($column_name == 'price') {
        echo '<strong>'.citybook_addons_get_price_formated( get_post_meta( $post_ID, P_META_PREFIX.'price', true ) ).'</strong>';
    }

    if ($column_name == 'ID') {
        echo '<strong>'.$post_ID.'</strong>';
    }

    if ($column_name == 'pm_count') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'pm_count', true ).'</strong>';
    }
    
    
    
    
}


add_filter('manage_lplan_posts_columns', 'citybook_addons_lplan_columns_head');
add_action('manage_lplan_posts_custom_column', 'citybook_addons_lplan_columns_content', 10, 2);

// metabox
function citybook_addons_plan_add_meta_box() {

    $screens = array( 'lplan');

    foreach ( $screens as $screen ) {

        add_meta_box(
            'lplan_stripe_plan',
            __( 'Stripe Recurring Plan', 'citybook-add-ons' ),
            'citybook_addons_plan_meta_box_stripe_plan_callback',
            $screen,
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
    }

    
}
add_action( 'add_meta_boxes', 'citybook_addons_plan_add_meta_box' );

function citybook_addons_plan_meta_box_stripe_plan_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'citybook_addons-lplan', '_lplan_nonce' );

    ?>
    <table class="form-table stripe_plan">
        <tbody>

            <tr class="hoz">
                <th class="w20 align-left"><?php _e( 'Stripe Plan', 'citybook-add-ons' ); ?></th>
                <td>
                    <input type="text" class="input-text" name="<?php echo P_META_PREFIX.'stripe_plan_id' ?>" id="<?php echo P_META_PREFIX.'stripe_plan_id' ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'stripe_plan_id', true );?>">
                    <p><?php _e( 'Enter your Stripe Plan ID or create <a href="#" class="ctb-modal-open">New Plan</a> using this plan details.', 'citybook-add-ons' ); ?></p>

                    <input type="hidden" name="_price" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'price', true );?>">
                </td>
            </tr>
            
        </tbody>
    </table>
    <?php 

    add_action( 'admin_footer', function()use($post){
        ?>
        <div class="ctb-modal-wrap ctb-modal">
            <div class="ctb-modal-holder">
                <div class="ctb-modal-inner">
                    <div class="ctb-modal-close"><span class="dashicons dashicons-no-alt"></span></div>
                    <h3><?php _e( 'Create a ', 'citybook-add-ons' );?><span><?php esc_html_e( 'Stripe Plan', 'citybook-add-ons' ); ?></span></h3>
                    <div class="ctb-modal-content">

                        <form id="create-stripe-plan-form" class="create-stripe-plan-form custom-form" action="#" method="POST">
                            

                            <label for="stripe_plan"><?php _e( 'Plan Title *', 'citybook-add-ons' ); ?></label>
                            <input type="text" id="stripe_plan" name="stripe_plan" value="<?php echo $post->post_title; ?>" required="required">
                            
                            <label for="stripe_product"><?php _e( 'Product Title *', 'citybook-add-ons' ); ?></label>
                            <input type="text" id="stripe_product" name="stripe_product" value="<?php echo sprintf(__( '%s Stripe product', 'citybook-add-ons' ), $post->post_title ); ?>" required="required">
                            
                            <input type="hidden" name="lplan_id" value="<?php echo $post->ID; ?>" required="required">
                     

                            <?php wp_nonce_field( 'create_stripe_plan', 'stripe_nonce' ); ?>

                            <input class="stripe-plan-submit" type="submit" id="stripe_submit" value="<?php esc_attr_e( 'Submit', 'citybook-add-ons' ); ?>">

                        </form>
                        
                    </div>
                    <!-- end modal-content -->
                </div>
            </div>
        </div>
        <!-- end modal --> 
        <?php
    } );   
}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function citybook_addons_lplan_save_meta_box_datas( $post_id ) {

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // Check if our nonce is set.
    if ( ! isset( $_POST['_lplan_nonce'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $_POST['_lplan_nonce'], 'citybook_addons-lplan' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    // Check the user's permissions.
    if ( isset( $_POST['post_type'] ) && 'lplan' == $_POST['post_type'] ) {

        if ( ! current_user_can( 'edit_page', $post_id ) ) {
            return;
        }

    } else {

        if ( ! current_user_can( 'edit_post', $post_id ) ) {
            return;
        }
    }
    
    if(isset($_POST[P_META_PREFIX.'stripe_plan_id'])){
        $new_val = sanitize_text_field( $_POST[P_META_PREFIX.'stripe_plan_id'] ) ;
        $origin_val = get_post_meta( $post_id, P_META_PREFIX.'stripe_plan_id', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, P_META_PREFIX.'stripe_plan_id', $new_val );
        }
        
    }
    // add new price meta for woo - first use _cth_price value and will update l
    if(isset($_POST['_cth_price'])){
        $new_val = sanitize_text_field( $_POST['_cth_price'] ) ;
        // if($new_val == '') $new_val = get_post_meta( $post_id, P_META_PREFIX.'price', true );
        $origin_val = get_post_meta( $post_id, '_price', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, '_price', $new_val );
        }
        
    }
}
add_action( 'save_post_lplan', 'citybook_addons_lplan_save_meta_box_datas' );




// create stripe plan action
add_action('wp_ajax_nopriv_create_stripe_plan', 'citybook_addons_create_stripe_plan_callback');
add_action('wp_ajax_create_stripe_plan', 'citybook_addons_create_stripe_plan_callback');

function citybook_addons_create_stripe_plan_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );

    if( !isset($_POST['stripe_nonce']) || !isset($_POST['lplan_id']) || !isset($_POST['stripe_plan']) || !isset($_POST['stripe_product']) ){
        $json['data']['error'] = esc_html__( 'Invalid create stripe form', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }
    

    $nonce = $_POST['stripe_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'create_stripe_plan' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $plan_post          = get_post($_POST['lplan_id']);

    if(empty($plan_post)){
        $json['data']['error'] = esc_html__( 'Invalid listing plan ID', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $prices = citybook_addons_get_plan_prices($plan_post->ID);

    $stripe_args = array(
        'nickname'      => $_POST['stripe_plan'],
        'product'       => array(
            'name'  => $_POST['stripe_product']
        ),
        'amount'        => citybook_addons_get_stripe_amount( $prices['total'] ),
        'interval'      => get_post_meta( $plan_post->ID , P_META_PREFIX.'period', true ),
        'interval_count'=> get_post_meta( $plan_post->ID , P_META_PREFIX.'interval', true )
    );

    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';
    $payment_class = new CTH_Payment_Stripe();

    $plan = $payment_class->createPlan($stripe_args);

    if($plan){
        $json['success'] = true;
        $json['plan_id'] = $plan->id;

        $update_lplan_field = true;

        if($update_lplan_field){
            update_post_meta( $plan_post->ID, P_META_PREFIX.'stripe_plan_id', $plan->id );
        }
    }else{
        $json['data']['error'] = esc_html__( 'There is something wrong. Please try again.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

// get active plan for setting selection
function citybook_addons_get_listing_plans(){
    $results = array();

    $post_args = array(
        'post_type' => 'lplan',
        
        'posts_per_page'=> -1,
        'orderby'          => 'date',
        'order'            => 'DESC',

        'post_status' => 'any'
    );

    $posts = get_posts( $post_args );
    if ( $posts ) {
        foreach ( $posts as $post ) {
            $results[$post->ID] = apply_filters( 'the_title' , $post->post_title );
            
        }
    }

    return $results;
}






