<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_Listing_Message() {
    
    $labels = array( 
        'name' => __( 'Message', 'citybook-add-ons' ),
        'singular_name' => __( 'Message', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Message', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Message', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Message', 'citybook-add-ons' ),
        'new_item' => __( 'New Message', 'citybook-add-ons' ),
        'view_item' => __( 'View Message', 'citybook-add-ons' ),
        'search_items' => __( 'Search Messages', 'citybook-add-ons' ),
        'not_found' => __( 'No Messages found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Messages found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Message:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Messages', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => 'List Messages',
        'supports' => array( 'title' /*, 'editor', 'author', 'thumbnail','comments','excerpt', 'post-formats'*/),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-email-alt',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => false,
        'rewrite' => array( 'slug' => __('lmessage','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'lmessage', $args );
}

//Register Booking 
add_action( 'init', 'citybook_addons_register_cpt_Listing_Message' );

// modify booking columns
function citybook_addons_lmessage_columns_head($defaults) {
    unset($defaults['date']);
    // unset($defaults['title']);
    unset($defaults['author']);
    unset($defaults['comments']);
    
    $defaults['from']             = __('From','citybook-add-ons');
    $defaults['to']             = __('To','citybook-add-ons');
    $defaults['status']             = __('Status','citybook-add-ons');
    // $defaults['lmsg_gateway']       =  __('Payment Getway','cth-gather-plugins');
    // $defaults['lmsg_pass']       =  __('Plan','cth-gather-plugins');
    // $defaults['lmsg_status']     = __('Status','cth-gather-plugins');
    
    // $defaults['lmsg_quantity']   = __('Quantity','citybook-add-ons');
    // $defaults['lmsg_currency']   = __('Currency','cth-gather-plugins');
    $defaults['date']   = __('Date','citybook-add-ons');

    $defaults['ID']             = __('ID','citybook-add-ons');

    return $defaults;
}

function citybook_addons_lmessage_columns_content($column_name, $post_ID) {

    if ($column_name == 'from') {
        if(get_post_meta( $post_ID, P_META_PREFIX.'from_user_id', true ) == 0){
            $from_name = get_post_meta( $post_ID, P_META_PREFIX.'lmsg_name', true );
        }else{
            $user_info = get_userdata( get_post_meta( $post_ID, P_META_PREFIX.'from_user_id', true ) );
            $from_name = $user_info->display_name;
        }
        echo '<strong>'.$from_name.'</strong>';
    }
    if ($column_name == 'to') {
        // if(get_post_meta( $post_ID, P_META_PREFIX.'to_user_id', true ) == 0){
        //     $to_name = get_post_meta( $post_ID, P_META_PREFIX.'lmsg_name', true );
        // }else{
        //     $user_info = get_userdata( get_post_meta( $post_ID, P_META_PREFIX.'to_user_id', true ) );
        //     $to_name = $user_info->display_name;
        // }
        // only send to an user
        $user_info = get_userdata( get_post_meta( $post_ID, P_META_PREFIX.'to_user_id', true ) );
        echo '<strong>'.$user_info->display_name.'</strong>';
    }
    if ($column_name == 'status') {
        echo '<strong>'.citybook_addons_get_booking_status_text(get_post_meta( $post_ID, P_META_PREFIX.'lmsg_status', true )).'</strong>';
        
    }

    // if ($column_name == 'lmsg_quantity') {
    //     echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'lmsg_quantity', true ).'</strong>';
        
    // }
    // if ($column_name == 'lmsg_date') {
    //     // echo '<strong>'.date(get_option('date_format' ) . get_option('time_format' ), get_post_meta( $post_ID, P_META_PREFIX.'lmsg_date', true ) ).'</strong>';
    //     echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'lmsg_date', true ).' '.get_post_meta( $post_ID, P_META_PREFIX.'lmsg_time', true ).'</strong>';
        
    // }

    if ($column_name == 'ID') {
        echo '<strong>'.$post_ID.'</strong>';
    }
}


add_filter('manage_lmessage_posts_columns', 'citybook_addons_lmessage_columns_head');
add_action('manage_lmessage_posts_custom_column', 'citybook_addons_lmessage_columns_content', 10, 2);

// submit a author message
// add_action('wp_ajax_nopriv_citybook_addons_lauthor_message', 'citybook_addons_lauthor_message_callback');
// add_action('wp_ajax_citybook_addons_lauthor_message', 'citybook_addons_lauthor_message_callback');

function citybook_addons_lauthor_message_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $authid = $_POST['authid'];
    if(is_numeric($authid) && (int)$authid > 0){

        $lmessage_datas = array();
        $lmessage_metas_loggedin = array();
		if(isset($_POST['lmsg_name'])&&isset($_POST['lmsg_email']) ){
            // $lmessage_datas['post_title'] = sprintf(__( 'Message from %s', 'citybook-add-ons' ), $_POST['lmsg_name']);
		    $lmessage_datas['post_title'] = $_POST['lmsg_name'];
		}else{
            $current_user = wp_get_current_user();
            if(0 == $current_user->ID){ // no logged in user and invalid form
                $json['success'] = false;
                $json['data']['error'] = __( 'Invalid message form without name and email.', 'citybook-add-ons' );
                
            }else{
                // $lmessage_datas['post_title'] = sprintf(__( 'Message from %s', 'citybook-add-ons' ), $current_user->display_name ); 
                $lmessage_datas['post_title'] = $current_user->display_name;

                $lmessage_metas_loggedin['lmsg_name'] = $current_user->display_name;
                $lmessage_metas_loggedin['lmsg_email'] = $current_user->user_email;
                $lmessage_metas_loggedin['lmsg_phone'] = get_user_meta($current_user->ID,  P_META_PREFIX.'phone', true );
            }
            
		}
		$lmessage_datas['post_content'] = '';
		//$lmessage_datas['post_author'] = '0';// default 0 for no author assigned
		$lmessage_datas['post_status'] = 'publish';
		$lmessage_datas['post_type'] = 'lmessage';

		do_action( 'citybook_addons_insert_message_before', $lmessage_datas );

		$lmessage_id = wp_insert_post($lmessage_datas ,true );

		if (!is_wp_error($lmessage_id)) {
		    //print( $lmessage_id->get_error_message() );
		    // $json['data']['lmessage_id'] = $lmessage_id;
            $meta_fields = array(
                'lmsg_name'                 => 'text',
                'lmsg_email'                => 'text',
                'lmsg_phone'                => 'text',

                
                'lmsg_message'              => 'text',
                'lmsg_type'                 => 'text',
            );
            $lmessage_metas = array();
            foreach($meta_fields as $field => $ftype){
                if(isset($_POST[$field])) $lmessage_metas[$field] = $_POST[$field] ;
                else{
                    if($ftype == 'array'){
                        $lmessage_metas[$field] = array();
                    }else{
                        $lmessage_metas[$field] = '';
                    }
                } 
            }
            $lmessage_metas['to_user_id'] = $authid;
            $lmessage_metas['from_user_id'] = get_current_user_id();
            $lmessage_metas['lmsg_status'] = 'pending'; // pending - completed - failed - refunded - canceled

            // merge with logged in customser data
            $lmessage_metas = array_merge($lmessage_metas,$lmessage_metas_loggedin);

            // $cmb_prefix = '_cth_';
            foreach ($lmessage_metas as $key => $value) {
                // https://codex.wordpress.org/Function_Reference/update_post_meta
                // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
                // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                if ( !update_post_meta( $lmessage_id, P_META_PREFIX.$key,  $value  ) ) {
                    $json['data'][] = sprintf(__('Insert message %s meta failure or existing meta value','citybook-add-ons'),$key);
                    // wp_send_json($json );
                }
            }

            // $json['data']['lmessage_metas'] = $lmessage_metas;

            $json['data']['message'] = apply_filters( 'citybook_addons_insert_message_message', __( 'Your message is received. The listing author will contact with you soon.<br>You can also login with your email to manage messages.<br>Thank you.', 'citybook-add-ons' ) );

            do_action( 'citybook_addons_insert_message_after', $lmessage_id );
		}else{
            $json['success'] = false;
			$json['data']['error'] = $lmessage_id->get_error_message();

			if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert booking post error: " . $lmessage_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);

		    // throw new Exception($lmessage_id->get_error_message());

		}

    }else{
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The author id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

// delete message
add_action('wp_ajax_nopriv_citybook_addons_del_lmessage', 'citybook_addons_del_lmessage_callback');
add_action('wp_ajax_citybook_addons_del_lmessage', 'citybook_addons_del_lmessage_callback');

function citybook_addons_del_lmessage_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $msgid = $_POST['msgid'];
    if(is_numeric($msgid) && (int)$msgid > 0){
        if(get_current_user_id() != get_post_meta( $msgid, P_META_PREFIX.'to_user_id', true ) ){
            $json['data']['error'] = __( "You don't have permission to delete this message", 'citybook-add-ons' );
            // wp_send_json($json );
        }else{

            $deleted_post = wp_delete_post( $msgid, true );//move to trash
            if($deleted_post){
                $json['data']['deleted_message'] = $deleted_post;
                $json['success'] = true;
            }else{
                $json['data']['error'] = esc_html__( 'Delete message failure', 'citybook-add-ons' ) ;
            }

        }

            
    }else{
        
        $json['data']['error'] = esc_html__( 'The message id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

		


