<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// modify users columns
function citybook_addons_users_columns_head( $columns ) {
    $columns['membership'] = __('Membership Plan','citybook-add-ons');
    return $columns;
}
// add_filter( 'manage_users_columns', 'citybook_addons_users_columns_head' );

function citybook_addons_users_columns_content( $val, $column_name, $user_id ) {
    switch ($column_name) {
        case 'membership' :

        //var_dump(get_user_meta( $user_id, P_META_PREFIX.'subscriptions', true ));
        	// $plan_post = get_post(get_user_meta( $user_id, P_META_PREFIX.'member_plan', true));
         //    $val = null == $plan_post? __( 'None', 'citybook-add-ons' ) : sprintf( __( '%s<br>From: %s', 'citybook-add-ons' ), $plan_post->post_title, get_user_meta( $user_id, P_META_PREFIX.'payment_date', true) ) ;
                $val = implode( "<br>", (array) get_user_meta( $user_id, P_META_PREFIX.'subscriptions', true ) );
            break;
        
        default:
    }
    return $val;
}
// add_filter( 'manage_users_custom_column', 'citybook_addons_users_columns_content', 10, 3 );

// create stripe plan action
add_action('wp_ajax_nopriv_citybook_addons_delete_notification', 'citybook_addons_delete_notification_callback');
add_action('wp_ajax_citybook_addons_delete_notification', 'citybook_addons_delete_notification_callback');

function citybook_addons_delete_notification_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $key = $_POST['key'];

    $current_user = wp_get_current_user();

    $notifications = get_user_meta( $current_user->ID, P_META_PREFIX.'notifications', true );

    if(!empty($notifications) && is_array($notifications)){
        if(array_key_exists($key, $notifications)){
            unset($notifications[$key]);

            update_user_meta( $current_user->ID, P_META_PREFIX.'notifications', $notifications );

            $json['success'] = true;
        }
    }


    wp_send_json($json );

}

// Apply filter - to use custom avatar
add_filter( 'get_avatar' , 'citybook_addons_custom_avatar' , 1 , 5 );

function citybook_addons_custom_avatar( $avatar, $id_or_email, $size, $default, $alt ) {
    $user = false;

    if ( is_numeric( $id_or_email ) ) {

        $id = (int) $id_or_email;
        $user = get_user_by( 'id' , $id );

    } elseif ( is_object( $id_or_email ) ) {

        if ( ! empty( $id_or_email->user_id ) ) {
            $id = (int) $id_or_email->user_id;
            $user = get_user_by( 'id' , $id );
        }

    } else {
        $user = get_user_by( 'email', $id_or_email );   
    }

    if ( $user && is_object( $user ) ) {
        if(function_exists('bp_core_fetch_avatar')){
            $avatar = bp_core_fetch_avatar ( array( 'item_id' => $user->ID, 'type' => 'full' ) );
        }else{
            $custom_avatar = get_user_meta( $user->ID, P_META_PREFIX.'custom_avatar', true );
            if(is_array($custom_avatar) && count($custom_avatar)){
                $custom_ava_id = reset($custom_avatar);
                if(!is_numeric($custom_ava_id)) $custom_ava_id = key($custom_avatar);
                $avatar = wp_get_attachment_url( $custom_ava_id );
                
                // $avatar = wp_get_attachment_url( reset($custom_avatar) );
                $avatar = "<img alt='{$alt}' src='{$avatar}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
            }
        }
    }

    return $avatar;
}


// for bookmarks listing
add_action('wp_ajax_nopriv_citybook_addons_bookmarks_listing', 'citybook_addons_bookmarks_listing_callback');
add_action('wp_ajax_citybook_addons_bookmarks_listing', 'citybook_addons_bookmarks_listing_callback');

function citybook_addons_bookmarks_listing_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $listing_post          = get_post($_POST['listing']);

    if(empty($listing_post)){
        $json['data']['error'] = esc_html__( 'Invalid listing', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    
    if(!is_user_logged_in()){
        $json['data']['error'] = esc_html__( 'Not logged in user', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if(citybook_addons_already_bookmarked($listing_post->ID)){
        $json['data']['error'] = esc_html__( 'User had already bookmarked', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $json['success'] = true;


    // increase listing bookmarks
    $bookmarks = get_post_meta( $listing_post->ID, P_META_PREFIX.'bookmarks', true );
    if($bookmarks == '')
        $bookmarks = 1;
    else 
        $bookmarks += 1;
    // update post meta
    update_post_meta( $listing_post->ID, P_META_PREFIX.'bookmarks', $bookmarks );

    // send notification to listing author
    if( citybook_addons_get_option('db_hide_bookmarks') != 'yes' ){
        citybook_addons_user_add_notification($listing_post->post_author, array(
            'type' => 'new_bookmarks',
            'message' => sprintf(__( 'Someone bookmarked your <a href="%s" target="_blank">%s</a> listing!', 'citybook-add-ons' ), esc_url( get_the_permalink($listing_post->ID) ), $listing_post->post_title ) 
        ));
    }
        

    
    
    //update user bookmarks array
    $user_id = get_current_user_id();

    $listing_bookmarks = get_user_meta( get_current_user_id(), P_META_PREFIX.'listing_bookmarks', true );

    if(!empty($listing_bookmarks) && is_array($listing_bookmarks)){
        if(array_search($listing_post->ID, $listing_bookmarks) === false){
            $listing_bookmarks[] = $listing_post->ID;
        }else{
            $json['data']['error'] = esc_html__( 'User had already bookmarked', 'citybook-add-ons' ) ;
        }
    }else{
        $listing_bookmarks = array($listing_post->ID);
    }

    update_user_meta( get_current_user_id(), P_META_PREFIX.'listing_bookmarks', $listing_bookmarks );

    // send notification to current user
    if( citybook_addons_get_option('db_hide_bookmarks') != 'yes' ){
        citybook_addons_user_add_notification(get_current_user_id(), array(
            'type' => 'bookmarked',
            'message' => sprintf(__( 'You have bookmarked <a href="%s" target="_blank">%s</a> listing!', 'citybook-add-ons' ), esc_url( get_the_permalink($listing_post->ID) ), $listing_post->post_title ) 
        ));
    }
        

    $json['data']['icon'] = __( '<i class="fa fa-bookmark"></i> <span class="bm-text">Saved</span><span class="tooltiptext">Bookmarked</span>', 'citybook-add-ons' );

    wp_send_json($json );

}
function citybook_addons_already_bookmarked($post_ID = 0){
    if(!is_user_logged_in()) return false;

    $listing_bookmarks = get_user_meta( get_current_user_id(), P_META_PREFIX.'listing_bookmarks', true );
    
    if(!empty($listing_bookmarks) && is_array($listing_bookmarks)){
        if(array_search($post_ID, $listing_bookmarks) !== false) return true;
    }

    return false;

}
// for delete bookmark
add_action('wp_ajax_nopriv_citybook_addons_delete_bookmark', 'citybook_addons_delete_bookmark_callback');
add_action('wp_ajax_citybook_addons_delete_bookmark', 'citybook_addons_delete_bookmark_callback');

function citybook_addons_delete_bookmark_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $listing_post          = get_post($_POST['listing']);

    if(empty($listing_post)){
        $json['data']['error'] = esc_html__( 'Invalid listing', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    
    if(!is_user_logged_in()){
        $json['data']['error'] = esc_html__( 'Not logged in user', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if(!citybook_addons_already_bookmarked($listing_post->ID)){
        $json['data']['error'] = esc_html__( 'You haven\'t bookmarked this listing', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $json['success'] = true;


    // decrease listing bookmarks
    $bookmarks = get_post_meta( $listing_post->ID, P_META_PREFIX.'bookmarks', true );
    if($bookmarks == '')
        $bookmarks = 0;
    else 
        $bookmarks -= 1;
    // update post meta
    update_post_meta( $listing_post->ID, P_META_PREFIX.'bookmarks', $bookmarks );

    
    //update user bookmarks array
    $user_id = get_current_user_id();

    $listing_bookmarks = get_user_meta( get_current_user_id(), P_META_PREFIX.'listing_bookmarks', true );
    if(!empty($listing_bookmarks) && is_array($listing_bookmarks)){
        $key = array_search($listing_post->ID, $listing_bookmarks);
        if( $key !== false){
            unset($listing_bookmarks[$key]);
            update_user_meta( get_current_user_id(), P_META_PREFIX.'listing_bookmarks', $listing_bookmarks );
        }
    }
    wp_send_json($json );

}






