<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



$GLOBALS['citybook_ads'] = array();

/* add edit listing var */
function citybook_addons_add_query_vars_filter( $vars ){
  $vars[] = "listing_id";
  $vars[] = "dashboard";
  // $vars[] = "ls_type";
  return $vars;
}
add_filter( 'query_vars', 'citybook_addons_add_query_vars_filter' );

// filter document_title_parts for dasboard subpages

function citybook_addons_document_title_parts_filter( $title ){
    $dashboard_page_id = citybook_addons_get_option('dashboard_page');
    $dashboard_var = get_query_var('dashboard');
    if(is_page($dashboard_page_id) && $dashboard_var != ''){
        $title['title'] .= ' - ' . citybook_addons_get_dashboard_subpage($dashboard_var);
    }
    return $title;
}
add_filter( 'document_title_parts', 'citybook_addons_document_title_parts_filter', 10, 1 );



function citybook_addons_listing_author_no_admin_access() {
    if(!wp_doing_ajax()){
        // $redirect = isset( $_SERVER['HTTP_REFERER'] ) ? $_SERVER['HTTP_REFERER'] : home_url( '/' );
        // global $current_user;
        // $user_roles = $current_user->roles;
        // $user_role = array_shift($user_roles);

        if( in_array( citybook_addons_get_user_role(), citybook_addons_get_option('admin_bar_hide_roles') ) ){
            wp_die( __( "You don't have permission to access this page.", 'citybook-add-ons' ) );
        }
    }
        
 }

add_action( 'admin_init', 'citybook_addons_listing_author_no_admin_access', 100 );


// custom template for single listing page
function citybook_addons_listing_single_template($single_template) {
    global $post;

    if ($post->post_type == 'listing') {
        $single_template = CITYBOOK_ADD_ONS_DIR . 'templates/single-listing.php';
    }
    return $single_template;
}
add_filter( 'single_template', 'citybook_addons_listing_single_template' );

// custom template for listing search page
add_action( 'parse_request', 'citybook_addons_parse_request_callback' );
function citybook_addons_parse_request_callback( $query ) {
    if (  isset($_GET['search_term']) ) {
        $query->query_vars[ 'post_type' ] = 'listing';
    }
    return $query;
}

// custom template for listing search page
// https://wordpress.stackexchange.com/questions/89886/how-to-create-a-custom-search-for-custom-post-type
function citybook_addons_listing_search_template($template)   
{    
    global $wp_query;   

    $post_type = get_query_var('post_type');
    // var_dump($post_type);   
    if( isset($_GET['s']) && $post_type == 'listing' )   
    {
        // return locate_template('listing-search.php');  //  redirect to listing-search.php

        $template = CITYBOOK_ADD_ONS_DIR . 'templates/listing-search.php';
    }elseif(is_post_type_archive('listing')){
        $template = CITYBOOK_ADD_ONS_DIR . 'templates/archive-listing.php';
    }elseif(is_tax('listing_cat')||is_tax('listing_feature')||is_tax('listing_location')){
        $template = CITYBOOK_ADD_ONS_DIR . 'templates/tax-listing.php';
    }
    // elseif(is_author()){
    //     $template = CITYBOOK_ADD_ONS_DIR . 'templates/listing-author.php';
    // }

    elseif( array_key_exists('author_name', $wp_query->query_vars) && !empty($wp_query->query_vars['author_name']) )
    {
        global $laumember;
        $laumember = new WP_User( $wp_query->query_vars["author_name"] );
        if( $laumember )
        {
            $template = CITYBOOK_ADD_ONS_DIR . 'templates/listing-author.php';
        }
    }

    return $template;   
}
add_filter('template_include', 'citybook_addons_listing_search_template');

// modify posts result for search

function citybook_addons_listing_search_result($query) {
    if ( ! is_admin() && $query->is_main_query() ) {
        

        if (is_post_type_archive('listing') || is_tax('listing_cat')||is_tax('listing_feature')||is_tax('listing_location') || ( $query->is_search && 'listing' == $query->get('post_type') ) ) {
            
            $ad_posts_args = array();
            $ad_posts = array();
            if(is_search()){
                if(citybook_addons_get_option('ads_search_enable') == 'yes'){
                    $ad_posts_args = array(
                        'post_type'             => 'listing', 
                        'orderby'               => citybook_addons_get_option('ads_search_orderby'),
                        'order'                 => citybook_addons_get_option('ads_search_order'),
                        'posts_per_page'        => citybook_addons_get_option('ads_search_count'),
                        'meta_query'            => array(
                            'relation' => 'AND',
                            array(
                                'key'     => P_META_PREFIX.'is_ad',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_position_search',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_expire',
                                'value'   => current_time('mysql', 1),
                                'compare' => '>=',
                                'type'    => 'DATETIME',
                            ),
                        ),

                    );

                    if( isset($_GET['lcats']) && !empty( array_filter($_GET['lcats']) ) ){
                        $ad_posts_args['tax_query'] = array(
                            array(
                                'taxonomy' => 'listing_cat',
                                'field'    => 'term_id',
                                'terms'    => $_GET['lcats'],
                            ),
                        );
                    }
                }
            }elseif(is_tax('listing_cat')){
                if(citybook_addons_get_option('ads_category_enable') == 'yes'){
                    $ad_posts_args = array(
                        'post_type'             => 'listing', 
                        'orderby'               => citybook_addons_get_option('ads_category_orderby'),
                        'order'                 => citybook_addons_get_option('ads_category_order'),
                        'posts_per_page'        => citybook_addons_get_option('ads_category_count'),
                        'tax_query' => array(
                            array(
                                'taxonomy' => 'listing_cat',
                                'field'    => 'term_id',
                                'terms'    => get_queried_object_id(),
                            ),
                        ),

                        'meta_query'            => array(
                            'relation' => 'AND',
                            array(
                                'key'     => P_META_PREFIX.'is_ad',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_position_category',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_expire',
                                'value'   => current_time('mysql', 1),
                                'compare' => '>=',
                                'type'    => 'DATETIME',
                            ),
                        ),

                    );
                }
            }elseif(is_post_type_archive('listing')){
                if(citybook_addons_get_option('ads_archive_enable') == 'yes'){
                    $ad_posts_args = array(
                        'post_type'             => 'listing', 
                        'orderby'               => citybook_addons_get_option('ads_archive_orderby'),
                        'order'                 => citybook_addons_get_option('ads_archive_order'),
                        'posts_per_page'        => citybook_addons_get_option('ads_archive_count'),
                        'meta_query'            => array(
                            'relation' => 'AND',
                            array(
                                'key'     => P_META_PREFIX.'is_ad',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_position_archive',
                                'value'   => 'yes',
                            ),
                            array(
                                'key'     => P_META_PREFIX.'ad_expire',
                                'value'   => current_time('mysql', 1),
                                'compare' => '>=',
                                'type'    => 'DATETIME',
                            ),
                        ),

                    );
                }
            }
            if(!empty($ad_posts_args)){

                if(citybook_addons_get_option('listings_orderby') == 'listing_featured'){
                    $ad_posts_args['meta_key'] = P_META_PREFIX.'featured';
                    $ad_posts_args['orderby'] = 'meta_value_num';
                }
                
                // The Query
                $posts_query = new WP_Query( $ad_posts_args );
                
                if($posts_query->have_posts()) :
                    $GLOBALS['citybook_ads']['html'] = '';
                    $GLOBALS['citybook_ads']['object'] = array();
                    while($posts_query->have_posts()) : $posts_query->the_post();
                        $ad_posts[] = get_the_ID();
                        ob_start();
                        citybook_addons_get_template_part('template-parts/listing', false, array('is_ad'=>true));
                        $GLOBALS['citybook_ads']['html'] .= ob_get_clean();
                        $GLOBALS['citybook_ads']['object'][] = citybook_addons_get_listing_post_data();
                    endwhile;
                endif;

                wp_reset_postdata();
            }

            if(!empty($ad_posts)) $query->set('post__not_in', $ad_posts );

            
           

            $add_queries = array();
            // http://localhost:8888/citybook/?s=L&lcats%5B%5D=92&post_type=listing&lfeas%5B%5D=200&llocs%5B%5D=10

            // php 5.5+
            if( isset($_GET['lcats']) && !empty( array_filter($_GET['lcats']) ) ){

                

                $add_queries[] =    array(
                                        'taxonomy' => 'listing_cat',
                                        'field'    => 'term_id',
                                        'terms'    => $_GET['lcats'],
                                    );

            }
            if( isset($_GET['lfeas']) && !empty( array_filter($_GET['lfeas']) ) ){

                $add_queries[] =    array(
                                        'taxonomy' => 'listing_feature',
                                        'field'    => 'term_id',
                                        'terms'    => $_GET['lfeas'],
                                    );

            }
            if( isset($_GET['llocs']) && !empty($_GET['llocs'] ) ){
                $llocs = explode(',',$_GET['llocs']);
                $add_queries[] =    array(
                                        'taxonomy' => 'listing_location',
                                        'field'    => 'slug',
                                        'terms'    => array_filter( $llocs, function($loc){ return sanitize_title( $loc ); } ),
                                    );

            }

            if(!empty($add_queries)){
                $add_queries['relation'] = citybook_addons_get_option('search_tax_relation');
                $query->set('tax_query', $add_queries);
            }  

            // // listing meta search
            // $meta_queries = array();

            // // address_add value
            // if( !isset($_GET['nearme-filter']) && isset($_GET['address']) && !empty($_GET['address'] ) ){
            //     $address_q = explode(",", $_GET['address']);
            //     $addes_qr = array();
            //     foreach ($address_q as $add_r) {
            //         $addes_qr[] =    array(
            //                             'key' => P_META_PREFIX.'contact_infos_address',
            //                             'value'    => trim($add_r),
            //                             'compare' => 'LIKE',
            //                         );
            //     }
            //     if(count($addes_qr)> 1) $addes_qr['relation'] = 'OR';
                
            //     $meta_queries[] = $addes_qr;
            // }

            
            // if(!empty($meta_queries)){
            //     if(count($meta_queries)> 1) $meta_queries['relation'] = 'AND';
            //     $query->set('meta_query', $meta_queries);
            // } 

            $query->set('posts_per_page', citybook_addons_get_option('listings_count'));
            $query->set('orderby', citybook_addons_get_option('listings_orderby'));
            $query->set('order', citybook_addons_get_option('listings_order'));

            // $query->set('meta_key', P_META_PREFIX.'featured');
            // $query->set('orderby', 'meta_value');
            // $query->set('order', 'DESC');

            if(citybook_addons_get_option('listings_orderby') == 'listing_featured'){
                $query->set('meta_key', P_META_PREFIX.'featured');
                $query->set('orderby', 'meta_value_num');
            }
            if(citybook_addons_get_option('listings_orderby') == 'event_start_date'){
                $query->set('meta_key', P_META_PREFIX.'levent_date');
                $query->set('meta_type', 'DATE');
                $query->set('orderby', 'meta_value_date');
            }

            // for additional search
            $query->set('suppress_filters', false);
            $query->set('cthqueryid', 'main-search');
            
        }
        
        if ( $query->is_tag() ) {
            $query->set( 'post_type', array( 'post','nav_menu_item','listing' ) );
        }
        
    }
}

add_action( 'pre_get_posts', 'citybook_addons_listing_search_result' );


function citybook_addons_listing_search_where($where, $q){
    global $wpdb;
    if ( ! is_admin() && $q->is_main_query() ) {
        // if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Is search" . PHP_EOL, 3, CTH_LOG_FILE);
        // if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). json_encode($q) . PHP_EOL, 3, CTH_LOG_FILE);
        if (is_search() && 'listing' == get_query_var('post_type') )
            $where .= "OR (t.name LIKE '%".get_search_query()."%' AND {$wpdb->posts}.post_status = 'publish')";
    }
    return $where;
}

function citybook_addons_listing_search_join($join, $q){
    global $wpdb;
    if ( ! is_admin() && $q->is_main_query() ) {
        if ( is_search() && 'listing' == get_query_var('post_type') )
            $join .= "LEFT JOIN {$wpdb->term_relationships} tr ON {$wpdb->posts}.ID = tr.object_id INNER JOIN {$wpdb->term_taxonomy} tt ON tt.term_taxonomy_id=tr.term_taxonomy_id INNER JOIN {$wpdb->terms} t ON t.term_id = tt.term_id";
    }
    return $join;
}

function citybook_addons_listing_search_groupby($groupby, $q){
    global $wpdb;
    if ( ! is_admin() && $q->is_main_query() ) {
        // we need to group on post ID
        $groupby_id = "{$wpdb->posts}.ID";
        if(!is_search() || strpos($groupby, $groupby_id) !== false || 'listing' != get_query_var('post_type')) return $groupby;

        // groupby was empty, use ours
        if(!strlen(trim($groupby))) return $groupby_id;

        // wasn't empty, append ours
        return $groupby.", ".$groupby_id;
    }

    return $groupby;
}

// add_filter('posts_where','citybook_addons_listing_search_where', 10, 2);
// add_filter('posts_join', 'citybook_addons_listing_search_join', 10, 2);
// add_filter('posts_groupby', 'citybook_addons_listing_search_groupby', 10, 2);

// function citybook_addons_add_tag_custom_type($query){
//     if ( ! is_admin() && $query->is_main_query() ) {
//         // add support post_tag to listing post
//         if( is_tag() && empty($query->query_vars['suppress_filters']) ){
//             $post_types = (array)$query->get('post_type');

//             $query->set('post_type', array('post','nav_menu_item','listing'));
//         }
//     }
    
//     return $query;
// }

// add_filter( 'pre_get_posts', 'citybook_addons_add_tag_custom_type' );

function citybook_addons_auto_login_new_user( $user_id ) {
    
    wp_set_current_user($user_id);

    // Set the global user object
    // $current_user = get_user_by( 'id', $user_id );

    // set the WP login cookie
    $secure_cookie = is_ssl() ? true : false;

    wp_set_auth_cookie( $user_id, true, $secure_cookie ); // This function does not return a value

}
// do not remove the callback function
// add_action( 'user_register', 'citybook_addons_auto_login_new_user' );
// https://codex.wordpress.org/Plugin_API/Action_Reference/user_register

function citybook_addons_generate_password($length = 12) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-';
    $count = mb_strlen($chars);

    for ($i = 0, $result = ''; $i < $length; $i++) {
        $index = rand(0, $count - 1);
        $result .= mb_substr($chars, $index, 1);
    }

    return $result;
}

function citybook_addons_register_cpt_Listing() {
    
    $labels = array( 
        'name' => __( 'Listing', 'citybook-add-ons' ),
        'singular_name' => __( 'Listing', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Listing', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Listing', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Listing', 'citybook-add-ons' ),
        'new_item' => __( 'New Listing', 'citybook-add-ons' ),
        'view_item' => __( 'View Listing', 'citybook-add-ons' ),
        'search_items' => __( 'Search Listings', 'citybook-add-ons' ),
        'not_found' => __( 'No Listings found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Listings found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Listing:', 'citybook-add-ons' ),
        'menu_name' => __( 'CityBook Listings', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Listings',
        'supports' => array( 'title', 'editor', 'author', 'thumbnail','comments','excerpt'/*, 'post-formats'*/),
        'taxonomies' => array('listing_cat','post_tag', 'listing_feature', 'listing_location'),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 25,
        'menu_icon' => 'dashicons-location-alt', // plugin_dir_url( __FILE__ ) .'assets/admin_ico_listing.png', 
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => true,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => array( 'slug' => __('listing','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'listing', $args );
}

//Register Listing 
add_action( 'init', 'citybook_addons_register_cpt_Listing' );


//create a custom taxonomy name it Skills for your posts

function citybook_addons_register_taxonomy_Listing_Cat() {

    // Add new taxonomy, make it hierarchical like categories
    //first do the translations part for GUI

    $labels = array(
        'name' => __( 'Listing Categories', 'citybook-add-ons' ),
        'singular_name' => __( 'Category', 'citybook-add-ons' ),
        'search_items' =>  __( 'Search Categories','citybook-add-ons' ),
        'all_items' => __( 'All Categories','citybook-add-ons' ),
        'parent_item' => __( 'Parent Category','citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Category:','citybook-add-ons' ),
        'edit_item' => __( 'Edit Category','citybook-add-ons' ), 
        'update_item' => __( 'Update Category','citybook-add-ons' ),
        'add_new_item' => __( 'Add New Category','citybook-add-ons' ),
        'new_item_name' => __( 'New Category Name','citybook-add-ons' ),
        'menu_name' => __( 'Listing Categories','citybook-add-ons' ),
    );     

    // Now register the taxonomy

    register_taxonomy('listing_cat',array('listing'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_in_nav_menus'=> true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => __('listing_cat','citybook-add-ons') ),
        // https://codex.wordpress.org/Roles_and_Capabilities
        'capabilities' => array(
            'manage_terms' => 'manage_categories',
            'edit_terms' => 'manage_categories',
            'delete_terms' => 'manage_categories',
            'assign_terms' => 'edit_posts'
        ),

    ));

}

//Add Listing Category
    
add_action( 'init', 'citybook_addons_register_taxonomy_Listing_Cat', 0 );

//create a custom taxonomy name it Skills for your posts

function citybook_addons_register_taxonomy_Listing_Feature() {

    // Add new taxonomy, make it hierarchical like categories
    //first do the translations part for GUI

    $labels = array(
        'name' => __( 'Listing Features', 'citybook-add-ons' ),
        'singular_name' => __( 'Feature', 'citybook-add-ons' ),
        'search_items' =>  __( 'Search Features','citybook-add-ons' ),
        'all_items' => __( 'All Features','citybook-add-ons' ),
        'parent_item' => __( 'Parent Feature','citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Feature:','citybook-add-ons' ),
        'edit_item' => __( 'Edit Feature','citybook-add-ons' ), 
        'update_item' => __( 'Update Feature','citybook-add-ons' ),
        'add_new_item' => __( 'Add New Feature','citybook-add-ons' ),
        'new_item_name' => __( 'New Feature Name','citybook-add-ons' ),
        'menu_name' => __( 'Listing Features','citybook-add-ons' ),
    );     

    // Now register the taxonomy

    register_taxonomy('listing_feature',array('listing'), array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_in_nav_menus'=> true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => __('listing_feature','citybook-add-ons') ),
        // https://codex.wordpress.org/Roles_and_Capabilities
        // 'capabilities' => array(
        //     'manage_terms' => 'manage_categories',
        //     'edit_terms' => 'manage_categories',
        //     'delete_terms' => 'manage_categories',
        //     'assign_terms' => 'edit_posts'
        // ),

    ));

}

//Add Listing Category
    
add_action( 'init', 'citybook_addons_register_taxonomy_Listing_Feature', 0 );

function citybook_addons_register_taxonomy_Listing_Location() {

    // Add new taxonomy, make it hierarchical like categories
    //first do the translations part for GUI

    $labels = array(
        'name' => __( 'Listing Locations', 'citybook-add-ons' ),
        'singular_name' => __( 'Location', 'citybook-add-ons' ),
        'search_items' =>  __( 'Search Locations','citybook-add-ons' ),
        'all_items' => __( 'All Locations','citybook-add-ons' ),
        'parent_item' => __( 'Parent Location','citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Location:','citybook-add-ons' ),
        'edit_item' => __( 'Edit Location','citybook-add-ons' ), 
        'update_item' => __( 'Update Location','citybook-add-ons' ),
        'add_new_item' => __( 'Add New Location','citybook-add-ons' ),
        'new_item_name' => __( 'New Location Name','citybook-add-ons' ),
        'menu_name' => __( 'Listing Locations','citybook-add-ons' ),
    );     

    // Now register the taxonomy

    register_taxonomy('listing_location',array('listing'), array(
        'hierarchical' => true, // false for insert new tax when inserting post
        'labels' => $labels,
        'show_ui' => true,
        'show_in_nav_menus'=> true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array( 'slug' => __('listing_location','citybook-add-ons') ),
        // https://codex.wordpress.org/Roles_and_Capabilities
        // 'capabilities' => array(
        //     'manage_terms' => 'manage_categories',
        //     'edit_terms' => 'manage_categories',
        //     'delete_terms' => 'manage_categories',
        //     'assign_terms' => 'edit_posts'
        // ),

    ));

}

//Add Listing Category
    
add_action( 'init', 'citybook_addons_register_taxonomy_Listing_Location', 0 );




if(!function_exists('cth_listing_columns_head')){
    function cth_listing_columns_head($defaults) {
        unset($defaults['tags']);
        unset($defaults['comments']);
        unset($defaults['taxonomy-listing_feature']);
        $defaults['_thumbnail'] = __( 'Thumbnail', 'citybook-add-ons' );
        $defaults['_id'] = __( 'ID', 'citybook-add-ons' );
        $defaults['expire_date'] = __( 'Expiration Date', 'citybook-add-ons' );
        $defaults['_featured'] = __( 'Featured', 'citybook-add-ons' );
        $defaults['_verified'] = __( 'Verified', 'citybook-add-ons' );

        
        return $defaults;
    }
}
if(!function_exists('cth_listing_columns_content')){
    // CUSTOM POSTS
    function cth_listing_columns_content($column_name, $post_ID) {
        if ($column_name == '_id') {
            echo $post_ID;
        }
        if ($column_name == '_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }

        if ($column_name == 'expire_date') {
            $expire_date = get_post_meta( $post_ID, P_META_PREFIX.'expire_date', true );
            if($expire_date == 'NEVER'){
                _e( 'Never', 'citybook-add-ons' );
            }elseif( $expire_date < current_time( 'mysql', 1 ) ){
                _e( 'Expired', 'citybook-add-ons' );
                //echo '<br>'.$expire_date;
            }else{
                echo $expire_date;
            }
        }

        if ($column_name == '_featured') {
            echo '<a href="#" class="button set-lfeatured'.( get_post_meta( $post_ID, P_META_PREFIX.'featured', true ) == '1'? ' lfeatured' : '' ).'" data-id="'.$post_ID.'"><span class="lfeatured-loading"><i class="fa fa-spinner fa-pulse"></i></span><span class="as-lfeatured">'.__( 'Set as featured', 'citybook-add-ons' ).'</span><span class="lfeatured">'.__( 'Featured', 'citybook-add-ons' ).'</span></a>';
        }

        if ($column_name == '_verified') {
            echo '<a href="#" class="button set-lverified'.( get_post_meta( $post_ID, P_META_PREFIX.'verified', true ) == true? ' lverified' : '' ).'" data-id="'.$post_ID.'"><span class="lverified-loading"><i class="fa fa-spinner fa-pulse"></i></span><span class="as-lverified">'.__( 'Verify', 'citybook-add-ons' ).'</span><span class="lverified">'.__( 'Verified', 'citybook-add-ons' ).'</span></a>';
        }

    }
}

add_filter('manage_listing_posts_columns', 'cth_listing_columns_head', 10);
add_action('manage_listing_posts_custom_column', 'cth_listing_columns_content', 10, 2);

if(!function_exists('citybook_addons_listing_cat_columns_head')){
    function citybook_addons_listing_cat_columns_head($defaults) {
        $defaults['thumbnail'] = __('Thumbnail','citybook-add-ons');
        $defaults['id'] = __('ID','citybook-add-ons');
        return $defaults;
    }
}

if(!function_exists('citybook_addons_listing_cat_columns_content')){
    function citybook_addons_listing_cat_columns_content($c, $column_name, $term_id) {
        if ($column_name == 'id') {
            echo $term_id;
        }
        if ($column_name == 'thumbnail') {
            $term_meta = get_term_meta( $term_id, '_cth_term_meta', true );
            if(isset($term_meta['featured_img']) && !empty($term_meta['featured_img'])){
                echo wp_get_attachment_image( $term_meta['featured_img']['id'], 'thumbnail', false, array('style'=>'width:100px;height:auto;') );
                
            }
        }
    }
}
add_filter('manage_edit-listing_cat_columns', 'citybook_addons_listing_cat_columns_head');
add_filter('manage_listing_cat_custom_column', 'citybook_addons_listing_cat_columns_content', 10, 3);


/**
 * Taxonomy meta box
 *
 * @since CityBook 1.0
 */
require_once CITYBOOK_ADD_ONS_DIR . 'inc/cth_taxonomy_fields.php';
require_once CITYBOOK_ADD_ONS_DIR . 'inc/listing_cat_metabox_fields.php';
require_once CITYBOOK_ADD_ONS_DIR . 'inc/listing_feature_metabox_fields.php';



function citybook_addons_listing_add_meta_box($post) {

    $new_post = false;
    if($post->post_date == $post->post_modified && $post->post_date_gmt == '0000-00-00 00:00:00' && $post->post_modified_gmt == '0000-00-00 00:00:00' && $post->post_status == 'auto-draft' ) $new_post = true;

    // global $gather_stripe_options;
    // $striperes_add_fields            = isset( $gather_stripe_options['add_fields'] ) ? $gather_stripe_options['add_fields'] : array(); // get_option('eventres_add_fields','' );

    // $screens = array( 'listing');

    $screen = 'listing';

    // foreach ( $screens as $screen ) {

    // https://xdsoft.net/jqplugins/datetimepicker/

        // add_meta_box(
        //     'listing_features',
        //     __( 'Features', 'citybook-add-ons' ),
        //     'citybook_addons_listing_meta_box_feature_callback',
        //     $screen, // for listing post
        //     'normal',
        //     'high'
        //     //,'normal', //('normal', 'advanced', or 'side')
        //     //'core'//('high', 'core', 'default' or 'low') 
        // );
        add_meta_box(
            'listing_expire',
            __( 'Expiration Date', 'citybook-add-ons' ),
            'citybook_addons_listing_meta_box_expire_callback',
            $screen,
            'side',
            'high',
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
            array('new_post' => $new_post)
        );
        add_meta_box(
            'listing_loc_contacts',
            __( 'Contacts', 'citybook-add-ons' ),
            'citybook_addons_listing_meta_box_loc_contacts_callback',
            $screen, // for listing post
            'normal',
            'high',
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
            array('new_post' => $new_post)
        );
        if(citybook_addons_get_option('submit_hide_price_opt') != 'yes'){
            add_meta_box(
                'listing_prices_opt',
                __( 'Price Options', 'citybook-add-ons' ),
                'citybook_addons_listing_meta_box_prices_opt_callback',
                $screen, // for listing post
                'normal',
                'high',
                //,'normal', //('normal', 'advanced', or 'side')
                //'core'//('high', 'core', 'default' or 'low') 
                array('new_post' => $new_post)
            );
        }

        add_meta_box(
            'listing_header_media',
            __( 'Header Media', 'citybook-add-ons' ),
            'citybook_addons_listing_meta_box_header_media_callback',
            $screen, // for listing post
            'normal',
            'high',
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
            array('new_post' => $new_post)
        );

        add_meta_box(
            'listing_content_widgets',
            __( 'Content Widgets', 'citybook-add-ons' ),
            'citybook_addons_listing_meta_box_content_widgets_callback',
            $screen, // for listing post
            'normal',
            'high',
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
            array('new_post' => $new_post)
        );

        add_meta_box(
            'listing_add_content_widgets',
            __( 'Additional Content Widgets', 'citybook-add-ons' ),
            'citybook_addons_listing_meta_box_add_content_widgets_callback',
            $screen, // for listing post
            'normal',
            'high',
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
            array('new_post' => $new_post)
        );

        add_meta_box(
                'listing_sidebar_widgets',
                __( 'Sidebar Widgets', 'citybook-add-ons' ),
                'citybook_addons_listing_meta_box_sidebar_widgets_callback',
                $screen, // for listing post
                'normal',
                'high',
                //,'normal', //('normal', 'advanced', or 'side')
                //'core'//('high', 'core', 'default' or 'low') 
                array('new_post' => $new_post)
            );
        add_meta_box(
                'listing_add_sidebar_widgets',
                __( 'Additional Sidebar Widgets', 'citybook-add-ons' ),
                'citybook_addons_listing_meta_box_add_widget_widgets_callback',
                $screen, // for listing post
                'normal',
                'high',
                //,'normal', //('normal', 'advanced', or 'side')
                //'core'//('high', 'core', 'default' or 'low') 
                array('new_post' => $new_post)
            );
        


        if(citybook_addons_get_option('submit_hide_socials_opt') != 'yes'){
            add_meta_box(
                'listing_socials',
                __( 'Socials', 'citybook-add-ons' ),
                'citybook_addons_listing_meta_box_socials_callback',
                $screen, // for listing post
                'normal',
                'high',
                //,'normal', //('normal', 'advanced', or 'side')
                //'core'//('high', 'core', 'default' or 'low') 
                array('new_post' => $new_post)
            );
        }

        
            

    // }

    
}
add_action( 'add_meta_boxes_listing', 'citybook_addons_listing_add_meta_box' );


function citybook_addons_listing_meta_box_feature_callback( $post, $metabox) {

    //global $gather_stripe_options;
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );

    /*
     * Use get_post_meta() to retrieve an existing value
     * from the database and use the value for the form.
     */
    //$option_prices   = cth_gather_plugins_striperes_get_plans();//get_option('striperes_item_prices' );  

    

    //$pur_pass           = get_post_meta( $post->ID, 'pur_pass', true );
    // $pur_price          = get_post_meta( $post->ID, 'pur_price', true );
    // $pur_quantity       = get_post_meta( $post->ID, 'pur_quantity', true );
    // $pur_discount_text = get_post_meta( $post->ID, 'pur_discount_text', true );


    
    // $features = get_post_meta( $post->ID, '_cth_features', true );

    // // var_dump($features);
    // if(is_array($features) && !empty($features)){
    //     foreach ($features as $fea_id => $check) {
    //         display_listing_feature_field('features',$fea_id,$check);
    //     }
    // }
        

}

function citybook_addons_listing_meta_box_loc_contacts_callback($post, $metabox){


    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'citybook_addons-listing', '_listing_nonce' );
    ?>
    <div class="custom-form">
        <?php 
        citybook_addons_get_template_part(
            'template-parts/location-contacts', 
            false, 
            array(
                // new arg for hide location from back-end
                'hide_location' => true,
                'location'=>'', //trim($cur_locs,','), 
                'contact_infos'=> array(
                    'address' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_address', true ),
                    'latitude' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_latitude', true ),
                    'longitude' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_longitude', true ),
                    'phone' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_phone', true ),
                    'email' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_email', true ),
                    'website' => get_post_meta( $post->ID, P_META_PREFIX.'contact_infos_website', true ),
                ),
                
            ) 
        );
        ?>

    </div>
    <?php
}
function citybook_addons_listing_meta_box_prices_opt_callback($post, $metabox){
    ?>
    <div class="custom-form">              
        <div class="row">
            <div class="col-md-4">
                
                <label for="price_range"><?php esc_html_e( 'Price Range', 'citybook-add-ons' );?></label>
                <select id="price_range" class="fwcl chosen-select" name="price_range">
                    <?php 
                    $price_range = get_post_meta( $post->ID, P_META_PREFIX.'price_range', true );
                    foreach (citybook_addons_get_listing_price_range() as $range => $title) {
                        echo '<option value="'.$range.'" '.selected( $range, $price_range, false ).'>'.$title.'</option>';
                    }
                    ?>
                </select>
            </div>
            <div class="col-md-4">
                <label for="price_from"><?php esc_html_e( 'Price From', 'citybook-add-ons' );?></label>
                <input type="text" id="price_from" name="price_from" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'price_from', true );?>">
            </div>
            <div class="col-md-4">
                <label for="price_to"><?php esc_html_e( 'Price To', 'citybook-add-ons' );?></label>
                <input type="text" id="price_to" name="price_to" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'price_to', true );?>">
            </div>
            <!-- <div class="col-md-12">
                <?php 
                // $editor_args = array(
                //     'textarea_rows' => 5,
                //     'textarea_name'=> 'price_textarea',
                //     'teeny' => true,
                //     'quicktags' => true
                // );
                // wp_editor( get_post_meta( $post->ID, P_META_PREFIX.'price_textarea', true ), 'price_textarea_id_', $editor_args );
                ?>
            </div> -->
        </div>
    </div>
    <?php
}

function citybook_addons_listing_meta_box_socials_callback($post, $metabox){
    $socials = get_post_meta( $post->ID, P_META_PREFIX.'socials', true );
    ?>
    <div class="custom-form">
        <div class="repeater-fields-wrap"  data-tmpl="tmpl-user-social">
            <div class="repeater-fields">
            <?php 
            if(!empty($socials)){
                foreach ($socials as $key => $social) {
                    citybook_addons_get_template_part('templates-inner/social',false, array('index'=>$key,'name'=>$social['name'],'url'=>$social['url']));
                }
            }
            ?>
            </div>
            <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Social','citybook-add-ons' );?></button>
        </div>
    </div>
    <?php
}

function citybook_addons_listing_meta_box_sidebar_widgets_callback($post, $metabox){
    $new_post = $metabox['args']['new_post'];
    ?>
    <div class="custom-form">
        
        <?php //if(citybook_addons_get_option('submit_hide_counter_opt') != 'yes'): ?>
        <!-- act-widget--> 
        <div class="act-widget fl-wrap">
            <div class="act-widget-header">
                <h4><?php _e( 'Event Counter', 'citybook-add-ons' );?></h4>
                
            </div>
            <div class="row">
                <div class="col-md-6">
                    <label><?php _e( 'Event Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="levent_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'levent_date', true );?>"/>
                </div>
                <div class="col-md-6">
                    <label><?php _e( 'Event Time<i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="levent_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'levent_time', true );?>"/>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <label><?php _e( 'Event End Date <i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="levent_end_date" type="text" placeholder="<?php esc_html_e( 'Date Format : 2019-09-20', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'levent_end_date', true );?>"/>
                </div>
                <div class="col-md-6">
                    <label><?php _e( 'Event End Time<i class="fa fa-calendar-o"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="levent_end_time" type="text" placeholder="<?php esc_html_e( 'Time Format : 12:00:00', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'levent_end_time', true );?>"/>
                </div>
            </div>

        </div>
        <!-- act-widget end--> 
        <?php //endif; ?>
        
        
        
        <?php //if(citybook_addons_get_option('submit_hide_workinghours_opt') != 'yes'): ?>
        <!-- act-widget--> 
        <div class="act-widget fl-wrap">
            <div class="act-widget-header">
                <h4><?php _e( 'Working Hours', 'citybook-add-ons' );?></h4>
                
            </div>
            <?php 
            // $post_working_hours = get_post_meta( $post->ID, P_META_PREFIX.'working_hours', true );
            if($new_post) $post_working_hours = null;
            else $post_working_hours = citybook_addons_get_listing_working_hours_data($post->ID);
            citybook_addons_get_template_part('template-parts/working-hours', false, array('post_working_hours'=>$post_working_hours));
            ?>
        
        </div>
        <!-- act-widget end--> 
        <?php //endif; ?>

    </div>
    <?php
}

function citybook_addons_listing_meta_box_content_widgets_callback($post, $metabox){
    $new_post = $metabox['args']['new_post'];
    ?>
    <div class="custom-form">

        <div class="row">
            <div class="col-md-4">
                <!-- act-widget--> 
                <div class="act-widget fl-wrap">
                    <div class="act-widget-header">
                        <h4><?php _e( '1. Promo video', 'citybook-add-ons' );?></h4>
                        
                    </div>
                    <?php 
                    citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'is_single' => true, 'name'=>'promo_bg', 'datas'=> get_post_meta( $post->ID, P_META_PREFIX.'promo_bg', true ) ) );
                    ?>
                    <div class="add-list-media-wrap">
                        
                        <label><?php _e( 'Video URL :  <i class="fa fa-video-camera"></i>', 'citybook-add-ons' );?></label>
                        <input class="has-icon" name="promovideo_url" type="text" placeholder="https://www.youtube.com/" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'promovideo_url', true );?>"/>   
                    </div>
                </div>
                <!-- act-widget end-->
            </div>
            <div class="col-md-4">
                <!-- act-widget--> 
                <div class="act-widget fl-wrap">
                    <div class="act-widget-header">
                        <h4><?php _e( '2. Gallery Thumbnails', 'citybook-add-ons' );?></h4>
                        
                    </div>
                    <?php 
                    citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'gallery_imgs', 'datas'=> get_post_meta( $post->ID, P_META_PREFIX.'gallery_imgs', true ) ) );
                    ?>
                </div>
                <!-- act-widget end-->
            </div>
            <div class="col-md-4">
                <!-- act-widget--> 
                <div class="act-widget fl-wrap">
                    <div class="act-widget-header">
                        <h4><?php _e( '3. Slider', 'citybook-add-ons' );?></h4>
                        
                    </div>
                    <?php 
                    citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'slider_imgs', 'datas'=> get_post_meta( $post->ID, P_META_PREFIX.'slider_imgs', true ) ) );
                    ?>
                </div>
                <!-- act-widget end-->
            </div>
        </div>
        <!-- row end -->
        <?php if(citybook_addons_get_option('submit_hide_faqs_opt') != 'yes'): ?>  
        <?php 
        $lFAQs = get_post_meta( $post->ID, P_META_PREFIX.'lfaqs', true );
        ?>
        <div class="list-faqs-wrap">
            <label for=""><?php esc_html_e( 'Frequently Asked Questions', 'citybook-add-ons' ); ?></label>
            <div class="repeater-fields-wrap repeater-fields-faqs"  data-tmpl="tmpl-faq">
                <div class="repeater-fields">
                <?php 
                if(!empty($lFAQs)){
                    foreach ($lFAQs as $key => $lfaq) {
                        citybook_addons_get_template_part('templates-inner/faq',false, array('index'=>$key,'title'=>$lfaq['title'],'content'=>$lfaq['content']));
                    }
                }
                ?>
                </div>
                <button class="btn addfield" type="button"><?php  esc_html_e( 'Add FAQ','citybook-add-ons' );?></button>
            </div>
        </div>
        <!-- list-faqs-wrap end -->
        <?php endif; ?>

    </div>
    <?php
}

function citybook_addons_listing_meta_box_add_content_widgets_callback($post, $metabox){
    $new_post = $metabox['args']['new_post'];
    do_action( 'citybook-addons-submit-addfields', $post->ID, !$new_post );
}
function citybook_addons_listing_meta_box_add_widget_widgets_callback($post, $metabox){
    $new_post = $metabox['args']['new_post'];
    do_action( 'citybook-addons-submit-widget-addfields', $post->ID, !$new_post );
}
function citybook_addons_listing_meta_box_expire_callback($post, $metabox){
    ?>
    <div class="custom-form">
        <?php 
        $expire = get_post_meta( $post->ID, P_META_PREFIX.'expire_date', true );
        if($expire == 'NEVER') $expire = '';
        ?>
        <p><?php _e( 'Set expiration date. Leave <strong>empty</strong> for <strong>never</strong> expire.', 'citybook-add-ons' ); ?></p>
        <input type="text" id="listing_expire_date" name="expire_date" value="<?php echo $expire;?>">
    </div>
    <?php
}
function citybook_addons_listing_meta_box_header_media_callback($post, $metabox){
    $new_post = $metabox['args']['new_post'];

    $checked = get_post_meta( $post->ID, P_META_PREFIX.'headertype', true );
    if($new_post) $checked = 'bgimage';

    ?>
    <div class="custom-form">
        
        <div class="row">
            <!--col --> 
            <div class="col-md-8">
                <div class="row">
                    <!--col --> 
                    <div class="col-md-6">
                        <?php 
                        citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgimage', 'checked' => $checked, 'label' => __( 'Background Image', 'citybook-add-ons' ) ) );
                        ?>
                    </div>
                    <!--col-md-6 end--> 
                    <!--col --> 
                    <div class="col-md-6">
                        <?php 
                        citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'carousel', 'checked' => $checked, 'label' => __( 'Carousel', 'citybook-add-ons' ) ) );
                        ?>
                    </div>
                    <!--col-md-6 end--> 
                </div>

                <?php 
                citybook_addons_get_template_part( 'template-parts/images-select', false, array( 'name'=>'headerimgs', 'datas'=> get_post_meta( $post->ID, P_META_PREFIX.'headerimgs', true ) ) );
                ?>
                
            </div>
            <!--col-md-8 end --> 
            
            <!--col --> 
            <div class="col-md-4">
                <?php 
                citybook_addons_get_template_part( 'template-parts/radio-head', false, array( 'name'=>'headertype', 'value'=> 'bgvideo', 'checked' => $checked, 'label' => __( 'Video Background', 'citybook-add-ons' ) ) );
                ?>
                <div class="add-list-media-wrap">
                    <label><?php _e( 'Youtube Video ID  <i class="fa fa-youtube"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="headerbg_youtube" type="text" placeholder="<?php esc_html_e( 'Ex: Hg5iNVSp2z8', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'headerbg_youtube', true );?>"/> 

                    <label><?php _e( 'Or Vimeo Video ID <i class="fa fa-vimeo"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="headerbg_vimeo" type="text" placeholder="<?php esc_html_e( 'Ex: 97871257', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'headerbg_vimeo', true );?>"/> 

                    <label><?php _e( 'Or Vimeo URL (.MP4) <i class="fa fa-video-camera"></i>', 'citybook-add-ons' );?></label>
                    <input class="has-icon" name="headerbg_mp4" type="text" placeholder="<?php esc_html_e( 'Ex: domain.com/wp-content/uploads/2018/04/1.mp4', 'citybook-add-ons' ); ?>" value="<?php echo get_post_meta( $post->ID, P_META_PREFIX.'headerbg_mp4', true );?>"/> 


                    
                </div>
            </div>
            <!--col-md-4 end-->                                                   
        </div>
    </div>
    <?php
}


/**
 * Save post metadata when a post is saved.
 *
 * @param int $post_id The post ID.
 * @param post $post The post object.
 * @param bool $update Whether this is an existing post being updated or not.
 */
function citybook_addons_save_listing_meta( $post_id, $post, $update ) {

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // If this is just a revision, don't send the email.
    if ( wp_is_post_revision( $post_id ) )
        return;

    // Check if our nonce is set.
    if ( ! isset( $_POST['_listing_nonce'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $_POST['_listing_nonce'], 'citybook_addons-listing' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    // - Update the post's metadata.
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Begin: citybook_addons_save_listing_meta" . PHP_EOL, 3, CTH_LOG_FILE);

    // unhook this function so it doesn't loop infinitely
    remove_action( 'save_post_listing', 'citybook_addons_save_listing_meta', 10, 3  );
    
        citybook_addons_do_save_listing_meta($post_id, true, true);

    // re-hook this function
    add_action( 'save_post_listing', 'citybook_addons_save_listing_meta', 10, 3  );

}
add_action( 'save_post_listing', 'citybook_addons_save_listing_meta', 10, 3 );





function display_listing_feature_field($prefix = 'features',$fea_id = 0,$check = ''){

    if(!(int)$fea_id) return;

    $feature = get_term( $fea_id, 'listing_feature' );


    if ( $feature != null && ! is_wp_error( $feature ) ){
        echo '<div class="listing-feature-wrap">';
        // echo '<label for="'.$prefix.'['.$fea_id.']'.'"><input id="'.$prefix.'['.$fea_id.']'.'" type="checkbox" value="1" name="'.$prefix.'['.$fea_id.']'.'">'.$feature->name.'</label>';
        echo '<input id="'.$prefix.'_'.$fea_id.'" type="checkbox" value="'.$fea_id.'" name="'.$prefix.'[]"'.' '.checked( $fea_id, $check ,false ).'>';
        echo '<label for="'.$prefix.'_'.$fea_id.'">'.$feature->name.'</label>';
        echo '</div>';
    }



}

function display_listing_add_feature_field($prefix = 'add-features',$field = array()){

    $default = array(
        'type' => 'select',
        'name' => 'Field Name',
        'label' => 'Field Label',
        'value' => array(
            'name' => 'Value name',
            'value' => 'Value value',
        ),


    );

    $field = array_merge($default,$field);

    

    switch ($field['type']) {
        case 'select':
            echo '<div class="listing-add-feature-wrap add-feature-select">';

            echo '<label for="'.$prefix.'['.$field['name'].']'.'">'.$field['label'].'</label>';
            echo '<select id="'.$prefix.'['.$field['name'].']'.'" name="'.$prefix.'['.$field['name'].']'.'">';

            if(!empty($field['value'])){
                foreach ((array)$field['value'] as $val) {
                    echo '<option value="'.$val['value'].'">'.$val['name'].'</option>';
                }
            }

            echo '</select>';
            break;
        case 'checkbox':
            echo '<div class="listing-add-feature-wrap add-feature-checkbox">';
            echo '<input type="checkbox" id="'.$prefix.'['.$field['name'].']'.'" name="'.$prefix.'['.$field['name'].']'.'" value="'.$field['value'].'">';
            echo '<label for="'.$prefix.'['.$field['name'].']'.'">'.$field['label'].'</label>';
            

            break;
        case 'radio':
            echo '<div class="listing-add-feature-wrap add-feature-radio">';

            echo '<label>'.$field['label'].'</label>';
            if(!empty($field['value'])){
                echo '<div class="add-feature-radio-wrap">';
                    foreach ((array)$field['value'] as $key => $val) {
                        echo '<input type="radio" id="'.$prefix.'['.$field['name'].']'.$key.'" name="'.$prefix.'['.$field['name'].']'.'" value="'.$val['value'].'">';
                        echo '<label for="'.$prefix.'['.$field['name'].']'.$key.'">'.$val['name'].'</label>';

                        echo '<div class="radios-sep"></div>';
                        
                    }
                echo '</div>';
            }
            break;
        case 'switch':
            echo '<div class="listing-add-feature-wrap add-feature-switch">';

            
            echo '<label class="switch-field-label">'.$field['label'].'</label>';

            echo '<div class="onoffswitch">';
                echo '<input type="checkbox" id="'.$prefix.'['.$field['name'].']'.'" name="'.$prefix.'['.$field['name'].']'.'" value="'.$field['value'].'" class="onoffswitch-checkbox">';
                echo '<label class="onoffswitch-label" for="'.$prefix.'['.$field['name'].']'.'">';
                    echo '<span class="onoffswitch-inner"></span>';
                    echo '<span class="onoffswitch-switch"></span>';
                echo '</label>';
            echo '</div>';
            break;
        case 'textarea':
            echo '<div class="listing-add-feature-wrap add-feature-textarea">';

            echo '<label for="'.$prefix.'['.$field['name'].']'.'">'.$field['label'].'</label>';
            echo '<textarea id="'.$prefix.'['.$field['name'].']'.'" name="'.$prefix.'['.$field['name'].']'.'">'.$field['value'].'</textarea>';
            break;
        default:
            echo '<div class="listing-add-feature-wrap add-feature-text">';

            echo '<label for="'.$prefix.'['.$field['name'].']'.'">'.$field['label'].'</label>';
            echo '<input type="text" id="'.$prefix.'['.$field['name'].']'.'" name="'.$prefix.'['.$field['name'].']'.'" value="'.$field['value'].'"/>';
            break;
    }

    echo '</div>';

}

/* shortcode for listing */
require_once CITYBOOK_ADD_ONS_DIR . 'shortcodes/listing.php';




// add_action('wp_ajax_nopriv_citybook_addons_cat_features', 'citybook_addons_cat_features_callback');
// add_action('wp_ajax_citybook_addons_cat_features', 'citybook_addons_cat_features_callback');

// function citybook_addons_cat_features_callback() {
//     $json = array(
//         'success' => true,
//         'data' => array(
//             'POST'=>$_POST,
//         )
//     );
//     // wp_send_json($json );

//     $nonce = $_POST['_nonce'];
    
//     if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
//         $json['success'] = false;
//         $json['data'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;

//         // die ( '<p class="error">Security checked!, Cheatn huh?</p>' );

//         wp_send_json($json );
//     }

//     if(isset($_POST['cat'])) $listing_cat = $_POST['cat'];

//     if(!is_numeric($listing_cat)) {
//         $json['success'] = false;
//         $json['data'] = esc_html__( 'Invalid listing category', 'citybook-add-ons' ) ;
//         wp_send_json($json );
//     }

//     $term_meta = get_option("_cth_tax_listing_cat_$listing_cat");
    // $term_meta = get_term_meta( $listing_cat, '_cth_term_meta', true );

//     $cat_features = array();

//     if(isset($term_meta['features']) && !empty($term_meta['features'])){
//         $cat_features['features'] = array();
//         foreach ($term_meta['features'] as $fea_id) {
//             $feature = get_term( $fea_id, 'listing_feature' );

//             if ( $feature != null && ! is_wp_error( $feature ) ){

//                 $cat_features['features'][] = array(
//                     'type' => 'feature', // is features field
//                     'label' => $feature->name,
//                     'value' => $fea_id
//                 );
                
//             }

            
//         }

//     }

//     if(isset($term_meta['add-features']) && !empty($term_meta['add-features'])){
//         $cat_features['add-features'] = array();
//         foreach ($term_meta['add-features'] as $field) {
//             $cat_features['add-features'][] = $field;
//             // display_listing_add_feature_field('add-features',$field);
//         }
//     }
    
//     $json['data'] = $cat_features;

//     wp_send_json($json );

// }


add_action('wp_ajax_nopriv_citybook_addons_cats_features', 'citybook_addons_cats_features_callback');
add_action('wp_ajax_citybook_addons_cats_features', 'citybook_addons_cats_features_callback');

function citybook_addons_cats_features_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    // wp_send_json($json );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;

        // die ( '<p class="error">Security checked!, Cheatn huh?</p>' );

        wp_send_json($json );
    }

    if(isset($_POST['cats'])) $listing_cats = (array)$_POST['cats'];

    if(!is_array($listing_cats)) {
        $json['success'] = false;
        $json['data'] = esc_html__( 'Invalid listing category list - it must be array [50,51]', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $cats_features = array();
    $cats_add_features = array();

    $cat_desc_id = 0;
    $cats_subcats = array();

    foreach ($listing_cats as $listing_cat) {
        
        if(!is_numeric($listing_cat)) {
            $json['success'] = false;
            $json['data'] = esc_html__( 'Invalid listing category', 'citybook-add-ons' ) ;
            wp_send_json($json );
        }

        if(!$cat_desc_id) $cat_desc_id = $listing_cat;

        // $term_meta = get_option("_cth_tax_listing_cat_$listing_cat");

        $term_meta = get_term_meta( $listing_cat, '_cth_term_meta', true );

        // $cat_features = array();

        if(isset($term_meta['features']) && !empty($term_meta['features'])){
            // $cat_features['features'] = array();
            foreach ($term_meta['features'] as $fea_id) {
                $feature = get_term( $fea_id, 'listing_feature' );

                if ( $feature != null && ! is_wp_error( $feature ) ){

                    // $cat_features['features']
                    $cats_features[] = array(
                        'type' => 'feature', // is features field
                        'label' => $feature->name,
                        'value' => $fea_id,
                        'lvalue' => ''
                    );
                    
                }

                
            }

        }

        if(isset($term_meta['add-features']) && !empty($term_meta['add-features'])){
            // $cat_features['add-features'] = array();
            foreach ($term_meta['add-features'] as $field) {
                // $cat_features['add-features'][] = $field;
                $field['lvalue'] = '';
                $cats_add_features[] = $field;
                // display_listing_add_feature_field('add-features',$field);
            }
        }
        if(citybook_addons_get_option('search_load_subcat') == 'yes'){
            $sub_cats = get_terms( array(
                'taxonomy'      => 'listing_cat',
                // 'hide_empty'    => false,
                'parent'        => $listing_cat,
            ) );

            if ( ! empty( $sub_cats ) && ! is_wp_error( $sub_cats ) ){
                foreach ( $sub_cats as $sub_cat ) {
                    $cats_subcats[] = array(
                        'id'            => $sub_cat->term_id,
                        'slug'          => $sub_cat->slug,
                        'name'          => $sub_cat->name,
                    );
                }
            }
        }
        
    }
    // end foreach 

    $json['data'] = array(
        'features'      => array_unique($cats_features, SORT_REGULAR),
        'add-features'  => array_unique($cats_add_features,SORT_REGULAR),
        'cat_desc'      => term_description($cat_desc_id, 'listing_cat'),
        'subcats'       => $cats_subcats,
    );
    wp_send_json($json );

}


add_action('wp_ajax_nopriv_citybook_addons_submit_listing', 'citybook_addons_submit_listing_callback');
add_action('wp_ajax_citybook_addons_submit_listing', 'citybook_addons_submit_listing_callback');

function citybook_addons_submit_listing_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            // '_POST'=>$_POST,
            // '_FILE'=>$_FILES
        )
    );

    // wp_send_json($json );

    // verify google reCAPTCHA
    if( citybook_addons_verify_recaptcha() === false ){
        $json['success'] = false;
        $json['data']['submit_msg'] = esc_html__( 'reCAPTCHA failed, please try again.', 'citybook-add-ons' ) ;
    }

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['submit_msg'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;

        // die ( '<p class="error">Security checked!, Cheatn huh?</p>' );

        wp_send_json($json );
    }


    
    // register new user and log he in
    if(isset($_POST['user_email'])){

        $user_name = isset($_POST['user_login'])? $_POST['user_login'] : substr($_POST['user_email'], 0, strpos($_POST['user_email'], "@") ); // substr(string,start,length)

        $new_user_data = array(
            'user_login' => $user_name,
            // 'user_pass'  => citybook_addons_generate_password(), // // When creating an user, `user_pass` is expected.
            'user_email' => $_POST['user_email'],
            'role'       => 'listing_author' //'subscriber'
        );

        
        


        $user_id = wp_insert_user( $new_user_data );

        //On success
        if ( ! is_wp_error( $user_id ) ) {
            // echo "User created : ". $user_id;

            $json['data']['user_id'] = $user_id;
            if(citybook_addons_get_option('new_user_email') != 'none') wp_new_user_notification( $user_id, null, citybook_addons_get_option('new_user_email') );
            // auto login user
            if( citybook_addons_get_option('register_auto_login') == 'yes' || citybook_addons_get_option('users_can_submit_listing') == 'yes' ) citybook_addons_auto_login_new_user( $user_id );

            // // Set the global user object
            // $current_user = get_user_by( 'id', $user_id );

            // // set the WP login cookie
            // $secure_cookie = is_ssl() ? true : false;

            // wp_set_auth_cookie( $user_id, true, $secure_cookie ); // This function does not return a value.

            do_action( 'citybook_addons_register_user', $user_id, true /*is when submit lisitng*/ );

        }else{
            $json['success'] = false;
            $json['data']['submit_msg'] = $user_id->get_error_message() ;
            $json['data']['new_user_data'] = $new_user_data ;
            // $json['data']['at_pos'] = strpos("@", $_POST['user_email']);
            // $json['data']['substr'] = substr($_POST['user_email'], 0, strpos($_POST['user_email'], "@") );

            wp_send_json( $json );

        }


    }
    // check if logged in user
    if(!is_user_logged_in()){
        $json['success'] = false;
        $json['data']['submit_msg'] = __( 'You must login on submiting a listing.', 'citybook-add-ons' );
        wp_send_json( $json );

    }

        

    // begin insert listing
    $listing_data = array();
    // if(isset($res_post_datas['first_name'])|| isset($res_post_datas['last_name'])){
    //     $listing_data['post_title'] = $res_post_datas['first_name'] .' '.$res_post_datas['last_name'];
    // }else{
    //     $listing_data['post_title'] = $res_post_datas['email'];
    // }

    $edit_listing_id = $_POST['listing_id'];
    $is_editing_listing = false;
    if(is_numeric($edit_listing_id) && (int)$edit_listing_id > 0){
        $old_listing_post = get_post( $edit_listing_id );
        if($old_listing_post){
            $is_editing_listing = true;
            $json['data']['is_editing_listing'] = true;
            if( ! current_user_can( 'edit_post' , $edit_listing_id ) ){
                $json['success'] = false;
                $json['data']['submit_msg'] = __( "You don't have permission to edit this listing.", 'citybook-add-ons' ) ;
                $json['data']['url'] = esc_url( home_url('/') );
                wp_send_json( $json );
            }

            // don't update post author
            $listing_data['post_author'] = $old_listing_post->post_author;
            $listing_data['post_status'] = $old_listing_post->post_status;
            $listing_data['post_date'] = $old_listing_post->post_date;

            
        }
            
    }



    $listing_data['ID'] = $edit_listing_id; // set ID to update


    $listing_data['post_title'] = $_POST['title'];

    $listing_data['tax_input'] = array();

    
    if(isset($_POST['listing_cats'])&& $_POST['listing_cats']) $listing_data['tax_input']['listing_cat'] = $_POST['listing_cats'];
    if(isset($_POST['features'])&& $_POST['features']) $listing_data['tax_input']['listing_feature'] = $_POST['features'];
    // if(isset($_POST['locations'])) $listing_data['tax_input']['listing_location'] = $_POST['locations'];
    
    if(isset($_POST['listing_tags'])&& $_POST['listing_tags']) $listing_data['tags_input'] = explode(",", $_POST['listing_tags']);
    // if(isset($_POST['locations']) && $_POST['locations']){

    //     // wp_set_post_terms( $post_id, $terms, $taxonomy, $append );

    //     $ploc = explode(",", $_POST['locations']);

    //     // $json['data']['ploc'] = $ploc;

    //     // // wp_send_json( $json );

    //     if(!empty($ploc)) $listing_data['tax_input']['listing_location'] = array($ploc[0]); // get first location from google.

    // } 
    

    // $listing_data['post_author'] = 2;

    $listing_data['post_content'] = $_POST['listing_content'];
    if(isset($_POST['post_excerpt'])) $listing_data['post_excerpt'] = $_POST['post_excerpt'];
    //$listing_data['post_author'] = '0';// default 0 for no author assigned
    // set status for listing submission only
    if($is_editing_listing == false){
        $listing_data['post_status'] = 'pending'; // publish, future, draft, pending, private, trash, auto-draft, inherit
    }

    
    $listing_data['post_type'] = 'listing';

    $listing_data['comment_status'] = 'open'; // closed

    $json['data']['post_data'] = $listing_data;
    // wp_send_json( $json );

    do_action( 'citybook_addons_insert_listing_before', $listing_data, $is_editing_listing );

    $listing_id = wp_insert_post($listing_data ,true );
                    

    if (!is_wp_error($listing_id)) {
        $json['data']['listing_id'] = $listing_id;

        if(isset($_POST['locations']) && $_POST['locations']){
            $ploc = explode(",", $_POST['locations']);
            if(!empty($ploc)){
                wp_set_object_terms($listing_id, $ploc, 'listing_location');
            }
        } 

        citybook_addons_do_save_listing_meta($listing_id, $is_editing_listing, false);
        // process image for listing submission only
        if($is_editing_listing == false){
            // $json['data']['featured'] = $_FILES['featured']['error'];
            // set featured image
            if( isset($_FILES['featured']) && $_FILES['featured']['error'] === UPLOAD_ERR_OK){
                $movefile = citybook_addons_handle_image_upload($_FILES['featured']);

                if(is_array($movefile)){

                    // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                    // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                    // Prepare an array of post data for the attachment.
                    $attachment = array(
                        // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                        'post_mime_type' => $movefile['type'],
                        'post_title'     => sanitize_file_name(basename($movefile['file'])),
                        'post_content'   => '',
                        'post_status'    => 'inherit'
                    );

                    // Insert the attachment.
                    $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $listing_id );

                    if($attach_id != 0){
                        // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                        require_once( ABSPATH . 'wp-admin/includes/image.php' );

                        // Generate the metadata for the attachment, and update the database record.
                        $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                        // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                        // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                        wp_update_attachment_metadata( $attach_id, $attach_data );
                        // Post meta ID on success, false on failure.
                        $json['data']['thumbnail_meta_id'] = set_post_thumbnail( $listing_id, $attach_id );
                    }else{
                        $json['data'][] = __( "wp_insert_attachment error on featured image", 'citybook-add-ons' );
                    }

                }else{

                    $json['data']['upload_error'] = $movefile ;
                }

            }
            // end if featured image

            // upload header images - only for submit item - use meta data for edit item (using media manager)
            if(isset($_FILES['headerimgs'])){
                $headerimgsfiles = array();
                $headerfiles = $_FILES["headerimgs"];  
                foreach ($headerfiles['name'] as $key => $value) {            
                    if ($headerfiles['name'][$key]) {
                        $file = array( 
                            'name' => $headerfiles['name'][$key],
                            'type' => $headerfiles['type'][$key], 
                            'tmp_name' => $headerfiles['tmp_name'][$key], 
                            'error' => $headerfiles['error'][$key],
                            'size' => $headerfiles['size'][$key]
                        ); 
                        $headerimgsfiles[] = $file;
                        
                    }
                } 

                $headerimgsMeta = array();

                foreach ($headerimgsfiles as $key => $file) {
                        
                    $movefile = citybook_addons_handle_image_upload($file);

                    if(is_array($movefile)){

                        // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                        // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                        // Prepare an array of post data for the attachment.
                        $attachment = array(
                            // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                            'post_mime_type' => $movefile['type'],
                            'post_title'     => sanitize_file_name(basename($movefile['file'])),
                            'post_content'   => '',
                            'post_status'    => 'inherit'
                        );

                        // // Insert the attachment.
                        $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $listing_id );

                        if($attach_id != 0){
                            // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                            require_once( ABSPATH . 'wp-admin/includes/image.php' );

                            // Generate the metadata for the attachment, and update the database record.
                            $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                            // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                            // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                            wp_update_attachment_metadata( $attach_id, $attach_data );
                            // Post meta ID on success, false on failure.
                            // $json['data']['meta_id'] = set_post_thumbnail( $listing_id, $attach_id );

                            // $headerimgsMeta[] = array( $attach_id , wp_get_attachment_url( $attach_id ) );
                            // $headerimgsMeta[$attach_id] = wp_get_attachment_url( $attach_id ) ;
                            $headerimgsMeta[] = $attach_id ;
                        }else{
                            $json['data']['upload_header'.$key] = __( "wp_insert_attachment error on header image", 'citybook-add-ons' );
                        }

                    }else{

                        $json['data']['upload_error_header'.$key] = $movefile ;
                    }

                }

                if ( !empty($headerimgsMeta) && !update_post_meta( $listing_id, P_META_PREFIX.'headerimgs',  $headerimgsMeta ) ) {
                    $json['data'][] = __('Insert listing headerimgs meta failure','citybook-add-ons');
                    // wp_send_json($json );
                }

            }
            // end if headerimgs

            // for promo_bg
            if( isset($_FILES['promo_bg']) && $_FILES['promo_bg']['error'] === UPLOAD_ERR_OK){
                $movefile = citybook_addons_handle_image_upload($_FILES['promo_bg']);

                if(is_array($movefile)){
                    // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                    // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                    // Prepare an array of post data for the attachment.
                    $attachment = array(
                        // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                        'post_mime_type' => $movefile['type'],
                        'post_title'     => sanitize_file_name(basename($movefile['file'])),
                        'post_content'   => '',
                        'post_status'    => 'inherit'
                    );

                    // Insert the attachment.
                    $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $listing_id );

                    if($attach_id != 0){
                        // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                        require_once( ABSPATH . 'wp-admin/includes/image.php' );

                        // Generate the metadata for the attachment, and update the database record.
                        $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                        // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                        // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                        wp_update_attachment_metadata( $attach_id, $attach_data );

                        if ( !empty($headerimgsMeta) && !update_post_meta( $listing_id, P_META_PREFIX.'promo_bg',  array($attach_id) ) ) {
                            $json['data'][] = __('Insert listing promo_bg meta failure','citybook-add-ons');
                            // wp_send_json($json );
                        }

                    }else{
                        $json['data']['promo_bg_att_error'] = __( "wp_insert_attachment error on promo bg image", 'citybook-add-ons' );
                    }

                }else{

                    $json['data']['promo_bg_upload_error'] = $movefile ;
                }

            }
            // end for promo_bg

            // for gallery imgs
            if(isset($_FILES['gallery_imgs'])){
                $uploadedImgsFiles = array();
                $uploadedFile = $_FILES["gallery_imgs"];  
                foreach ($uploadedFile['name'] as $key => $value) {            
                    if ($uploadedFile['name'][$key]) {
                        $file = array( 
                            'name' => $uploadedFile['name'][$key],
                            'type' => $uploadedFile['type'][$key], 
                            'tmp_name' => $uploadedFile['tmp_name'][$key], 
                            'error' => $uploadedFile['error'][$key],
                            'size' => $uploadedFile['size'][$key]
                        ); 
                        $uploadedImgsFiles[] = $file;
                        
                    }
                } 

                $uploadedImgsMeta = array();

                foreach ($uploadedImgsFiles as $key => $file) {
                        
                    $movefile = citybook_addons_handle_image_upload($file);

                    if(is_array($movefile)){

                        // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                        // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                        // Prepare an array of post data for the attachment.
                        $attachment = array(
                            // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                            'post_mime_type' => $movefile['type'],
                            'post_title'     => sanitize_file_name(basename($movefile['file'])),
                            'post_content'   => '',
                            'post_status'    => 'inherit'
                        );

                        // // Insert the attachment.
                        $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $listing_id );

                        if($attach_id != 0){
                            // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                            require_once( ABSPATH . 'wp-admin/includes/image.php' );

                            // Generate the metadata for the attachment, and update the database record.
                            $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                            // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                            // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                            wp_update_attachment_metadata( $attach_id, $attach_data );
                            // Post meta ID on success, false on failure.
                            // $json['data']['meta_id'] = set_post_thumbnail( $listing_id, $attach_id );

                            // $uploadedImgsMeta[] = array( $attach_id , wp_get_attachment_url( $attach_id ) );
                            // $uploadedImgsMeta[$attach_id] = wp_get_attachment_url( $attach_id ) ;
                            $uploadedImgsMeta[] = $attach_id ;
                        }else{
                            $json['data']['upload_gallery'.$key] = __( "wp_insert_attachment error on gallery image", 'citybook-add-ons' );
                        }

                    }else{

                        $json['data']['upload_error_gallery'.$key] = $movefile ;
                    }

                }

                if ( !empty($uploadedImgsMeta) && !update_post_meta( $listing_id, P_META_PREFIX.'gallery_imgs',  $uploadedImgsMeta ) ) {
                    $json['data'][] = __('Insert listing gallery_imgs meta failure','citybook-add-ons');
                    // wp_send_json($json );
                }

            }
            // end for gallery imgs

            // for slider imgs
            if(isset($_FILES['slider_imgs'])){
                $uploadedImgsFiles = array();
                $uploadedFile = $_FILES["slider_imgs"];  
                foreach ($uploadedFile['name'] as $key => $value) {            
                    if ($uploadedFile['name'][$key]) {
                        $file = array( 
                            'name' => $uploadedFile['name'][$key],
                            'type' => $uploadedFile['type'][$key], 
                            'tmp_name' => $uploadedFile['tmp_name'][$key], 
                            'error' => $uploadedFile['error'][$key],
                            'size' => $uploadedFile['size'][$key]
                        ); 
                        $uploadedImgsFiles[] = $file;
                        
                    }
                } 

                $uploadedImgsMeta = array();

                foreach ($uploadedImgsFiles as $key => $file) {
                        
                    $movefile = citybook_addons_handle_image_upload($file);

                    if(is_array($movefile)){

                        // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                        // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                        // Prepare an array of post data for the attachment.
                        $attachment = array(
                            // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                            'post_mime_type' => $movefile['type'],
                            'post_title'     => sanitize_file_name(basename($movefile['file'])),
                            'post_content'   => '',
                            'post_status'    => 'inherit'
                        );

                        // // Insert the attachment.
                        $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $listing_id );

                        if($attach_id != 0){
                            // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                            require_once( ABSPATH . 'wp-admin/includes/image.php' );

                            // Generate the metadata for the attachment, and update the database record.
                            $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                            // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                            // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                            wp_update_attachment_metadata( $attach_id, $attach_data );
                            // Post meta ID on success, false on failure.
                            // $json['data']['meta_id'] = set_post_thumbnail( $listing_id, $attach_id );

                            // $uploadedImgsMeta[] = array( $attach_id , wp_get_attachment_url( $attach_id ) );
                            // $uploadedImgsMeta[$attach_id] = wp_get_attachment_url( $attach_id ) ;
                            $uploadedImgsMeta[] = $attach_id;
                        }else{
                            $json['data']['upload_slider'.$key] = __( "wp_insert_attachment error on slider image", 'citybook-add-ons' );
                        }

                    }else{

                        $json['data']['upload_error_slider'.$key] = $movefile ;
                    }

                }

                if ( !empty($uploadedImgsMeta) && !update_post_meta( $listing_id, P_META_PREFIX.'slider_imgs',  $uploadedImgsMeta ) ) {
                    $json['data'][] = __('Insert listing slider_imgs meta failure','citybook-add-ons');
                    // wp_send_json($json );
                }

            }
            // end for slider imgs
            

        }
        // end if($is_editing_listing == false)
            
        // update thumbnail image
        if($is_editing_listing && $_POST['featured']){
            $featured = $_POST['featured'];
            if(is_array($featured) && count($featured)){
                // reset($featured); // reset array to first element
                $json['data']['thumbnail_meta_id'] = set_post_thumbnail( $listing_id, reset($featured) ); // key($featured) - get first array key -> image id
            }else{
                $json['data']['edit_featured'] = __( "Featured image is empty.", 'citybook-add-ons' );
            }

        }
        // end update featured
        if(citybook_addons_get_option('submit_redirect') == 'single')
            $listing_redirect_url = get_post_permalink($listing_id);
        else
            $listing_redirect_url = get_permalink( citybook_addons_get_option('submit_redirect') );
        
        if(!is_wp_error($listing_redirect_url)) $json['data']['url'] = $listing_redirect_url ;


        do_action( 'citybook_addons_insert_listing_after', $listing_id, $is_editing_listing );
    }else{
        
        $json['data'] = array(
            '_POST'=>$_POST,
            'submit_msg' => $listing_id->get_error_message()
        );


    }

    wp_send_json($json );

    // https://codex.wordpress.org/Function_Reference/wp_handle_upload
    // https://wordpress.org/plugins/radio-buttons-for-taxonomies/

    // https://stackoverflow.com/questions/19949876/how-to-auto-login-after-registration-in-wordpress-with-core-php
    // https://stackoverflow.com/questions/19949876/how-to-auto-login-after-registration-in-wordpress-with-core-php
    // https://codex.wordpress.org/Roles_and_Capabilities
    // https://codex.wordpress.org/Function_Reference/register_taxonomy
    // https://developer.wordpress.org/reference/functions/wp_insert_post/
}

function citybook_addons_do_save_listing_meta($listing_id = 0, $edit = false, $backend = false){
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Begin citybook_addons_do_save_listing_meta ". PHP_EOL, 3, CTH_LOG_FILE);

    $meta_fields = array(
        // 'location' => 'text',
        // prices
        'price_range' => 'text',
        'price_from' => 'text',
        'price_to' => 'text',

        // 'contact_infos' => 'array',
        // from-version-1.0.3
        'contact_infos_address' => 'text',
        'contact_infos_latitude' => 'text',
        'contact_infos_longitude' => 'text',
        'contact_infos_phone' => 'text',
        'contact_infos_email' => 'text',
        'contact_infos_website' => 'text',

        // 'features' => 'array',
        'add-features' => 'array',

        'headertype' => 'text',
        // featured - for featured image
        // headerimgs - for header images

        // 'timezone' => 'text',
        // 'working_hours' => 'array',
        'socials' => 'array',

        // header video
        'headerbg_youtube' => 'text',
        'headerbg_vimeo' => 'text',
        'headerbg_mp4' => 'text',

        // contents
        'content_head_info' => 'text', // show listing infos (view,rating,cats..) on the content top below breadcrumbs
        'content_promovideo' => 'text',
        'promovideo_url' => 'text',
        'content_galleryimgs' => 'text',
        'content_sliderimgs' => 'text',

        // widgets
        'widget_booking' => 'text',
        'widget_counter' => 'text',
        'widget_wkhour' => 'text',
        'widget_addfeas' => 'text',
        'widget_contacts' => 'text',
        'widget_author' => 'text',
        'widget_moreauthor' => 'text',

        'widget_price_range' => 'text',




        // event
        'levent_date'       =>'text',
        'levent_time'       =>'text',
        'levent_end_date'   =>'text',
        'levent_end_time'   =>'text',


        // faqs
        'faqs'              => 'array',
        'lfaqs'             =>'array',
        // listing rating
        'rating_average'    => 'text',
        'rating_count'      => 'text',
    );
    if($edit){
        $meta_fields['headerimgs'] = 'array';
        $meta_fields['promo_bg'] = 'array';
        $meta_fields['gallery_imgs'] = 'array';
        $meta_fields['slider_imgs'] = 'array';
    }
    $listing_metas = array();
    foreach($meta_fields as $field => $ftype){
        if(isset($_POST[$field])) $listing_metas[$field] = $_POST[$field] ;
        else{
            if($ftype == 'array'){
                $listing_metas[$field] = array();
            }else{
                $listing_metas[$field] = '';
            }
        } 
    }
    foreach ($listing_metas as $key => $value) {
        $old_val = get_post_meta( $listing_id, P_META_PREFIX.$key, true );
        if($old_val != $value) update_post_meta( $listing_id, P_META_PREFIX.$key, $value );
    }
    // update working hours new
    $working_hours_data = array();
    if(isset($_POST['working_hours'])) $working_hours_data = $_POST['working_hours'];
    citybook_addons_do_update_listing_working_hours( $listing_id, $working_hours_data );
    // adding price for woo support in future
    // https://github.com/woocommerce/woocommerce/issues/14212
    // http://reigelgallarde.me/programming/how-to-add-custom-post-type-to-woocommerce/
    $old_price = get_post_meta( $listing_id, '_price', true );
    if($old_price != $listing_metas['price_from']) update_post_meta( $listing_id, '_price',  $listing_metas['price_from'] );
    
    // disable update subscription meta from back-end
    if($backend != true){
        // current user sub
        $user_current_subscription = citybook_addons_get_current_subscription();
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Current sub: " .json_encode($user_current_subscription). PHP_EOL, 3, CTH_LOG_FILE);
        if($user_current_subscription){
            // one listing is for on subscription
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Listing order id: " .get_post_meta( $listing_id, P_META_PREFIX.'order_id', true ). PHP_EOL, 3, CTH_LOG_FILE);
            if(get_post_meta( $listing_id, P_META_PREFIX.'order_id', true ) == ''){
                $order_listings = get_post_meta( $user_current_subscription['id'], P_META_PREFIX.'listings', true );
                if($user_current_subscription['plan_llimit'] == 'unlimited' || count($order_listings) < (int)$user_current_subscription['plan_llimit'] ){
                    // add this listing to current sub
                    if(empty($order_listings) || !in_array($listing_id, $order_listings)){
                        $order_listings[] = $listing_id;
                        update_post_meta( $user_current_subscription['id'], P_META_PREFIX.'listings', $order_listings );
                        // and add sub to current listing
                        update_post_meta( $listing_id, P_META_PREFIX.'order_id', $user_current_subscription['id'] );
                        update_post_meta( $listing_id, P_META_PREFIX.'plan_id', $user_current_subscription['plan_id'] );
                        // change expire_date base on order
                        update_post_meta( $listing_id, P_META_PREFIX.'expire_date', $user_current_subscription['end_date'] );
                        if($user_current_subscription['end_date'] !== 'NEVER' ){
                            // convert local time to GMT - Simply subtracts the value of the 'gmt_offset' option.
                            $ts = get_gmt_from_date($user_current_subscription['end_date'],'U');
                            // $ts = get_date_from_gmt($user_current_subscription['end_date'],'U');
                            citybook_addons_scheduleExpireEvent($listing_id,$ts);
                        }
                            

                        // update listing status to publish if enabled
                        if(citybook_addons_get_option('auto_publish_paid_listings','no') == 'yes'){
                            $lis_args = array(
                                'ID'                => $listing_id,
                                'post_status'       => 'publish',
                            );
                            $lis_id = wp_update_post( $lis_args, true );                          
                            if (CTH_DEBUG && is_wp_error($lis_id)) {
                                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Publish listing (ID: $lis_id) after active subscription error: " . $lis_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
                            }else{
                                $lis_post = get_post($lis_id);
                                citybook_addons_user_add_notification($lis_post->post_author, array(
                                    'type' => 'listing_publish',
                                    'message' => sprintf(__( 'Your listing <a href="%s">%s</a> has been approved!', 'citybook-add-ons' ), get_the_permalink($lis_id), $lis_post->post_title )
                                ));
                            }
                        }
                        // end publish listing with an active subscription
                    }
                }
                // end check if listing is not assign to any order
            }elseif($edit && get_post_status($listing_id) == 'pending'){ // expired listing is set to pending status
                if($user_current_subscription['plan_llimit'] == 'unlimited' || count($order_listings) < (int)$user_current_subscription['plan_llimit'] ){
                    $order_listings = get_post_meta( $user_current_subscription['id'], P_META_PREFIX.'listings', true );
                    if(empty($order_listings) || !in_array($listing_id, $order_listings)){
                        $order_listings[] = $listing_id;
                        update_post_meta( $user_current_subscription['id'], P_META_PREFIX.'listings', $order_listings );

                        // and add sub to current listing
                        update_post_meta( $listing_id, P_META_PREFIX.'order_id', $user_current_subscription['id'] );
                        update_post_meta( $listing_id, P_META_PREFIX.'plan_id', $user_current_subscription['plan_id'] );
                        // change expire_date base on order
                        update_post_meta( $listing_id, P_META_PREFIX.'expire_date', $user_current_subscription['end_date'] );
                        if($user_current_subscription['end_date'] !== 'NEVER' ){
                            // convert local time to GMT - Simply subtracts the value of the 'gmt_offset' option.
                            $ts = get_gmt_from_date($user_current_subscription['end_date'],'U');
                            // $ts = get_date_from_gmt($user_current_subscription['end_date'],'U');
                            citybook_addons_scheduleExpireEvent($listing_id,$ts);
                        }
                        // update listing status to publish if enabled
                        if(citybook_addons_get_option('auto_publish_paid_listings','no') == 'yes'){
                            $lis_args = array(
                                'ID'                => $listing_id,
                                'post_status'       => 'publish',
                            );
                            $lis_id = wp_update_post( $lis_args, true );                          
                            if (CTH_DEBUG && is_wp_error($lis_id)) {
                                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Publish listing (ID: $lis_id) after active subscription error: " . $lis_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
                            }else{
                                $lis_post = get_post($lis_id);
                                citybook_addons_user_add_notification($lis_post->post_author, array(
                                    'type' => 'listing_publish',
                                    'message' => sprintf(__( 'Your listing <a href="%s">%s</a> has been approved!', 'citybook-add-ons' ), get_the_permalink($lis_id), $lis_post->post_title )
                                ));
                            }
                        }
                        // end publish listing with an active subscription

                    }
                }
            }
            

                
        }
    }
    // end back-end disable

    // set backend expiration date
    if($backend && isset($_POST['expire_date'])){
        if($_POST['expire_date'] == ''){
            update_post_meta( $listing_id, P_META_PREFIX.'expire_date',  'NEVER' );
            citybook_addons_unscheduleExpireEvent($listing_id);
        }else{
            update_post_meta( $listing_id, P_META_PREFIX.'expire_date',  $_POST['expire_date'] );
            // convert local time to GMT - Simply subtracts the value of the 'gmt_offset' option.
            $ts = get_gmt_from_date($_POST['expire_date'],'U');
            // $ts = get_date_from_gmt($_POST['expire_date'],'U');
            citybook_addons_scheduleExpireEvent($listing_id,$ts);
        }
    }

    // if there is no current sub or any user
    // add expire date for submit listing only and not set yet
    if(get_post_meta( $listing_id, P_META_PREFIX.'expire_date', true ) == ''){
        $expire_date = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
        update_post_meta( $listing_id, P_META_PREFIX.'expire_date', $expire_date  );

        $ts = get_gmt_from_date($expire_date,'U');
        // $ts = get_date_from_gmt($expire_date,'U');
        citybook_addons_scheduleExpireEvent($listing_id,$ts);
    }
    // set listing expire by event end date
    // https://support.cththemes.com/?topic=auto-publish-listing-issue/#post-28478
    // $event_end_date_string = get_post_meta( $listing_id, P_META_PREFIX.'levent_end_date', true );
    // $expire_date_string = get_post_meta( $listing_id, P_META_PREFIX.'expire_date', true );
    // if($event_end_date_string != '' && $expire_date_string != '' ){
    //     $event_end_date = strtotime($event_end_date_string);
    //     $expire_date_tmp = strtotime($expire_date_string);
    //     if($expire_date_tmp > $event_end_date){
    //         citybook_addons_unscheduleExpireEvent($listing_id);
    //         citybook_addons_scheduleExpireEvent($listing_id,$event_end_date);
    //     }
    // }

    // for saving custom additional fields
    do_action('citybook-addons-save-addfields', $listing_id);

}



// update profile
add_action('wp_ajax_nopriv_citybook_addons_profile', 'citybook_addons_profile_callback');
add_action('wp_ajax_citybook_addons_profile', 'citybook_addons_profile_callback');

function citybook_addons_profile_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            // 'POST'=>$_POST,
            // 'FILES'=>$_FILES,
        )
    );
    // wp_send_json($json );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $user_data = array(
        'ID'                => get_current_user_id(),
        'first_name'        => $_POST['first_name'],
        'last_name'         => $_POST['last_name'],
        'display_name'      => $_POST['display_name'],
        'user_url'          => $_POST['user_url'],
        'description'       => $_POST['description'],
    );

    $user_id = wp_update_user( $user_data );

    if ( is_wp_error( $user_id ) ) {
        // There was an error, probably that user doesn't exist.
        $json['success'] = false;
        $json['data']['error'] = $user_id->get_error_message() ;
    } else {
        $json['data']['user_id'] = $user_id;

        $meta_fields = array(
            'phone' => 'text',
            'address' => 'text',
            'socials' => 'array',
            // for custom avatar upload
            'custom_avatar' => 'array',
        );
        $user_metas = array();
        foreach($meta_fields as $field => $ftype){
            if(isset($_POST[$field])){ 
                $user_metas[$field] = $_POST[$field] ;
            }else{
                if($ftype == 'array'){
                    $user_metas[$field] = array();
                }else{
                    $user_metas[$field] = '';
                }
            } 
        }

        // check for custom avatar upload
        if( isset($_FILES['custom_avatar_upload']) && $_FILES['custom_avatar_upload']['error'] === UPLOAD_ERR_OK){
            $movefile = citybook_addons_handle_image_upload($_FILES['custom_avatar_upload']);

            if(is_array($movefile)){
                // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                // Prepare an array of post data for the attachment.
                $attachment = array(
                    // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                    'post_mime_type' => $movefile['type'],
                    'post_title'     => sanitize_file_name(basename($movefile['file'])),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                );

                // Insert the attachment.
                $attach_id = wp_insert_attachment( $attachment, $movefile['file'] );

                if($attach_id != 0){
                    // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                    require_once( ABSPATH . 'wp-admin/includes/image.php' );

                    // Generate the metadata for the attachment, and update the database record.
                    $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                    // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                    // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                    wp_update_attachment_metadata( $attach_id, $attach_data );

                    // $user_metas['custom_avatar'] = array( $attach_id => wp_get_attachment_url( $attach_id ) );
                    $user_metas['custom_avatar'] = array( $attach_id );
                }else{
                    $json['data']['avatar_upload_error'] = __( "wp_insert_attachment error on custom avatar upload image", 'citybook-add-ons' );
                }
            }else{
                $json['data']['avatar_upload_error'] = $movefile ;
            }
        }
        // end custom avatar upload
        // unset custom avatar if empty
        if( empty($user_metas['custom_avatar']) ) unset($user_metas['custom_avatar']);
        
        foreach ($user_metas as $key => $value) {
            if ( !update_user_meta( $user_id, P_META_PREFIX.$key,  $value  ) ) {
                $json['data'][] = sprintf(__('Insert user %s meta failure or existing meta value','citybook-add-ons'),$key);
            }
        }
        // end update meta field

        // send notification to current user
        citybook_addons_user_add_notification($user_id, array(
            'type' => 'edit_profile',
            'message' => __( 'Your profile has been changed.', 'citybook-add-ons' )
        ));
        
        $dashboard_page_id = citybook_addons_get_option('dashboard_page');
        $json['data']['url'] = get_permalink( $dashboard_page_id ) ;

    }   

    
    wp_send_json($json );
}

// change password
add_action('wp_ajax_nopriv_citybook_addons_change_pass', 'citybook_addons_change_pass_callback');
add_action('wp_ajax_citybook_addons_change_pass', 'citybook_addons_change_pass_callback');

function citybook_addons_change_pass_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $current_user = wp_get_current_user();
    $json['data']['current_user'] = $current_user;
    if ( $current_user->exists() ) {
        $old_pass = $_POST['old_pass'];
        if(wp_check_password( $old_pass, $current_user->data->user_pass, $current_user->ID)){
            $json['data'][] = esc_html__( 'The current password is correct.', 'citybook-add-ons' ) ;
            $new_pass = $_POST['new_pass'];
            $confirm_pass = $_POST['confirm_pass'];
            if($new_pass === $confirm_pass){
                // wp_set_password( $new_pass, $current_user->ID );
                $user_id_new = wp_update_user( array( 'ID' => $current_user->ID, 'user_pass' => $new_pass ) );
                if ( is_wp_error( $user_id_new ) ) {
                    $json['success'] = false;
                    $json['data']['error'] = $user_id_new->get_error_message() ;
                } else {
                    $json['data']['success'] = esc_html__( 'Updated', 'citybook-add-ons' ) ;
                    $dashboard_page_id = citybook_addons_get_option('dashboard_page');
                    $json['data']['url'] = get_permalink( $dashboard_page_id ) ;

                    // send notification to current user
                    citybook_addons_user_add_notification($user_id_new, array(
                        'type' => 'password_changed',
                        'message' => __( 'Your password has been changed.', 'citybook-add-ons' )
                    ));

                }   
            }else{
                $json['success'] = false;
                $json['data']['error'] = esc_html__( 'The new password does not match each other.', 'citybook-add-ons' ) ;
            }
        }else{
            $json['success'] = false;
            $json['data']['error'] = esc_html__( 'The old password is incorrect.', 'citybook-add-ons' ) ;
        }
    }else{
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'User does not exists. Can not update password', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

// delete listing
add_action('wp_ajax_nopriv_citybook_addons_delete_listing', 'citybook_addons_delete_listing_callback');
add_action('wp_ajax_citybook_addons_delete_listing', 'citybook_addons_delete_listing_callback');

function citybook_addons_delete_listing_callback() {
    $json = array(
        'success' => false,
        // 'data' => array(
        //     'POST'=>$_POST,
        // )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $lid = isset($_POST['lid'])? $_POST['lid'] : 0;
    if(is_numeric($lid) && (int)$lid > 0){
        $deleted_post = wp_delete_post( $lid, false );//move to trash

        if($deleted_post){
            $json['success'] = true;
            $json['data']['post'] = $deleted_post;
            // update order/subscription listings data
            $listing_order = get_post_meta( $lid,  P_META_PREFIX.'order_id', true );
            if(is_numeric($listing_order) && (int)$listing_order > 0){

                // check for existing listings item
                $order_listings = get_post_meta( $listing_order, P_META_PREFIX.'listings', true );
                if(is_array($order_listings) && !empty($order_listings)){
                    if (($key = array_search($lid, $order_listings)) !== false) {
                        unset($order_listings[$key]);
                        update_post_meta( $listing_order, P_META_PREFIX.'listings', $order_listings );
                    }
                }


                update_post_meta( $lid, P_META_PREFIX.'order_id', '' );
            }
            // set expire_date to current date
            update_post_meta( $lid, P_META_PREFIX.'expire_date', current_time('mysql', 1) );

            citybook_addons_user_add_notification($deleted_post->post_author, array(
                'type' => 'delete_listing',
                'message' => sprintf(__( 'You have deleted <strong>%s</strong> listing.', 'citybook-add-ons' ), $deleted_post->post_title )
            ));

        }else{
            // $json['success'] = false;
            $json['data']['error'] = esc_html__( 'Delete listing failure', 'citybook-add-ons' ) ;
        }
    }else{
        // $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The post id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}
// featured listing
add_action('wp_ajax_nopriv_citybook_addons_featured_listing', 'citybook_addons_featured_listing_callback');
add_action('wp_ajax_citybook_addons_featured_listing', 'citybook_addons_featured_listing_callback');

function citybook_addons_featured_listing_callback() {
    $json = array(
        'success' => false,
        // 'data' => array(
        //     'POST'=>$_POST,
        // )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $lid = isset($_POST['lid'])? $_POST['lid'] : 0;
    if(is_numeric($lid) && (int)$lid > 0){
        $lfeatured = isset($_POST['lfeatured'])? $_POST['lfeatured'] : false;
        $listing_order = get_post_meta( $lid,  P_META_PREFIX.'order_id', true );

        $json['listing_order'] = $listing_order;

        if(is_numeric($listing_order) && (int)$listing_order > 0){
            $featured_listings = get_post_meta( $listing_order, P_META_PREFIX.'featured', true );
            if($lfeatured){
                if( !empty($featured_listings) && is_array($featured_listings) ){
                    if (($key = array_search($lid, $featured_listings)) !== false) {
                        unset($featured_listings[$key]);
                        update_post_meta( $listing_order, P_META_PREFIX.'featured', $featured_listings );
                    }
                }
                update_post_meta( $lid, P_META_PREFIX.'featured', '0' );
                $json['success'] = true;
            }else{
                // check for existing featured
                $plan_id = get_post_meta( $listing_order, P_META_PREFIX.'plan_id', true );
                $featured_limit = get_post_meta( $plan_id, P_META_PREFIX.'lfeatured', true );
                if(is_numeric($featured_limit) && $featured_limit > 0){
                    
                    if( !empty($featured_listings) && is_array($featured_listings) ){
                        if( count($featured_listings) < $featured_limit ){
                            if ( false === array_search($lid, $featured_listings) ) {
                                $featured_listings[] = $lid;
                                update_post_meta( $listing_order, P_META_PREFIX.'featured', $featured_listings );
                                update_post_meta( $lid, P_META_PREFIX.'featured', '1' );
                                $json['success'] = true;
                                $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;

                            }else{
                                $json['data']['error'] = esc_html__( 'Listing was featured', 'citybook-add-ons' ) ;
                            }
                        }else{
                            // featured limited
                            $json['data']['error'] = esc_html__( 'Your subscription hit featured listing limit', 'citybook-add-ons' ) ;
                        }
                    }else{
                        // there is no featured
                        
                        update_post_meta( $listing_order, P_META_PREFIX.'featured', array($lid) );
                        update_post_meta( $lid, P_META_PREFIX.'featured', '1' );

                        $json['success'] = true;
                        $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;
                    }
                }else{
                    $json['data']['error'] = esc_html__( 'You subscription has no featured listings or hit the limit', 'citybook-add-ons' ) ;
                }
                
                

            }
        }else{
            // not associating with subscription
            if($lfeatured){
                update_post_meta( $lid, P_META_PREFIX.'featured', '0' );
                $json['success'] = true;
            }else{
                $active_sub = citybook_addons_get_current_subscription();
                if( $active_sub && $active_sub['valid'] ){
                    $listing_order = $active_sub['id'];
                    
                    // check for existing featured
                    $plan_id = get_post_meta( $listing_order, P_META_PREFIX.'plan_id', true );
                    $featured_limit = get_post_meta( $plan_id, P_META_PREFIX.'lfeatured', true );
                    if(is_numeric($featured_limit) && $featured_limit > 0){
                        $featured_listings = get_post_meta( $listing_order, P_META_PREFIX.'featured', true );
                        if( !empty($featured_listings) && is_array($featured_listings) ){
                            if( count($featured_listings) < $featured_limit ){
                                if ( false === array_search($lid, $featured_listings) ) {
                                    // attach to order/subscription
                                    $order_listings = get_post_meta( $listing_order, P_META_PREFIX.'listings', true );
                                    if( !empty($order_listings) && is_array($order_listings) ){
                                        $order_listings[] = $lid;
                                        update_post_meta( $listing_order, P_META_PREFIX.'listings', $order_listings );
                                    }else{
                                        update_post_meta( $listing_order, P_META_PREFIX.'listings', array($lid) );
                                    }
                                    $featured_listings[] = $lid;
                                    update_post_meta( $listing_order, P_META_PREFIX.'featured', $featured_listings );
                                    update_post_meta( $lid, P_META_PREFIX.'order_id', $listing_order );
                                    update_post_meta( $lid, P_META_PREFIX.'featured', '1' );
                                    $json['success'] = true;
                                    $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;

                                }else{
                                    $json['data']['error'] = esc_html__( 'Listing was featured', 'citybook-add-ons' ) ;
                                }
                            }else{
                                // featured limited
                                $json['data']['error'] = esc_html__( 'Your subscription hit featured listing limit', 'citybook-add-ons' ) ;
                            }
                        }else{
                            // there is no featured
                            $order_listings = get_post_meta( $listing_order, P_META_PREFIX.'listings', true );
                            if( !empty($order_listings) && is_array($order_listings) ){
                                $order_listings[] = $lid;
                                update_post_meta( $listing_order, P_META_PREFIX.'listings', $order_listings );
                            }else{
                                update_post_meta( $listing_order, P_META_PREFIX.'listings', array($lid) );
                            }
                            update_post_meta( $listing_order, P_META_PREFIX.'featured', array($lid) );
                            update_post_meta( $lid, P_META_PREFIX.'order_id', $listing_order );
                            update_post_meta( $lid, P_META_PREFIX.'featured', '1' );

                            $json['success'] = true;
                            $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;
                        }
                    }else{
                        $json['data']['error'] = esc_html__( 'Your subscription has no featured listings or hit the limit', 'citybook-add-ons' ) ;
                    }
                    
                }else{
                    $json['data']['error'] = esc_html__( 'Please order a membership plan', 'citybook-add-ons' ) ;
                }
            }
        }
    }else{
        // $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The post id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

add_action('wp_ajax_admin_lfeatured', 'citybook_addons_admin_lfeatured_callback');
function citybook_addons_admin_lfeatured_callback(){
    $json = array(
        'success' => false,
        // 'data' => array(
        //     'POST'=>$_POST,
        // )
    );

    $lid = isset($_POST['lid'])? $_POST['lid'] : 0;
    if(is_numeric($lid) && (int)$lid > 0){
        $lfeatured = isset($_POST['lfeatured'])? $_POST['lfeatured'] : false;
        $listing_order = get_post_meta( $lid,  P_META_PREFIX.'order_id', true );

        $json['listing_order'] = $listing_order;

        if(is_numeric($listing_order) && (int)$listing_order > 0){
            $featured_listings = get_post_meta( $listing_order, P_META_PREFIX.'featured', true );
            if($lfeatured){
                if( !empty($featured_listings) && is_array($featured_listings) ){
                    if (($key = array_search($lid, $featured_listings)) !== false) {
                        unset($featured_listings[$key]);
                        update_post_meta( $listing_order, P_META_PREFIX.'featured', $featured_listings );
                    }
                }
                update_post_meta( $lid, P_META_PREFIX.'featured', '0' );
                $json['success'] = true;
            }else{
                // check for existing featured
                $plan_id = get_post_meta( $listing_order, P_META_PREFIX.'plan_id', true );
                $featured_limit = get_post_meta( $plan_id, P_META_PREFIX.'lfeatured', true );
                if(is_numeric($featured_limit) && $featured_limit > 0){
                    
                    if( !empty($featured_listings) && is_array($featured_listings) ){
                        if( count($featured_listings) < $featured_limit ){
                            if ( false === array_search($lid, $featured_listings) ) {
                                $featured_listings[] = $lid;
                                update_post_meta( $listing_order, P_META_PREFIX.'featured', $featured_listings );
                                update_post_meta( $lid, P_META_PREFIX.'featured', '1' );
                                $json['success'] = true;
                                $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;

                            }else{
                                $json['data']['error'] = esc_html__( 'Listing was featured', 'citybook-add-ons' ) ;
                            }
                        }else{
                            // featured limited
                            $json['data']['error'] = esc_html__( 'Your subscription hit featured listing limit', 'citybook-add-ons' ) ;
                        }
                    }else{
                        // there is no featured
                        
                        update_post_meta( $listing_order, P_META_PREFIX.'featured', array($lid) );
                        update_post_meta( $lid, P_META_PREFIX.'featured', '1' );

                        $json['success'] = true;
                        $json['data'][] = esc_html__( 'Listing is featured', 'citybook-add-ons' ) ;
                    }
                }else{
                    $json['data']['error'] = esc_html__( 'Your subscription has no featured listings or hit the limit', 'citybook-add-ons' ) ;
                }
                
                

            }
        }else{
            // not associating with subscription
            if($lfeatured)
                update_post_meta( $lid, P_META_PREFIX.'featured', '0' );
            else
                update_post_meta( $lid, P_META_PREFIX.'featured', '1' );
            $json['success'] = true;
        }
    }else{
        // $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The post id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

add_action('wp_ajax_admin_lverified', 'citybook_addons_admin_lverified_callback');
function citybook_addons_admin_lverified_callback(){
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );

    $lid = isset($_POST['lid'])? $_POST['lid'] : 0;
    if(is_numeric($lid) && (int)$lid > 0){
        $lverified = isset($_POST['lverified']) && $_POST['lverified'] ? false : true;
        if(update_post_meta( $lid, P_META_PREFIX.'verified', $lverified )) $json['success'] = true;
    }else{
        // $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The post id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}



