<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_Listing_Invoice() {
    
    $labels = array( 
        'name' => __( 'Invoice', 'citybook-add-ons' ),
        'singular_name' => __( 'Invoice', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Invoice', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Invoice', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Invoice', 'citybook-add-ons' ),
        'new_item' => __( 'New Invoice', 'citybook-add-ons' ),
        'view_item' => __( 'View Invoice', 'citybook-add-ons' ),
        'search_items' => __( 'Search Invoices', 'citybook-add-ons' ),
        'not_found' => __( 'No Invoices found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Invoices found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Invoice:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Invoices', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => 'Subscription invoice',
        'supports' => array( '' ),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-media-text',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => false,
        'can_export' => false,
        'rewrite' => array( 'slug' => __('cthinvoice','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'cthinvoice', $args );
}

//Register Order 
add_action( 'init', 'citybook_addons_register_cpt_Listing_Invoice' );

// modify order columns
function citybook_addons_cthinvoice_columns_head($defaults) {
    // unset($defaults['date']);
    // unset($defaults['title']);
    // unset($defaults['author']);
    unset($defaults['comments']);
    // $defaults['ID']             = __('Order','citybook-add-ons');
    // $defaults['plan']             = __('Plan','citybook-add-ons');
    // $defaults['status']             = __('Status','citybook-add-ons');

    $defaults['plan']   = __('Plan','citybook-add-ons');

    $defaults['end_date']   = __('Expire Date','citybook-add-ons');

    $defaults['payment']       =  __('Payment','citybook-add-ons');
    // $defaults['quantity']   = __('Quantity','citybook-add-ons');
    // $defaults['lo_date']   = __('Order Date','citybook-add-ons');
    $defaults['amount']   = __('Total','citybook-add-ons');
    

    
    // $defaults['from_date']   = __('Active Date','citybook-add-ons');
    

    // $defaults['payment_count']   = __('Payment Count','citybook-add-ons');

    return $defaults;
}

function citybook_addons_cthinvoice_columns_content($column_name, $post_ID) {
    // if ($column_name == 'ID') {
    //     echo '<div class="tips">';
    //     echo '<a href="'.admin_url('post.php?post='.$post_ID.'&action=edit' ).'"><strong>#'.$post_ID.'</strong></a>';
    //     echo __(' by ','citybook-add-ons'). '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'first_name', true ). ' '.get_post_meta( $post_ID, P_META_PREFIX.'last_name', true ).'</strong>';
    //     echo '<br><small class="meta email"><a href="mailto:'.get_post_meta( $post_ID, P_META_PREFIX.'email', true ).'">'.get_post_meta( $post_ID, P_META_PREFIX.'email', true ).'</a></small>';
    //     echo '</div>';
    // }
    // if ($column_name == 'plan') {
    //     $plan = get_post( get_post_meta( $post_ID, P_META_PREFIX.'plan_id', true ) );
    //     if (null != $plan) echo '<strong>'.$plan->post_title.'</strong>';
    // }
    // if ($column_name == 'status') {
    //     echo '<strong>'.citybook_addons_get_booking_status_text(get_post_meta( $post_ID, P_META_PREFIX.'status', true )).'</strong>';
        
    // }
    if ($column_name == 'payment') {
        echo '<strong>'.citybook_addons_get_order_method_text(get_post_meta( $post_ID, P_META_PREFIX.'payment', true )).'</strong>';
        
    }
    
    // if ($column_name == 'quantity') {
    //     echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'quantity', true ).'</strong>';
        
    // }
    
    // if ($column_name == 'lo_date') {
    //     echo '<strong>'.get_the_date( get_option('date_format' ), $post_ID ).'</strong>';
        
    // }

    if ($column_name == 'amount') {
        echo '<strong>'.citybook_addons_get_price_formated( get_post_meta( $post_ID, P_META_PREFIX.'amount', true ) ).'</strong>';
        
    }

    

    if ($column_name == 'plan') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'plan_title', true).'</strong>'; 
    }

    if ($column_name == 'from_date') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'from_date', true ).'</strong>';
        
    }

    if ($column_name == 'end_date') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'end_date', true ).'</strong>';
        
    }

    

}


add_filter('manage_cthinvoice_posts_columns', 'citybook_addons_cthinvoice_columns_head');
add_action('manage_cthinvoice_posts_custom_column', 'citybook_addons_cthinvoice_columns_content', 10, 2);

// invoice metabox

function citybook_addons_invoice_add_meta_box() {

    add_meta_box(
        'cthinvoice_details',
        __( 'Invoice Details', 'citybook-add-ons' ),
        'citybook_addons_invoice_meta_box_payment_details_callback',
        'cthinvoice',
        'normal',
        'core'
        //,'normal', //('normal', 'advanced', or 'side')
        //'core'//('high', 'core', 'default' or 'low') 
    );

    
}
add_action( 'add_meta_boxes_cthinvoice', 'citybook_addons_invoice_add_meta_box' );

function citybook_addons_invoice_meta_box_payment_details_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );
    ?>
    <table class="form-table cth-table table-invoice-details">
        <tbody>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Date', 'citybook-add-ons' ); ?></td>
                <td class="w60 text-bold" colspan="3"><?php echo citybook_addons_date_format( $post->post_date ); ?></td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Subscribed with', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'user_name', true ); ?></td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Charged via', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3"><?php echo citybook_addons_get_order_method_text(get_post_meta( $post->ID, P_META_PREFIX.'payment', true )); ?></td>
            </tr>
            <tr>
                <td class="w40" colspan="2"><?php _e( 'Expiration date', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-bold" colspan="3"><?php echo citybook_addons_date_format( get_post_meta( $post->ID, P_META_PREFIX.'end_date', true ), true ); ?></td>
            </tr>
            <tr>
                <td class="w80" colspan="4"><?php _e( 'Subscription to', 'citybook-add-ons' ); ?> <?php echo get_post_meta( $post->ID, P_META_PREFIX.'plan_title', true ); ?></td>
                <td class="w20 text-right"><?php echo citybook_addons_get_price_formated(get_post_meta( $post->ID, P_META_PREFIX.'amount', true )); ?></td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold text-blur" colspan="2"><?php _e( 'Subtotal', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-right" colspan="3"><?php echo citybook_addons_get_price_formated(get_post_meta( $post->ID, P_META_PREFIX.'amount', true )); ?></td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold text-blur" colspan="2"><?php _e( 'Total', 'citybook-add-ons' ); ?></td>
                <td class="w40 text-right" colspan="3"><?php echo citybook_addons_get_price_formated(get_post_meta( $post->ID, P_META_PREFIX.'amount', true )); ?></td>
            </tr>
            <tr>
                <td class="w40 text-right text-bold" colspan="2"><?php _e( 'Paid', 'citybook-add-ons' ); ?></td>
                <td class="w60 text-right text-bold" colspan="3"><?php echo citybook_addons_get_price_formated(get_post_meta( $post->ID, P_META_PREFIX.'amount', true )); ?></td>
            </tr>
        </tbody>
    </table>
    <?php   
}

// /**
//  * When the post is saved, saves our custom data.
//  *
//  * @param int $post_id The ID of the post being saved.
//  */
// function citybook_addons_order_save_meta_box_datas( $post_id ) {

//     /*
//      * We need to verify this came from our screen and with proper authorization,
//      * because the save_post action can be triggered at other times.
//      */

//     // If this is just a revision, don't send the email.
//     if ( wp_is_post_revision( $post_id ) )
//         return;

//     // Check if our nonce is set.
//     if ( ! isset( $_POST['_cthinvoice_nonce'] ) ) {
//         return;
//     }

//     // Verify that the nonce is valid.
//     if ( ! wp_verify_nonce( $_POST['_cthinvoice_nonce'], 'citybook_addons-cthinvoice' ) ) {
//         return;
//     }

//     // If this is an autosave, our form has not been submitted, so we don't want to do anything.
//     if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
//         return;
//     }

    

//     // Check the user's permissions.
//     if ( ! current_user_can( 'edit_post', $post_id ) ) {
//         return;
//     }

    
//     if(isset($_POST['lo_status'])){
//         $new_status = sanitize_text_field( $_POST['lo_status'] ) ;
//         $origin_status = get_post_meta( $post_id, P_META_PREFIX.'status', true );
//         if($new_status !== $origin_status){
//             update_post_meta( $post_id, P_META_PREFIX.'status', $new_status );

//             // unhook this function so it doesn't loop infinitely
//             remove_action( 'save_post_cthinvoice', 'citybook_addons_order_save_meta_box_datas', 10, 1 );
//                 do_action('citybook_addons_cthinvoice_change_status_'.$origin_status.'_to_'.$new_status, $post_id );
//                 do_action('citybook_addons_cthinvoice_change_status_to_'.$new_status, $post_id );
//             // re-hook this function
//             add_action( 'save_post_cthinvoice', 'citybook_addons_order_save_meta_box_datas', 10, 1  );
                
//         }
//     }
// }
// add_action( 'save_post_cthinvoice', 'citybook_addons_order_save_meta_box_datas', 10, 1 );

function citybook_addons_get_invoice_datas_array($invoice_post){
    return array(
        'author' => get_post_meta( $invoice_post->ID, P_META_PREFIX.'user_name', true ),
        'amount' => citybook_addons_get_price_formated(get_post_meta( $invoice_post->ID, P_META_PREFIX.'amount', true )),
        
        'method' => citybook_addons_get_order_method_text(get_post_meta( $invoice_post->ID, P_META_PREFIX.'payment', true )),
        'title' => $invoice_post->post_title,
        'number' => $invoice_post->ID,
        'date' => citybook_addons_date_format( $invoice_post->post_date ),

        'plan' => get_post_meta( $invoice_post->ID, P_META_PREFIX.'plan_title', true ),
        'expire' => citybook_addons_date_format( get_post_meta( $invoice_post->ID, P_META_PREFIX.'end_date', true ), true ),
        
    );
}

// create stripe plan action
add_action('wp_ajax_nopriv_citybook-view-invoice', 'citybook_addons_view_invoice_callback');
add_action('wp_ajax_citybook-view-invoice', 'citybook_addons_view_invoice_callback');

function citybook_addons_view_invoice_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );


    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $invoice_post          = get_post($_POST['invoice']);

    if(empty($invoice_post)){
        $json['data']['error'] = esc_html__( 'Invalid invoice', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $json['success'] = true;

    $json['invoice'] = citybook_addons_get_invoice_datas_array($invoice_post);

    wp_send_json($json );

}

        


















