<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_CTH_Claim() {
    
    $labels = array( 
        'name' => __( 'Claims', 'citybook-add-ons' ),
        'singular_name' => __( 'Claim', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Claim', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Claim', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Claim', 'citybook-add-ons' ),
        'new_item' => __( 'New Claim', 'citybook-add-ons' ),
        'view_item' => __( 'View Claim', 'citybook-add-ons' ),
        'search_items' => __( 'Search Claims', 'citybook-add-ons' ),
        'not_found' => __( 'No Claims found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Claims found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Claim:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Claims', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => __( 'Listing author claims', 'citybook-add-ons' ),
        'supports' => array( 'title'),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-money',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => false,
        'can_export' => false,
        'rewrite' => array( 'slug' => __('claim','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'cthclaim', $args );
}

//Register Booking 
add_action( 'init', 'citybook_addons_register_cpt_CTH_Claim' );

// modify booking columns
function citybook_addons_cthclaim_columns_head($defaults) {
    // unset($defaults['date']);
    
    $defaults['status']             = __('Status/Actions','citybook-add-ons');
    $defaults['ID']                 = __('ID','citybook-add-ons');
    return $defaults;
}

function citybook_addons_cthclaim_columns_content($column_name, $post_ID) {
    if ($column_name == 'status') {
        echo '<strong>'.citybook_add_ons_get_claim_status( get_post_meta( $post_ID, P_META_PREFIX.'claim_status', true ) ).'</strong>';
    }

    if ($column_name == 'ID') {
        echo '<strong>'.$post_ID.'</strong>';
    }
    
    
    
    
}


add_filter('manage_cthclaim_posts_columns', 'citybook_addons_cthclaim_columns_head');
add_action('manage_cthclaim_posts_custom_column', 'citybook_addons_cthclaim_columns_content', 10, 2);

// metabox
function citybook_addons_cthclaim_add_meta_box() {

    $screens = array( 'cthclaim');

    foreach ( $screens as $screen ) {

        add_meta_box(
            'cthclaim_details',
            __( 'Details: ', 'citybook-add-ons' ),
            'citybook_addons_cthclaim_meta_box_details_callback',
            $screen,
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
    }

    
}
add_action( 'add_meta_boxes', 'citybook_addons_cthclaim_add_meta_box' );

function citybook_addons_cthclaim_meta_box_details_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'citybook_addons-lclaim', '_lclaim_nonce' );

    
    $listing_id             = get_post_meta( $post->ID, P_META_PREFIX.'listing_id', true );
    $user_id                = get_post_meta( $post->ID, P_META_PREFIX.'user_id', true );


    

    $listing_post          = get_post($listing_id);

    $user_info = get_userdata($user_id);

    ?>
    <table class="form-table lclaim-details">
        <tbody>

            <tr class="hoz">
                <th class="w20"><?php _e( 'For Listing', 'citybook-add-ons' ); ?></th>
                <td>
                    <?php 
                        echo sprintf(__( '<h3><a href="%s" target="_blank">%s</a></h3>', 'citybook-add-ons' ), esc_url(get_permalink($listing_post->ID)), $listing_post->post_title );
                    ?>
                </td>
            </tr>

            <tr class="hoz">
                <th class="w20"><?php _e( 'Claim Author', 'citybook-add-ons' ); ?></th>
                <td>
                <?php 
                if(!$user_info){
                    _e( 'No author', 'citybook-add-ons' );
                }else{
                    echo sprintf(__( '<a href="%s" target="_blank">%s</a>', 'citybook-add-ons' ), esc_url(get_author_posts_url($user_info->ID)), $user_info->display_name );

                }
                ?>
                </td>
            </tr>
            <?php 
            $statuses = citybook_add_ons_get_claim_status();
            $selected = get_post_meta( $post->ID, P_META_PREFIX.'claim_status', true ); ?>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Status/Actions', 'citybook-add-ons' ); ?></th>
                <td>
                    <?php 
                    if(count($statuses)){
                        echo '<select id="claim_status" name="claim_status">';
                        foreach ($statuses as $status => $label) {
                            echo '<option value="'.$status.'" '.selected( $selected, $status, false ).'>'.$label.'</option>';
                        }
                        echo '</select>';
                    }
                    ?>

                </td>
            </tr>
            
            <tr class="hoz claim-price-tr<?php if($selected == 'asked_charge') echo ' claim-fee-asked'; ?>" id="claim_price_tr">
                <th class="w20"><?php _e( 'Claim Price', 'citybook-add-ons' ); ?></th>
                <td>
                    <?php echo citybook_add_ons_get_currency_symbol(citybook_addons_get_option('currency','USD')); ?><input type="text" name="_price" value="<?php echo (float) get_post_meta( $post->ID, '_price', true );?>">
                    <p><?php _e( 'Enter listing claim price then save the change. Claimed user will receive an email contains details for paying this.', 'citybook-add-ons' ); ?></p>
                </td>
            </tr>

            <tr class="hoz">
                <th class="w20"><?php _e( 'Author Message', 'citybook-add-ons' ); ?></th>
                <td>
                    <textarea name="claim_msg" id="claim_msg" cols="30" rows="5" class="w100"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'claim_msg', true );?></textarea>
                </td>
            </tr>

        </tbody>
    </table>
    <?php   
}


/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function citybook_addons_cthclaim_save_meta_box_datas( $post_id ) {

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // If this is just a revision, don't send the email.
    if ( wp_is_post_revision( $post_id ) )
        return;

    // Check if our nonce is set.
    if ( ! isset( $_POST['_lclaim_nonce'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $_POST['_lclaim_nonce'], 'citybook_addons-lclaim' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    if(isset($_POST['claim_msg'])){
        $new_val = sanitize_textarea_field( $_POST['claim_msg'] ) ;
        $origin_val = get_post_meta( $post_id, P_META_PREFIX.'claim_msg', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, P_META_PREFIX.'claim_msg', $new_val );
        }
        
    }

    if(isset($_POST['_price'])){
        $new_val = (float)$_POST['_price'];
        $origin_val = (float) get_post_meta( $post_id, '_price', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, '_price', $new_val );
        }
        
    }

    if(isset($_POST['claim_status'])){
        $new_status = sanitize_text_field( $_POST['claim_status'] ) ;
        $origin_status = get_post_meta( $post_id, P_META_PREFIX.'claim_status', true );
        if($new_status !== $origin_status){
            update_post_meta( $post_id, P_META_PREFIX.'claim_status', $new_status );

            // unhook this function so it doesn't loop infinitely
            remove_action( 'save_post_cthclaim', 'citybook_addons_cthclaim_save_meta_box_datas', 10, 1  );
            
                do_action('citybook_addons_lclaim_change_status_'.$origin_status.'_to_'.$new_status, $post_id );
                do_action('citybook_addons_lclaim_change_status_to_'.$new_status, $post_id );  

            // re-hook this function
            add_action( 'save_post_cthclaim', 'citybook_addons_cthclaim_save_meta_box_datas', 10, 1  );


            
        }
    }

    
    
}
add_action( 'save_post_cthclaim', 'citybook_addons_cthclaim_save_meta_box_datas', 10, 1 );
// https://codex.wordpress.org/Plugin_API/Action_Reference/save_post

// admin approve claim
function citybook_addons_lclaim_change_status_to_approved_callback($claim_id = 0){
    if(is_numeric($claim_id)&&(int)$claim_id > 0){
        $claim_post = get_post($claim_id);
        if (null != $claim_post){
            $listing_id                     = get_post_meta( $claim_post->ID, P_META_PREFIX.'listing_id', true );
            $user_id                        = get_post_meta( $claim_post->ID, P_META_PREFIX.'user_id', true );
            
            // update user role to listing author - need to check for option
            // update role for subscriber and listing customer only 
            $current_role = citybook_addons_get_user_role($user_id);
            // only update role if lower role
            if(in_array($current_role, array( 'author', 'contributor', 'subscriber', 'l_customer' ))){
                $user_id_new = wp_update_user( array( 'ID' => $user_id, 'role' => 'listing_author' ) );
                if ( is_wp_error( $user_id_new ) ) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update user role to listing_author" . PHP_EOL, 3, CTH_LOG_FILE);
                }

                citybook_addons_user_add_notification($user_id, array(
                    'type' => 'role_change',
                    'message' => __( 'Your role has changed to <strong>Listing Author</strong>.', 'citybook-add-ons' )
                ));
            }
            // update listing author to claimed author
            $lis_args = array(
                'ID'                => $listing_id,
                'post_author'       => $user_id,
            );

            $lis_id = wp_update_post( $lis_args, true );    

            if (CTH_DEBUG && is_wp_error($lis_id)) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update listing (ID: $lis_id) to claimed author (ID: $user_id) error: " . $lis_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);
            }

            // update listing verified field
            if ( !update_post_meta( $listing_id, P_META_PREFIX.'verified',  true  ) ) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update listing meta verified error or existing value" . PHP_EOL, 3, CTH_LOG_FILE);
            }

            do_action( 'citybook_addons_cthclaim_approved', $claim_id, $listing_id, $user_id );
        }
    }
                
}
add_action( 'citybook_addons_lclaim_change_status_to_approved', 'citybook_addons_lclaim_change_status_to_approved_callback', 10, 1 );


// create stripe plan action
add_action('wp_ajax_nopriv_citybook_addons_claim-listing', 'citybook_addons_claim_listing_callback');
add_action('wp_ajax_citybook_addons_claim-listing', 'citybook_addons_claim_listing_callback');

function citybook_addons_claim_listing_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $listing_post = get_post($_POST['listing_id']);

    if(empty($listing_post)){
        $json['data']['error'] = esc_html__( 'Invalid listing ID', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if( get_post_meta( $listing_post->ID, P_META_PREFIX.'verified', true ) ){
        $json['data']['error'] = esc_html__( 'This listing was verified! Contact us for further assistance.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $lclaim_datas = array();
    $current_user = wp_get_current_user();

    $lclaim_datas['post_title'] = sprintf( _x( '%s claimed for %s listing', 'listing claim title', 'citybook-add-ons' ), $current_user->display_name, $listing_post->post_title );

    $lclaim_datas['post_content'] = '';
    $lclaim_datas['post_status'] = 'publish';
    $lclaim_datas['post_type'] = 'cthclaim';

    do_action( 'citybook_addons_insert_cthclaim_before', $lclaim_datas );

    $claim_id = wp_insert_post($lclaim_datas ,true );
    if (!is_wp_error($claim_id)) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Claim inserted: " . $claim_id . PHP_EOL, 3, CTH_LOG_FILE);
        // update claim meta datas
        $claim_metas['listing_id'] = $listing_post->ID;
        $claim_metas['claim_status'] = 'pending';
        $claim_metas['user_id'] = $current_user->ID;
        $claim_metas['claim_msg'] = isset($_POST['claim_message']) ? $_POST['claim_message'] : '';
        foreach ($claim_metas as $key => $value) {
            // https://codex.wordpress.org/Function_Reference/update_post_meta
            // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
            // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
            if ( !update_post_meta( $claim_id, P_META_PREFIX.$key,  $value  ) ) {
                $json['data'][] = sprintf(__('Insert claim %s meta failure or existing meta value','citybook-add-ons'),$key);
            }
        }
        $json['success'] = true;
        $json['data']['message'] = __( 'Your claim has been submitted.', 'citybook-add-ons' );

        do_action( 'citybook_addons_insert_cthclaim_after', $claim_id );
    }

    wp_send_json($json );

}

        







