<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



add_action( 'citybook_author_contact_form_after', function($author_id){
    if(!is_user_logged_in()):
    ?>
    <div class="terms_wrap">
        <?php if(citybook_addons_get_option('register_term_text') != ''): ?>
        <div class="filter-tags">
            <input id="accept_term_contact" name="accept_term" value="1" type="checkbox" required="required">
            <label for="accept_term_contact"><?php echo citybook_addons_get_option('register_term_text');?></label>
        </div>
        <?php endif; ?>
        <?php if(citybook_addons_get_option('register_consent_data_text') != ''): ?>
        <div class="filter-tags">
            <input id="consent_data_contact" name="consent_data" value="1" type="checkbox" required="required">
            <label for="consent_data_contact"><?php echo citybook_addons_get_option('register_consent_data_text');?></label>
        </div>
        <?php endif; ?>
    </div>
    <div class="clearfix"></div>
    <?php
    endif;
} );

add_action( 'citybook_author_contact_form_before', function($author_id){
    if(!is_user_logged_in()){

        echo _e( '<div class="author-contant-head">Your email will be used to register new user.<br> And your message will be sent under that new user.</div>', 'citybook-add-ons' );

    }
} );

// submit a author message
add_action('wp_ajax_nopriv_citybook_addons_lauthor_message', 'citybook_addons_lauthor_message_chat_callback');
add_action('wp_ajax_citybook_addons_lauthor_message', 'citybook_addons_lauthor_message_chat_callback');

function citybook_addons_lauthor_message_chat_callback() {
    global $wpdb;
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    $nonce = $_POST['_nonce'];
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = __( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $authid = isset($_POST['authid'])? $_POST['authid'] : 0;
    if( is_numeric($authid) && $authid > 0 ){
        $from_user_id = 0;
        if(isset($_POST['lmsg_name'])&&isset($_POST['lmsg_email']) ){
            // register new user
            // check for corrent email
            if ( !is_email( $_POST['lmsg_email'] ) ) {
                $json['data']['error'] = __( 'Invalid email address.', 'citybook-add-ons' ) ;
                wp_send_json($json );
            }
            $new_user_data = array(
                'user_login' => $_POST['lmsg_name'],
                'user_pass'  => wp_generate_password( 12, false ),
                'user_email' => $_POST['lmsg_email'],
                // 'role'       => 'l_customer' //'subscriber'
            );

            $user_id = wp_insert_user( $new_user_data );

            if ( ! is_wp_error( $user_id ) ) {
                // send login
                if(citybook_addons_get_option('new_user_email') != 'none') wp_new_user_notification( $user_id, null, citybook_addons_get_option('new_user_email') );
                if(citybook_addons_get_option('register_auto_login') == 'yes') citybook_addons_auto_login_new_user( $user_id );

                
            }else{
                $json['data']['error'] = $user_id->get_error_message() ;
                wp_send_json($json );
            }
            $from_user_id = $user_id;
        }else{
            if(!is_user_logged_in()){ // no logged in user and invalid form
                $json['data']['error'] = __( 'Invalid message form without name and email.', 'citybook-add-ons' );
                wp_send_json($json );
            }
            $from_user_id = get_current_user_id();
        }

        // check for sending user
        if(is_numeric($from_user_id) && $from_user_id ){
            $chat_table = $wpdb->prefix . 'cth_chat';
            $chat_reply_table = $wpdb->prefix . 'cth_chat_reply';

            $chat_id_checked = 0;
            $time = time();
            $ip = $_SERVER['REMOTE_ADDR'];

            // insert new chat contact
            $result = $wpdb->insert( 
                $chat_table, 
                array( 
                    
                    'user_one'  => $from_user_id, 
                    'user_two'  => $authid, 
                    'ip'        => $ip, 
                    'time'      => $time, 
                ) 
            );
            // end inshert chat
            // https://codex.wordpress.org/Class_Reference/wpdb#INSERT_row
            if($result != false){
                $chat_id_checked = $wpdb->insert_id;
                // insert reply row
                if($chat_id_checked){
                    $result = $wpdb->insert( 
                        $chat_reply_table, 
                        array( 
                            
                            'user_id_fk'    => $from_user_id, 
                            'reply'         => $_POST['lmsg_message'], 
                            'ip'            => $ip, 
                            'time'          => $time, 
                            'c_id_fk'       => $chat_id_checked
                        ) 
                    );
                    if($result != false){
                        $json['data']['message'] = apply_filters( 'citybook_addons_insert_message_message', __( 'Your message is received. The listing author will contact with you soon.<br>You can also login with your email to manage messages.<br>Thank you.', 'citybook-add-ons' ) );
                    }else{
                        $json['data']['error'] = __( 'Can not create chat message.', 'citybook-add-ons' );
                        wp_send_json($json );
                    }
                }
            }else{
                $json['data']['error'] = __( 'Can not create chat contact.', 'citybook-add-ons' );
                wp_send_json($json );
            }

        }else{
            $json['data']['error'] = __( 'Invalide user.', 'citybook-add-ons' );
            wp_send_json($json );
        }

    }else{
        $json['data']['error'] = __( 'The author id is incorrect.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }
    $json['success'] = true;
    wp_send_json($json );

}


// submit chat reply
add_action('wp_ajax_nopriv_citybook_addons_chat_reply', 'citybook_addons_chat_reply_callback');
add_action('wp_ajax_citybook_addons_chat_reply', 'citybook_addons_chat_reply_callback');

function citybook_addons_chat_reply_callback() {
    global $wpdb;

    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = __( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }
    $user_id_checked = 0;
    // if loggined user
    if(isset($_POST['user_id']) && $_POST['user_id']){
        if( get_current_user_id() != $_POST['user_id'] ){
            // incorrect logged in user
            $json['data']['error'] = __( 'Incorrect logged in user.', 'citybook-add-ons' ) ;
            wp_send_json($json );
        }

        $user_id_checked = get_current_user_id();

    }else{ // for guest message

        $json['data']['error'] = __( 'Invalid send user', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    // check for to user id (receive user)
    $to_user_id_checked = 0;
    if(isset($_POST['touid']) && $_POST['touid']){
        $to_user_id_checked = $_POST['touid'];
    }else{ // for guest message
        $json['data']['error'] = __( 'You have no contact to chat.<br>Please use chat form on single listing page to begin chat with author.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $chat_table = $wpdb->prefix . 'cth_chat';
    $chat_reply_table = $wpdb->prefix . 'cth_chat_reply';

    $time = time();
    $ip = $_SERVER['REMOTE_ADDR'];

    if($user_id_checked != $to_user_id_checked){
        // check for chat
        $chat_id_checked = isset($_POST['cid'])? $_POST['cid'] : 0;
        $chatids = $wpdb->get_col( "SELECT c_id FROM $chat_table WHERE ((user_one ='$user_id_checked' AND user_two ='$to_user_id_checked') OR (user_one ='$to_user_id_checked' AND user_two ='$user_id_checked')) AND c_id = '$chat_id_checked' ");
        
        if(!$chatids){
            // create new chat row

            $result = $wpdb->insert( 
                $chat_table, 
                array( 
                    
                    'user_one'  => $user_id_checked, 
                    'user_two'  => $to_user_id_checked, 
                    'ip'        => $ip, 
                    'time'      => $time, 
                ) 
            );
            // end inshert chat
            // https://codex.wordpress.org/Class_Reference/wpdb#INSERT_row
            if($result != false){
                $chat_id_checked = $wpdb->insert_id;
            }
        }
    }
    // user_id
    // cid
    // touid
    $reply_insert_id = 0;
    if($chat_id_checked){
        $result = $wpdb->insert( 
            $chat_reply_table, 
            array( 
                
                'user_id_fk'    => $user_id_checked, 
                'reply'         => $_POST['chat-msg'], 
                'ip'            => $ip, 
                'time'          => $time, 
                'c_id_fk'       => $chat_id_checked
            ) 
        );
        if($result != false){
            $reply_insert_id = $wpdb->insert_id;
        }
    }

    $reply_user = get_userdata( $user_id_checked );

    $json['data']['cid'] = $chat_id_checked;
    $json['data']['crid'] = $reply_insert_id;
    $json['data']['crtime'] = $time;
    $json['data']['reply'] = $_POST['chat-msg'];
    $json['data']['uid'] = $user_id_checked;
    $json['data']['display_name'] = $reply_user->display_name;
    $json['data']['user_email'] = $reply_user->user_email;
    $json['data']['user_one'] = 0;


    $json['data']['avatar'] = get_avatar($reply_user->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $reply_user->display_name );
    $json['data']['time'] = sprintf(__( '%s <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($time) ), date_i18n( get_option('time_format'), citybook_addons_gmt_to_local_timestamp($time) ));
    $json['data']['current_user'] = get_current_user_id();



    $reply_post = $wpdb->get_results( $wpdb->prepare( 
            "
            SELECT R.cr_id AS crid,R.time AS crtime,R.reply,U.ID AS uid,U.display_name,U.user_email, C.user_one, C.c_id AS cid
            FROM $chat_reply_table R, $wpdb->users U, $chat_table C
            WHERE U.ID = R.user_id_fk AND C.c_id = R.c_id_fk AND R.cr_id = %s
            ",
            $reply_insert_id
        )
    );
    if ( $reply_post ){
        $reply_data  = reset($reply_post);

        $json['data']['crid'] = $reply_data->crid;
        $json['data']['crtime'] = $reply_data->crtime;
        $json['data']['reply'] = $reply_data->reply;
        $json['data']['uid'] = $reply_data->uid;
        $json['data']['display_name'] = $reply_data->display_name;
        $json['data']['user_email'] = $reply_data->user_email;
        $json['data']['user_one'] = $reply_data->user_one;


        $json['data']['avatar'] = get_avatar($reply_data->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $reply_data->display_name );
        $json['data']['time'] = sprintf(__( '%s <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($reply_data->crtime) ), date_i18n( get_option('time_format'), citybook_addons_gmt_to_local_timestamp($reply_data->crtime) ));
        $json['data']['current_user'] = get_current_user_id();

    }
    $json['success'] = true;
    wp_send_json( $json );
}

// get replies
add_action('wp_ajax_nopriv_citybook_addons_chat_replies', 'citybook_addons_chat_replies_callback');
add_action('wp_ajax_citybook_addons_chat_replies', 'citybook_addons_chat_replies_callback');

function citybook_addons_chat_replies_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = __( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }
    $json['data']['replies'] = array();
    if(isset($_POST['cid']) && $_POST['cid']){
        // set first reply for new user chat
        if($_POST['cid'] == 'new' ){
            // for listing author data 
            if(isset($_POST['touid']) && isset($_POST['repliesCount']) && $_POST['repliesCount'] == 1){
                $listing_author = get_userdata( $_POST['touid'] );
                $time = time();
                $first_reply = array();
                $first_reply['crid'] = 1;
                $first_reply['crtime'] = $time;
                $first_reply['reply'] = sprintf(__( 'Hello, I am %s.<br>May I help you?', 'citybook-add-ons' ), $listing_author->display_name );
                $first_reply['uid'] = $listing_author->ID;
                $first_reply['display_name'] = $listing_author->display_name;
                $first_reply['user_email'] = $listing_author->user_email;
                $first_reply['user_one'] = get_current_user_id();


                $first_reply['avatar'] = get_avatar($listing_author->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $listing_author->display_name );
                $first_reply['time'] = sprintf(__( '%s <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($time) ), date_i18n( get_option('time_format'), citybook_addons_gmt_to_local_timestamp($time) ));
                $first_reply['current_user'] = get_current_user_id();
                $json['data']['replies'] = array($first_reply);
            }else{
                $json['data']['replies'] = array();
            }
        }else{
            // modify get replies clauses
            add_filter( 'ctb_chat_replies_clauses', function($clauses){
                // get new latest replies
                if( isset($_POST['lastID']) && $_POST['lastID'] ){
                    $clauses['wheres'] .= " AND R.cr_id > {$_POST['lastID']}";
                }
                // get 5 prev replies
                if( isset($_POST['firstID']) && $_POST['firstID'] ){
                    $clauses['wheres'] .= " AND R.cr_id < {$_POST['firstID']}";
                    // $clauses['orders'] = " ORDER BY R.cr_id DESC";
                    if(citybook_addons_get_option('messages_prev_load') > 0){
                        $clauses['limits'] = citybook_addons_get_option('messages_prev_load');
                    }
                }
                return $clauses;
            } );
            $json['data']['replies'] = citybook_addons_get_chat_replies($_POST['cid']);
        }
            
    }else{
        $json['data']['error'] = __( 'Invalid chat contact.<br>Please use chat form on single listing page to begin chat with author.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $json['success'] = true;
    wp_send_json($json );
}


function citybook_addons_get_chats($user_id = 0){
    global $wpdb;

    if(!$user_id){
        // return false when no user
        if(!is_user_logged_in()) return false;
        $user_id = get_current_user_id();
    }

    $chat_table = $wpdb->prefix . 'cth_chat';
    $chat_reply_table = $wpdb->prefix . 'cth_chat_reply';
    $user_chats = array();

    $chats = $wpdb->get_results(
        "
        SELECT u.ID AS uid,c.c_id AS cid,c.time AS ctime,u.display_name,u.user_email,c.user_one,(CASE WHEN c.user_one ='$user_id' THEN c.user_two ELSE c.user_one END) AS touid
        FROM $chat_table c, $wpdb->users u
        WHERE 
            CASE 
                WHEN c.user_one = '$user_id'
                    THEN c.user_two = u.ID
                WHEN c.user_two = '$user_id'
                    THEN c.user_one= u.ID
            END 
        AND ( c.user_one ='$user_id' OR c.user_two ='$user_id' )
        ORDER BY c.c_id DESC LIMIT 20
        "
    );

    if ( $chats ){
        foreach ( $chats as $chat ){
            $last_reply = $wpdb->get_results( $wpdb->prepare( 
                    "
                    SELECT R.cr_id AS crid,R.time AS crtime,R.reply 
                    FROM $chat_reply_table R
                    WHERE R.c_id_fk = %s 
                    ORDER BY R.cr_id DESC LIMIT 1
                    ",
                    $chat->cid
                )
            );

            $chat->date = date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($chat->ctime) );

            $last_reply_result = (object) array();

            if ( $last_reply ){
                $last_reply_result = reset($last_reply);
                $last_reply_result->date = date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($last_reply_result->crtime) );
            }

            $last_reply_result->avatar = get_avatar($chat->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $chat->display_name );
            

            

            $user_chats[] = (object) array_merge((array)$chat, (array)$last_reply_result);

        }   
    }

    return $user_chats;

}

function citybook_addons_get_chat_replies($chat_id = 0){
    global $wpdb;

    if(!$chat_id || !is_numeric($chat_id)) return false;

    $chat_table = $wpdb->prefix . 'cth_chat';
    $chat_reply_table = $wpdb->prefix . 'cth_chat_reply';

    $selects = "SELECT R.cr_id AS crid,R.time AS crtime,R.reply,U.ID AS uid,U.display_name,U.user_email, C.user_one,C.c_id AS cid";
    $froms = "FROM $chat_reply_table R, $wpdb->users U, $chat_table C";
    $wheres = $wpdb->prepare( "WHERE R.user_id_fk = U.ID AND C.c_id = R.c_id_fk AND R.c_id_fk = %s", $chat_id);
    $orders = "ORDER BY R.cr_id DESC"; // get last replies then reverse using php
    if(citybook_addons_get_option('messages_first_load') > 0){
        $limits = citybook_addons_get_option('messages_first_load');
    }

    $pieces = array( 'selects', 'froms', 'wheres', 'orders', 'limits' );


    $clauses = (array) apply_filters_ref_array( 'ctb_chat_replies_clauses', array( compact( $pieces ) ) );

    $selects = isset( $clauses[ 'selects' ] ) ? $clauses[ 'selects' ] : '';
    $froms = isset( $clauses[ 'froms' ] ) ? $clauses[ 'froms' ] : '';
    $wheres = isset( $clauses[ 'wheres' ] ) ? $clauses[ 'wheres' ] : '';
    $orders = isset( $clauses[ 'orders' ] ) ? $clauses[ 'orders' ] : '';
    $limits = isset( $clauses[ 'limits' ] ) ? $clauses[ 'limits' ] : '';

    if($limits != '') $limits = "LIMIT {$limits}";

    
    $replies = $wpdb->get_results( $selects . ' ' . $froms . ' ' . $wheres . ' ' . $orders . ' ' . $limits );

    $results = array();

    if($replies){
        // $replies = array_reverse($replies);
        foreach (array_reverse($replies) as $reply) {
            $reply->avatar =  get_avatar($reply->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $reply->display_name );
            $reply->time = sprintf(__( '%s <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option('date_format'), citybook_addons_gmt_to_local_timestamp($reply->crtime) ), date_i18n( get_option('time_format'), citybook_addons_gmt_to_local_timestamp($reply->crtime) ));
            $reply->current_user = get_current_user_id();
            $results[] = $reply;
        }
        
    }
    return $results;

}

function citybook_addons_delete_chat_user( $user_id ) {
    global $wpdb;

    $chat_table = $wpdb->prefix . 'cth_chat';
    $chat_reply_table = $wpdb->prefix . 'cth_chat_reply';

    $wpdb->query( 
        $wpdb->prepare( 
            "
            DELETE FROM $chat_reply_table
            WHERE c_id_fk = (SELECT c_id FROM $chat_table WHERE user_one = %d OR user_two = %d)
            ",
            $user_id,
            $user_id
        )
    );

    $wpdb->query( 
        $wpdb->prepare( 
            "
            DELETE FROM $chat_table
            WHERE user_one = %d OR user_two = %d
            ",
            $user_id,
            $user_id
        )
    );

}
add_action( 'delete_user', 'citybook_addons_delete_chat_user' );

function citybook_addons_gmt_to_local_timestamp( $gmt_timestamp ) {
    $iso_date        = date( 'Y-m-d H:i:s', $gmt_timestamp );
    $local_timestamp = get_date_from_gmt( $iso_date, 'U' );

    return $local_timestamp;
}

/*
[12-Nov-2018 11:51:49 UTC] WordPress database error Subquery returns more than 1 row for query 
            DELETE FROM wp_cth_chat_reply
            WHERE c_id_fk = (SELECT c_id FROM wp_cth_chat WHERE user_one = 980 OR user_two = 980)
             made by wp_delete_user, do_action('delete_user'), WP_Hook->do_action, WP_Hook->apply_filters, citybook_addons_delete_chat_user
[12-Nov-2018 11:51:49 UTC] WordPress database error Cannot delete or update a parent row: a foreign key constraint fails (`servers_citybook`.`wp_cth_chat_reply`, CONSTRAINT `wp_cth_chat_reply_ibfk_2` FOREIGN KEY (`c_id_fk`) REFERENCES `wp_cth_chat` (`c_id`)) for query 
            DELETE FROM wp_cth_chat
            WHERE user_one = 980 OR user_two = 980
             made by wp_delete_user, do_action('delete_user'), WP_Hook->do_action, WP_Hook->apply_filters, citybook_addons_delete_chat_user
[12-Nov-2018 11:51:49 UTC] WordPress database error Cannot delete or update a parent row: a foreign key constraint fails (`servers_citybook`.`wp_cth_chat`, CONSTRAINT `wp_cth_chat_ibfk_1` FOREIGN KEY (`user_one`) REFERENCES `wp_users` (`ID`)) for query DELETE FROM `wp_users` WHERE `ID` = 980 made by wp_delete_user
*/