<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_Listing_Booking() {
    
    $labels = array( 
        'name' => __( 'Booking', 'citybook-add-ons' ),
        'singular_name' => __( 'Booking', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Booking', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Booking', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Booking', 'citybook-add-ons' ),
        'new_item' => __( 'New Booking', 'citybook-add-ons' ),
        'view_item' => __( 'View Booking', 'citybook-add-ons' ),
        'search_items' => __( 'Search Bookings', 'citybook-add-ons' ),
        'not_found' => __( 'No Bookings found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Bookings found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Booking:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Bookings', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => 'List Bookings',
        // 'supports' => array( 'title', 'editor', 'author', 'thumbnail','comments','excerpt'/*, 'post-formats'*/),
        'supports' => array( '' ),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-calendar-alt',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => false,
        'rewrite' => array( 'slug' => __('booking','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'lbooking', $args );
}

//Register Booking 
add_action( 'init', 'citybook_addons_register_cpt_Listing_Booking' );

// modify booking columns
function citybook_addons_lbooking_columns_head($defaults) {
    unset($defaults['date']);
    unset($defaults['title']);
    unset($defaults['author']);
    unset($defaults['comments']);
    $defaults['ID']             = __('Booking','citybook-add-ons');
    $defaults['listing']             = __('Listing','citybook-add-ons');
    $defaults['status']             = __('Status','citybook-add-ons');
    // $defaults['lb_gateway']       =  __('Payment Getway','cth-gather-plugins');
    // $defaults['lb_pass']       =  __('Plan','cth-gather-plugins');
    // $defaults['lb_status']     = __('Status','cth-gather-plugins');
    
    $defaults['lb_quantity']   = __('Quantity','citybook-add-ons');
    // $defaults['lb_currency']   = __('Currency','cth-gather-plugins');
    $defaults['lb_date']   = __('Booking Date','citybook-add-ons');
    return $defaults;
}

function citybook_addons_lbooking_columns_content($column_name, $post_ID) {
    //echo '<pre>';var_dump(get_post_meta( $post_ID, '', false ));die;
    if ($column_name == 'ID') {
        //$res_pre_fname = get_post_meta( $post_ID, 'pre_fname', true );
        //echo intval($res_date);
        echo '<div class="tips">';
        echo '<a href="'.admin_url('post.php?post='.$post_ID.'&action=edit' ).'"><strong>#'.$post_ID.'</strong></a>';
        echo __(' by ','citybook-add-ons'). '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'lb_name', true ).'</strong>';
        echo '<br><small class="meta email"><a href="mailto:'.get_post_meta( $post_ID, P_META_PREFIX.'lb_email', true ).'">'.get_post_meta( $post_ID, P_META_PREFIX.'lb_email', true ).'</a></small>';
        echo '</div>';
    }
    if ($column_name == 'listing') {
        $listing = get_post( get_post_meta( $post_ID, P_META_PREFIX.'listing_id', true ) );
        if (null != $listing) echo '<strong>'.$listing->post_title.'</strong>';
    }
    if ($column_name == 'status') {
        echo '<strong>'.citybook_addons_get_booking_status_text(get_post_meta( $post_ID, P_META_PREFIX.'lb_status', true )).'</strong>';
        
    }
    // if ($column_name == 'lb_gateway') {
    //     echo '<strong>'.get_post_meta( $post_ID, 'lb_gateway', true ).'</strong>';
        
    // }
    // if ($column_name == 'lb_pass') {
    //     echo '<strong>'.get_post_meta( $post_ID, 'lb_pass', true ).'</strong>';
        
    // }
    if ($column_name == 'lb_quantity') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'lb_quantity', true ).'</strong>';
        
    }
    
    // if ($column_name == 'lb_currency') {
    //     echo '<strong>'.get_post_meta( $post_ID, 'lb_currency', true ).'</strong>';
        
    // }
    if ($column_name == 'lb_date') {
        // echo '<strong>'.date(get_option('date_format' ) . get_option('time_format' ), get_post_meta( $post_ID, P_META_PREFIX.'lb_date', true ) ).'</strong>';
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'lb_date', true ).' '.get_post_meta( $post_ID, P_META_PREFIX.'lb_time', true ).'</strong>';
        
    }
}


add_filter('manage_lbooking_posts_columns', 'citybook_addons_lbooking_columns_head');
add_action('manage_lbooking_posts_custom_column', 'citybook_addons_lbooking_columns_content', 10, 2);


function citybook_addons_get_booking_statuses_array($defauls = array() ) {
    if(empty($defauls)){
        $defauls = array(
            // paypal
            'pending'=> __('Pending','citybook-add-ons'), 
            'completed'=> __('Completed','citybook-add-ons'), 
            'failed'=> __('Failed','citybook-add-ons'), 
            'refunded'=> __('Refunded','citybook-add-ons'), 
            // stripe
            'created'=> __('Created','citybook-add-ons'), 
            'trialing'=>__('Trialing','citybook-add-ons'), 
            'active'=>__('Active','citybook-add-ons'), 
            'past_due'=>__('Past Due','citybook-add-ons'), 
            'canceled'=>__('Canceled','citybook-add-ons') ,
            'unpaid'=>__('Unpaid','citybook-add-ons') 
        );
    }

    return $defauls ;
}
function citybook_addons_get_booking_status_text($status = 'pending'){
    $statuses = citybook_addons_get_booking_statuses_array();
    if(isset($statuses[$status])) return $statuses[$status];
    return $statuses['pending'];
}

// lbooking metabox
function citybook_addons_lbooking_add_meta_box() {
        // add_meta_box(
        //     'lbooking_details',
        //     __( 'Plan Details', 'citybook-add-ons' ),
        //     'citybook_addons_lbooking_meta_box_details_callback',
        //     'lbooking',
        //     'normal',
        //     'core'
        //     //,'normal', //('normal', 'advanced', or 'side')
        //     //'core'//('high', 'core', 'default' or 'low') 
        // );
        add_meta_box(
            'lbooking_customer',
            __( 'Customer Details', 'citybook-add-ons' ),
            'citybook_addons_lbooking_meta_box_customer_details_callback',
            'lbooking',
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );

        
        add_meta_box(
            'lbooking_meta',
            __( 'Booking Meta', 'citybook-add-ons' ),
            'citybook_addons_lbooking_meta_box_meta_callback',
            'lbooking',
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
        add_meta_box(
            'lbooking_status',
            __( 'Booking Status', 'citybook-add-ons' ),
            'citybook_addons_lbooking_meta_box_status_callback',
            'lbooking',
            'side',
            'high'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
}
add_action( 'add_meta_boxes_lbooking', 'citybook_addons_lbooking_add_meta_box' );

function citybook_addons_lbooking_meta_box_customer_details_callback( $post ) {

    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'citybook_addons-lbooking', '_lbooking_nonce' );
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );

    ?>
    <h2><?php _e( 'Customer details', 'citybook-add-ons' ); ?></h2>
    <p class="lbk-desc"></p>
    <table class="form-table lorder-details">
        <tbody>

            <tr class="hoz">
                <th class="w20"><?php _e( 'First Name', 'citybook-add-ons' ); ?></th>
                <td><a href="<?php echo get_edit_user_link( get_post_meta( $post->ID, P_META_PREFIX.'user_id', true ) ); ?>"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_name', true ); ?></a></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Email', 'citybook-add-ons' ); ?></th>
                <td><a href="mailto:<?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_email', true ); ?>"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_email', true ); ?></a></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Phone', 'citybook-add-ons' ); ?></th>
                <td><a href="tel:<?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_phone', true ); ?>"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_phone', true ); ?></a></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Date', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_date', true ); ?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Time', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_time', true ); ?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Quantify', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_quantity', true ); ?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Additional Info', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_add_info', true ); ?></td>
            </tr>
        </tbody>
    </table>
    <?php   
}

function citybook_addons_lbooking_meta_box_meta_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );
    ?>
    <h2><?php _e( 'Booking Meta', 'citybook-add-ons' ); ?></h2>
    <p class="lbk-desc"></p>
    <table class="form-table lorder-details">
        <tbody>

            <tr class="hoz">
                <th class="w20"><?php _e( 'Gateway', 'citybook-add-ons' ); ?></th>
                <td><?php echo citybook_addons_get_order_method_text(get_post_meta( $post->ID, P_META_PREFIX.'payment_method', true ));?></td>
            </tr>
            <?php 
            if( 'woo' == get_post_meta( $post->ID, P_META_PREFIX.'payment_method', true ) ):
            ?>
            <tr class="hoz">
                <th class="w20"><?php _e( 'WooCommerce Order', 'citybook-add-ons' ); ?></th>
                <td><a href="<?php echo get_edit_post_link( get_post_meta( $post->ID, P_META_PREFIX.'woo_order', true ) ); ?>"><?php echo sprintf( __( '#%s', 'citybook-add-ons' ), get_post_meta( $post->ID, P_META_PREFIX.'woo_order', true ) ); ?></a></td>
            </tr>
            <?php endif; ?>

            
            <tr class="hoz">
                <th class="w20"><?php _e( 'Note', 'citybook-add-ons' ); ?></th>
                <td>
                    <textarea name="lb_notes" id="lb_notes" cols="30" rows="5" class="w100"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'lb_notes', true );?></textarea>
                </td>
            </tr>


        </tbody>
    </table>
    <?php   
}
function citybook_addons_lbooking_meta_box_status_callback( $post ) {
    /*
     * Use get_post_meta() to retrieve an existing value
     * from the database and use the value for the form.
     */
    $value = get_post_meta( $post->ID, P_META_PREFIX.'lb_status', true );

    $status = citybook_addons_get_booking_statuses_array();
    ?>
    <table class="form-table lorder-details">
        <tbody>
            <tr class="hoz">
                <td>
                    <select name="lb_status" class="w100">
                    <?php 
                    foreach ($status as $sts => $lbl) {
                        echo '<option value="'.$sts.'" '.selected( $value, $sts, false ).'>'.$lbl.'</option>';
                    }
                    ?>
                    </select>
                </td>
            </tr>
            
        </tbody>
    </table>
    <?php
}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function citybook_addons_lbooking_save_meta_box_datas( $post_id ) {

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // If this is just a revision, don't send the email.
    if ( wp_is_post_revision( $post_id ) )
        return;

    // Check if our nonce is set.
    if ( ! isset( $_POST['_lbooking_nonce'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $_POST['_lbooking_nonce'], 'citybook_addons-lbooking' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    if(isset($_POST['lb_notes'])){
        $new_val = sanitize_textarea_field( $_POST['lb_notes'] ) ;
        $origin_val = get_post_meta( $post_id, P_META_PREFIX.'lb_notes', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, P_META_PREFIX.'lb_notes', $new_val );
        }
        
    }

    
    if(isset($_POST['lb_status'])){
        $new_status = sanitize_text_field( $_POST['lb_status'] ) ;
        $origin_status = get_post_meta( $post_id, P_META_PREFIX.'lb_status', true );
        if($new_status !== $origin_status){
            update_post_meta( $post_id, P_META_PREFIX.'lb_status', $new_status );

            // unhook this function so it doesn't loop infinitely
            remove_action( 'save_post_lbooking', 'citybook_addons_lbooking_save_meta_box_datas', 10, 1 );
                do_action('citybook_addons_lbooking_change_status_'.$origin_status.'_to_'.$new_status, $post_id );
                do_action('citybook_addons_lbooking_change_status_to_'.$new_status, $post_id );
            // re-hook this function
            add_action( 'save_post_lbooking', 'citybook_addons_lbooking_save_meta_box_datas', 10, 1  );
                
        }
    }
}
add_action( 'save_post_lbooking', 'citybook_addons_lbooking_save_meta_box_datas', 10, 1 );


// manually change order status to completed
function citybook_addons_lbooking_change_status_to_completed_callback($booking_id = 0){
    if(is_numeric($booking_id)&&(int)$booking_id > 0){
        $listing_id = get_post_meta( $booking_id, P_META_PREFIX.'listing_id', true );

        if( citybook_addons_get_option('booking_author_woo') == 'yes' && get_post_meta( $booking_id, P_META_PREFIX.'woo_order', true ) != '' ){
            $woo_order = wc_get_order( get_post_meta( $booking_id, P_META_PREFIX.'woo_order', true ) );
            if(!empty($woo_order)){
                $woo_order->update_status( 'completed' , __( 'Administrator has approved this payment.', 'citybook-add-ons' ) );
            }
        }else{
            if ( !update_post_meta( $booking_id, P_META_PREFIX.'lb_status',  'completed'  ) ) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update booking status to completed failure" . PHP_EOL, 3, CTH_LOG_FILE);
            }else{
                // push customer notification
                $customer = get_user_by( 'email', get_post_meta( $booking_id, P_META_PREFIX.'lb_email', true ) );
                if ( ! empty( $customer ) ) {
                    if( citybook_addons_get_option('db_hide_bookings') != 'yes' ){
                        citybook_addons_user_add_notification($customer->ID, array(
                            'type' => 'booking_approved',
                            'message' => sprintf(__( 'Your booking for <strong>%s</strong> listing has been approved.', 'citybook-add-ons' ), get_post_field('post_title', $listing_id) )
                        ));
                    }
                        
                }
                do_action( 'citybook_addons_edit_booking_approved', $booking_id );

            }
        }
    }        
}
add_action( 'citybook_addons_lbooking_change_status_to_completed', 'citybook_addons_lbooking_change_status_to_completed_callback', 10, 1 );


// booking listing
add_action('wp_ajax_nopriv_citybook_addons_booking_listing', 'citybook_addons_booking_listing_callback');
add_action('wp_ajax_citybook_addons_booking_listing', 'citybook_addons_booking_listing_callback');

function citybook_addons_booking_listing_callback() {
    $json = array(
        'success' => true,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    
    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $slid = $_POST['slid'];
    if(is_numeric($slid) && (int)$slid > 0){
        // $booking_title = __( 'Listing booking from %s', 'citybook-add-ons' );
        $booking_title = __( '%1$s booking from %2$s', 'citybook-add-ons' );
        $booking_datas = array();
        $booking_metas_loggedin = array();
		if(isset($_POST['lb_name'])&&isset($_POST['lb_email']) ){
		    $booking_datas['post_title'] = sprintf( $booking_title, get_the_title( $slid ), $_POST['lb_name'] );
		}else{
            $current_user = wp_get_current_user();
            if(0 == $current_user->ID){ // no logged in user and invalid form
                $json['success'] = false;
                $json['data']['error'] = __( 'Invalid booking form without name and email.', 'citybook-add-ons' );
                
            }else{
                // $booking_datas['post_title'] = sprintf( $booking_title, $current_user->display_name );
                $booking_datas['post_title'] = sprintf( $booking_title, get_the_title( $slid ), $current_user->display_name );

                $booking_metas_loggedin['user_id'] = $current_user->ID;
                $booking_metas_loggedin['lb_name'] = $current_user->display_name;
                $booking_metas_loggedin['lb_email'] = $current_user->user_email;
                $booking_metas_loggedin['lb_phone'] = get_user_meta($current_user->ID,  P_META_PREFIX.'phone', true );
            }
            
		}
		$booking_datas['post_content'] = '';
		//$booking_datas['post_author'] = '0';// default 0 for no author assigned
		$booking_datas['post_status'] = 'publish';
		$booking_datas['post_type'] = 'lbooking';

		do_action( 'citybook_addons_insert_booking_before', $booking_datas );

		$booking_id = wp_insert_post($booking_datas ,true );

		if (!is_wp_error($booking_id)) {
		    //print( $booking_id->get_error_message() );
		    // $json['data']['booking_id'] = $booking_id;
            $meta_fields = array(
                // 'listing_id' => 'text', listing_id will be set manually
                'lb_name'               => 'text',
                'lb_email'              => 'text',
                'lb_phone'              => 'text',

                'lb_quantity'           => 'text',
                'lb_date'               => 'text',
                'lb_time'               => 'text',
                'lb_add_info'           => 'text',
                'lb_booking_type'       => 'text',
            );
            $booking_metas = array();
            foreach($meta_fields as $field => $ftype){
                if(isset($_POST[$field])) $booking_metas[$field] = $_POST[$field] ;
                else{
                    if($ftype == 'array'){
                        $booking_metas[$field] = array();
                    }else{
                        $booking_metas[$field] = '';
                    }
                } 
            }
            $booking_metas['listing_id'] = $slid;
            $booking_metas['lb_status'] = 'pending'; // pending - completed - failed - refunded - canceled

            // user id for non logged in user, will be override with loggedin info
            $booking_metas['user_id'] = 0;
            
            // merge with logged in customser data
            $booking_metas = array_merge($booking_metas,$booking_metas_loggedin);

            // woo payment
            $booking_metas['payment_method'] = 'woo'; // banktransfer - paypal - stripe - woo

            // $cmb_prefix = '_cth_';
            foreach ($booking_metas as $key => $value) {
                // https://codex.wordpress.org/Function_Reference/update_post_meta
                // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
                // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                if ( !update_post_meta( $booking_id, P_META_PREFIX.$key,  $value  ) ) {
                    $json['data'][] = sprintf(__('Insert booking %s meta failure or existing meta value','citybook-add-ons'),$key);
                    // wp_send_json($json );
                }
            }
            // add _price for woo
            $listing_price = get_post_meta( $slid, P_META_PREFIX.'price_from', true );
            if( $listing_price != '' && is_numeric($listing_price) ){
                update_post_meta( $booking_id, '_price',  $listing_price );

                if( citybook_addons_get_option('add_cart_delay') < 300000 ){
                    $quantity = (isset($_POST['lb_quantity']) && is_numeric($_POST['lb_quantity']) && $_POST['lb_quantity'] )? $_POST['lb_quantity'] : 1;
                    $json['data']['url'] = citybook_addons_get_add_to_cart_url( $booking_id, $quantity );
                }
                    
            }
            // $json['data']['booking_metas'] = $booking_metas;

            $json['data']['message'] = apply_filters( 'citybook_addons_insert_booking_message', __( 'Your booking is received. The listing author will contact with you soon.<br>You can also login with your email to manage bookings.<br>Thank you.', 'citybook-add-ons' ) );

            do_action( 'citybook_addons_insert_booking_after', $booking_id );
		}else{
            $json['success'] = false;
			$json['data']['error'] = $booking_id->get_error_message();

			if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert booking post error: " . $booking_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);

		    // throw new Exception($booking_id->get_error_message());

		}

    }else{
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'The listing id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

// cancel booking
add_action('wp_ajax_nopriv_citybook_addons_cancel_lbooking', 'citybook_addons_cancel_lbooking_callback');
add_action('wp_ajax_citybook_addons_cancel_lbooking', 'citybook_addons_cancel_lbooking_callback');

function citybook_addons_cancel_lbooking_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $bkid = $_POST['bkid'];
    if(is_numeric($bkid) && (int)$bkid > 0){
        $current_user = wp_get_current_user(); 
        if($current_user->user_email != get_post_meta( $bkid, P_META_PREFIX.'lb_email', true ) ){
            $json['data'][] = __( "You don't have permission to this booking", 'citybook-add-ons' );
            wp_send_json($json );
        }
        if ( !update_post_meta( $bkid, P_META_PREFIX.'lb_status',  'canceled'  ) ) {
            $json['data'][] = sprintf(__('Insert booking %s meta failure or existing meta value','citybook-add-ons'),'lb_status');
        }else{
            $json['success'] = true;
        }
    }else{
        
        $json['data']['error'] = esc_html__( 'The post id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}

// approve booking
add_action('wp_ajax_nopriv_citybook_addons_approve_lbooking', 'citybook_addons_approve_lbooking_callback');
add_action('wp_ajax_citybook_addons_approve_lbooking', 'citybook_addons_approve_lbooking_callback');

function citybook_addons_approve_lbooking_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $bkid = $_POST['bkid'];
    if(is_numeric($bkid) && (int)$bkid > 0){
        $listing_id = get_post_meta( $bkid, P_META_PREFIX.'listing_id', true );
        if(get_current_user_id() != get_post_field('post_author', $listing_id) ){
            $json['data'][] = __( "You don't have permission to approve this booking", 'citybook-add-ons' );
            $json['data']['user'] = get_current_user_id();
            $json['data']['author'] = get_post_field('post_author', $listing_id);
            wp_send_json($json );
        }

        if( citybook_addons_get_option('booking_author_woo') == 'yes' && get_post_meta( $bkid, P_META_PREFIX.'woo_order', true ) != '' ){
            $woo_order = wc_get_order( get_post_meta( $bkid, P_META_PREFIX.'woo_order', true ) );
            if(!empty($woo_order)){
                $woo_order->update_status( 'completed' , __( 'Listing author has approved this payment.', 'citybook-add-ons' ) );
            }
        }else{
            if ( !update_post_meta( $bkid, P_META_PREFIX.'lb_status',  'completed'  ) ) {
                $json['data'][] = sprintf(__('Insert booking %s meta failure or existing meta value','citybook-add-ons'),'lb_status');
            }else{
                $json['success'] = true;
                // push customer notification
                $customer = get_user_by( 'email', get_post_meta( $bkid, P_META_PREFIX.'lb_email', true ) );
                if ( ! empty( $customer ) ) {
                    if( citybook_addons_get_option('db_hide_bookings') != 'yes' ){
                        citybook_addons_user_add_notification($customer->ID, array(
                            'type' => 'booking_approved',
                            'message' => sprintf(__( 'Your booking for <strong>%s</strong> listing has been approved.', 'citybook-add-ons' ), get_post_field('post_title', $listing_id) )
                        ));
                    }
                    
                }
                do_action( 'citybook_addons_edit_booking_approved', $bkid );

            }
        }
            
    }else{
        
        $json['data']['error'] = esc_html__( 'The booking id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}	

// approve booking
add_action('wp_ajax_nopriv_citybook_addons_delete_lbooking', 'citybook_addons_delete_lbooking_callback');
add_action('wp_ajax_citybook_addons_delete_lbooking', 'citybook_addons_delete_lbooking_callback');

function citybook_addons_delete_lbooking_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            // 'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['success'] = false;
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }


    $bkid = $_POST['bkid'];
    if(is_numeric($bkid) && (int)$bkid > 0){
        $listing_id = get_post_meta( $bkid, P_META_PREFIX.'listing_id', true );
        if(get_current_user_id() != get_post_field('post_author', $listing_id) || citybook_addons_get_option('booking_author_delete') != 'yes' ){
            $json['data']['error'] = __( "You don't have permission to approve this booking", 'citybook-add-ons' );
            $json['data']['user'] = get_current_user_id();
            $json['data']['author'] = get_post_field('post_author', $listing_id);
            wp_send_json($json );
        }

        $force_delete = citybook_addons_get_option('booking_del_trash') == 'yes' ? false : true;
        $deleted_post = wp_delete_post( $bkid, $force_delete );
        if($deleted_post){
            $json['data']['deleted_booking'] = $deleted_post;
            $json['success'] = true;
        }else{
            $json['data']['error'] = esc_html__( 'Delete booking failure', 'citybook-add-ons' ) ;
        }
            
    }else{
        
        $json['data']['error'] = esc_html__( 'The booking id is incorrect.', 'citybook-add-ons' ) ;
    }

    wp_send_json($json );

}   



