<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */




function citybook_addons_register_cpt_CTH_ADs() {
    
    $labels = array( 
        'name' => __( 'ADs', 'citybook-add-ons' ),
        'singular_name' => __( 'AD', 'citybook-add-ons' ),
        'add_new' => __( 'Add New AD', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New AD', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit AD', 'citybook-add-ons' ),
        'new_item' => __( 'New AD', 'citybook-add-ons' ),
        'view_item' => __( 'View AD', 'citybook-add-ons' ),
        'search_items' => __( 'Search ADs', 'citybook-add-ons' ),
        'not_found' => __( 'No ADs found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No ADs found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent AD:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing ADs', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => false,
        'description' => __( 'Listing author ads', 'citybook-add-ons' ),
        'supports' => array( 'title'),
        'taxonomies' => array(),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,//default from show_ui
        'menu_position' => 25,
        'menu_icon' => 'dashicons-forms',
        'show_in_nav_menus' => false,
        'publicly_queryable' => false,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => false,
        'can_export' => false,
        'rewrite' => array( 'slug' => __('cthads','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'cthads', $args );
}

//Register Booking 
add_action( 'init', 'citybook_addons_register_cpt_CTH_ADs' );



function citybook_addons_register_taxonomy_cthads_package() {

    // Add new taxonomy, make it hierarchical like categories
    //first do the translations part for GUI

    $labels = array(
        'name' => __( 'ADs Package', 'citybook-add-ons' ),
        'singular_name' => __( 'ADs Package', 'citybook-add-ons' ),
        'search_items' =>  __( 'Search ADs Packages','citybook-add-ons' ),
        'all_items' => __( 'All ADs Packages','citybook-add-ons' ),
        'parent_item' => __( 'Parent ADs Package','citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent ADs Package:','citybook-add-ons' ),
        'edit_item' => __( 'Edit ADs Package','citybook-add-ons' ), 
        'update_item' => __( 'Update ADs Package','citybook-add-ons' ),
        'add_new_item' => __( 'Add New ADs Package','citybook-add-ons' ),
        'new_item_name' => __( 'New ADs Package Name','citybook-add-ons' ),
        'menu_name' => __( 'ADs Packages','citybook-add-ons' ),
    );     

    // Now register the taxonomy

    register_taxonomy('cthads_package',array('cthads'), array(
        'hierarchical' => false,
        'labels' => $labels,
        'public' => false,
        'show_ui' => true,
        'show_in_nav_menus'=> false,
        'show_admin_column' => true,
        'query_var' => false,
        'rewrite' => array( 'slug' => __('cthads_package','citybook-add-ons') ),
        // https://codex.wordpress.org/Roles_and_Capabilities
        // 'capabilities' => array(
        //     'manage_terms' => 'manage_categories',
        //     'edit_terms' => 'manage_categories',
        //     'delete_terms' => 'manage_categories',
        //     'assign_terms' => 'edit_posts'
        // ),

    ));

}

//Add Listing Category
    
add_action( 'init', 'citybook_addons_register_taxonomy_cthads_package', 0 );




// modify order columns
function citybook_addons_cthads_columns_head($defaults) {
    unset($defaults['date']);
    // unset($defaults['title']);
    unset($defaults['author']);
    unset($defaults['comments']);
    // $defaults['ID']             = __('Order','citybook-add-ons');
    // $defaults['plan']             = __('Plan','citybook-add-ons');
    $defaults['status']             = __('Status','citybook-add-ons');

    // $defaults['plan']   = __('Plan','citybook-add-ons');

    // $defaults['lo_gateway']       =  __('Payment Getway','citybook-add-ons');
    // $defaults['quantity']   = __('Quantity','citybook-add-ons');
    // $defaults['lo_date']   = __('Order Date','citybook-add-ons');
    // $defaults['amount']   = __('Total','citybook-add-ons');
    

    
    $defaults['ad_pos']   = __('AD Positions','citybook-add-ons');


    $defaults['from_date']   = __('Active Date','citybook-add-ons');
    $defaults['end_date']   = __('Expire Date','citybook-add-ons');

    // $defaults['payment_count']   = __('Payment Count','citybook-add-ons');

    return $defaults;
}

function citybook_addons_cthads_columns_content($column_name, $post_ID) {
    // if ($column_name == 'ID') {
    //     echo '<div class="tips">';
    //     echo '<a href="'.admin_url('post.php?post='.$post_ID.'&action=edit' ).'"><strong>#'.$post_ID.'</strong></a>';
    //     echo __(' by ','citybook-add-ons'). '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'first_name', true ). ' '.get_post_meta( $post_ID, P_META_PREFIX.'last_name', true ).'</strong>';
    //     echo '<br><small class="meta email"><a href="mailto:'.get_post_meta( $post_ID, P_META_PREFIX.'email', true ).'">'.get_post_meta( $post_ID, P_META_PREFIX.'email', true ).'</a></small>';
    //     echo '</div>';
    // }
    // if ($column_name == 'plan') {
    //     $plan = get_post( get_post_meta( $post_ID, P_META_PREFIX.'plan_id', true ) );
    //     if (null != $plan) echo '<strong>'.$plan->post_title.'</strong>';
    // }
    if ($column_name == 'status') {
        echo '<strong>'.citybook_addons_get_booking_status_text(get_post_meta( $post_ID, P_META_PREFIX.'status', true )).'</strong>';
        
    }
    if ($column_name == 'lo_gateway') {
        echo '<strong>'.citybook_addons_get_order_method_text(get_post_meta( $post_ID, P_META_PREFIX.'payment_method', true )).'</strong>';
        
    }
    
    // if ($column_name == 'quantity') {
    //     echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'quantity', true ).'</strong>';
        
    // }
    
    if ($column_name == 'lo_date') {
        echo '<strong>'.get_the_date( get_option('date_format' ), $post_ID ).'</strong>';
        
    }

    if ($column_name == 'amount') {
        echo '<strong>'.citybook_addons_get_price_formated( get_post_meta( $post_ID, P_META_PREFIX.'amount', true ) ).'</strong>';
        
    }

    // if ($column_name == 'payment_count') {
    //     echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'payment_count', true ).'</strong>';
        
    // }

    // if ($column_name == 'plan') {
    //     $plan_title = __( 'Deleted Plan', 'citybook-add-ons' );
    //     $plan_id = get_post_meta( $post_ID, P_META_PREFIX.'plan_id', true);
    //     if(get_post_meta( $post_ID, P_META_PREFIX.'order_type', true) == 'listing_ad'){
    //         $ad_package = get_term( $plan_id, 'cthads_package' );
    //         if ( !empty( $ad_package ) && !is_wp_error( $ad_package ) ) $plan_title = $ad_package->name;
    //     }else{
    //         $plan_post = get_post($plan_id);
    //         if(!empty($plan_post)) $plan_title = $plan_post->post_title;
    //     }

    //     echo '<strong>'.$plan_title.'</strong>'; 
    // }

    if ($column_name == 'ad_pos') {
        $listing_id = get_post_meta( $post_ID, P_META_PREFIX.'listing_id', true );
        foreach (citybook_addons_listing_ad_positions() as $pos => $lbl) {
            if( get_post_meta( $listing_id, P_META_PREFIX.'ad_position_'.$pos, true ) == 'yes' ){
                echo '<strong>'.$lbl.'</strong><br>';
            }
        }
        
        
    }

    if ($column_name == 'from_date') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'from_date', true ).'</strong>';
        
    }

    if ($column_name == 'end_date') {
        echo '<strong>'.get_post_meta( $post_ID, P_META_PREFIX.'end_date', true ).'</strong>';
        
    }

    

}


add_filter('manage_cthads_posts_columns', 'citybook_addons_cthads_columns_head');
add_action('manage_cthads_posts_custom_column', 'citybook_addons_cthads_columns_content', 10, 2);

// order metabox

function citybook_addons_cthads_add_meta_box() {

    // $screens = array( 'cthads');

    // foreach ( $screens as $screen ) {

        add_meta_box(
            'cthads_details',
            __( 'AD Package Details', 'citybook-add-ons' ),
            'citybook_addons_cthads_meta_box_payment_details_callback',
            'cthads',
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
        add_meta_box(
            'cthads_customer',
            __( 'Customer Details', 'citybook-add-ons' ),
            'citybook_addons_cthads_meta_box_customer_details_callback',
            'cthads',
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );

        
        add_meta_box(
            'cthads_meta',
            __( 'AD Meta', 'citybook-add-ons' ),
            'citybook_addons_cthads_meta_box_payment_meta_callback',
            'cthads',
            'normal',
            'core'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
        // add_meta_box(
        //     'cthads_note',
        //     __( 'Registration Note', 'cth-gather-plugins' ),
        //     'citybook_addons_cthads_meta_box_payment_note_callback',
        //     $screen,
        //     'normal',
        //     'core'
        //     //,'normal', //('normal', 'advanced', or 'side')
        //     //'core'//('high', 'core', 'default' or 'low') 
        // );

        add_meta_box(
            'cthads_status',
            __( 'AD Status', 'citybook-add-ons' ),
            'citybook_addons_cthads_meta_box_paymeny_status_callback',
            'cthads',
            'side',
            'high'
            //,'normal', //('normal', 'advanced', or 'side')
            //'core'//('high', 'core', 'default' or 'low') 
        );
    // }

    
}
add_action( 'add_meta_boxes_cthads', 'citybook_addons_cthads_add_meta_box' );

function citybook_addons_cthads_meta_box_payment_details_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    wp_nonce_field( 'citybook_addons-cthads', '_cthads_nonce' );

    $plan_title = __( 'Deleted Package', 'citybook-add-ons' );
    $plan_id = get_post_meta( $post->ID, P_META_PREFIX.'plan_id', true);
    $prices             = citybook_addons_get_plan_prices($plan_id);
    

    $ad_package = get_term( $plan_id, 'cthads_package' );
    if ( !empty( $ad_package ) && !is_wp_error( $ad_package ) ){
        $plan_title         = $ad_package->name;
        $prices             = citybook_addons_get_plan_prices(0, get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_price', true ) );

    } 

    

    ?>
    <table class="form-table cthads-details">
        <thead>
            <tr>
                <th class="lod-plan"><?php _e( 'Package', 'citybook-add-ons' );?></th>
                <th class="lod-price"><?php _e( 'Price', 'citybook-add-ons' );?></th>
                <th class="lod-quantity"><?php _e( 'Quantity', 'citybook-add-ons' );?></th>
                <th class="lod-amount"><?php _e( 'Amount', 'citybook-add-ons' );?></th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="lod-plan"><?php echo $plan_title; ?></td>
                <td class="lod-price"><?php echo citybook_addons_get_price_formated( $prices['price'] ); ?></td>
                <td class="lod-quantity"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'quantity', true ); ?></td>
                <td class="lod-amount"><?php echo citybook_addons_get_price_formated( $prices['total'] ); ?></td>
                
            </tr>
        </tbody>
    </table>
    <?php   
}
function citybook_addons_cthads_meta_box_customer_details_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );

    ?>
    <table class="form-table cthads-details">
        <tbody>

            <tr class="hoz">
                <th class="w20"><?php _e( 'First Name', 'citybook-add-ons' ); ?></th>
                <td><a href="<?php echo get_edit_user_link( get_post_meta( $post->ID, P_META_PREFIX.'user_id', true ) ); ?>"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'first_name', true ); ?></a></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Email', 'citybook-add-ons' ); ?></th>
                <td><a href="mailto:<?php echo get_post_meta( $post->ID, P_META_PREFIX.'email', true ); ?>"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'email', true ); ?></a></td>
            </tr>
        </tbody>
    </table>
    <?php   
}

function citybook_addons_cthads_meta_box_payment_meta_callback( $post ) {

    
    // Add a nonce field so we can check for it later.
    // wp_nonce_field( 'cth_gather_plugins_save_meta_box_data', 'cth_gather_plugins_meta_box_nonce' );
    ?>
    <table class="form-table cthads-details">
        <tbody>

            <tr class="hoz">
                <th class="w20"><?php _e( 'Gateway', 'citybook-add-ons' ); ?></th>
                <td><?php echo citybook_addons_get_order_method_text(get_post_meta( $post->ID, P_META_PREFIX.'payment_method', true ));?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Purchase Code', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_post_meta( $post->ID, P_META_PREFIX.'purchase_code', true );?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Listing', 'citybook-add-ons' ); ?></th>
                <td><?php echo get_the_title(get_post_meta( $post->ID, P_META_PREFIX.'listing_id', true )); ?></td>
            </tr>
            <tr class="hoz">
                <th class="w20"><?php _e( 'Note', 'citybook-add-ons' ); ?></th>
                <td>
                    <textarea name="ad_notes" id="ad_notes" cols="30" rows="5" class="w100"><?php echo get_post_meta( $post->ID, P_META_PREFIX.'ad_notes', true );?></textarea>
                </td>
            </tr>

        </tbody>
    </table>
    <?php   
}
function citybook_addons_cthads_meta_box_paymeny_status_callback( $post ) {

    

    /*
     * Use get_post_meta() to retrieve an existing value
     * from the database and use the value for the form.
     */
    $value = get_post_meta( $post->ID, P_META_PREFIX.'status', true );

    $status = citybook_addons_get_ad_statuses();
    ?>
    <table class="form-table cthads-details">
        <tbody>
            <tr class="hoz">
                <td>
                    <select name="ad_status" class="w100">
                    <?php 
                    foreach ($status as $sts => $lbl) {
                        echo '<option value="'.$sts.'" '.selected( $value, $sts, false ).'>'.$lbl.'</option>';
                    }
                    ?>
                    </select>
                </td>
            </tr>
            
        </tbody>
    </table>
    <?php
}

/**
 * When the post is saved, saves our custom data.
 *
 * @param int $post_id The ID of the post being saved.
 */
function citybook_addons_cthads_save_meta_box_datas( $post_id ) {

    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // If this is just a revision, don't send the email.
    if ( wp_is_post_revision( $post_id ) )
        return;

    // Check if our nonce is set.
    if ( ! isset( $_POST['_cthads_nonce'] ) ) {
        return;
    }

    // Verify that the nonce is valid.
    if ( ! wp_verify_nonce( $_POST['_cthads_nonce'], 'citybook_addons-cthads' ) ) {
        return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
        return;
    }

    

    // Check the user's permissions.
    if ( ! current_user_can( 'edit_post', $post_id ) ) {
        return;
    }

    if(isset($_POST['ad_notes'])){
        $new_val = sanitize_textarea_field( $_POST['ad_notes'] ) ;
        $origin_val = get_post_meta( $post_id, P_META_PREFIX.'ad_notes', true );
        if($new_val !== $origin_val){
            update_post_meta( $post_id, P_META_PREFIX.'ad_notes', $new_val );
        }
        
    }

    
    if(isset($_POST['ad_status'])){
        $new_status = sanitize_text_field( $_POST['ad_status'] ) ;
        $origin_status = get_post_meta( $post_id, P_META_PREFIX.'status', true );
        if($new_status !== $origin_status){
            update_post_meta( $post_id, P_META_PREFIX.'status', $new_status );

            // unhook this function so it doesn't loop infinitely
            remove_action( 'save_post_cthads', 'citybook_addons_cthads_save_meta_box_datas', 10, 1 );
                do_action('citybook_addons_cthads_change_status_'.$origin_status.'_to_'.$new_status, $post_id );
                do_action('citybook_addons_cthads_change_status_to_'.$new_status, $post_id );
            // re-hook this function
            add_action( 'save_post_cthads', 'citybook_addons_cthads_save_meta_box_datas', 10, 1  );
                
        }
    }
}
add_action( 'save_post_cthads', 'citybook_addons_cthads_save_meta_box_datas', 10, 1 ); 


function citybook_addons_get_ad_statuses($status = '' ) {
    $statuses = array(
        // paypal
        'pending'=> __('Pending','citybook-add-ons'), 
        'completed'=> __('Completed','citybook-add-ons'), 
        'failed'=> __('Failed','citybook-add-ons'), 
        'refunded'=> __('Refunded','citybook-add-ons'), 
        // stripe
        'created'=> __('Created','citybook-add-ons'), 
        'trialing'=>__('Trialing','citybook-add-ons'), 
        'active'=>__('Active','citybook-add-ons'), 
        'past_due'=>__('Past Due','citybook-add-ons'), 
        'canceled'=>__('Canceled','citybook-add-ons') ,
        'unpaid'=>__('Unpaid','citybook-add-ons') ,


        'disable'=>__('Disable this AD','citybook-add-ons') ,
    );
    if(!empty($status) && isset($statuses[$status])) return $statuses[$status];

    return $statuses;
}







