<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



// process listing checkout
function citybook_addons_process_ad_campaign_checkout(){
    
    // listing ad
    if(isset($_POST['ad_checkout']) && isset($_POST['listing-id']) && isset($_POST['ad-package']) && isset($_POST['payment-method']) && isset($_POST['_wpnonce'])){
    
        if ( ! wp_verify_nonce( $_POST['_wpnonce'], 'listing-checkout' ) ){ 
            die ( '<p class="error">Security checked!, Cheatn huh?</p>' );
        }
        $listing_id = $_POST['listing-id'];

        $current_user = wp_get_current_user(); 

        $listing_post = get_post($listing_id);
        // // display none on incorrect listing or not authorize listing item
        if(null == $listing_post ) return;
        // ad package term
        $ad_package = get_term( $_POST['ad-package'], 'cthads_package' );
        // display none on incorrect plan
        if ( empty( $ad_package ) || is_wp_error( $ad_package ) ) return;

        $raw_price = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_price', true );
        $var_ad_title = $ad_package->name;
        $var_ad_id = $ad_package->term_id;

        $prices = citybook_addons_get_plan_prices(0, $raw_price);

        // add new ad to back-end
        $cthads_datas = array();
        $cthads_datas['post_title'] = sprintf(__( '%1$s for %2$s', 'citybook-add-ons' ), $var_ad_title, $listing_post->post_title);
        $cthads_datas['post_content'] = '';
        $cthads_datas['post_author'] = $current_user->ID;
        $cthads_datas['post_status'] = 'publish';
        $cthads_datas['post_type'] = 'cthads';

        $cthads_datas['tax_input']['cthads_package'] = array($ad_package->term_id);

        do_action( 'citybook_addons_insert_ad_before', $cthads_datas );

        $cthads_id = wp_insert_post($cthads_datas ,true );

        if (!is_wp_error($cthads_id)) {

            // increase ad pacakge pm_count - payment count
            $plan_pm_count = get_term_meta( $var_ad_id , P_META_PREFIX.'pm_count', true );
            $plan_pm_count += 1;
            update_term_meta( $var_ad_id , P_META_PREFIX.'pm_count', $plan_pm_count );

            $is_recurring_plan = get_term_meta( $var_ad_id , P_META_PREFIX.'is_recurring', true );
           
            $cthads_metas = array(
                'listing_id'                    => $listing_id, // listing id
                'plan_id'                       => $var_ad_id, // ad package id
                'amount'                        => $prices['total'],
                'quantity'                      => 1,
                'currency_code'                 => citybook_addons_get_option('currency','USD'),
                'custom'                        => $cthads_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no|subscription_no|ad_yes',
                'user_id'                       => $current_user->ID,
                'email'                         => $current_user->user_email,
                'first_name'                    => $current_user->user_firstname,
                'last_name'                     => $current_user->user_lastname,
                'display_name'                  => $current_user->display_name,



                'payment_method'                => $_POST['payment-method'], // banktransfer - paypal - stripe


                'is_recurring_plan'             => $is_recurring_plan, // is recurring plan



                'is_per_listing_sub'            => 'yes', // is per listing subscription

                // for ad campaign type
                'order_type'                    => 'listing_ad',
            );
            $cthads_metas['status'] = 'pending'; // pending - completed - failed - refunded
            $cthads_metas['payment_count'] = '0';



            // $cmb_prefix = '_cth_';
            foreach ($cthads_metas as $key => $value) {
                // https://codex.wordpress.org/Function_Reference/update_post_meta
                // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. 
                // NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                if ( !update_post_meta( $cthads_id, P_META_PREFIX.$key,  $value  ) ) {
                    // $json['data'][] = sprintf(__('Insert order %s meta failure or existing meta value','citybook-add-ons'),$key);
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). sprintf(__('Insert ad %s meta failure or existing meta value','citybook-add-ons'),$key) . PHP_EOL, 3, CTH_LOG_FILE);
                    // wp_send_json($json );
                }
            }


            do_action( 'citybook_addons_insert_ad_after', $cthads_id, $listing_id, $var_ad_id );
            // check for free plan
            if(empty($prices['total'])){

                if(citybook_addons_get_option('auto_active_free_sub') == 'yes'){
                    $plan_interval = get_term_meta( $var_ad_id, P_META_PREFIX.'ad_interval', true );
                    $plan_period = get_term_meta( $var_ad_id, P_META_PREFIX.'ad_period', true );
                    if($plan_interval){
                        $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
                    }else{
                        $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
                    }

                    $data = array(
                        'user_id'                   => $current_user->ID,
                        'item_number'               => $var_ad_id, // this is listing ad package id
                        'pm_date'                   => current_time('mysql', 1), // Time at which the object was created. Measured in seconds since the Unix epoch.
                        'order_id'                  => $cthads_id,
                        'recurring_subscription'    => false, // not used

                        'txn_id'                    => uniqid('free_add'), // invoice id

                        // for stripe period
                        'payment_method'            => __( 'Free AD', 'citybook-add-ons' ),
                        'period_start'              => current_time('mysql', 1),
                        'period_end'                => $expire,

                        'for_listing_ad'            => 'yes',

                    );
                    citybook_add_ons_active_ad_campaign($data, false);
                }
                // redirect to Paypal
                wp_redirect( home_url('/') );
                exit;

            }else{
            // process payment if not free

                $payment_method = $_POST['payment-method']; // banktransfer - paypal - stripe

                // for paypal method payment
                if($payment_method === 'paypal'){
                    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';

                    $payment_class = new CTH_Payment_Paypal();


                    // modify paypal args for this payment
                    // for recurring - subscription payment
                    if( $is_recurring_plan ){
                        // https://developer.paypal.com/docs/classic/paypal-payments-standard/integration-guide/Appx_websitestandard_htmlvariables/#recurring-payment-variables
                        $paypal_args = array(
                            'cmd'               => '_xclick-subscriptions', // Subscribe button
                            'item_name'         => sprintf(__( 'Payment for %s subscription AD', 'citybook-add-ons' ), $var_ad_title),
                            'item_number'       => $var_ad_id, // ad package id

                            // subscribe
                            'a3'                => $prices['total'], // Regular subscription price.
                            'p3'                => citybook_add_ons_get_paypal_duration( get_term_meta( $var_ad_id, P_META_PREFIX.'ad_interval', true ), get_term_meta( $var_ad_id, P_META_PREFIX.'ad_period', true ) ), // Subscription duration
                            't3'                => citybook_add_ons_get_paypal_duration_unit( get_term_meta( $var_ad_id, P_META_PREFIX.'ad_period', true ) ), // Regular subscription units of duration.
                            /*
                            D. Days. Valid range for p3 is 1 to 90.
                            W. Weeks. Valid range for p3 is 1 to 52.
                            M. Months. Valid range for p3 is 1 to 24.
                            Y. Years. Valid range for p3 is 1 to 5.
                            */
                            'src'               => 1, // Recurring payments. Subscription payments recur unless subscribers cancel their subscriptions before the end of the current billing cycle or you limit the number of times that payments recur with the value that you specify for srt.
                            // 'srt'               => 52, //Recurring times.
                            // 'sra'               => 1, // Reattempt on failure. If a recurring payment fails, PayPal attempts to collect the payment two more times before canceling the subscription.

                            'no_note'           => 1, // Do not prompt buyers to include a note with their payments. Valid value is from Subscribe buttons: For Subscribe buttons, always set no_note to 1.
                            'modify'            => 0, // Modification behavior.
                            /*
                            Valid value is:
                            0. Enables subscribers only to sign up for new subscriptions.
                            1. Enables subscribers to sign up for new subscriptions and modify their current subscriptions.
                            2. Enables subscribers to modify only their current subscriptions.
                            The default value is 0.
                            */




                            // 'amount'            => $prices['total'],
                            // 'quantity'          => 1,
                            'currency_code'     => citybook_addons_get_option('currency','USD'),
                            'custom'            => $cthads_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no|subscription_yes|ad_yes',
                            'business'          => citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
                            
                            'email'             => $current_user->user_email,
                            'first_name'        => $current_user->user_firstname,
                            'last_name'         => $current_user->user_lastname,

                            'notify_url'        => home_url('/?action=cth_ad_ppipn'),
                        
                        );
                    }else{
                        $paypal_args = array(
                            'cmd'               => '_xclick',
                            'item_name'         => sprintf(__( 'Payment for %s AD package', 'citybook-add-ons' ), $var_ad_title),
                            'item_number'       => $var_ad_id, // ad package id
                            'amount'            => $prices['total'],
                            'quantity'          => 1,
                            'currency_code'     => citybook_addons_get_option('currency','USD'),
                            'custom'            => $cthads_id .'|'. $listing_id .'|'. $current_user->ID .'|'. $current_user->user_email .'|renew_no|subscription_no|ad_yes',
                            'business'          => citybook_addons_get_option('payments_paypal_business','cththemespp-facilitator@gmail.com'),
                            'email'             => $current_user->user_email,
                            'first_name'        => $current_user->user_firstname,
                            'last_name'         => $current_user->user_lastname,

                            'notify_url'        => home_url('/?action=cth_ad_ppipn'),
                        
                        );
                    }

                        
                    $paypal_redirect = $payment_class->processBuyNow($paypal_args);

                    // redirect to Paypal
                    wp_redirect( $paypal_redirect ); 
                    exit;
                }elseif($payment_method === 'stripe'){

                    $stripe_local = CTH_DEBUG && $_SERVER['SERVER_NAME'] == 'localhost';

                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Stripe Local: " . $stripe_local . PHP_EOL, 3, CTH_LOG_FILE);
                    
                    // for stripe payment method
                    // load the stripe libraries
                    // require_once CITYBOOK_ADD_ONS_DIR .'inc/classes/stripe-php/init.php';

                    require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';
                    $payment_class = new CTH_Payment_Stripe();

                    $stripeEmail = $_POST['stripeEmail'];
                    // for recurring - subscription payment
                    if( $is_recurring_plan && get_term_meta( $var_ad_id , P_META_PREFIX.'stripe_plan_id', true ) != '' ){

                        $subscription_metas = array(
                            'ctb_plan_id'               => $var_ad_id, // make unique meta key for site identifing
                            'listing_id'                => $listing_id,
                            'order_id'                  => $cthads_id,
                            'user_id'                   => $current_user->ID,
                            'user_email'                => $current_user->user_email,
                            'renew'                     => 'no',
                            'subscription'              => 'yes',

                            'for_listing_ad'            => 'yes',
                        );
                        $stripe_args = array(
                            'items' => array(
                                array(
                                    'plan' => get_term_meta( $var_ad_id , P_META_PREFIX.'stripe_plan_id', true ),
                                    'quantity'  => 1
                                ),
                            ),
                            'metadata'      => $subscription_metas
                        );

                        $subscription_obj = $payment_class->processRecurring($stripe_args);

                        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Stripe subscription object: " . json_encode($subscription_obj) . PHP_EOL, 3, CTH_LOG_FILE);
                        
                        // for local test only
                        if($stripe_local && isset($subscription_obj->status) && $subscription_obj->status === 'active'){
                            citybook_add_ons_active_ad_campaign(
                                array(
                                    'user_id' => $current_user->ID,
                                    'item_number' =>  $var_ad_id, // this is listing plan id
                                    'pm_date' => $subscription_obj->created, // or use start for correction
                                    'order_id' => $cthads_id,
                                    'recurring_subscription' => true, // not used

                                    'txn_id'                    => $subscription_obj->id,
                                    'subscription_id'           => $subscription_obj->id,

                                    'for_listing_ad'            => 'yes',
                                ), 
                                true
                            );
                        }

                    } // end stripe recurring subscription
                    else{
                        
                        $charge_metas = array(
                            'ctb_plan_id'               => $var_ad_id, // make unique meta key for site identifing
                            'listing_id'                => $listing_id,
                            'order_id'                  => $cthads_id,
                            'user_id'                   => $current_user->ID,
                            'user_email'                => $current_user->user_email,
                            'renew'                     => 'no',
                            'subscription'              => 'no',

                            'for_listing_ad'            => 'yes',
                        );
                        $stripe_args = array(
                            // 'customer'   => $customer->id, // will be added from the class
                            'amount'        => citybook_addons_get_stripe_amount( $prices['total'] ),
                            // 'currency'   => citybook_addons_get_option('currency','USD'), // lowercase will be added from the class
                            'description'   => sprintf( __( 'Payment from %s', 'citybook-add-ons' ), $stripeEmail ), 
                            'receipt_email' => $stripeEmail,
                            'metadata'      => $charge_metas
                        );

                        $charge_obj = $payment_class->processOneTime($stripe_args);
                        // for local test only
                        if($stripe_local && isset($charge_obj->status) && $charge_obj->status === 'succeeded'){
                            citybook_add_ons_active_ad_campaign(
                                array(
                                    'user_id' => $current_user->ID,
                                    'item_number' =>  $var_ad_id, // this is listing plan id
                                    'pm_date' => $charge_obj->created, // or use start for correction
                                    'order_id' => $cthads_id,
                                    'recurring_subscription' => false, // not used
                                    // update order transactions
                                    // for one time payment is balance_transaction data
                                    'txn_id'                    => $charge_obj->balance_transaction,

                                    'for_listing_ad'            => 'yes',

                                ), 
                                true
                            );
                        }
                    }


                        
                    

                    // redirect to home page
                    wp_redirect( home_url('/') ); 
                    // wp_redirect( 'https://citybook.cththemes.com' ); 
                    exit;

                    

                }
                // end stripe payment method process
                else{
                    wp_redirect( home_url('/') );
                    exit;

                }
                // end bank transfer method
            }
            // end check for free plan

        }else{
            
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Insert ad post error: " . $cthads_id->get_error_message() . PHP_EOL, 3, CTH_LOG_FILE);

            // throw new Exception($cthads_id->get_error_message());

        }
        // end add new order
        
    }
    // paypal ipn
    if(isset($_GET['action'])){
        

        // listing ad paypal payment ipn
        if($_GET['action'] === 'cth_ad_ppipn'){
            require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-paypal.php';
            $payment_class = new CTH_Payment_Paypal();
            $pm_datas = $payment_class->extractPaymentData();
            // var_dump($pm_datas);

            // 

            // if($payment_class->validateIPN()){
                
            // }
            if ($pm_datas['pm_status'] === 'Completed') {
                //The payment has been completed, and the funds have been added successfully to your account balance.
                citybook_add_ons_active_ad_campaign($pm_datas, false);

            }elseif($pm_datas['pm_status'] === 'Refunded'){
                //The payment has been refunded


                $cthads_id = $pm_datas['order_id'];
                if ( !update_post_meta( $cthads_id, P_META_PREFIX.'status',  'refunded' ) ) {
                    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to refunded failure" . PHP_EOL, 3, CTH_LOG_FILE);
                }
                do_action( 'citybook_addons_ad_refunded', $cthads_id );
            }else{
                //The payment has other status include false (boolean)
            }

        }
        // end membership paypal payment ipn

        // need to check from payments.php
        // // membership stripe payment webhook
        // if($_GET['action'] === 'cth_stripewebhook'){
        // // server https://citybook.cththemes.com/?action=cth_stripewebhook

        //     require_once CITYBOOK_ADD_ONS_DIR.'posttypes/payment-stripe.php';
        //     $payment_class = new CTH_Payment_Stripe();

        //     //$payment_class->checkWebHooks();

        //     // $pm_datas = $payment_class->extractPaymentData();


        // }
        // // end membership stripe payment webhook
    }
    // end paypal ipn


        
}

add_action( 'init', 'citybook_addons_process_ad_campaign_checkout' );

// active listing ad
function citybook_add_ons_active_ad_campaign($pm_datas = array(), $stripe_date = false){
    $cthads_id = $pm_datas['order_id'];
    // ad package term
    $ad_package = get_term( $pm_datas['item_number'], 'cthads_package' );
    // check if the ad package is deleted
    if ( empty( $ad_package ) || is_wp_error( $ad_package ) ){
        if(get_post_meta( $cthads_id, P_META_PREFIX.'plan_period', true ) == '') return;  // also need check for plan datas attached to order in case of deleted plan post
    }

    $ad_package_positions = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_type', true );

    $from_date = $stripe_date ? citybook_add_ons_charge_date( $pm_datas['pm_date'] ) : citybook_add_ons_payment_date( $pm_datas['pm_date'] );

    // need to update user to listing author membership
    // with $pm_datas['item_number'] -> plan_id
    // with $pm_datas['listing_id'] -> listing_id
    $user_id = $pm_datas['user_id'];

    // update user order/subscription ids array
    $user_orders = get_user_meta($user_id,  P_META_PREFIX.'listing_ads', true );
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "User ADs before" . json_encode($user_orders). PHP_EOL, 3, CTH_LOG_FILE);
    if( is_array($user_orders) ){
        if( !in_array($cthads_id, $user_orders) ) $user_orders[] = $cthads_id;
    }else{
        $user_orders = array($cthads_id);
    }
    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "User ADs after" . json_encode($user_orders). PHP_EOL, 3, CTH_LOG_FILE);
    if ( !update_user_meta( $user_id, P_META_PREFIX.'listing_ads',  $user_orders ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update listing_ads user data" . PHP_EOL, 3, CTH_LOG_FILE);
    }

    
    if ( !update_post_meta( $cthads_id, P_META_PREFIX.'status',  'completed' ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order status to completed failure" . PHP_EOL, 3, CTH_LOG_FILE);
    }else{
        
    }
    if( citybook_addons_get_option('db_hide_ads') != 'yes' ){
        citybook_addons_user_add_notification($user_id, array(
            'type' => 'ad_completed',
            'message' => sprintf(__( 'Your AD order has marked as complete. So you can see it soon on the ad position.', 'citybook-add-ons' ), $cthads_id )
        ));
    }
    // update payment count - useful for check recurring payment
    $payment_count = get_post_meta( $cthads_id, P_META_PREFIX.'payment_count', true );
    if(!$payment_count) $payment_count = 1;
    else $payment_count += 1;
    if ( !update_post_meta( $cthads_id, P_META_PREFIX.'payment_count',  $payment_count ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Change order payment_count to $payment_count failure" . PHP_EOL, 3, CTH_LOG_FILE);
    }

    /// ALSO USE ORDER AS AUTHOR SUBSCRIPTION RECORD
    if ( !update_post_meta( $cthads_id, P_META_PREFIX.'plan_id',  $pm_datas['item_number'] ) ) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update ad package id failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
    }
    // valid date from - only add active date for newly created order - not for next payment
    if(get_post_meta( $cthads_id, P_META_PREFIX.'from_date', true ) == ''){
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'from_date',  $from_date ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update from_date order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }

    
    
    $order_listing = get_post_meta( $cthads_id, P_META_PREFIX.'listing_id', true );
    // update listin is_ad to yes
    update_post_meta( $order_listing, P_META_PREFIX. 'is_ad', 'yes' );
    // update listing ad_position
    if($order_listing != ''){
        if(is_array($ad_package_positions)){

            // $ad_pos_key = 1;
            foreach ($ad_package_positions as $pos) {
                update_post_meta( $order_listing, P_META_PREFIX. 'ad_position_'.$pos, 'yes');
                // $ad_pos_key++;
            }
            
        }else{
            update_post_meta( $order_listing, P_META_PREFIX. 'ad_position', $ad_package_positions);
        }

    }

    // add ad package datas to order/subscription
    $plan_interval = get_term_meta( $pm_datas['item_number'], P_META_PREFIX.'ad_interval', true );
    $plan_period = get_term_meta( $pm_datas['item_number'], P_META_PREFIX.'ad_period', true );
    if($plan_period){
        $ad_end_date = citybook_add_ons_cal_next_date($from_date, $plan_period, $plan_interval);
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'plan_period',  $plan_period ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update order/subscription plan period failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'plan_interval',  $plan_interval ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Update order/subscription plan interval failure or same existing value" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        
        // calculate expired date
        
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'end_date',  $ad_end_date ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update end_date order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }

        // also update listing ad expiration date
        update_post_meta( $order_listing, P_META_PREFIX. 'ad_expire', $ad_end_date );

        $ad_end_ts = get_gmt_from_date($ad_end_date,'U');
        citybook_addons_scheduleExpireEvent($cthads_id, $ad_end_ts);

        // listing submission limit
        $limit = get_term_meta( $pm_datas['item_number'], P_META_PREFIX.'ad_limit', true ) != '' ? get_term_meta( $pm_datas['item_number'], P_META_PREFIX.'ad_limit', true ) : 1;
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'plan_llimit',  $limit ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update plan_llimit order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
        
    }
    // check for existing purchase code
    if(get_post_meta( $cthads_id, P_META_PREFIX.'purchase_code', true ) == ''){
        if ( !update_post_meta( $cthads_id, P_META_PREFIX.'purchase_code',  citybook_addons_create_purchase_code('FORAD') ) ) {
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update purchase_code order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }



    // update order/subscription transaction ids array - paypal: txn_id
    if(isset($pm_datas['txn_id']) && $pm_datas['txn_id'] != ''){
        // create new invoice post
        
        $required_data = array(
            'order_id'  => $cthads_id,
            'user_id'  => $user_id,
            'user_name'  => __( 'No user', 'citybook-add-ons' ),
            'user_email'  => __( 'No user email', 'citybook-add-ons' ),
            'from_date'  => get_post_meta( $cthads_id, P_META_PREFIX.'from_date', true ),
            'end_date'  => get_post_meta( $cthads_id, P_META_PREFIX.'end_date', true ),
            'payment'  => get_post_meta( $cthads_id, P_META_PREFIX.'payment_method', true ),
            'txn_id'  => $pm_datas['txn_id'],

            'plan_title'  => $ad_package->name,
            'quantity'  => get_post_meta( $cthads_id, P_META_PREFIX.'quantity', true ),
            'amount'  => get_post_meta( $cthads_id, P_META_PREFIX.'amount', true ),
            'tax'  => 0, // maybe change in the future
            'charged_to'  => '', // maybe change in the future

            'for_listing_ad'    => 'yes',
        );
        $user_datas = get_user_by( 'ID', $user_id );
        if( $user_datas ){
            $required_data['user_name'] = $user_datas->display_name;
            $required_data['user_email'] = $user_datas->user_email;
            $required_data['charged_to'] = $user_datas->user_email;
        }

        $new_invoice = citybook_addons_create_invoice($required_data);
        if($new_invoice != false){
            $order_transactions = get_post_meta($cthads_id,  P_META_PREFIX.'transactions', true );
            if( is_array($order_transactions) ){

                if(!array_search($new_invoice, $order_transactions)){
                    $order_transactions[] = $new_invoice;
                }

                
            }else{
                $order_transactions = array($new_invoice);
                
            }
            if ( !update_post_meta( $cthads_id, P_META_PREFIX.'transactions',  $order_transactions ) ) {
                if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update transactions order/subscription data" . PHP_EOL, 3, CTH_LOG_FILE);
            }
        }

            
    }

    // will create new linvoice post type to store user invoices

    if(get_post_meta( $cthads_id, P_META_PREFIX.'is_recurring_plan', true ) == 'on' && isset($pm_datas['subscription_id'])){

        if( !update_post_meta( $cthads_id, P_META_PREFIX.'subscription_id',  $pm_datas['subscription_id'] ) ){
            if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Can not update order subscription_id data" . PHP_EOL, 3, CTH_LOG_FILE);
        }
    }


    do_action( 'citybook_addons_ad_completed', $cthads_id );

}

function citybook_addons_listing_ad_positions($pos = ''){
    $positions = array(
                    'sidebar'=> esc_html__('Sidebar','citybook-add-ons'),
                    'archive'=> esc_html__('Listing Archive','citybook-add-ons'),
                    'category'=> esc_html__('Listing Category','citybook-add-ons'),
                    'search'=> esc_html__('Listing Search','citybook-add-ons'),
                    'home'=> esc_html__('Elementor Listings Slider','citybook-add-ons'),
                    'custom_grid' => esc_html__('Elementor Listings Grid','citybook-add-ons'),
                );
    $positions = apply_filters( 'citybook_addons_ad_positions', $positions );
    if(!empty($pos) && isset($positions[$pos])) return $positions[$pos];

    return $positions;
}

// manually change order status to completed
function citybook_addons_cthads_change_status_to_completed_callback($order_id = 0){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){

            $plan_id = get_post_meta( $order_post->ID, P_META_PREFIX.'plan_id', true );

            $ad_package = get_term( $plan_id, 'cthads_package' );
            // check if the ad package is deleted
            if ( empty( $ad_package ) || is_wp_error( $ad_package ) ) return;

            $plan_interval = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_interval', true );
            $plan_period = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_period', true );
            if($plan_interval){
                $expire = citybook_add_ons_cal_next_date('', $plan_period, $plan_interval) ;
            }else{
                $expire = citybook_add_ons_cal_next_date('', 'day', citybook_addons_get_option('listing_expire_days') );
            }


            $data = array(
                'user_id'                   => get_post_meta( $order_post->ID, P_META_PREFIX.'user_id', true ),
                'item_number'               => $plan_id, // this is listing plan id
                'pm_date'                   => current_time('mysql', 1), // Time at which the object was created. Measured in seconds since the Unix epoch.
                'order_id'                  => $order_post->ID,
                'recurring_subscription'    => false, // not used

                'txn_id'                    => uniqid('manual_sub'), // invoice id

                // for stripe period
                'payment_method'            => __( 'Manual AD', 'citybook-add-ons' ),
                'period_start'              => current_time('mysql', 1),
                'period_end'                => $expire,

                'for_listing_ad'            => 'yes',

            );
            citybook_add_ons_active_ad_campaign($data, false);

        }
    }

                
}
add_action( 'citybook_addons_cthads_change_status_to_completed', 'citybook_addons_cthads_change_status_to_completed_callback', 10, 1 );

function citybook_addons_cthads_change_status_to_disable_callback($order_id = 0){
    if(is_numeric($order_id)&&(int)$order_id > 0){
        $order_post = get_post($order_id);
        if (null != $order_post){

            $plan_id = get_post_meta( $order_post->ID, P_META_PREFIX.'plan_id', true );

            $ad_package = get_term( $plan_id, 'cthads_package' );
            // check if the ad package is deleted
            if ( empty( $ad_package ) || is_wp_error( $ad_package ) ) 
                $ad_package_positions = array();
            else
                $ad_package_positions = get_term_meta( $ad_package->term_id, P_META_PREFIX.'ad_type', true );


            $ad_listing = get_post_meta( $order_post->ID, P_META_PREFIX.'listing_id', true );
            // update listin is_ad to yes
            update_post_meta( $ad_listing, P_META_PREFIX. 'is_ad', 'no' );
            // update listing ad_position
            if($ad_listing != ''){
                if(is_array($ad_package_positions) && !empty($ad_package_positions)){

                    // $ad_pos_key = 1;
                    foreach ($ad_package_positions as $pos) {
                        update_post_meta( $ad_listing, P_META_PREFIX. 'ad_position_'.$pos, 'no');
                        // $ad_pos_key++;
                    }
                    
                }
            }
        }
    }           
}
add_action( 'citybook_addons_cthads_change_status_to_disable', 'citybook_addons_cthads_change_status_to_disable_callback', 10, 1 );


function citybook_addons_elementor_listing_slider_ads(){
    if(citybook_addons_get_option('ads_home_enable') != 'yes') return;
    
    $args = array(
        'post_type'             => 'listing', 
        'orderby'               => citybook_addons_get_option('ads_home_orderby'),
        'order'                 => citybook_addons_get_option('ads_home_order'),
        'posts_per_page'        => citybook_addons_get_option('ads_home_count'),
        // 'post__not_in'          => array(get_the_ID()),
        'meta_query'            => array(
            'relation' => 'AND',
            array(
                'key'     => P_META_PREFIX.'is_ad',
                'value'   => 'yes',
            ),
            // array(
            //     'key'     => P_META_PREFIX.'ad_position',
            //     'value'   => 'home',
            // ),
            array(
                    'key'     => P_META_PREFIX.'ad_position_home',
                    'value'   => 'yes',
            ),
            array(
                'key'     => P_META_PREFIX.'ad_expire',
                'value'   => current_time('mysql', 1),
                'compare' => '>=',
                'type'    => 'DATETIME',
            ),
        ),

    );

    // The Query
    $posts_query = new WP_Query( $args );
    if($posts_query->have_posts()) :

    while($posts_query->have_posts()) : $posts_query->the_post();
        ?>
        <!--slick-slide-item-->
        <div id="post-<?php the_ID(); ?>" <?php post_class('slick-slide-item'); ?>>
            <?php citybook_addons_get_template_part('template-parts/listing', false, array('is_ad'=>true,'for_slider'=>true));?>
        </div>
        <!--slick-slide-item-->
        <?php
    endwhile;

    wp_reset_postdata();
    endif;
}
add_action( 'citybook_addons_elementor_listing_slider_before', 'citybook_addons_elementor_listing_slider_ads' );

function citybook_addons_display_listing_sidebar_ads(){

    if(citybook_addons_get_option('ads_sidebar_enable') != 'yes') return;
    // http://prntscr.com/mmjaue
    // if(get_post_meta( get_the_ID(), P_META_PREFIX.'plan_id', true ) == '456') return;

    $args = array(
        'post_type'             =>  'listing', 
        'orderby'               => citybook_addons_get_option('ads_sidebar_orderby'),
        'order'                 => citybook_addons_get_option('ads_sidebar_order'),
        'posts_per_page'        => citybook_addons_get_option('ads_sidebar_count'),
        'post__not_in'          => array(get_the_ID()),
        'meta_query'            => array(
            'relation' => 'AND',
            array(
                'key'     => P_META_PREFIX.'is_ad',
                'value'   => 'yes',
            ),
            // array(
            //     'key'     => P_META_PREFIX.'ad_position',
            //     'value'   => 'sidebar',
            // ),
            array(
                    'key'     => P_META_PREFIX.'ad_position_sidebar',
                    'value'   => 'yes',
            ),
            array(
                'key'     => P_META_PREFIX.'ad_expire',
                'value'   => current_time('mysql', 1),
                'compare' => '>=',
                'type'    => 'DATETIME',
            ),
        ),

    );

    // The Query
    $posts_query = new WP_Query( $args );
    if($posts_query->have_posts()) :

    ?>
    <!--box-widget-item -->
    <div class="box-widget-item fl-wrap ads-widget">
        <div class="box-widget-item-header">
            <h3><?php esc_html_e( 'ADs : ', 'citybook-add-ons' );?></h3>
        </div>
        
        <div class="sidebar-ad-widget">
            
                <div class="sidebar-ad-carousel fl-wrap">
                <?php 
                while($posts_query->have_posts()) : $posts_query->the_post();
                    ?>
                    <!--slick-slide-item-->
                    <div id="post-<?php the_ID(); ?>" <?php post_class('slick-slide-item'); ?>>
                        <?php citybook_addons_get_template_part('template-parts/listing', false, array( 'for_slider'=>true,'is_ad'=>true ));?>
                    </div>
                    <!--slick-slide-item-->
                    <?php
                endwhile;
                ?>
                </div>
           
        </div>
    </div>
    <!--box-widget-item end -->
    <?php
    wp_reset_postdata();
    endif;
}
add_action( 'citybook_addons_listing_widgets_before', 'citybook_addons_display_listing_sidebar_ads' );

function citybook_addons_listing_loop_before_ads(&$action_args){

    if(is_search()){
        if(citybook_addons_get_option('ads_search_enable') != 'yes') return;
        $posts_args = array(
            'post_type'             => 'listing', 
            'orderby'               => citybook_addons_get_option('ads_search_orderby'),
            'order'                 => citybook_addons_get_option('ads_search_order'),
            'posts_per_page'        => citybook_addons_get_option('ads_search_count'),
            // 'post__not_in'          => array(get_the_ID()),
            'meta_query'            => array(
                'relation' => 'AND',
                array(
                    'key'     => P_META_PREFIX.'is_ad',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_position_search',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_expire',
                    'value'   => current_time('mysql', 1),
                    'compare' => '>=',
                    'type'    => 'DATETIME',
                ),
            ),

        );

    }elseif(is_tax('listing_cat')){
        if(citybook_addons_get_option('ads_category_enable') != 'yes') return;
        $posts_args = array(
            'post_type'             => 'listing', 
            'orderby'               => citybook_addons_get_option('ads_category_orderby'),
            'order'                 => citybook_addons_get_option('ads_category_order'),
            'posts_per_page'        => citybook_addons_get_option('ads_category_count'),
            // 'post__not_in'          => array(get_the_ID()),
            
            'tax_query' => array(
                array(
                    'taxonomy' => 'listing_cat',
                    'field'    => 'term_id',
                    'terms'    => get_queried_object_id(),
                ),
            ),

            'meta_query'            => array(
                'relation' => 'AND',
                array(
                    'key'     => P_META_PREFIX.'is_ad',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_position_category',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_expire',
                    'value'   => current_time('mysql', 1),
                    'compare' => '>=',
                    'type'    => 'DATETIME',
                ),
            ),

        );
    }elseif(is_post_type_archive('listing')){
        if(citybook_addons_get_option('ads_archive_enable') != 'yes') return;
        $posts_args = array(
            'post_type'             => 'listing', 
            'orderby'               => citybook_addons_get_option('ads_archive_orderby'),
            'order'                 => citybook_addons_get_option('ads_archive_order'),
            'posts_per_page'        => citybook_addons_get_option('ads_archive_count'),
            // 'post__not_in'          => array(get_the_ID()),

            'meta_query'            => array(
                'relation' => 'AND',
                array(
                    'key'     => P_META_PREFIX.'is_ad',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_position_archive',
                    'value'   => 'yes',
                ),
                array(
                    'key'     => P_META_PREFIX.'ad_expire',
                    'value'   => current_time('mysql', 1),
                    'compare' => '>=',
                    'type'    => 'DATETIME',
                ),
            ),

        );
    }
    if(!empty($posts_args)){
        
        // The Query
        $posts_query = new WP_Query( $posts_args );
        
        if($posts_query->have_posts()) :
            while($posts_query->have_posts()) : $posts_query->the_post();
                citybook_addons_get_template_part('template-parts/listing', false, array('is_ad'=>true));
                $action_args['gmap_listings'][] = citybook_addons_get_listing_post_data();
            endwhile;
        endif;

        wp_reset_postdata();
    }
        
}
// add_action( 'citybook_addons_listing_loop_before', 'citybook_addons_listing_loop_before_ads' );

function citybook_addons_elementor_listings_grid_before_ads(&$action_args){
    if(citybook_addons_get_option('ads_custom_grid_enable') != 'yes') return;

    $posts_args = array(
        'post_type'             => 'listing', 
        'orderby'               => citybook_addons_get_option('ads_custom_grid_orderby'),
        'order'                 => citybook_addons_get_option('ads_custom_grid_order'),
        'posts_per_page'        => citybook_addons_get_option('ads_custom_grid_count'),
        // 'post__not_in'          => array(get_the_ID()),

        'meta_query'            => array(
            'relation' => 'AND',
            array(
                'key'     => P_META_PREFIX.'is_ad',
                'value'   => 'yes',
            ),
            array(
                'key'     => P_META_PREFIX.'ad_position_custom_grid',
                'value'   => 'yes',
            ),
            array(
                'key'     => P_META_PREFIX.'ad_expire',
                'value'   => current_time('mysql', 1),
                'compare' => '>=',
                'type'    => 'DATETIME',
            ),
        ),

    );

    // The Query
    $posts_query = new WP_Query( $posts_args );
    
    if($posts_query->have_posts()) :
        while($posts_query->have_posts()) : $posts_query->the_post();
            citybook_addons_get_template_part('template-parts/listing', false, array('is_ad'=>true));
            $action_args['gmap_listings'][] = citybook_addons_get_listing_post_data();
        endwhile;
    endif;

    wp_reset_postdata();
        
}
add_action( 'citybook_addons_elementor_listings_grid_before', 'citybook_addons_elementor_listings_grid_before_ads' );


