<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



/**
 * CityBook_Addons class
 *
 * @since 1.0
 */
if(!class_exists('CityBook_Addons')) {

    class CityBook_Addons {

        private $slug; // settings page slug
        private $page; // settings page slug
        private $options; // global options
        public $plugin_url;
        public $plugin_path;

        protected $menu_slug = 'citybook-addons';

        protected $option_tabs = array();

        protected $option_options = array();

        protected $current_section = 'default-section-id';

        /** Constructor */
        function __construct() {
            
            // if(!get_option('citybook_addons_slug')) update_option( 'citybook_addons_slug', 'settings_page_citybook-addons' );

            // $slug           = get_option('citybook_addons_slug');
            // $this->option_name     = $slug;
            // $this->options  = get_option($slug);

            // delete_option( 'settings_page_citybook-addons' );

            $this->option_name     = $this->menu_slug.'-options';

            // If the theme options don't exist, create them.
            if( false == get_option( $this->option_name ) ) {  
                add_option( $this->option_name , array());
            }else{
                $this->option_options = get_option( $this->option_name );
            } 

            // end if

        }

        function init() {

            add_action('init', array(&$this, 'plugin_info'));

            //if(is_admin()) {
                add_action( 'admin_menu', array($this, 'register_settings') );
                add_action( 'admin_footer', array($this, 'price_templates') );
            //}

            // manually update option
            // add_action( 'admin_menu', array($this, 'manually_update_options') , 2 );

            // https://core.trac.wordpress.org/browser/tags/4.9/src/wp-includes/option.php#L323
            // $value = apply_filters( 'pre_update_option', $value, $option, $old_value );

            // add_filter('pre_update_option', array($this, 'filter_pre_update_option'), 10, 3);

            

            

            
            
            add_action( 'admin_enqueue_scripts', array(&$this, 'enqueue_admin_scripts') );

            add_action( 'wp_enqueue_scripts', array(&$this, 'enqueue_site_scripts') );




            add_filter( 'ajax_query_attachments_args', array($this, 'filter_media_frontend') );


        }

        function price_templates(){
            ?>
            <script type="text/template" id="tmpl-content-addwidget">
                <?php citybook_addons_get_template_part( 'templates-inner/add-widget' );?>
            </script>
            <script type="text/template" id="tmpl-content-addwidgetfield">
                <?php citybook_addons_get_template_part( 'templates-inner/add-widgetfield' );?>
            </script>
            <script type="text/template" id="tmpl-key-mobileapp">
                <?php citybook_addons_get_template_part( 'templates-inner/add-key-mobileapp' );?>
            </script>
            <?php
            // edit listing templates
            citybook_addons_get_template_part('shortcodes/tmpls');
            // socials template
            citybook_addons_get_template_part('shortcodes/tmpls-dashboard');
        }

        function enqueue_site_scripts(){
            global $wp_query;
            // global $post;

            wp_enqueue_style( 'select2' , $this->plugin_url ."assets/css/select2.min.css", false ); 
            wp_enqueue_style( 'jscrollpane' , $this->plugin_url ."assets/css/jquery.jscrollpane.css", false ); 
            wp_enqueue_style( 'citybook-addons' , $this->plugin_url ."assets/css/citybook-add-ons.min.css", false ); 

            
            
            // wp_enqueue_script( 'backbone.marionette', $this->plugin_url ."assets/js/backbone.marionette.min.js" , array('jquery','backbone','underscore'), null , true );
            // wp_enqueue_script( 'jquery.selectbox', $this->plugin_url ."assets/js/jquery.selectbox.min.js" , array(), null , true );
            wp_enqueue_script( 'select2', $this->plugin_url ."assets/js/select2.min.js" , array('jquery'), null , true );
            wp_enqueue_script( 'mousewheel', $this->plugin_url ."assets/js/jquery.mousewheel.js" , array(), null , true );
            wp_enqueue_script( 'jscrollpane', $this->plugin_url ."assets/js/jquery.jscrollpane.min.js" , array(), null , true );
            
            $gmap_api_key = citybook_addons_get_option('gmap_api_key');
            $google_map_language = citybook_addons_get_option('google_map_language')? '&language='.citybook_addons_get_option('google_map_language') : '';


            
            if(citybook_addons_get_option('use_osm_map')=='yes'){
                wp_enqueue_style( 'openlayers' , $this->plugin_url ."assets/css/ol.css", false ); 
                wp_enqueue_script( 'openlayers', $this->plugin_url ."assets/js/ol.js" , array(), null , true );
            }else{
                wp_enqueue_script("googleapis", "https://maps.googleapis.com/maps/api/js?key=$gmap_api_key&libraries=places$google_map_language",array(),false,true);
                wp_enqueue_script( 'infobox', $this->plugin_url ."assets/js/infobox.js" , array('googleapis'), null , true );
                wp_enqueue_script( 'markerclusterer', $this->plugin_url ."assets/js/markerclusterer.js" , array('googleapis'), null , true );
                wp_enqueue_script( 'oms', $this->plugin_url ."assets/js/oms.min.js" , array(), null , true );
            }
            
            wp_enqueue_media();

            wp_enqueue_script( 'citybook-addons', $this->plugin_url ."assets/js/citybook-add-ons.min.js" , array('underscore','masonry','jquery-ui-sortable'), null , true );

            // AIzaSyChCXNJOoVajjJ1KvF3g0kq63yb5KQLPMA

            // wp_enqueue_script( 'citybook-app', $this->plugin_url ."assets/js/citybook-app.js" , array('backbone.marionette','jquery.selectbox','citybook-gmap'), null , true );

            $gmap_marker = citybook_addons_get_option('gmap_marker');

            $curr_user_data = array(
                'id'    => 0,
                'display_name'  =>'',
                'avatar'        => '',
            );

            if(is_user_logged_in()){
                $current_user = wp_get_current_user();
                $curr_user_data = array(
                    'id'            => $current_user->ID,
                    'display_name'  => $current_user->display_name,
                    'avatar'  => get_avatar($current_user->user_email,'150','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=150', $current_user->display_name ),
                );
            }


            $_citybook_add_ons = array(
                'url'           => esc_url(admin_url( 'admin-ajax.php' ) ),
                'nonce'         => wp_create_nonce( 'citybook-add-ons' ),
                'posted_on'     => __('Posted on ','citybook-add-ons'),
                'reply'         => __('Reply','citybook-add-ons'),
                'retweet'       => __('Retweet','citybook-add-ons'),
                'favorite'      => __('Favorite','citybook-add-ons'),
                'pl_w'          => __('Please wait...','citybook-add-ons'),
                'like'          => esc_html__( 'Like', 'citybook-add-ons' ),
                'unlike'        => esc_html__( 'Unlike', 'citybook-add-ons' ),
                'marker'        => $gmap_marker['url']? $gmap_marker['url'] : CITYBOOK_ADD_ONS_DIR_URL ."assets/images/marker.png",
                'center_lat'    => floatval(citybook_addons_get_option('gmap_default_lat')),
                'center_lng'    => floatval(citybook_addons_get_option('gmap_default_long')),
                'map_zoom'      => citybook_addons_get_option('gmap_default_zoom'),

                'gmap_type'     => citybook_addons_get_option('gmap_type'),

                

                // for ajax search
                // 'is_search'     => is_search(),
                // 'is_tax_cat'    => is_tax('listing_cat'),
                // 'is_tax_loc'    => is_tax('listing_location'),
                // 'is_tax_fea'    => is_tax('listing_feature'),
                // 'query_vars'    =>  $wp_query->query_vars ,

                'location_type' => citybook_addons_get_option('listing_location_result_type'),
                'address_format'   => array_filter( explode(",", citybook_addons_get_option('listing_address_format') ) ),
                'country_restrictions' => citybook_addons_get_option('country_restrictions'),

                'place_lng' => citybook_addons_get_option('google_map_language')? citybook_addons_get_option('google_map_language') : '',

                'disable_bubble'    => citybook_addons_get_option('disable_bubble', 'no'), 

                // 'filter_subcats'    => citybook_addons_get_option('search_load_subcat'), 

                'lb_approved'       => __( 'Approved', 'citybook-add-ons' ),

                'lb_24h'            => citybook_addons_get_option('booking_clock_24h') == 'yes'? true: false,
                'td_color'          => citybook_addons_get_option('time_picker_color'), 
                'lb_delay'          => citybook_addons_get_option('add_cart_delay'), 
                'md_limit'          => citybook_addons_get_option('submit_media_limit'), 
                'md_limit_msg'      => sprintf(__( 'Max upload files is %s', 'citybook-add-ons' ), citybook_addons_get_option('submit_media_limit') ), 
                'md_limit_size'     => citybook_addons_get_option('submit_media_limit_size'), 
                'md_limit_size_msg' => sprintf(__( 'Max upload file size is %s MB', 'citybook-add-ons' ), citybook_addons_get_option('submit_media_limit_size') ), 

                'search'            => __( 'Search...', 'citybook-add-ons' ),

                'gcaptcha'          => ( citybook_addons_get_option('enable_g_recaptcah') == 'yes' && citybook_addons_get_option('g_recaptcha_site_key') != '' )? true: false,
                'gcaptcha_key'      => citybook_addons_get_option('g_recaptcha_site_key'),
                
                'weather_strings'   => array(
                    'days' => array(
                        _x( 'Sunday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Monday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Tuesday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Wednesday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Thursday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Friday', 'weather widget', 'citybook-add-ons' ),
                        _x( 'Saturday', 'weather widget', 'citybook-add-ons' ),
                    ),
                    'min'   => _x( 'Min', 'weather widget', 'citybook-add-ons' ),
                    'max'   => _x( 'Max', 'weather widget', 'citybook-add-ons' ),
                    'direction' => array(
                        _x( 'N', 'wind direction', 'citybook-add-ons' ),
                        _x( 'NNE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'NE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'ENE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'E', 'wind direction', 'citybook-add-ons' ),
                        _x( 'ESE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'SE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'SSE', 'wind direction', 'citybook-add-ons' ),
                        _x( 'S', 'wind direction', 'citybook-add-ons' ),
                        _x( 'SSW', 'wind direction', 'citybook-add-ons' ),
                        _x( 'SW', 'wind direction', 'citybook-add-ons' ),
                        _x( 'WSW', 'wind direction', 'citybook-add-ons' ),
                        _x( 'W', 'wind direction', 'citybook-add-ons' ),
                        _x( 'WNW', 'wind direction', 'citybook-add-ons' ),
                        _x( 'NW', 'wind direction', 'citybook-add-ons' ),
                        _x( 'NNW', 'wind direction', 'citybook-add-ons' ),
                    ),
                ),
                'i18n'          => array(
                    'del-listing'               => __( "Are you sure want to delete {{listing_title}} listing and its data?\nThe listing is permanently deleted.", 'citybook-add-ons' ),
                    'cancel-booking'            => __( "Are you sure want to cancel {{booking_title}} booking?", 'citybook-add-ons' ),
                    'approve-booking'           => __( "Are you sure want to approve {{booking_title}} booking?", 'citybook-add-ons' ),
                    'del-booking'               => __( "Are you sure want to delete {{booking_title}} booking and its data?\nThe booking is permanently deleted.", 'citybook-add-ons' ),
                    'del-message'               => __( "Are you sure want to cancel {{message_title}} message?", 'citybook-add-ons' ),
                ),

                'distance_df'                   => citybook_addons_get_option('distance_df'),
                'curr_user'                     => $curr_user_data,

                'free_map'                      => citybook_addons_get_option('use_osm_map') == 'yes'? true: false,
                

            );
            // if(is_singular('listing')){
            //     $_citybook_add_ons['slid'] = 
            // }

            wp_localize_script( 'citybook-addons', '_citybook_add_ons', $_citybook_add_ons );

            

            // google reCAPTCHA - v2
            if( citybook_addons_get_option('enable_g_recaptcah') == 'yes' && citybook_addons_get_option('g_recaptcha_site_key') != '' )
                wp_enqueue_script( 'g-recaptcha', "https://www.google.com/recaptcha/api.js?onload=cthCaptchaCallback&render=explicit#cthasync#cthdefer" , array('citybook-addons'), null , true );


            // for Stripe payment
            if( is_page( citybook_addons_get_option('checkout_page') ) ){
                wp_enqueue_script( 'checkout.stripe', 'https://checkout.stripe.com/checkout.js' , array(), null , false );
                wp_enqueue_script( 'add-ons-payments', $this->plugin_url ."assets/js/payments.min.js" , array('jquery', 'checkout.stripe'), null , true );
                $stripe_logo = citybook_addons_get_option('stripe_logo');
                $_citybook_add_ons_payments = array(
                    'site_title'            => get_bloginfo('name'),
                    // 'site_desc'         => get_bloginfo('description'),
                    'logo'                  => $stripe_logo['url'],
                    'publishable_key'       => citybook_addons_get_option('payments_test_mode') == 'yes'? citybook_addons_get_option('payments_stripe_test_public') : citybook_addons_get_option('payments_stripe_live_public'),
                    'currency_code'         => citybook_addons_get_option('currency','USD'),

                    'one_time_text'         => __( 'Pay for {{plan}} plan', 'citybook-add-ons' ),
                    'recurring_text'        => __( 'Subscription for {{plan}} plan', 'citybook-add-ons' ),
                    'use_email'             => citybook_addons_get_option('payments_stripe_use_email') == 'yes'? true : false,


                    // 'url'           => esc_url(admin_url( 'admin-ajax.php' ) ),
                    // 'nonce'         => wp_create_nonce( 'citybook-add-ons' ),
                    

                );
                wp_localize_script( 'add-ons-payments', '_citybook_add_ons_payments', $_citybook_add_ons_payments );
            }
            
        }

        function enqueue_admin_scripts($hook) {
            // Load only on ?page=mypluginname
            // var_dump($hook);
            wp_enqueue_style( 'select2', CITYBOOK_ADD_ONS_DIR_URL .'assets/css/select2.min.css' );
            wp_enqueue_style( 'citybook-add-ons', CITYBOOK_ADD_ONS_DIR_URL .'assets/css/admin.css' );

            wp_enqueue_style( 'datetimepicker.jquery', CITYBOOK_ADD_ONS_DIR_URL .'assets/admin/datetimepicker/jquery.datetimepicker.min.css' );

            $gmap_api_key = citybook_addons_get_option('gmap_api_key');

            //free map or google map
            if(citybook_addons_get_option('use_osm_map')){

                wp_enqueue_script( 'openlayers', CITYBOOK_ADD_ONS_DIR_URL ."assets/js/ol.js" , array(), null , true );

            }else{

                wp_enqueue_script("googleapis", "https://maps.googleapis.com/maps/api/js?key=$gmap_api_key&libraries=places",array(),false,true);
            }
            
            wp_enqueue_script('datetimepicker.jquery', CITYBOOK_ADD_ONS_DIR_URL . 'assets/admin/datetimepicker/jquery.datetimepicker.full.min.js', array('jquery'), null, true);

            wp_enqueue_script('citybook-addons-admin', CITYBOOK_ADD_ONS_DIR_URL . 'assets/js/addons-admin.min.js', array('jquery','jquery-ui-sortable'), null, true);
            $gmap_marker = citybook_addons_get_option('gmap_marker');
            $_citybook_add_ons_admin = array(
                'center_lat'    =>  floatval(citybook_addons_get_option('gmap_default_lat')),
                'center_lng'    =>  floatval(citybook_addons_get_option('gmap_default_long')),
                'map_zoom'      =>  citybook_addons_get_option('gmap_default_zoom'),
                'marker'        =>  $gmap_marker['url']? $gmap_marker['url'] : CITYBOOK_ADD_ONS_DIR_URL ."assets/images/marker.png",
                'free_map'      =>  citybook_addons_get_option('use_osm_map') == 'yes'? true: false
            );
            wp_localize_script( 'citybook-addons-admin', '_citybook_add_ons_admin', $_citybook_add_ons_admin );

            if($hook != 'settings_page_citybook-addons') {
                return;
            }
            wp_enqueue_media();
            wp_enqueue_style( 'wp-color-picker');
            wp_enqueue_script( 'wp-color-picker');
            wp_enqueue_script('citybook_addons_image', CITYBOOK_ADD_ONS_DIR_URL . 'inc/assets/upload_file.js', array('jquery'), null, true);
            // wp_enqueue_style( 'custom_wp_admin_css', plugins_url('admin-style.css', __FILE__) );
            wp_enqueue_script('select2', CITYBOOK_ADD_ONS_DIR_URL . 'assets/js/select2.min.js', array('jquery'), null, true);
            wp_enqueue_script('citybook-add-ons-options', CITYBOOK_ADD_ONS_DIR_URL . 'assets/js/addons-options.js', array('select2'), null, true);

        }


        function filter_media_frontend( $query ) {
            // admins get to see everything
            if ( ! current_user_can( 'manage_options' ) ) $query['author'] = get_current_user_id();
            return $query;
        }


        function parse_listing_cats($cats = array(),&$return =array(),$parent_id = 0,$curlevel = -1,$maxlevel = 3){
            $return = $return? $return : array();
            if ( !empty($cats) ) :
                foreach( $cats as $cat ) {
                    if( $cat->parent == $parent_id ) {
                        // $return[$cat->term_id] = array('name'=>$cat->name,'level'=>$curlevel+1,'children'=>array());
                        $return[] = array('id'=>$cat->term_id,'name'=>$cat->name,'level'=>$curlevel+1);
                        // if($return[$cat->term_id]['level'] < $maxlevel ) $this->parse_listing_cats($cats,$return[$cat->term_id]['children'],$cat->term_id,$return[$cat->term_id]['level']);
                        if($curlevel+1 < $maxlevel ) $this->parse_listing_cats($cats,$return,$cat->term_id,$curlevel+1);

                        
                    }
                }
            endif;
            // return $return;
        }

        


        function get_setting_tab_options($tab = 'general'){
            if(isset($this->option_options[$tab])) 
                return $this->option_options[$tab];
            elseif($tab == '') 
                return $this->option_options;
            else 
                return array();
        }


        function register_setting_field($field = array(), $tab = ''){
            $default = array(
                'type' => 'section', // section or field
                'field_type' => 'text', // field type for register field only
                'id' => 'default-section-id', // section or field id
                'title' => __( 'Default title', 'citybook-add-ons' ), // section or field title
                // 'callback' => '__return_false', // section or field callback for echo its output
                // 'section_id' => 'default-section-id', // for setting field only // use current_section instead
                // 'args' => array(
                //     'id' => 'default-section-id', // id of the field
                //     'desc' => __( 'Default description', 'citybook-add-ons' ), // id of the field
                // ), // for setting field only

                'desc' => '', // desc of the field

                'args' => array(
                    // 'options' => array(key=>value) for radio
                )
            );

            $field = array_merge($default, $field);

            if($field['type'] == 'section'){
                if(!isset($field['callback'])) $field['callback'] = '__return_false';
                // $page_tab = $this->menu_slug.'_widgets-options';
                // $id, $title, $callback, $page
                // $page - The menu page on which to display this section. Should match $menu_slug from Function Reference/add theme page if you are adding a section to an 'Appearance' page, or Function Reference/add options page if you are adding a section to a 'Settings' page.
                add_settings_section( $field['id'], $field['title'], $field['callback'], $this->slug ."-$tab" );

                $this->current_section = $field['id'] ;
            }
            if($field['type'] == 'field'){
                if(!isset($field['callback'])){
                    switch ($field['field_type']) {
                        case 'text':
                            $field['callback'] = array($this, 'settings_field_input');
                            break;
                        case 'number':
                            $field['callback'] = array($this, 'settings_field_number');
                            break;
                        case 'textarea':
                            $field['callback'] = array($this, 'settings_field_textarea');
                            break;
                        case 'editor':
                            $field['callback'] = array($this, 'settings_field_editor');
                            break;
                        case 'checkbox':
                            $field['callback'] = array($this, 'settings_field_checkbox');
                            break;
                        case 'radio':
                            $field['callback'] = array($this, 'settings_field_radio');
                            break;
                        case 'select':
                            $field['callback'] = array($this, 'settings_field_select');
                            break;
                        case 'info':
                            $field['callback'] = array($this, 'settings_field_info');
                            break;
                        case 'page_select':
                            $field['callback'] = array($this, 'settings_field_page_select');
                            break;
                        case 'user_select':
                            $field['callback'] = array($this, 'settings_field_user_select');
                            break;
                        case 'image':
                            $field['callback'] = array($this, 'settings_field_image');
                            break;
                        case 'repeat_content':
                            $field['callback'] = array($this, 'settings_field_repeat_content');
                            break;
                        case 'repeat_widget':
                            $field['callback'] = array($this, 'settings_field_repeat_widget');
                            break;
                        case 'color':
                            $field['callback'] = array($this, 'settings_field_color');
                            break;
                        case 'lfeatures':
                            $field['callback'] = array($this, 'settings_field_lfeatures');
                            break;
                        case 'cth_tags':
                            $field['callback'] = array($this, 'settings_field_cth_tags');
                            break;
                        case 'repeat_key_mobileapp':
                            $field['callback'] = array($this, 'settings_field_repeat_key_mobile_app');
                            break;
                        default:
                            $field['callback'] = array($this, 'settings_field_input');
                            break;
                    }
                }
                // $id, $title, $callback, $page, $section, $args
                add_settings_field(
                    $field['id'], 
                    $field['title'], 
                    $field['callback'], 
                    $this->slug ."-$tab", 
                    $this->current_section, 
                    array_merge(array(
                        'id'    => $field['id'], 
                        'desc'  => $field['desc']
                    ), $field['args'])
                );
            }
        }

        function register_settings() {
            // add_options_page( $page_title, $menu_title, $capability, $menu_slug, $function);
            $this->slug = add_options_page( 'CityBook Add-ons', 'CityBook Add-ons', 'manage_options', $this->menu_slug, array($this, 'view_admin_settings') );

            $this->options  = get_option($this->option_name, array());

            // https://developer.wordpress.org/reference/functions/register_setting/
            // string $option_group, string $option_name, array $args = array()
            register_setting($this->option_name, $this->option_name, array($this, 'sanitize_settings') );

            // if($options){
            //     foreach ($options as $field) {
            //         $this->register_setting_field($field);
            //     }
            // }

            $tabs_options = $this->get_setting_tab_options('');
            if(!empty($tabs_options)){
                foreach ($tabs_options as $tab => $options) {
                    if(!empty($options)){
                        foreach ($options as $field) {
                            $this->register_setting_field($field, $tab);
                        }
                    }
                }
            }

        }


        function filter_pre_update_option($value, $option, $old_value){
            if($option == $this->option_name){
                if(!is_array($old_value)) $old_value = array();
                return array_merge($old_value,$value);
            }
            return $value;
        }

        function settings_field_info($args) {
            $desc = $args['desc'];
            echo "<p class='description desc-info'>$desc</div>";

        }

        function settings_field_input($args) {
            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';
            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            echo "<input id='$id' name='{$this->option_name}[{$id}]' size='40' type='text' value='{$value}' />";
            echo "<p class='description'>$desc</div>";

        }

        function settings_field_number($args) {
            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';
            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            $attrs = '';
            if(isset($args['min'])) $attrs .= ' min="'.$args['min'].'"';
            if(isset($args['max'])) $attrs .= ' max="'.$args['max'].'"';
            if(isset($args['step'])) $attrs .= ' step="'.$args['step'].'"';

            echo "<input id='$id' name='{$this->option_name}[{$id}]' size='40' type='number' value='{$value}'".$attrs."/>";
            echo "<p class='description'>$desc</div>";

        }

        function settings_field_textarea($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';
            // $options = $this->options;

            // $default = "#login {width: 500px} .success {background-color: #F0FFF8; border: 1px solid #CEEFE1;}";

            // if(!isset($options['custom_style'])) $options['custom_style'] = $default;
            // $text = $options['custom_style'];

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            echo "<textarea id='{$id}' name='{$this->option_name}[{$id}]' rows='7' cols='50' class='large-text code'>{$value}</textarea>";
            echo "<p class='description'>$desc</div>";

        }

        function settings_field_editor($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            /**
             * 2.
             * This code renders an editor box and a submit button.
             * The box will have 15 rows, the quicktags won't load
             * and the PressThis configuration is used.
             */
            $editor_args = array(
                'textarea_rows' => isset($args['rows'])? $args['rows'] : 10,
                'textarea_name'=> $this->option_name .'['. $id .']',
                'teeny' => true,
                'quicktags' => true
            );
            wp_editor( $value, $this->option_name .'_'. $id .'_', $editor_args );
            echo "<p class='description'>$desc</div>";

        }
        function settings_field_checkbox($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : (isset($args['default']) ? $args['default'] : '');
            $value = isset($args['value'])? $args['value'] : 1;

            $checked = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            echo '<label for="'. $id .'">';
                echo '<input type="hidden" name="'. $this->option_name .'['. $id .']" value="">';
                echo '<input type="checkbox" id="'.$id.'" name="'. $this->option_name .'['. $id .']" value="'.$value.'" '. checked( $checked, $value, false ) .'/>';
            echo '&nbsp;' . $desc .'</label>';

        }

        function settings_field_image($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            // echo '<label for="'. $id .'">';
            //     echo '<input type="checkbox" id="'.$id.'" name="'. $this->option_name .'['. $id .']" value="1" '. checked( $value, 1, false ) .'/>';
            // echo '&nbsp;' . $desc .'</label>';


            echo '<img id="'. $this->option_name .'['. $id .'][preview]" src="'.(isset($value['url']) ? esc_attr($value['url']) : '').'" alt="" '.(isset($value['url']) ? ' style="display:block;width:200px;height=auto;"' : ' style="display:none;width:200px;height=auto;"').'>';
            echo '<input type="hidden" name="'. $this->option_name .'['. $id .'][url]" id="'. $this->option_name .'['. $id .'][url]" value="'.(isset($value['url']) ? esc_attr($value['url']) : '').'">';
            echo '<input type="hidden" name="'. $this->option_name .'['. $id .'][id]" id="'. $this->option_name .'['. $id .'][id]" value="'.(isset($value['id']) ? esc_attr($value['id']) : '').'">';
            
            echo '<p class="description"><a href="#" data-uploader_title="'.esc_html__( 'Select Image', 'citybook-add-ons' ).'" class="button button-primary upload_image_button metakey-'.$this->option_name.' fieldkey-'.$id.'">'.esc_html__('Upload Image', 'citybook-add-ons').'</a>  <a href="#" class="button button-secondary remove_image_button metakey-'.$this->option_name.' fieldkey-'.$id.'">'.esc_html__('Remove', 'citybook-add-ons').'</a></p>';


            echo "<p class='description'>$desc</div>";

        }

        function settings_field_radio($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            if (isset($args['options']) && !empty($args['options'])) {
                foreach ($args['options'] as $option_value => $option_text) {
                    // $checked = ' ';
                    // if (get_option($value['id']) == $option_value) {
                    //     $checked = ' checked="checked" ';
                    // }
                    // else if (get_option($value['id']) === FALSE && $value['std'] == $option_value){
                    //     $checked = ' checked="checked" ';
                    // }
                    // else {
                    //     $checked = ' ';
                    // }
                    echo '<div class="mnt-radio" style="display:inline-block;padding:0 10px 0 0;"><input type="radio" name="'. $this->option_name .'['. $id .']" value="'.
                        $option_value.'" '.checked( $option_value, $value, false )."/>".$option_text."</div>\n";

                    if(isset($args['options_block']) && $args['options_block']) echo '<br>';
                }
            }


            echo "<p class='description'>$desc</div>";


        }

        function settings_field_select($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            $field_class = 'select_field' . (isset($args['multiple']) && $args['multiple'] == true ? ' multiple_field':'') . (isset($args['use-select2']) && $args['use-select2'] == true ? ' use-select2':'');

            if(isset($args['multiple']) && $args['multiple'] == true){
                echo '<input type="hidden" name="'.$this->option_name .'['. $id .'][]'.'">'."\n";
                echo '<select id="'. $this->option_name .'['. $id .']" class="'.$field_class.'" name="'. $this->option_name .'['. $id ."][]\" multiple=\"multiple\">\n";
                    if (isset($args['options']) && !empty($args['options'])) {
                        foreach ($args['options'] as $option_value => $option_text) {
                            echo "\t".'<option value="'.$option_value.'" '. (in_array($option_value, (array)$value)? ' selected="selected"':'').'>'.$option_text."</option>\n";
                        }
                    }
                echo "</select>\n";
            }else{
                echo '<select id="'. $this->option_name .'['. $id .']" class="'.$field_class.'" name="'. $this->option_name .'['. $id ."]\">\n";
                    if (isset($args['options']) && !empty($args['options'])) {
                        foreach ($args['options'] as $option_value => $option_text) {
                            echo "\t".'<option value="'.$option_value.'" '.selected( $value, $option_value, false ).'>'.$option_text."</option>\n";
                        }
                    }
                echo "</select>\n";
            }

            echo "<p class='description'>$desc</div>";


        }

        function settings_field_page_select($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            $options = isset($args['options']) ? $args['options'] : array();

            $all_page_ids = get_all_page_ids();
            if(!empty($all_page_ids)){
            echo '<select id="'. $this->option_name .'['. $id .']" class="post_form" name="'. $this->option_name .'['. $id .']">\n';
                $is_selected = false;
                if(!empty($options)){
                    foreach ($options as $opt) {
                        if( isset($opt[0]) && isset($opt[1]) ){
                            echo '<option value="'.$opt[0].'" '.selected( $value, $opt[0], false ).'>'.$opt[1]."</option>\n";
                            if($value == $opt[0]) $is_selected = true;
                        } 
                    }
                }
                foreach ($all_page_ids as $key => $p_id) {
                    $p_p = get_post($p_id);
                    if($p_p->post_status == 'publish'){
                        $selected = ' ';
                        if($is_selected != true){
                            if( $value == $p_id ){
                                $selected = ' selected="selected" ';
                                $is_selected = true;
                            }
                            elseif( isset($args['default_title']) && $args['default_title'] == $p_p->post_title ){
                                $selected = ' selected="selected" ';
                                $is_selected = true;
                            }
                        }
                        echo '<option value="'.$p_id.'" '.$selected.'>'.$p_p->post_title."</option>\n";
                    }
                }
            echo "</select>\n";
            } 
            echo "<p class='description'>$desc</div>";
        }
        function settings_field_user_select($args){
            if(!isset($args['id'])) return;
            $desc = isset($args['desc'])? $args['desc'] : '';

            $id = $args['id'];
            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            $all_user = get_users(array(
                'role__in' => array('Administrator', 'Editor')
            ));
            if(!empty($all_user)){
                echo '<select id="'. $this->option_name .'['. $id .']" class="post_form" name="'. $this->option_name .'['. $id .']">\n';
                    
                    foreach ($all_user as $key => $user) {
                        $selected = '';
                        if($value==$user->ID){
                            $selected = 'selected="selected" ';
                        }
                        echo '<option value="'.$user->ID.'" '.$selected.'>'.$user->user_login."</option>\n";
                    }
                echo "</select>\n";
            }
            echo "<p class='description'>$desc</div>";
        }
        function settings_field_repeat_content($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $fields = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');
            
            $option_field_name = $this->option_name .'['. $id .']';

            echo '<input type="hidden" name="'.$option_field_name .'">'."\n";
            ?>
            <div class="addons-form">
                <div class="repeater-fields-wrap"  data-tmpl="tmpl-content-addfield">
                    <div class="repeater-fields">
                    <?php 
                    if(!empty($fields)){
                        foreach ((array)$fields as $key => $field) {
                            citybook_addons_get_template_part('templates-inner/add-field',false, array( 'index'=>$key,'name'=>$option_field_name,'field'=>$field ) );
                        }
                    }
                    ?>
                    </div>
                    <button class="btn addfield" type="button"><?php  esc_html_e( 'Add Field','citybook-add-ons' );?></button>
                </div>
            </div>

            <?php

            echo "<p class='description'>$desc</div>";

            add_action( 'admin_footer', function()use($option_field_name){
                ?>
                <script type="text/template" id="tmpl-content-addfield">
                    <?php citybook_addons_get_template_part('templates-inner/add-field',false, array( 'name'=>$option_field_name ) );?>
                </script>
                <?php
            });
        }

        function settings_field_repeat_widget($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $widgets = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');
            // echo '<pre>';var_dump($widgets);
            $option_field_name = $this->option_name .'['. $id .']';
            echo '<input type="hidden" name="'.$option_field_name .'">'."\n";

            ?>
            <div class="addons-form">
                <div class="repeater-widgets-wrap"  data-tmpl="tmpl-content-addwidget">
                    <div class="repeater-widgets">
                    <?php 
                    if(!empty($widgets)){
                        foreach ((array)$widgets as $key => $widget) {
                            citybook_addons_get_template_part('templates-inner/add-widget',false, array( 'index'=>$key,'name'=>$option_field_name,'widget'=>$widget ) );
                        }
                    }
                    ?>
                    </div>
                    <button class="btn addwidget" data-name="<?php echo esc_attr( $option_field_name ); ?>" type="button"><?php  esc_html_e( 'Add Widget','citybook-add-ons' );?></button>
                </div>
            </div>
            <?php
            echo "<p class='description'>$desc</div>";
        }

        function settings_field_repeat_key_mobile_app($args){
            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';
            $mobilekeys = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');
            $option_field_name = $this->option_name .'['. $id .']';
            // echo '<input type="hidden" name="'.$option_field_name .'">'."\n";
            
            // var_dump($mobilekeys);
            ?>
                <div class="addons-form">
                    <div class="repeater-key-wrap" data-tmpl="tmpl-key-mobileapp">
                        <div class="repeater-key-mobile-app">
                            <?php 
                                if(!empty($mobilekeys)){
                                    foreach ($mobilekeys as $index => $key) {
                                        citybook_addons_get_template_part('templates-inner/add-key-mobileapp',false, array( 'index'=>$index,'name'=>$option_field_name,'key'=>$key ) );
                                    }
                                }
                            ?>
                        </div>
                        <button class="btn addkeymobileapp button-secondary" type="button" data-name="<?php echo esc_attr( $option_field_name ); ?>"><?php  esc_html_e( 'Add Key','citybook-add-ons' );?></button>
                    </div>
                </div>
                
            <?php
            echo "<p class='description'>$desc</div>";
        }

        function settings_field_color($args) {
            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';
            $value = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : '');

            echo "<input id='$id' class='cth-color-field' name='{$this->option_name}[{$id}]' size='40' type='text' value='{$value}' />";
            echo "<p class='description'>$desc</div>";

        }

        function settings_field_lfeatures($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $selected = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : array());
            $option_field_name = $this->option_name .'['. $id .']';
            echo '<input type="hidden" name="'.$option_field_name .'">'."\n";


            $features = get_terms( array(
                'orderby'       => 'count',
                'taxonomy'      => 'listing_feature',
                'hide_empty'    => isset($args['hide_empty']) ? $args['hide_empty'] : true,
            ) );

            if ( ! empty( $features ) && ! is_wp_error( $features ) ){

                $feature_group = array();
                foreach( $features as $key => $term){
                    if(citybook_addons_get_option('feature_parent_group') == 'yes'){
                        if($term->parent){
                            if(!isset($feature_group[$term->parent]) || !is_array($feature_group[$term->parent])) $feature_group[$term->parent] = array();
                            $feature_group[$term->parent][$term->term_id] = $term->name;
                        }else{
                            if(!isset($feature_group[$term->term_id])) $feature_group[$term->term_id] = $term->name;
                        }
                    }else{
                        if(!isset($feature_group[$term->term_id])) $feature_group[$term->term_id] = $term->name;
                    }
                        
                }



                echo '<div class="lcat-features-wrap">';
                foreach( $feature_group as $tid => $tvalue){
                    if( is_array( $tvalue ) && count( $tvalue ) ){
                        $term = get_term_by( 'id', $tid , 'listing_feature' );
                        // var_dump($term);
                        if($term){

                            $fea_checked = '';
                            if (in_array($tid, (array)$selected)) $fea_checked = ' checked="checked"';
                            echo    '<div class="lcat-feature-item lcat-feature-item-has-children">
                                            
                                            <label class="lcat-fea-lbl" for="'.$option_field_name.'_'.$tid.'">
                                                <input type="checkbox" id="'.$option_field_name.'_'.$tid.'" name="'.$option_field_name.'['.$tid.']" value="'.$tid.'"'.$fea_checked.'>' . $term->name . '
                                            </label>

                                        </div>';


                            echo '<div class="lcat-feature-children">';

                            foreach ($tvalue as $id => $name) {
                                $fea_checked = '';
                                if (in_array($id, (array)$selected)) $fea_checked = ' checked="checked"';
                                echo    '<div class="lcat-feature-item">
                                                
                                                <label class="lcat-fea-lbl" for="'.$option_field_name.'_'.$id.'">
                                                    <input type="checkbox" id="'.$option_field_name.'_'.$id.'" name="'.$option_field_name.'['.$id.']" value="'.$id.'"'.$fea_checked.'>' . $name . '
                                                </label>

                                            </div>';
                            }

                            echo '</div>';
                        }
                        
                    }else{
                        $fea_checked = '';
                        if (in_array($tid, (array)$selected)) $fea_checked = ' checked="checked"';
                        echo    '<div class="lcat-feature-item">
                                        
                                        <label class="lcat-fea-lbl" for="'.$option_field_name.'_'.$tid.'">
                                            <input type="checkbox" id="'.$option_field_name.'_'.$tid.'" name="'.$option_field_name.'['.$tid.']" value="'.$tid.'"'.$fea_checked.'>' . $tvalue . '
                                        </label>

                                    </div>';

                    }
                    
                        
                }
                echo '</div>';//end content-widgets-wrap

            }

            echo "<p class='description'>$desc</div>";
        }


        function settings_field_cth_tags($args) {

            if(!isset($args['id'])) return;
            $id = $args['id'];
            $desc = isset($args['desc'])? $args['desc'] : '';

            $selected = isset($this->options[$id]) ? $this->options[$id] : (isset($args['default']) ? $args['default'] : array());
            $option_field_name = $this->option_name .'['. $id .']';
            echo '<input type="hidden" name="'.$option_field_name .'">'."\n";


            $features = get_terms( array(
                'orderby'       => 'count',
                'taxonomy'      => 'post_tag',
                'hide_empty'    => isset($args['hide_empty']) ? $args['hide_empty'] : true,
            ) );

            if ( ! empty( $features ) && ! is_wp_error( $features ) ){

                echo '<div class="lcat-features-wrap">';
                foreach( $features as $key => $term){
                    $fea_checked = '';
                    if (in_array($term->term_id, (array)$selected)) $fea_checked = ' checked="checked"';
                    echo    '<div class="lcat-feature-item">
                                    
                                    <label class="lcat-fea-lbl" for="'.$option_field_name.'_'.$term->term_id.'">
                                        <input type="checkbox" id="'.$option_field_name.'_'.$term->term_id.'" name="'.$option_field_name.'['.$term->term_id.']" value="'.$term->term_id.'"'.$fea_checked.'>' . $term->name . '
                                    </label>

                                </div>';
                }
                echo '</div>';

            }

            echo "<p class='description'>$desc</div>";
        }


        

        /** 
         * Sanitize options
         *
         * @todo    Check if author/key is valid
         * @since   1.0
         */
        function sanitize_settings($args) {

            return $args;
        }

        /**
         * Main Settings panel
         *
         * @since   1.0
         */
        function view_admin_settings() {
            ?>
            <div class="wrap">
    
                <div id="icon-options-general" class="icon32"></div>
                <h2><?php _e( 'CityBook Add-Ons Settings', 'citybook-add-ons' ); ?></h2>
            
                <?php //settings_errors(); ?>
                <?php
                $active_tab = isset( $_GET[ 'addonstab' ] ) ? $_GET[ 'addonstab' ] : 'general';
                ?>
                <h2 class="nav-tab-wrapper">
                    <?php
                    foreach ($this->option_tabs as $id => $title) {
                        ?>
                        <a href="#cth-addons-tab-<?php echo $id; ?>" data-tabid="<?php echo $id; ?>" class="nav-tab cth-addons-tab <?php echo $active_tab == $id ? ' nav-tab-active' : ''; ?>"><?php echo $title;?></a>
                        <?php
                    }
                    ?>
                </h2>


                <form action="options.php" method="post" id="ctb-addons-options-form">
                <?php
                // $slug = $this->option_name;
                // A settings group name. This should match the group name used in register_setting().
                settings_fields($this->option_name); // Output nonce, action, and option_page fields for a settings page
                // $page - The slug name of the page whose settings sections you want to output. This should match the page name used in add_settings_section().
                // do_settings_sections($this->slug);
                echo "<div class=\"cth-addons-tab-content\">";
                $tabs_options = $this->get_setting_tab_options('');
                if(!empty($tabs_options)){
                    foreach ($tabs_options as $tab => $options) {
                        echo "<div id=\"cth-addons-tab-$tab\" class=\"cth-addons-pane cth-addons-tab-$tab".($active_tab == $tab ? ' current' : '')."\">";
                        do_settings_sections($this->slug. "-$tab");
                        echo "</div>";
                    }
                }
                echo "</div>";

                submit_button();
                ?>
                </form>

            </div>
            <?php
        }
        
        function plugin_info() {
            // hide admin bar front-end
            if(!is_admin() && is_user_logged_in() && in_array( citybook_addons_get_user_role(), citybook_addons_get_option('admin_bar_hide_roles') ) ) {
                show_admin_bar( false );
            }
            
            $this->plugin_url = plugin_dir_url(__FILE__);
            $this->plugin_path = plugin_dir_path(__FILE__);

            $this->option_tabs = array( 
                'general'           => esc_html__( 'General', 'citybook-add-ons' ),
                'register'           => esc_html__( 'Register', 'citybook-add-ons' ),
                'membership'        => esc_html__( 'Membership', 'citybook-add-ons' ),
                'submit_listing'    => esc_html__( 'Submit', 'citybook-add-ons' ),
                'search'            => esc_html__( 'Search', 'citybook-add-ons' ),
                'listings'          => esc_html__( 'Listings', 'citybook-add-ons' ),
                'ads'               => esc_html__( 'ADs', 'citybook-add-ons' ),
                'single'            => esc_html__( 'Single', 'citybook-add-ons' ),
                
                'gmap'              => esc_html__( 'Google Map', 'citybook-add-ons' ),
                'booking'           => esc_html__( 'Booking', 'citybook-add-ons' ),
                'payments'          => esc_html__( 'Payments', 'citybook-add-ons' ),
                'emails'            => esc_html__( 'Emails', 'citybook-add-ons' ),
                'widgets'           => esc_html__( 'Widgets', 'citybook-add-ons' ),
                'maintenance'       => esc_html__( 'Maintenance', 'citybook-add-ons' ),
            );
            // get option array from includes/option_values.php function
            $this->option_options = citybook_addons_get_plugin_options();
        }

    }

}
// plugin option values
require_once CITYBOOK_ADD_ONS_DIR . 'includes/option_values.php';



if(!isset($citybook_addons_options)) $citybook_addons_options = get_option( 'citybook-addons-options', array() );

function citybook_addons_get_option( $setting, $default = null ) {
    global $citybook_addons_options;

    $default_options = array(
        'users_can_submit_listing'              => 'no',

        'maintenance_mode'                      => 'disable',
        'listings_count'                        => '6',

        'map_pos'                               => 'right',
        'filter_pos'                            => 'left_col',
        'columns_grid'                          => 'two',

        'listing_location_result_type'          => 'administrative_area_level_1',
        'country_restrictions'                  => '',

        'gmap_marker'                           => array(
            'url' => '',
            'id' => ''
        ),

        'payments_stripe_use_email'             => 'yes',

        'membership_package_expired_hide'       => 'no',
        'membership_single_expired_hide'        => 'no',

        // default submit listing will expired in days
        'listing_expire_days'                   => 30,

        'submit_redirect'                       => 'single',

        'single_show_rating'                    => '1',
        'rating_base'                           => 5,

        'gmap_default_lat'                      => '40.7',
        'gmap_default_long'                     => '-73.87',

        'enable_img_click'                      => 'no',
        'vat_tax'                               => 10,
        'auto_active_free_sub'                  => 'no',
        'search_include_tag'                    => 'no',
        'search_tax_relation'                   => 'AND',

        'ads_archive_enable'                    => 'yes',
        'ads_archive_count'                     => '2',
        'ads_archive_orderby'                   => 'date',
        'ads_archive_order'                     => 'DESC',

        'ads_category_enable'                   => 'yes',
        'ads_category_count'                    => '2',
        'ads_category_orderby'                  => 'date',
        'ads_category_order'                    => 'DESC',

        'ads_search_enable'                     => 'yes',
        'ads_search_count'                      => '2',
        'ads_search_orderby'                    => 'date',
        'ads_search_order'                      => 'DESC',

        'ads_sidebar_enable'                    => 'yes',
        'ads_sidebar_count'                     => '2',
        'ads_sidebar_orderby'                   => 'date',
        'ads_sidebar_order'                     => 'DESC',

        'ads_home_enable'                       => 'yes',
        'ads_home_count'                        => '2',
        'ads_home_orderby'                      => 'date',
        'ads_home_order'                        => 'DESC',

        'ads_custom_grid_enable'                => 'yes',
        'ads_custom_grid_count'                 => '2',
        'ads_custom_grid_orderby'               => 'date',
        'ads_custom_grid_order'                 => 'DESC',

        'listings_grid_layout'                  => 'grid',
        
        'submit_timezone_hide'                  => 'no',

        'use_clock_24h'                         => 'yes',

        'free_submit_page'                      => 'default',

        'new_user_email'                        => 'both',
        'register_auto_login'                   => 'no',

        'register_term_text'                    => 'By using the website, you accept the terms and conditions',
        'register_consent_data_text'            => 'Consent to processing of personal data',
        
        'search_cat_level'                      => '0',
        'search_load_subcat'                    => 'yes',

        'gmap_default_zoom'                     => 10,
        'always_show_submit'                    => 'yes',

        'emails_section_customer_booking_insert_enable'     => 'yes',
        'emails_section_customer_booking_insert_subject'    => '',
        'emails_section_customer_booking_insert_temp'       => '',

        'emails_section_customer_booking_approved_enable'     => 'yes',
        'emails_section_customer_booking_approved_subject'    => '',
        'emails_section_customer_booking_approved_temp'       => '',

        'booking_clock_24h'                     => 'yes',
        'time_picker_color'                     => '#4DB7FE',
        'add_cart_delay'                        => 3000,

        'booking_author_woo'                    => 'no',

        'submit_media_limit'                    => 3,
        'submit_media_limit_size'               => 2,

        'register_password'                     => 'no',
        'enable_g_recaptcah'                    => 'no',
        'g_recaptcha_site_key'                  => '',
        'g_recaptcha_secret_key'                => '',

        'listings_orderby'                      => 'date',
        'listings_order'                        => 'DESC',

        'db_hide_messages'                      => 'no',
        'db_hide_packages'                      => 'no',
        'db_hide_ads'                           => 'no',
        'db_hide_invoices'                      => 'no',
        'db_hide_bookings'                      => 'no',
        'db_hide_bookmarks'                     => 'no',
        'db_hide_reviews'                       => 'no',
        'db_hide_adnew'                         => 'no',

        'grid_wkhour'                           => 'yes',
        'grid_price'                            => 'yes',
        'grid_price_range'                      => 'yes',
        'grid_viewed_count'                     => 'yes',

        'listing_event_date'                    => 'yes',

        'feature_parent_group'                  => 'yes',

        // 'submit_hide_content_head'              => 'no',
        // 'submit_hide_head_background'           => 'no',
        // 'submit_hide_head_carousel'             => 'no',
        // 'submit_hide_head_video'                => 'no',
        // 'submit_hide_content_video'             => 'no',
        // 'submit_hide_content_gallery'           => 'no',
        // 'submit_hide_content_slider'            => 'no',
        // 'submit_hide_price_opt'                 => 'no',
        // 'submit_hide_faqs_opt'                  => 'no',
        // 'submit_hide_counter_opt'               => 'no',
        // 'submit_hide_workinghours_opt'          => 'no',
        // 'submit_hide_socials_opt'               => 'no',



        'filter_hide_string'                    => 'no',
        'filter_hide_loc'                       => 'no',
        'filter_hide_cat'                       => 'no',
        'filter_hide_address'                   => 'no',
        'filter_hide_event_date'                => 'no',
        'filter_hide_event_time'                => 'no',
        'filter_hide_open_now'                  => 'no',
        'filter_hide_price_range'               => 'no',
        'filter_hide_sortby'                    => 'no',


        'admin_bar_front'                       => 'no',

        // 'single_hide_contacts_info'             => 'no',
        // 'single_hide_booking_form_widget'       => 'no',
        // 'single_hide_addfeatures_widget'        => 'no',
        // 'single_hide_contacts_widget'           => 'no',
        // 'single_hide_author_widget'             => 'no',
        // 'single_hide_moreauthor_widget'         => 'no',


        'listing_address_format'                => 'formatted_address',
        'google_map_language'                   => '',
        'multiple_cat'                          => 'no',
        'allow_rating_imgs'                     => 'yes',
        // 'single_hide_weather_widget'            => 'no',

        'single_post_nav'                       => 'yes',
        'single_same_term'                      => '0',
        'filter_features'                       => array(),

        'register_no_redirect'                  => 'yes',
        'filter_ltags'                          => array(),

        'login_redirect_page'                   => 'cth_current_page',

        'emails_auth_claim_subject'             => '',
        'emails_auth_claim_temp'                => '',

        'approve_claim_after_paid'              => 'yes',

        'distance_min'                          => 2,
        'distance_max'                          => 20,
        'distance_df'                           => 5,

        'booking_approved_cancel'               => 'yes',

        'booking_author_delete'                 => 'yes',
        'booking_del_trash'                     => 'no',

        'admin_bar_hide_roles'                  => array('l_customer','listing_author','subscriber','contributor','author'),

        'single_hide_claim'                     => 'no',
        'single_hide_claimed'                   => 'yes',

        'emails_admin_new_claim_enable'         => 'yes',
        'emails_admin_new_claim_recipients'     => '',
        'emails_admin_new_claim_subject'        => '',
        'emails_admin_new_claim_temp'           => '',

        'emails_auth_new_claim_enable'          => '',
        'emails_auth_new_claim_subject'         => '',
        'emails_auth_new_claim_temp'            => '',
        'messages_first_load'                   => 10,
        'messages_prev_load'                    => 5,

        'all_info_for_admin'                    => 'yes',

        'admin_lplan'                           => 0,
        'free_lplan'                            => 0,

        'use_osm_map'                           => 'no',
        'gmap_single_zoom'                      => 16,
        'gmap_type'                             => 'ROADMAP',

        'logreg_form_before'                    => '<p>For faster login or register use your social account.</p>[fbl_login_button redirect="" hide_if_logged="" size="large" type="continue_with" show_face="true"]',
        'checkout_success_page'                 => 'none',
    );
    $value = false;
    if ( isset( $citybook_addons_options[ $setting ] ) ) {
        $value = $citybook_addons_options[ $setting ];
    }else {
        if(isset($default)){
            $value = $default;
        }else if( isset( $default_options[ $setting ] ) ){
            $value = $default_options[ $setting ];
        }
    }
    return $value;
}


$citybook_addons = new CityBook_Addons;
$citybook_addons->init();
