<?php 
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



function citybook_addons_scheduleExpireEvent($id,$ts){
	if (wp_next_scheduled('listingExpireAction',array($id)) !== false) {
		wp_clear_scheduled_hook('listingExpireAction',array($id)); //Remove any existing hooks
		if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> found - unscheduled" . PHP_EOL, 3, CTH_LOG_FILE);
	}
	wp_schedule_single_event($ts,'listingExpireAction',array($id));

	if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> scheduled at ".date_i18n('r',$ts)." "."(".$ts.")" . PHP_EOL, 3, CTH_LOG_FILE);
}

function citybook_addons_unscheduleExpireEvent($id) {
	// Delete Scheduled Expiration
	if (wp_next_scheduled('listingExpireAction',array($id)) !== false) {
		wp_clear_scheduled_hook('listingExpireAction',array($id)); //Remove any existing hooks
		if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> found - unscheduled" . PHP_EOL, 3, CTH_LOG_FILE);
	}
}
function listingExpireActionCallback($id){
	if (empty($id)) {
		if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "No listing ID found - exiting" . PHP_EOL, 3, CTH_LOG_FILE);
		return false;
	}

	if (is_null(get_post($id))) {
		if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> Post does not exist - exiting" . PHP_EOL, 3, CTH_LOG_FILE);
		return false;
	}

	// Remove KSES - wp_cron runs as an unauthenticated user, which will by default trigger kses filtering,
	// even if the post was published by a admin user.  It is fairly safe here to remove the filter call since
	// we are only changing the post status/meta information and not touching the content.
	// kses_remove_filters();

	if (wp_update_post(array('ID' => $id, 'post_status' => 'pending')) == 0) {
		if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> Failed save post to draft" . PHP_EOL, 3, CTH_LOG_FILE);
	}

    citybook_addons_user_add_notification( get_post_field( 'post_author', $id ), array(
        'type' => 'listing_expired',
        'message' => sprintf(__( 'Your subscription is expired. Please update/purchase new membership plan then edit listing to get it back.', 'citybook-add-ons' ), esc_url( get_the_permalink($id) ), get_post_field( 'post_title', $id ) ) 
    ));
    // your subscription is expired

    do_action( 'citybook_listing_expired', $id );
}
add_action( 'listingExpireAction', 'listingExpireActionCallback' );

// for AD expiration
function citybook_addons_scheduleExpireADEvent($id,$ts){
    if (wp_next_scheduled('listingExpireADAction',array($id)) !== false) {
        wp_clear_scheduled_hook('listingExpireADAction',array($id)); //Remove any existing hooks
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> found - unscheduled" . PHP_EOL, 3, CTH_LOG_FILE);
    }
    wp_schedule_single_event($ts,'listingExpireADAction',array($id));

    if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> scheduled at ".date_i18n('r',$ts)." "."(".$ts.")" . PHP_EOL, 3, CTH_LOG_FILE);
}
function citybook_addons_unscheduleExpireADEvent($id) {
    // Delete Scheduled Expiration
    if (wp_next_scheduled('listingExpireADAction',array($id)) !== false) {
        wp_clear_scheduled_hook('listingExpireADAction',array($id)); //Remove any existing hooks
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> found - unscheduled" . PHP_EOL, 3, CTH_LOG_FILE);
    }
}
function citybook_addons_adExpireActionCallback($id){
    if (empty($id)) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "No listing ID found - exiting" . PHP_EOL, 3, CTH_LOG_FILE);
        return false;
    }

    if (is_null(get_post($id))) {
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "ID: $id -> Post does not exist - exiting" . PHP_EOL, 3, CTH_LOG_FILE);
        return false;
    }

    // Remove KSES - wp_cron runs as an unauthenticated user, which will by default trigger kses filtering,
    // even if the post was published by a admin user.  It is fairly safe here to remove the filter call since
    // we are only changing the post status/meta information and not touching the content.
    // kses_remove_filters();

    $ad_listing = get_post_meta( $id, P_META_PREFIX.'listing_id', true );

    citybook_addons_user_add_notification( get_post_field( 'post_author', $id ), array(
        'type' => 'ad_expired',
        'message' => sprintf(__( 'Your advertisement for <a href="%s" target="_blank">%s</a> listing is expired.', 'citybook-add-ons' ), esc_url( get_the_permalink($ad_listing) ), get_post_field( 'post_title', $ad_listing ) ) 
    ));

    do_action( 'citybook_ad_expired', $id );
}
add_action( 'listingExpireAction', 'citybook_addons_adExpireActionCallback' );

