<?php 
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


class CTB_Update {
	/**
	 * Instance.
	 *
	 * Holds the CTB_Update instance.
	 *
	 */
	public static $instance = null;

	public static $messages = array('<p>Thank you for using this plugin! <strong>'.CITYBOOK_ADD_ONS_VERSION.'</strong>.</p>');

	/**
	 * Instance.
	 *
	 * Ensures only one instance of the class is loaded or can be loaded.
	 *
	 *
	 * @return CTB_Update An instance of the class.
	 */
	public static function instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	public static function update(){
		set_transient( 'ctb-update-admin-notice', true, 30 );

		self::$messages[] = '<p>Thank you for using this plugin! <strong>'.CITYBOOK_ADD_ONS_VERSION.'</strong>.</p>';
	}

	public function admin_notices(){

		/* Check transient, if available display notice */
	    if( get_transient( 'ctb-update-admin-notice' ) ){
	        ?>
	        <div class="updated notice is-dismissible">
	            <?php echo implode("<br>", self::$messages); ?>
	        </div>
	        <?php
	        /* Delete transient, only display this notice once. */
	        delete_transient( 'ctb-update-admin-notice' );
	    }
	}
	private function __construct() {
		register_activation_hook(CITYBOOK_ADD_ONS_PLUGIN_FILE, array('CTB_Update', 'update'));

		add_action( 'admin_notices', [ $this, 'admin_notices' ] );
	}

}

// CTB_Update::instance();


function citybook_addons_update_message_system() {
	global $wpdb;

	$chat_table = $wpdb->prefix . 'cth_chat';
	$chat_reply_table = $wpdb->prefix . 'cth_chat_reply';
	$charset_collate = $wpdb->get_charset_collate();

	$chat_sql = "CREATE TABLE IF NOT EXISTS $chat_table (
		c_id int(11) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
		user_one bigint(20) UNSIGNED NOT NULL,
		user_two bigint(20) UNSIGNED NOT NULL,
		ip varchar(30) DEFAULT NULL,
		time int(11) DEFAULT NULL,
		FOREIGN KEY (user_one) REFERENCES $wpdb->users(ID),
		FOREIGN KEY (user_two) REFERENCES $wpdb->users(ID)
	) $charset_collate;";

	$chat_reply_sql = "CREATE TABLE IF NOT EXISTS $chat_reply_table (
		cr_id bigint(20) UNSIGNED NOT NULL PRIMARY KEY AUTO_INCREMENT,
		reply text,
		user_id_fk bigint(20) UNSIGNED NOT NULL,
		ip varchar(30) DEFAULT NULL,
		time int(11) DEFAULT NULL,
		c_id_fk int(11) UNSIGNED NOT NULL,
		status TINYINT(1) DEFAULT 0,
		FOREIGN KEY (user_id_fk) REFERENCES $wpdb->users(ID),
		FOREIGN KEY (c_id_fk) REFERENCES {$chat_table}(c_id)
	) $charset_collate;";

	


	require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
	dbDelta( $chat_sql );
	dbDelta( $chat_reply_sql );

	// update existing messages to chats

	$args = array(
	    // 'fields'        => 'ids',
	    'post_type'     	=>  'lmessage', 
	    'post_status'     	=>  'publish', 
	    'posts_per_page' 	=> -1, // no limit

	    // 'meta_key'			=> 'to_user_id',
	    'orderby'			=> 'date',
	    'order'				=> 'ASC',
	);
	$posts = get_posts( $args );

	// var_dump($posts);die;

	if(!empty($posts)){
	    foreach ($posts as $post) {
	        // need to check for not register user and deleted user - WordPress database error Cannot add or update a child row: a foreign key constraint fails (`cththemes_citybook`.`wp_cth_chat`, CONSTRAINT `wp_cth_chat_ibfk_1` FOREIGN KEY (`user_one`) REFERENCES `wp_users` (`ID`)) for query INSERT INTO `wp_cth_chat` (`user_one`, `user_two`, `ip`, `time`) VALUES ('0', '1', '', '1524483726') 
	    	$from_user_id = get_post_meta( $post->ID, P_META_PREFIX.'from_user_id', true );
	    	$to_user_id = get_post_meta( $post->ID, P_META_PREFIX.'to_user_id', true );

	    	if( $from_user_id && $to_user_id ){
	    		// get created chats
	    		$old_c_id = $wpdb->get_var( $wpdb->prepare( 
					"
					SELECT c_id 
					FROM $chat_table 
					WHERE 
						CASE
							WHEN user_one = %s
								THEN user_two = %s
							WHEN user_two = %s
								THEN user_one= %s
						END
					AND (user_one = %s OR user_two = %s)
					", 
					$from_user_id,
					$to_user_id,
					$from_user_id,
					$to_user_id,
					$from_user_id,
					$from_user_id
				) );

				if(empty($old_c_id)){
					$result = $wpdb->insert( 
						$chat_table, 
						array( 
							
							'user_one' 	=> $from_user_id, 
							'user_two' 	=> $to_user_id, 
							'ip' 		=> '', 
							'time' 		=> strtotime( $post->post_date_gmt ), 
						) 
					);
					// end inshert chat
					// https://codex.wordpress.org/Class_Reference/wpdb#INSERT_row
					if($result != false){
						$old_c_id = $wpdb->insert_id;
					}
				}

				if(!empty($old_c_id)){
					$wpdb->insert( 
						$chat_reply_table, 
						array( 
							
							'user_id_fk' 	=> $from_user_id, 
							'reply' 		=> get_post_meta( $post->ID, P_META_PREFIX.'lmsg_message', true ), 
							'ip' 			=> '', 
							'time' 			=> strtotime( $post->post_date_gmt ), 
							'c_id_fk'		=> $old_c_id
						) 
					);
				}
				// end insert chat reply

			} // end check for users

	    }
	}


}

function citybook_addons_update_to_version_1_2_9() {

	$working_days = citybook_addons_get_working_days_array();
	foreach ($working_days as $day => $dayLbl ) {
		if($day != $dayLbl){
			$statics = citybook_addons_get_meta_values( P_META_PREFIX."wkh_status_{$dayLbl}", 'listing', array('publish', 'pending') ); 
			if(is_array($statics) && count($statics)){
	            foreach ($statics as $l_ID => $static) {
	                update_post_meta( $l_ID, P_META_PREFIX."wkh_status_{$day}", $static );

	                delete_post_meta( $l_ID, P_META_PREFIX."wkh_status_{$dayLbl}" );
	            }
	        }
	        $old_hours = citybook_addons_get_meta_values( P_META_PREFIX."wkh_hours_{$dayLbl}", 'listing', array('publish', 'pending') ); 
	        if(is_array($old_hours) && count($old_hours)){
	            foreach ($old_hours as $l_ID => $old_hour) {
	                update_post_meta( $l_ID, P_META_PREFIX."wkh_hours_{$day}", $old_hour );

	                delete_post_meta( $l_ID, P_META_PREFIX."wkh_hours_{$dayLbl}" );
	            }
	        }
		}
    }

}

function citybook_addons_update_to_version_1_3_0(){
	global $wpdb;

	// $dbname = $wpdb->dbname;
	$chat_table = $wpdb->prefix . 'cth_chat';

	// $chat_tables = $wpdb->get_results( 
	// 	"
	// 	SELECT * 
	// 	FROM information_schema.tables
	// 	WHERE table_schema = $dbname 
	// 	    AND table_name = $chat_table
	// 	LIMIT 1
	// 	"
	// );

	if($wpdb->get_var("SHOW TABLES LIKE '$chat_table'") != $chat_table) {
	    // do something
	    citybook_addons_update_message_system();
	}

	// if ( !$chat_tables ){
	// 	citybook_addons_update_message_system();
	// }

}