<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */





function citybook_addons_get_user_role( $user_id = 0 ) {
    // https://core.trac.wordpress.org/ticket/22624
    $user = ( $user_id ) ? get_userdata( $user_id ) : wp_get_current_user();
    return current( $user->roles );
}
// not used yet
function citybook_addons_get_author_roles(){
    if ( ! function_exists( 'get_editable_roles' ) ) {
        require_once ABSPATH . 'wp-admin/includes/user.php';
    }
    $roles = array();
    $editable_roles = array_reverse( get_editable_roles() );
    foreach ( $editable_roles as $role => $details ) {
        // $name = translate_user_role($details['name'] );
        $roles[esc_attr( $role )] = translate_user_role($details['name'] );
    }

    return $roles;
}

function citybook_addons_current_user_can($custom_cap = 'submit_listing'){
    $user_can = false;
    // check for submit listing capability
    if($custom_cap === 'submit_listing'){
        if( citybook_addons_get_option('users_can_submit_listing') == 'yes' ){
            $user_can = true;
        }elseif(current_user_can( 'submit_listing' )){
            $current_role = citybook_addons_get_user_role();
            if($current_role == 'administrator'){
                $user_can = true;
            }else{
                

                $user_current_subscription = citybook_addons_get_current_subscription();
                if($user_current_subscription){
                    $order_listings = get_post_meta( $user_current_subscription['id'], P_META_PREFIX.'listings', true );
                    if($user_current_subscription['plan_llimit'] == 'unlimited' || count((array)$order_listings) < (int)$user_current_subscription['plan_llimit'] ) $user_can = true;
                }

                // $user_membership = get_user_meta( get_current_user_id(), P_META_PREFIX.'member_plan', true );
                // $payment_date = get_user_meta( get_current_user_id(), P_META_PREFIX.'payment_date', true );

                // unlimited
                // if( get_post_meta( $user_membership , P_META_PREFIX.'lunlimited', true ) ){
                //     $user_can = true;
                // }else{
                //     // plan metas
                //     $plan_llimit = get_post_meta( $user_membership , P_META_PREFIX.'llimit', true );
                //     // get author listing post
                //     $l_args = array(
                //         'post_type'     =>  'listing', 
                //         'post_status'   => array( 'publish', 'pending', 'draft', 'future' ),
                //         'author' => get_current_user_id(),
                //         'date_query' => array(
                //             'relation' => 'OR',
                //             array(
                //                 'column' => 'post_date_gmt',
                //                 'after' => $payment_date,

                //                 // 'inclusive' => true,
                //             ),
                //             array(
                //                 'column' => 'post_date',
                //                 'after' => $payment_date,

                //                 // 'inclusive' => true,
                //             ),
                //             'inclusive' => true,
                            
                //         ),
                //         'posts_per_page' => -1,
                //     );
                    
                //     $l_posts = get_posts( $l_args );

                //     if( count($l_posts) < (int)$plan_llimit ) {
                //         $user_can = true;
                //     }

                //     // return false;
                // }
            }
            // end if not administrator
        }

        // if( citybook_addons_get_option('users_can_submit_listing') == 'yes' || current_user_can( 'submit_listing' ) ){
        //     $user_can = true;
        // }
    }
    if($custom_cap === 'view_listings_dashboard'){
        if( citybook_addons_get_option('users_can_submit_listing') == 'yes' || current_user_can( 'submit_listing' )){
            $user_can = true;
        }
    }
    // return false;
    return $user_can;
}

function citybook_addons_get_submit_link(){
    $current_sub = citybook_addons_get_current_subscription();
    // if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "Current subscription: " .json_encode($current_sub). PHP_EOL, 3, CTH_LOG_FILE);
    // if($current_sub && $current_sub['valid']) 
    $free_submit_page = citybook_addons_get_option('free_submit_page');
    if($free_submit_page == 'default' || ($current_sub && $current_sub['valid']) ){
        $submit_link = get_permalink( citybook_addons_get_option('submit_page') );
    }else{
        $submit_link = get_permalink( citybook_addons_get_option('free_submit_page') );
    }

    return esc_url($submit_link);
}

/**
 * Return attachment image link by using wp_get_attachment_image_src function
 *
 */
function citybook_addons_get_attachment_thumb_link( $id, $size = 'thumbnail'){
    $image_attributes = wp_get_attachment_image_src( $id, $size, false );
    if ( $image_attributes ) {
        return $image_attributes[0];
    }
    return '';
}

function citybook_addons_get_current_url(){
    global $wp;
    // get current page with query string
    return add_query_arg( $_SERVER['QUERY_STRING'], '', home_url( $wp->request ) );

    
    // $current_url = home_url(add_query_arg(array(),$wp->request));
    // return $current_url;
}

/** 
 * get template part file related to plugin folder
 *
 */
if(!function_exists('citybook_addons_get_template_part')){
    /**
     * Load a template part into a template
     *
     * Makes it easy for a theme to reuse sections of code in a easy to overload way
     * for child themes.
     *
     * Includes the named template part for a theme or if a name is specified then a
     * specialised part will be included. If the theme contains no {slug}.php file
     * then no template will be included.
     *
     * The template is included using require, not require_once, so you may include the
     * same template part multiple times.
     *
     * For the $name parameter, if the file is called "{slug}-special.php" then specify
     * "special".
      * For the var parameter, simple create an array of variables you want to access in the template
     * and then access them e.g. 
     * 
     * array("var1=>"Something","var2"=>"Another One","var3"=>"heres a third";
     * 
     * becomes
     * 
     * $var1, $var2, $var3 within the template file.
     *
     * @since 1.0.0
     *
     * @param string $slug The slug name for the generic template.
     * @param string $name The name of the specialised template.
     * @param array $vars The list of variables to carry over to the template
     * @author CTHthemes 
     * @ref http://www.zmastaa.com/2015/02/06/php-2/wordpress-passing-variables-get_template_part
     * @ref http://keithdevon.com/passing-variables-to-get_template_part-in-wordpress/
     */
    function citybook_addons_get_template_part( $slug, $name = null, $vars = null ) {
        //templates-inner/add-widget
        $template = "{$slug}.php";
        $name = (string) $name;
        // var_dump(CITYBOOK_ADD_ONS_DIR ."{$slug}-{$name}.php");
        if ( '' !== $name && file_exists( CITYBOOK_ADD_ONS_DIR ."{$slug}-{$name}.php" ) ) {
            $template = "{$slug}-{$name}.php";
        }

        if(isset($vars)) extract($vars);
        if($located = locate_template( 'cth_listing/'.$template )){
            include($located);
        }else{
            include(CITYBOOK_ADD_ONS_DIR.$template);
        }
        // include(citybook_addons_locate_template($template));
        
    }

 //    function citybook_addons_locate_template($template_names, $load = false, $require_once = true ) {
    //  $located = '';
    //  foreach ( (array) $template_names as $template_name ) {
    //      if ( !$template_name )
    //          continue;
    //      if ( file_exists(CITYBOOK_ADD_ONS_DIR . '/' . $template_name)) {
    //          $located = CITYBOOK_ADD_ONS_DIR . '/' . $template_name;
    //          break;
    //      } elseif ( file_exists(CITYBOOK_ADD_ONS_DIR . '/' . $template_name) ) {
    //          $located = CITYBOOK_ADD_ONS_DIR . '/' . $template_name;
    //          break;
    //      } elseif ( file_exists( ABSPATH . WPINC . '/theme-compat/' . $template_name ) ) {
    //          $located = ABSPATH . WPINC . '/theme-compat/' . $template_name;
    //          break;
    //      }
    //  }

    //  if ( $load && '' != $located )
    //      load_template( $located, $require_once );

    //  return $located;
    // }
}

function citybook_addons_get_working_days_array(){
    $days = array(
        'Monday' => __( 'Monday',  'citybook-add-ons' ),
        'Tuesday' => __( 'Tuesday',  'citybook-add-ons' ),
        'Wednesday' => __( 'Wednesday',  'citybook-add-ons' ),
        'Thursday' => __( 'Thursday',  'citybook-add-ons' ),
        'Friday' => __( 'Friday',  'citybook-add-ons' ),
        'Saturday' => __( 'Saturday',  'citybook-add-ons' ),
        'Sunday' => __( 'Sunday',  'citybook-add-ons' ),
    );
    return $days;
}

function citybook_addons_get_listing_working_hours_data( $post_id = 0 ){
    $data = array();
    $data['timezone'] = get_post_meta( $post_id, P_META_PREFIX."wkh_tz", true );
    $working_days = citybook_addons_get_working_days_array();

    foreach ($working_days as $day => $dayLbl ) {
        $data[$day] = array(
            'static'    => get_post_meta( $post_id, P_META_PREFIX."wkh_status_{$day}", true ),
            'hours'     => array(),
        );
        $meta_hours = get_post_meta( $post_id, P_META_PREFIX."wkh_hours_{$day}", true );
        $meta_hours = array_filter(explode(" ", $meta_hours));
        foreach ($meta_hours as $hour) {
            $cl_op = array_filter(explode("-", $hour));
            if(count($cl_op) == 2) $data[$day]['hours'][] = array('open'=>$cl_op[0],'close'=>$cl_op[1]);
        }

    }

    return $data;
}

function citybook_addons_do_update_listing_working_hours( $l_ID = 0, $meta_value = array() ){

    if(is_array($meta_value) && count($meta_value)){
        // update timezone
        if(isset($meta_value['timezone']) && $meta_value['timezone'] != ''){
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz", $meta_value['timezone']);
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz_offset", citybook_addons_get_timezone_offset($meta_value['timezone']));
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz_utc_offset", citybook_addons_get_mysql_timezone_offset($meta_value['timezone']));
        }else{
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz", 'UTC');
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz_offset", 0);
            update_post_meta($l_ID, P_META_PREFIX."wkh_tz_utc_offset", 0);
        }
        // update working days
        foreach (citybook_addons_get_working_days_array() as $day => $dayLbl ) {
            if(isset($meta_value[$day]) && is_array($meta_value[$day]) && count($meta_value[$day])){
                if(isset($meta_value[$day]['static'])){
                    update_post_meta($l_ID, P_META_PREFIX."wkh_status_{$day}", $meta_value[$day]['static']);
                }else{
                    update_post_meta($l_ID, P_META_PREFIX."wkh_status_{$day}", 'closeAllDay');
                }
                if(isset($meta_value[$day]['hours']) && is_array($meta_value[$day]['hours']) && count($meta_value[$day]['hours'])){
                    $hours = array();
                    foreach ($meta_value[$day]['hours'] as $hour) {
                        if($hour['open'] != '' && $hour['close'] != '')
                            $hours[] = "{$hour['open']}-{$hour['close']}";
                    }
                    update_post_meta($l_ID, P_META_PREFIX."wkh_hours_{$day}", implode(" ", $hours));
                }else{
                    update_post_meta($l_ID, P_META_PREFIX."wkh_hours_{$day}", '');
                }
            }
            else{
                update_post_meta($l_ID, P_META_PREFIX."wkh_status_{$day}", 'closeAllDay');
                update_post_meta($l_ID, P_META_PREFIX."wkh_hours_{$day}", '');
            }
        }
        // end update days
    }else{
        update_post_meta($l_ID, P_META_PREFIX."wkh_tz", 'UTC');
        update_post_meta($l_ID, P_META_PREFIX."wkh_tz_offset", 0);
        update_post_meta($l_ID, P_META_PREFIX."wkh_tz_utc_offset", 0);
        foreach (citybook_addons_get_working_days_array() as $day => $dayLbl ) {
            update_post_meta($l_ID, P_META_PREFIX."wkh_status_{$day}", 'closeAllDay');
            update_post_meta($l_ID, P_META_PREFIX."wkh_hours_{$day}", '');
        }
    }
                
}

function citybook_addons_get_working_hours_array(){
    $hours = array(
        '0:00' => __( '0:00 AM',  'citybook-add-ons' ),
        '0:30' => __( '0:30 AM',  'citybook-add-ons' ),

        '1:00' => __( '1:00 AM',  'citybook-add-ons' ),
        '1:30' => __( '1:30 AM',  'citybook-add-ons' ),

        '2:00' => __( '2:00 AM',  'citybook-add-ons' ),
        '2:30' => __( '2:30 AM',  'citybook-add-ons' ),

        '3:00' => __( '3:00 AM',  'citybook-add-ons' ),
        '3:30' => __( '3:30 AM',  'citybook-add-ons' ),
        
        '4:00' => __( '4:00 AM',  'citybook-add-ons' ),
        '4:30' => __( '4:30 AM',  'citybook-add-ons' ),

        '5:00' => __( '5:00 AM',  'citybook-add-ons' ),
        '5:30' => __( '5:30 AM',  'citybook-add-ons' ),

        '6:00' => __( '6:00 AM',  'citybook-add-ons' ),
        '6:30' => __( '6:30 AM',  'citybook-add-ons' ),

        '7:00' => __( '7:00 AM',  'citybook-add-ons' ),
        '7:30' => __( '7:30 AM',  'citybook-add-ons' ),

        '8:00' => __( '8:00 AM',  'citybook-add-ons' ),
        '8:30' => __( '8:30 AM',  'citybook-add-ons' ),

        '9:00' => __( '9:00 AM',  'citybook-add-ons' ),
        '9:30' => __( '9:30 AM',  'citybook-add-ons' ),

        '10:00' => __( '10:00 AM',  'citybook-add-ons' ),
        '10:30' => __( '10:30 AM',  'citybook-add-ons' ),

        '11:00' => __( '11:00 AM',  'citybook-add-ons' ),
        '11:30' => __( '11:30 AM',  'citybook-add-ons' ),

        '12:00' => __( '12:00 PM',  'citybook-add-ons' ),
        '12:30' => __( '12:30 PM',  'citybook-add-ons' ),

        '13:00' => __( '1:00 PM',  'citybook-add-ons' ),
        '13:30' => __( '1:30 PM',  'citybook-add-ons' ),

        '14:00' => __( '2:00 PM',  'citybook-add-ons' ),
        '14:30' => __( '2:30 PM',  'citybook-add-ons' ),

        '15:00' => __( '3:00 PM',  'citybook-add-ons' ),
        '15:30' => __( '3:30 PM',  'citybook-add-ons' ),

        '16:00' => __( '4:00 PM',  'citybook-add-ons' ),
        '16:30' => __( '4:30 PM',  'citybook-add-ons' ),

        '17:00' => __( '5:00 PM',  'citybook-add-ons' ),
        '17:30' => __( '5:30 PM',  'citybook-add-ons' ),

        '18:00' => __( '6:00 PM',  'citybook-add-ons' ),
        '18:30' => __( '6:30 PM',  'citybook-add-ons' ),

        '19:00' => __( '7:00 PM',  'citybook-add-ons' ),
        '19:30' => __( '7:30 PM',  'citybook-add-ons' ),

        '20:00' => __( '8:00 PM',  'citybook-add-ons' ),
        '20:30' => __( '8:30 PM',  'citybook-add-ons' ),

        '21:00' => __( '9:00 PM',  'citybook-add-ons' ),
        '21:30' => __( '9:30 PM',  'citybook-add-ons' ),

        '22:00' => __( '10:00 PM',  'citybook-add-ons' ),
        '22:30' => __( '10:30 PM',  'citybook-add-ons' ),

        '23:00' => __( '11:00 PM',  'citybook-add-ons' ),
        '23:30' => __( '11:30 PM',  'citybook-add-ons' ),

        '24:00' => __( '12:00 PM',  'citybook-add-ons' ),
        
    );
    if(citybook_addons_get_option('use_clock_24h') == 'yes'){
        $hours = array(
            '0:00' => __( '00:00',  'citybook-add-ons' ),
            '0:30' => __( '00:30',  'citybook-add-ons' ),

            '1:00' => __( '01:00',  'citybook-add-ons' ),
            '1:30' => __( '01:30',  'citybook-add-ons' ),

            '2:00' => __( '02:00',  'citybook-add-ons' ),
            '2:30' => __( '02:30',  'citybook-add-ons' ),

            '3:00' => __( '03:00',  'citybook-add-ons' ),
            '3:30' => __( '03:30',  'citybook-add-ons' ),
            
            '4:00' => __( '04:00',  'citybook-add-ons' ),
            '4:30' => __( '04:30',  'citybook-add-ons' ),

            '5:00' => __( '05:00',  'citybook-add-ons' ),
            '5:30' => __( '05:30',  'citybook-add-ons' ),

            '6:00' => __( '06:00',  'citybook-add-ons' ),
            '6:30' => __( '06:30',  'citybook-add-ons' ),

            '7:00' => __( '07:00',  'citybook-add-ons' ),
            '7:30' => __( '07:30',  'citybook-add-ons' ),

            '8:00' => __( '08:00',  'citybook-add-ons' ),
            '8:30' => __( '08:30',  'citybook-add-ons' ),

            '9:00' => __( '09:00',  'citybook-add-ons' ),
            '9:30' => __( '09:30',  'citybook-add-ons' ),

            '10:00' => __( '10:00',  'citybook-add-ons' ),
            '10:30' => __( '10:30',  'citybook-add-ons' ),

            '11:00' => __( '11:00',  'citybook-add-ons' ),
            '11:30' => __( '11:30',  'citybook-add-ons' ),

            '12:00' => __( '12:00',  'citybook-add-ons' ),
            '12:30' => __( '12:30',  'citybook-add-ons' ),

            '13:00' => __( '13:00',  'citybook-add-ons' ),
            '13:30' => __( '13:30',  'citybook-add-ons' ),

            '14:00' => __( '14:00',  'citybook-add-ons' ),
            '14:30' => __( '14:30',  'citybook-add-ons' ),

            '15:00' => __( '15:00',  'citybook-add-ons' ),
            '15:30' => __( '15:30',  'citybook-add-ons' ),

            '16:00' => __( '16:00',  'citybook-add-ons' ),
            '16:30' => __( '16:30',  'citybook-add-ons' ),

            '17:00' => __( '17:00',  'citybook-add-ons' ),
            '17:30' => __( '17:30',  'citybook-add-ons' ),

            '18:00' => __( '18:00',  'citybook-add-ons' ),
            '18:30' => __( '18:30',  'citybook-add-ons' ),

            '19:00' => __( '19:00',  'citybook-add-ons' ),
            '19:30' => __( '19:30',  'citybook-add-ons' ),

            '20:00' => __( '20:00',  'citybook-add-ons' ),
            '20:30' => __( '20:30',  'citybook-add-ons' ),

            '21:00' => __( '21:00',  'citybook-add-ons' ),
            '21:30' => __( '21:30',  'citybook-add-ons' ),

            '22:00' => __( '22:00',  'citybook-add-ons' ),
            '22:30' => __( '22:30',  'citybook-add-ons' ),

            '23:00' => __( '23:00',  'citybook-add-ons' ),
            '23:30' => __( '23:30',  'citybook-add-ons' ),

            '24:00' => __( '24:00',  'citybook-add-ons' ),
            
        );
    }
    return $hours;
}

function citybook_addons_generate_timezone_list()
{
    static $regions = array(
        DateTimeZone::AFRICA,
        DateTimeZone::AMERICA,
        DateTimeZone::ANTARCTICA,
        DateTimeZone::ASIA,
        DateTimeZone::ATLANTIC,
        DateTimeZone::AUSTRALIA,
        DateTimeZone::EUROPE,
        DateTimeZone::INDIAN,
        DateTimeZone::PACIFIC,
    );

    $timezones = array();
    foreach( $regions as $region )
    {
        $timezones = array_merge( $timezones, DateTimeZone::listIdentifiers( $region ) );
    }

    $timezone_offsets = array();
    foreach( $timezones as $timezone )
    {
        $tz = new DateTimeZone($timezone);
        $timezone_offsets[$timezone] = $tz->getOffset(new DateTime);
    }

    // sort timezone by offset
    asort($timezone_offsets);

    $timezone_list = array();
    foreach( $timezone_offsets as $timezone => $offset )
    {
        $offset_prefix = $offset < 0 ? '-' : '+';
        $offset_formatted = gmdate( 'H:i', abs($offset) );

        $pretty_offset = "UTC${offset_prefix}${offset_formatted}";

        $timezone_list[$timezone] = "(${pretty_offset}) $timezone";
    }

    return $timezone_list;
}

function citybook_addons_get_meta_values( $key = '', $type = 'post', $status = 'publish' ) {
    global $wpdb;
    $metas = array();
    if( empty( $key ) )
        return $metas;
    if( is_array( $status ) && count( $status ) ){
        $w_status = " AND (";

        $statuswheres = array();

        foreach ($status as $stval) {
            $statuswheres[] = $wpdb->prepare("p.post_status = %s", $stval);
        }

        $w_status .= implode(' OR ', $statuswheres);

        $w_status .= ") ";

    }else{
        $w_status = $wpdb->prepare(" AND p.post_status = %s", $status);
    }
    
    $r = $wpdb->get_results( $wpdb->prepare( "
        SELECT p.ID, pm.meta_value FROM {$wpdb->postmeta} pm
        LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
        WHERE pm.meta_key = '%s' 
        AND p.post_type = '%s'
        $w_status 
    ", $key, $type ));

    foreach ( $r as $my_r )
        $metas[$my_r->ID] = $my_r->meta_value;

    return $metas;
}


function citybook_addons_re_format_date( $string,$format = 'Y-m-d H:i:s' ){
    $datetime = date_create( $string );
    if ( ! $datetime ) {
        return gmdate( $format );
    }
    return $datetime->format( $format );
}

function citybook_addons_get_gmt_from_date( $string, $tz = '', $format = 'Y-m-d H:i:s' ){
    if( !$tz ) $tz = get_option( 'timezone_string' );
    if ( $tz ) {
            $datetime = date_create( $string, new DateTimeZone( $tz ) );
            if ( ! $datetime ) {
                    return gmdate( $format, 0 );
            }
            $datetime->setTimezone( new DateTimeZone( 'UTC' ) );
            $string_gmt = $datetime->format( $format );
    } else {
            if ( ! preg_match( '#([0-9]{1,4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})#', $string, $matches ) ) {
                    $datetime = strtotime( $string );
                    if ( false === $datetime ) {
                            return gmdate( $format, 0 );
                    }
                    return gmdate( $format, $datetime );
            }
            $string_time = gmmktime( $matches[4], $matches[5], $matches[6], $matches[2], $matches[3], $matches[1] );
            $string_gmt = gmdate( $format, $string_time - get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
    }
    return $string_gmt;
}

function citybook_addons_tz_offset_to_name($offset)
{
    $offset *= 3600; // convert hour offset to seconds
    $abbrarray = timezone_abbreviations_list();
    foreach ($abbrarray as $abbr)
    {
        foreach ($abbr as $city)
        {
            if ($city['offset'] == $offset)
            {
                return $city['timezone_id'];
            }
        }
    }

    return 'UTC';
    // return false;
}

function citybook_addons_get_utc_time($format = 'Y-m-d H:i:s'){

    // $currentDateTime = new DateTime('now', new DateTimeZone( 'UTC' ));
    return (new DateTime('now', new DateTimeZone( 'UTC' )))->format($format);
}

function citybook_addons_get_mysql_timezone_offset($tz=''){
    if( !$tz ) $tz = get_option( 'timezone_string' );
    if( $tz ){
        $listingTimezone = new DateTimeZone( $tz );
    }else if( get_option( 'gmt_offset' ) ){
        $tz = citybook_addons_tz_offset_to_name( get_option( 'gmt_offset' ) );//timezone_name_from_abbr('', get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
        $listingTimezone = new DateTimeZone( $tz );
    }else{
        $listingTimezone = new DateTimeZone( 'UTC' );
    }

    $date = new DateTime('now', $listingTimezone);

    // create a new date offset by the timezone offset
    // gets the interval as hours & minutes
    $offset = $listingTimezone->getOffset($date) . ' seconds';
    $dateOffset = clone $date;
    $dateOffset->sub(DateInterval::createFromDateString($offset));

    $interval = $dateOffset->diff($date);
    return $interval->format('%R%H:%I');
}

function citybook_addons_get_current_time_details($tz = ''){
    if( !$tz ) $tz = get_option( 'timezone_string' );
    if( $tz ){
        $listingTimezone = new DateTimeZone( $tz );
    }else if( get_option( 'gmt_offset' ) ){
        $tz = citybook_addons_tz_offset_to_name( get_option( 'gmt_offset' ) );//timezone_name_from_abbr('', get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
        $listingTimezone = new DateTimeZone( $tz );
    }else{
        $listingTimezone = new DateTimeZone( 'UTC' );
    }

    
    $utcTimezone        = new DateTimeZone('UTC');
    $utcDateTime        = new DateTime('now', $utcTimezone);
    $utcPrevDateTime    = new DateTime('now-1day', $utcTimezone);
    // $currentDateTime = new DateTime('now', $listingTimezone);
    // $prevDateTime    = new DateTime('now-1day', $listingTimezone);
    // change utc time to listing time zone
    $utcDateTime->setTimezone($listingTimezone);
    $utcPrevDateTime->setTimezone($listingTimezone);
    return array(
        // 'tz_offset'     => $listingTimezone->getOffset($utcDateTime),
        'tz_offset'     => $utcDateTime->format('Z'),
        'day'           => $utcDateTime->format('l'),
        'hour'          => $utcDateTime->format('G.i'),
        'date'          => $utcDateTime->format('Y-m-d H:i:s'),

        'prev_day'      => $utcPrevDateTime->format('l'),
    );
}
function citybook_addons_get_timezone_offset($tz = '', $hour = false){
    if( !$tz ) $tz = get_option( 'timezone_string' );
    if( $tz ){
        $listingTimezone = new DateTimeZone( $tz );
    }else if( get_option( 'gmt_offset' ) ){
        $tz = citybook_addons_tz_offset_to_name( get_option( 'gmt_offset' ) );//timezone_name_from_abbr('', get_option( 'gmt_offset' ) * HOUR_IN_SECONDS );
        $listingTimezone = new DateTimeZone( $tz );
    }else{
        $listingTimezone = new DateTimeZone( 'UTC' );
    }

    
    // $utcTimezone        = new DateTimeZone('UTC');
    // $utcDateTime        = new DateTime('now', $utcTimezone);
    $currentDateTime    = new DateTime('now', $listingTimezone);
    if($hour)
        return $currentDateTime->format('Z')/3600;
    else
        return $currentDateTime->format('Z');
}

function citybook_addons_get_working_hours($post_ID = 0){

    $return = array(
        'timezone' => 'UTC + 0',
        'status' => 'closed',
        'statusText' => __( 'Now Closed',  'citybook-add-ons' ),
        'days_hours' => array()
    );

    if(!is_numeric($post_ID) || !$post_ID) return $return;


    // $post_working_hours = get_post_meta( $post_ID, '_cth_working_hours', true ) ;
    $post_working_hours = citybook_addons_get_listing_working_hours_data($post_ID);

    if($post_working_hours){
        // $default_timezone = date_default_timezone_get();

        $working_days = citybook_addons_get_working_days_array();
        $working_hours_arr = citybook_addons_get_working_hours_array();

        // date_default_timezone_set($post_working_hours['timezone']);

        $current_time_details = citybook_addons_get_current_time_details($post_working_hours['timezone']);
        // var_dump($current_time_details);
        $tz_offset = $current_time_details['tz_offset']/3600;
        // $tz_offset = date('Z')/3600;
        if($tz_offset < 0){
            $return['timezone'] = __( 'UTC - ', 'citybook-add-ons' ) .(string)(-1*$tz_offset);
        }else{
            $return['timezone'] = __( 'UTC + ', 'citybook-add-ons' ) ."{$tz_offset}";
        }

        $curDy = $current_time_details['day']; //date('l');
        $prevDy = $current_time_details['prev_day'];

        foreach ($working_days as $day => $dayLbl) {

            $dayVals = $post_working_hours[$day];
            if(isset($dayVals['static'])){

                // $return['days_hours'][$dayLbl] = array(__( 'Day Off', 'citybook-add-ons' ));

                // if($day == $curDy){
                //     $return['statusText'] = __( 'Now Closed',  'citybook-add-ons' );
                //     $return['status'] = 'closed';
                // }
                if($dayVals['static'] == 'closeAllDay'){
                    $return['days_hours'][$dayLbl] = array(__( 'Day Off', 'citybook-add-ons' ));
                }elseif($dayVals['static'] == 'openAllDay'){
                    $return['days_hours'][$dayLbl] = array(__( 'Open all day', 'citybook-add-ons' ));
                    if($day == $curDy){
                        $return['statusText'] = __( 'Now Opening',  'citybook-add-ons' );
                        $return['status'] = 'opening';
                    }
                }elseif($dayVals['static'] == 'enterHours' && isset($dayVals['hours']) && count($dayVals['hours'])){
                    $return['days_hours'][$dayLbl] = array();
                    // $curHr = date('H:i'); // 06:30
                    $curHr = floatval( $current_time_details['hour'] ); //date('G.i'); // 6:30

                    foreach ($dayVals['hours'] as $hr) {
                        $ophrAfter = floatval( str_replace(":", ".", $hr['open']) );
                        $clhrAfter = floatval( str_replace(":", ".", $hr['close']) );
                        // check for prev day hour if current day closed
                        if($day == $prevDy){
                            if( $ophrAfter > $clhrAfter && $curHr < $clhrAfter ){
                                $return['statusText'] = __( 'Now Opening',  'citybook-add-ons' );
                                $return['status'] = 'opening';
                            }
                        }
                        if($day == $curDy){
                            if( $ophrAfter <= $clhrAfter ){
                                if( $curHr >= $ophrAfter && $curHr <= $clhrAfter ){
                                    $return['statusText'] = __( 'Now Opening',  'citybook-add-ons' );
                                    $return['status'] = 'opening';
                                }
                            }else{
                                if( $curHr >= $ophrAfter ){
                                    $return['statusText'] = __( 'Now Opening',  'citybook-add-ons' );
                                    $return['status'] = 'opening';
                                }
                            }
                        }
                        // only check status for current day

                        $return['days_hours'][$dayLbl][] = '<span>' .(isset($working_hours_arr[$hr['open']])? $working_hours_arr[$hr['open']] : $hr['open'] ). ' - ' . (isset($working_hours_arr[$hr['close']])? $working_hours_arr[$hr['close']] : $hr['close'] ) .'</span>' ;

                    }

                    // check for prev day hour if current day closed
                    // if( $return['status'] == 'closed' ){
                    //     $prevDayVals = $post_working_hours[$prevDy];
                    //     if($prevDayVals['static'] == 'enterHours' && isset($prevDayVals['hours']) && count($prevDayVals['hours'])){
                    //         foreach ($prevDayVals['hours'] as $hr) {
                    //             $ophrAfter = floatval( str_replace(":", ".", $hr['open']) );
                    //             $clhrAfter = floatval( str_replace(":", ".", $hr['close']) );
                    //             if( $ophrAfter > $clhrAfter && $curHr < $clhrAfter ){
                    //                 $return['statusText'] = __( 'Now Opening',  'citybook-add-ons' );
                    //                 $return['status'] = 'opening';
                    //             }
                    //         }
                    //     }
                    // }

                }
                // end if $dayVals['static']
            }
            // end if isset($dayVals['static'])
        } 
        // end foreach
        // set back to default timezone
        // date_default_timezone_set($default_timezone);

        // check for listing event
        $levent_date = trim( get_post_meta( $post_ID, P_META_PREFIX.'levent_date', true ) .' '. get_post_meta( $post_ID, P_META_PREFIX.'levent_time', true ) );
        $levent_end_date = trim( get_post_meta( $post_ID, P_META_PREFIX.'levent_end_date', true ) .' '. get_post_meta( $post_ID, P_META_PREFIX.'levent_end_time', true ) );
        if( $levent_date != '' && $levent_date > $current_time_details['date'] ){
            $return['status'] = 'closed';
            $return['statusText'] = __( 'Event not start',  'citybook-add-ons' );
        }
        if( $levent_end_date != '' && $levent_end_date < $current_time_details['date'] ){
            $return['status'] = 'closed';
            $return['statusText'] = __( 'Event Ended',  'citybook-add-ons' );
        }


    }
    // end if $post_working_hours

    return $return;

        
}

function citybook_addons_get_socials_list(){

    $socials = array(
        'facebook' => __( 'Facebook',  'citybook-add-ons' ),
        'twitter' => __( 'Twitter',  'citybook-add-ons' ),
        'youtube' => __( 'Youtube',  'citybook-add-ons' ),
        'vimeo' => __( 'Vimeo',  'citybook-add-ons' ),
        'instagram' => __( 'Instagram',  'citybook-add-ons' ),
        'vk' => __( 'Vkontakte',  'citybook-add-ons' ),
        'reddit' => __( 'Reddit',  'citybook-add-ons' ),
        'pinterest' => __( 'Pinterest',  'citybook-add-ons' ),
        'vine' => __( 'Vine Camera',  'citybook-add-ons' ),
        'tumblr' => __( 'Tumblr',  'citybook-add-ons' ),
        'flickr' => __( 'Flickr',  'citybook-add-ons' ),
        'google-plus-g' => __( 'Google+',  'citybook-add-ons' ),
        'linkedin' => __( 'LinkedIn',  'citybook-add-ons' ),
        'whatsapp' => __( 'Whatsapp',  'citybook-add-ons' ),
        'meetup' => __( 'Meetup',  'citybook-add-ons' ),
        'custom_icon' => __( 'Custom',  'citybook-add-ons' ),
    );

    return $socials ;

}  

function citybook_addons_get_listing_price_range($range = ''){

    $ranges = array(
        'none' => __( 'None',  'citybook-add-ons' ),
        'inexpensive' => __( '&dollar; - Inexpensive',  'citybook-add-ons' ),
        'moderate' => __( '&dollar;&dollar; - Moderate',  'citybook-add-ons' ),
        'pricey' => __( '&dollar;&dollar;&dollar; - Pricey',  'citybook-add-ons' ),
        'ultrahigh' => __( '&dollar;&dollar;&dollar;&dollar; - Ultra High',  'citybook-add-ons' ),
    );
    if($range!='' && isset($ranges[$range])) return $ranges[$range];

    return $ranges ;

}  
// facebook login
// https://www.codexworld.com/login-with-facebook-using-php/
// https://stackoverflow.com/questions/12069703/facebook-login-for-wordpress-without-a-plugin
// https://developers.facebook.com/docs/php/howto/example_facebook_login
// https://developers.facebook.com/docs/facebook-login/web#logindialog 


function citybook_addons_the_excerpt_max_charlength($charlength = 150, $echo = true) {
    $excerpt = get_the_excerpt();
    $charlength++;

    $return = $excerpt;

    if ( mb_strlen( $excerpt ) > $charlength ) {
        $subex = mb_substr( $excerpt, 0, $charlength - 5 );
        $exwords = explode( ' ', $subex );
        $excut = - ( mb_strlen( $exwords[ count( $exwords ) - 1 ] ) );
        if ( $excut < 0 ) {
            $return = mb_substr( $subex, 0, $excut );
        } else {
            $return = $subex;
        }
        $return .= esc_html__( '...', 'citybook-add-ons' );
    }
    if(!$echo) return $return;
    else echo $return;
}
// post archive pagination
function citybook_addons_pagination(){

    the_posts_pagination( array(
        'prev_text' =>  wp_kses(__('<i class="fa fa-caret-left"></i>','citybook-add-ons'),array('i'=>array('class'=>array(),),) ) ,
        'next_text' =>  wp_kses(__('<i class="fa fa-caret-right"></i>','citybook-add-ons'),array('i'=>array('class'=>array(),),) ) ,
        'screen_reader_text' => esc_html__( 'Posts navigation', 'citybook-add-ons' ),
    ) );

}

function citybook_addons_ajax_pagination($pages = '', $range = 2, $current_query = ''){
    $showitems = ($range * 2) + 1;
    
    if ($current_query == '') {
        global $paged;
        if (empty($paged)) $paged = 1;
    }else {
        $paged = $current_query->query_vars['paged'];
    }
    
    if ($pages == '') {
        if ($current_query == '') {
            global $wp_query;
            $pages = $wp_query->max_num_pages;
            if (!$pages) {
                $pages = 1;
            }
        } 
        else {
            $pages = $current_query->max_num_pages;
        }
    }
    if (1 < $pages) {
        echo '<span class="section-separator"></span>
        <nav class="navigation pagination custom-pagination ajax-pagination" role="navigation">
            <div class="nav-links">';

                // if ($paged > 1) echo '<a data-page="'.($paged - 1).'" href="#" class="prev page-numbers ajax-pagi-item">'.__('<i class="fa fa-caret-left" aria-hidden="true"></i>','citybook-add-ons').'</a>';
                
                for ($i = 1; $i <= $pages; $i++) {
                    if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems)) {
                        echo ($paged == $i) ? '<span data-page="'.$i.'" aria-current="page" class="page-numbers current">' . $i . "</span>" : '<a data-page="'.$i.'" href="#" class="page-numbers ajax-pagi-item">' . $i . '</a>';
                    }
                }

                // if ($paged < $pages) echo '<a data-page="'.($paged + 1).'" href="#" class="next page-numbers ajax-pagi-item">'.__('<i class="fa fa-caret-right" aria-hidden="true"></i>','citybook-add-ons').'</a>';
            
            echo'</div>
        </nav>';
    }
}



/**
 * Pagination for custom query page
 *
 * @since CityBook 1.0
 */
if (!function_exists('citybook_addons_custom_pagination')) {
    function citybook_addons_custom_pagination($pages = '', $range = 2, $current_query = '') {
        // var_dump($pages);die;
        $showitems = ($range * 2) + 1;
        
        if ($current_query == '') {
            global $paged;
            if (empty($paged)) $paged = 1;
        } 
        else {
            $paged = $current_query->query_vars['paged'];
        }
        
        if ($pages == '') {
            if ($current_query == '') {
                global $wp_query;
                $pages = $wp_query->max_num_pages;
                if (!$pages) {
                    $pages = 1;
                }
            } 
            else {
                $pages = $current_query->max_num_pages;
            }
        }
        
        if (1 < $pages) {
            echo '<span class="section-separator"></span>
            <nav class="navigation pagination custom-pagination" role="navigation">
                <h2 class="screen-reader-text">'.__( 'Posts navigation',  'citybook-add-ons' ).'</h2>
                <div class="nav-links">';

                    if ($paged > 1) echo '<a href="' . get_pagenum_link($paged - 1) . '" class="prev page-numbers">'.__('<i class="fa fa-caret-left" aria-hidden="true"></i>','citybook-add-ons').'</a>';
                    
                    for ($i = 1; $i <= $pages; $i++) {
                        if (1 != $pages && (!($i >= $paged + $range + 1 || $i <= $paged - $range - 1) || $pages <= $showitems)) {
                            echo ($paged == $i) ? '<span aria-current="page" class="page-numbers current">' . $i . "</span>" : "<a href='" . get_pagenum_link($i) . "' class='page-numbers'>" . $i . "</a>";
                        }
                    }

                    if ($paged < $pages) echo '<a href="' . get_pagenum_link($paged + 1) . '" class="next page-numbers">'.__('<i class="fa fa-caret-right" aria-hidden="true"></i>','citybook-add-ons').'</a>';
                echo'</div>
            </nav>';
        }

    }
}
// 0 for root level and so on
function citybook_addons_get_listing_categories($max_level = 3){
    $listing_cats = get_terms( array(
        'taxonomy' => 'listing_cat',
        'hide_empty' => false,
        // add new ordre object
        // 'orderby'       => 'name',
        // 'order'         => 'ASC',
    ) );

    $listing_cats_arr = array();
    citybook_addons_parse_listing_cats($listing_cats,$listing_cats_arr,0,-1,$max_level);

    return $listing_cats_arr;
}

function citybook_addons_parse_listing_cats($cats = array(),&$return =array(),$parent_id = 0,$curlevel = -1,$maxlevel = 3){
    $return = $return? $return : array();
    if ( !empty($cats) ) :
        foreach( $cats as $cat ) {
            if( $cat->parent == $parent_id ) {
                // $return[$cat->term_id] = array('name'=>$cat->name,'level'=>$curlevel+1,'children'=>array());
                $return[] = array('id'=>$cat->term_id,'name'=>$cat->name,'level'=>$curlevel+1);
                // if($return[$cat->term_id]['level'] < $maxlevel ) $this->parse_listing_cats($cats,$return[$cat->term_id]['children'],$cat->term_id,$return[$cat->term_id]['level']);
                if($curlevel+1 < $maxlevel ) citybook_addons_parse_listing_cats($cats,$return,$cat->term_id,$curlevel+1,$maxlevel);

                
            }
        }
    endif;
    // return $return;
}


function citybook_addons_get_listing_categories_select2(){
    $cats = citybook_addons_get_listing_categories();
    if(!empty($cats)){
        $return = array();
        foreach ($cats as $cat ){
            // $return[] = array($cat['id'] => str_repeat("-", $cat['level']).$cat['name']);
            $return[$cat['id']] = str_repeat("-", $cat['level']).$cat['name'];
        }
        return $return;
    }else{
        return array();
    }
}
function citybook_addons_get_listing_locations_hierarchy($max_level = 3){
    $terms = get_terms( array(
        'taxonomy' => 'listing_location',
        'hide_empty' => false
    ) );

    $terms_arr = array();
    citybook_addons_parse_listing_cats($terms,$terms_arr,0,-1,$max_level);

    return $terms_arr;
}
function citybook_addons_get_listing_locations_hierarchy_select2(){
    $terms = citybook_addons_get_listing_locations_hierarchy();
    if(!empty($terms)){
        $return = array();
        foreach ($terms as $term ){
            $return[$term['id']] = str_repeat("-", $term['level']).$term['name'];
        }
        return $return;
    }else{
        return array();
    }
}

function citybook_addons_get_listing_locations_select2(){
    $listing_locs = get_terms( array(
        'taxonomy' => 'listing_location',
        'hide_empty' => false
    ) );
    if ( ! empty( $listing_locs ) && ! is_wp_error( $listing_locs ) ){
        $return = array();
        foreach ($listing_locs as $loc ){
            $return[$loc->term_id] = $loc->name;
        }
        return $return;
    }else{
        return array();
    }
}

function citybook_addons_get_listing_locations($hide_empty = false){
    $listing_locs = get_terms( array(
        'taxonomy' => 'listing_location',
        'hide_empty' => $hide_empty
    ) );

    $locations = array();
    if ( ! empty( $listing_locs ) && ! is_wp_error( $listing_locs ) ){
        foreach ( $listing_locs as $loc ) {
            $locations[$loc->slug] = $loc->name;
        }
    }
    
    return $locations;
}

function citybook_addons_get_edit_listing_url($listing_id = null){

    $edit_page_id = citybook_addons_get_option('edit_page');

    if(!isset($listing_id)) $listing_id = get_the_ID();

    return add_query_arg( 'listing_id', $listing_id,  the_permalink( $edit_page_id ) );
}

function citybook_addons_get_listing_post_data(){
    $rating = citybook_addons_get_average_ratings(get_the_ID());
    $wkhour = citybook_addons_get_working_hours(get_the_ID());
    $price_range = get_post_meta( get_the_ID(), P_META_PREFIX.'price_range', true );
    $levent_date = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_date', true );
    $levent_time = get_post_meta( get_the_ID(), P_META_PREFIX.'levent_time', true );

    $listing_post = array(
        'url'                       => get_permalink( ),
        'rating'                    =>$rating,
        'cats'                      =>array(),
        'title'                     =>get_the_title( ),
        'excerpt'                   => citybook_addons_the_excerpt_max_charlength(citybook_addons_get_option('excerpt_length','55'),false), // get_the_excerpt(),
        'thumbnail'                 =>'',
        'phone'                     =>'',
        'latitude'                  =>'',
        'longitude'                 =>'',
        'address'                   =>'',
        'like_stats'                => citybook_addons_get_likes_stats(get_the_ID()),
        'author_avatar'             => get_avatar(get_the_author_meta('user_email'),'80','https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_the_author_meta( 'display_name' ) ),
        'author_url'                => get_author_posts_url( get_the_author_meta( 'ID' )),
        'author_name'               => get_the_author(),

        'ID'                        => get_the_ID(),
        'status'                    => $wkhour['status'],
        'statusText'                => $wkhour['statusText'],
        'bookmarked'                => citybook_addons_already_bookmarked(get_the_ID()),
        'price_from'                => get_post_meta( get_the_ID(), P_META_PREFIX.'price_from', true ),
        'price_to'                  => get_post_meta( get_the_ID(), P_META_PREFIX.'price_to', true ),
        'price_from_formated'       => citybook_addons_get_price_formated(get_post_meta( get_the_ID(), P_META_PREFIX.'price_from', true )),
        'price_to_formated'         => citybook_addons_get_price_formated(get_post_meta( get_the_ID(), P_META_PREFIX.'price_to', true )),

        'verified'                  => get_post_meta( get_the_ID(), P_META_PREFIX.'verified', true ),
        'price_range'               => ( $price_range != '' && $price_range != 'none' )? citybook_addons_get_listing_price_range( $price_range ) : '',

        'view'                      => citybook_addons_get_post_views(get_the_ID()),
        'levent_date'               => $levent_date,
        'levent_time'               => $levent_time,
        'event_date_text'           => $levent_date !='' ? sprintf( __( 'Will begin on <span>%s</span> at <span>%s</span>', 'citybook-add-ons' ), date_i18n( get_option( 'date_format' ), strtotime( $levent_date.' '.$levent_time ) ), date_i18n( get_option( 'time_format' ), strtotime( $levent_date.' '.$levent_time ) ) ) : '',
        

        'hide_author_info'          => citybook_addons_check_package_single_field( 'hide_author_info' ),

        'gmap_marker'               => '',
        'featured'                  => get_post_meta( get_the_ID(), P_META_PREFIX.'featured', true ),
    );

    if(has_post_thumbnail( )) $listing_post['thumbnail'] = get_the_post_thumbnail_url( null, 'citybook-listing-grid' );

    $cats = get_the_terms(get_the_ID(), 'listing_cat');
    if ( $cats && ! is_wp_error( $cats ) ){
        // echo '<div class="list-single-header-cat fl-wrap">';
        foreach( $cats as $key => $cat){

            // echo sprintf( '<a href="%1$s" class="listing-geodir-category">%2$s</a> ',
            //     esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
            //     esc_html( $cat->name )
            // );
            if($listing_post['gmap_marker'] == ''){
                $term_meta = get_term_meta( $cat->term_id, P_META_PREFIX.'term_meta', true );
                if(isset($term_meta['gmap_marker']) && !empty($term_meta['gmap_marker'])){
                    $listing_post['gmap_marker'] = wp_get_attachment_url( $term_meta['gmap_marker']['id'] );
                }
            }

            $listing_post['cats'][$cat->name] = sprintf( '<a href="%1$s" class="listing-geodir-category">%2$s</a> ',
                esc_url( get_term_link( $cat->term_id, 'listing_cat' ) ),
                esc_html( $cat->name )
            );
        }
        // echo '</div>';
    }


    // $contact_infos = get_post_meta( get_the_ID(), '_cth_contact_infos', true );
    // if(isset($contact_infos['latitude'])&&isset($contact_infos['longitude'])&&isset($contact_infos['address'])) {
    //     $listing_post['phone'] = $contact_infos['phone'];
    //     $listing_post['latitude'] = $contact_infos['latitude'];
    //     $listing_post['longitude'] = $contact_infos['longitude'];
    //     $listing_post['address'] = $contact_infos['address'];
    // }

    // $contact_infos = array(
    //                 'address' => get_post_meta( get_the_ID(), '_cth_contact_infos_address', true ),
    //                 'latitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_latitude', true ),
    //                 'longitude' => get_post_meta( get_the_ID(), '_cth_contact_infos_longitude', true ),
    //                 // 'phone' => get_post_meta( get_the_ID(), '_cth_contact_infos_phone', true ),
    //                 // 'email' => get_post_meta( get_the_ID(), '_cth_contact_infos_email', true ),
    //                 // 'website' => get_post_meta( get_the_ID(), '_cth_contact_infos_website', true ),
    //             );

    $listing_post['phone'] = get_post_meta( get_the_ID(), '_cth_contact_infos_phone', true );
    $listing_post['latitude'] = get_post_meta( get_the_ID(), '_cth_contact_infos_latitude', true );
    $listing_post['longitude'] = get_post_meta( get_the_ID(), '_cth_contact_infos_longitude', true );
    $listing_post['address'] = get_post_meta( get_the_ID(), '_cth_contact_infos_address', true );
    $listing_post['email'] = get_post_meta( get_the_ID(), '_cth_contact_infos_email', true );
    $listing_post['website'] = get_post_meta( get_the_ID(), '_cth_contact_infos_website', true );


    return $listing_post;
}
// get dashboard subpages - related with dashboard shortcode page.
function citybook_addons_get_dashboard_subpage($var = ''){

    $subpages = array(
        'listings' => __( 'Your Listings', 'citybook-add-ons' ),
        'reviews' => __( 'Your Reviews', 'citybook-add-ons' ),
        'changepass' => __( 'Change Password', 'citybook-add-ons' ),
        'messages' => __( 'Your Messages', 'citybook-add-ons' ),
        'bookings' => __( 'Your Bookings', 'citybook-add-ons' ),
        'bookmarks' => __( 'Bookmarks', 'citybook-add-ons' ),
        'profile' => __( 'Edit Profile', 'citybook-add-ons' ),
        'packages' => __( 'Packages', 'citybook-add-ons' ),
        'invoices' => __( 'Invoices', 'citybook-add-ons' ),
        'ads' => __( 'AD Campaigns', 'citybook-add-ons' ),
    );

    if($var != '' && isset($subpages[$var])){
        return $subpages[$var];
    }

    return get_the_title( citybook_addons_get_option('dashboard_page') );
}

if(!function_exists('citybook_addons_breadcrumbs')){
    function citybook_addons_breadcrumbs($classes='') {
               
        // Settings
        $breadcrums_id      = 'breadcrumbs';
        $breadcrums_class   = 'breadcrumbs '.$classes;
        $home_title         = esc_html__('Home','citybook-add-ons');
        $blog_title         = esc_html__('Blog','citybook-add-ons');


        // If you have any custom post types with custom taxonomies, put the taxonomy name below (e.g. product_cat)
        // $custom_taxonomy    = 'product_cat,portfolio_cat,cth_speaker';
        // $custom_taxonomy    = 'listing_cat,listing_feature,listing_location';
        $custom_taxonomy    = 'listing_cat';

        $custom_post_types = array(
                                'listing' => esc_html_x('Listing','listing archive in breadcrumb','citybook-add-ons'),
                                'product' => esc_html_x('Products','product archive in breadcrumb','citybook-add-ons'),
                                
                            );
          
        // Get the query & post information
        global $post;
          
        // Do not display on the homepage
        if ( !is_front_page() ) {
          
            // Build the breadcrums
            echo '<div id="' . esc_attr($breadcrums_id ) . '" class="' . esc_attr($breadcrums_class ) . '">';
              
            // Home page
            echo '<a class="breadcrumb-link breadcrumb-home" href="' . esc_url( home_url('/') ) . '" title="' . esc_attr($home_title ) . '">' . esc_attr($home_title ) . '</a>';

            if(is_home()){
                // Blog page
                echo '<span class="breadcrumb-current breadcrumb-item-blog">' . esc_attr($blog_title ) . '</span>';
            }
              
            if ( is_archive() && !is_tax() ) {

                // If post is a custom post type
                $post_type = get_post_type();

                if($post_type && array_key_exists($post_type, $custom_post_types)){
                    echo '<span class="breadcrumb-current breadcrumb-item-custom-post-type-' . $post_type . '">' . $custom_post_types[$post_type] . '</span>';
                }else{
                    echo '<span class="breadcrumb-current breadcrumb-item-archive">' . get_the_archive_title() . '</span>';
                }
                 
            } else if ( is_archive() && is_tax() ) {
                 
                // If post is a custom post type
                $post_type = get_post_type();
                 
                // If it is a custom post type display name and link
                if($post_type && $post_type != 'post') {
                     
                    $post_type_object = get_post_type_object($post_type);
                    $post_type_archive = get_post_type_archive_link($post_type);
                 
                    echo '<a class="breadcrumb-link breadcrumb-custom-post-type-' . $post_type . '" href="' . esc_url($post_type_archive ) . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>';
                 
                }
                 
                $custom_tax_name = get_queried_object()->name;
                echo '<span class="breadcrumb-current bread-item-archive">' . $custom_tax_name . '</span>';
                 
            } else if ( is_single() ) {
                
                // If post is a custom post type
                $post_type = get_post_type();
                $last_category = '';
                // If it is a custom post type (not support custom taxonomy) display name and link
                if( !in_array( $post_type, array('post','listing') ) ) {
                     
                    $post_type_object = get_post_type_object($post_type);
                    $post_type_archive = get_post_type_archive_link($post_type);

                    if(array_key_exists($post_type, $custom_post_types)){
                        echo '<a class="breadcrumb-link breadcrumb-cat breadcrumb-custom-post-type-' . $post_type . '" href="' . esc_url($post_type_archive ) . '" title="' . $custom_post_types[$post_type] . '">' . $custom_post_types[$post_type] . '</a>';
                    }else{
                        echo '<a class="breadcrumb-link breadcrumb-cat breadcrumb-custom-post-type-' . $post_type . '" href="' . esc_url($post_type_archive ) . '" title="' . $post_type_object->labels->name . '">' . $post_type_object->labels->name . '</a>';
                    }
                    
                    echo '<span class="breadcrumb-current breadcrumb-item-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span>';
                }elseif($post_type == 'post'){
                    // Get post category info
                    $category = get_the_category();
                     
                    // Get last category post is in
                    
                    if($category){
                        $last_cateogries = array_values($category);
                        $last_category = end($last_cateogries);
                     
                        // Get parent any categories and create array
                        $get_cat_parents = rtrim(get_category_parents($last_category->term_id, true, ','),',');
                        $cat_parents = explode(',',$get_cat_parents);
                         
                        // Loop through parent categories and store in variable $cat_display
                        $cat_display = '';
                        foreach($cat_parents as $parents) {
                            $cat_display .= '<span class="breadcrumb-current breadcrumb-item-cat">'.$parents.'</span>';
                            
                        }
                    }
                    
                    if(!empty($last_category)) {
                        echo wp_kses_post($cat_display );
                        echo '<span class="breadcrumb-current breadcrumb-item-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span>';
                         
                    // Else if post is in a custom taxonomy
                    }
                }
                    
                     
                // If it's a custom post type within a custom taxonomy
                if(empty($last_category) && !empty($custom_taxonomy)) {
                    $custom_taxonomy_arr = explode(",", $custom_taxonomy) ;
                    foreach ($custom_taxonomy_arr as $key => $custom_taxonomy_val) {
                        $taxonomy_terms = get_the_terms( $post->ID, $custom_taxonomy_val );
                        if($taxonomy_terms && !($taxonomy_terms instanceof WP_Error) ){
                            $cat_id         = $taxonomy_terms[0]->term_id;
                            $cat_nicename   = $taxonomy_terms[0]->slug;
                            $cat_link       = get_term_link($taxonomy_terms[0]->term_id, $custom_taxonomy_val);
                            $cat_name       = $taxonomy_terms[0]->name;

                            if(!empty($cat_id)) {
                         
                                echo '<a class="breadcrumb-link bread-cat-' . $cat_id . ' bread-cat-' . $cat_nicename . '" href="' . esc_url($cat_link ) . '" title="' . $cat_name . '">' . $cat_name . '</a>';
                                
                                echo '<span class="breadcrumb-current breadcrumb-item-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span>';
                             
                            }
                        }

                     } 
                    
                  
                }
                 
                
                 
            } else if ( is_category() ) {
                  
                // Category page
                echo '<span class="breadcrumb-current breadcrumb-item-cat-' . $category[0]->term_id . ' bread-cat-' . $category[0]->category_nicename . '">' . $category[0]->cat_name . '</span>';
                  
            } else if ( is_page() ) {
                
                $dashboard_page_id = citybook_addons_get_option('dashboard_page');
                $dashboard_var = get_query_var('dashboard');

                // Standard page
                if( $post->post_parent ){

                    $parents = '';
                      
                    // If child page, get parents 
                    $anc = get_post_ancestors( $post->ID );
                      
                    // Get parents in the right order
                    $anc = array_reverse($anc);
                      
                    // Parent page loop
                    foreach ( $anc as $ancestor ) {
                        $parents .= '<a class="breadcrumb-link breadcrumb-parent-' . $ancestor . '" href="' . esc_url(get_permalink($ancestor) ) . '" title="' . get_the_title($ancestor) . '">' . get_the_title($ancestor) . '</a>';
                        
                    }
                      
                    // Display parent pages
                    echo wp_kses_post($parents );

                    if(is_page($dashboard_page_id) && $dashboard_var != ''){

                        // dashboard page
                        echo '<a class="breadcrumb-link breadcrumb-dashboard" href="' . esc_url(get_permalink($dashboard_page_id) ) . '" title="' . get_the_title($dashboard_page_id) . '">' . get_the_title($dashboard_page_id) . '</a>';
                        // Current page
                        echo '<span class="breadcrumb-current breadcrumb-dashboard-subpage" title="' . esc_attr( citybook_addons_get_dashboard_subpage($dashboard_var) ). '">' . citybook_addons_get_dashboard_subpage($dashboard_var) . '</span>';

                    }else{
                      
                        // Current page
                        echo '<span class="breadcrumb-current breadcrumb-item-page-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span>';
                    }
                    
                      
                } else {
                      
                    // Just display current page if not parents
                    if(is_page($dashboard_page_id) && $dashboard_var != ''){

                        // dashboard page
                        echo '<a class="breadcrumb-link breadcrumb-dashboard" href="' . esc_url(get_permalink($dashboard_page_id) ) . '" title="' . get_the_title($dashboard_page_id) . '">' . get_the_title($dashboard_page_id) . '</a>';
                        // Current page
                        echo '<span class="breadcrumb-current breadcrumb-dashboard-subpage" title="' . esc_attr( citybook_addons_get_dashboard_subpage($dashboard_var) ). '">' . citybook_addons_get_dashboard_subpage($dashboard_var) . '</span>';

                    }else{
                      
                        // Current page
                        echo '<span class="breadcrumb-current breadcrumb-item-page-' . $post->ID . '" title="' . get_the_title() . '">' . get_the_title() . '</span>';
                    }
                      
                }
                  
            } else if ( is_tag() ) {
                  
                // Tag page
                  
                // Get tag information
                $term_id = get_query_var('tag_id');
                $taxonomy = 'post_tag';
                $args ='include=' . $term_id;
                $terms = get_terms( $taxonomy, $args );
                  
                // Display the tag name
                echo '<span class="breadcrumb-current breadcrumb-item-tag-' . $terms[0]->term_id . ' bread-tag-' . $terms[0]->slug . '">' . $terms[0]->name . '</span>';
              
            } elseif ( is_day() ) {
                  
                // Day archive
                  
                // Year link
                echo '<a class="breadcrumb-link breadcrumb-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives','citybook-add-ons').'</a>';
                
                  
                // Month link
                echo '<a class="breadcrumb-link breadcrumb-month bread-month-' . get_the_time('m') . '" href="' . get_month_link( get_the_time('Y'), get_the_time('m') ) . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives','citybook-add-ons').'</a>';
                
                  
                // Day display
                echo '<span class="breadcrumb-current bread-' . get_the_time('j') . '"> ' . get_the_time('jS') . ' ' . get_the_time('M') .  esc_html__(' Archives','citybook-add-ons').'</span>';
                  
            } else if ( is_month() ) {
                  
                // Month Archive
                  
                // Year link
                echo '<a class="breadcrumb-link breadcrumb-year bread-year-' . get_the_time('Y') . '" href="' . get_year_link( get_the_time('Y') ) . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives','citybook-add-ons').'</a>';
                
                  
                // Month display
                echo '<span class="breadcrumb-current breadcrumb-month breadcrumb-month-' . get_the_time('m') . '" title="' . get_the_time('M') . '">' . get_the_time('M') . esc_html__(' Archives','citybook-add-ons').'</span>';
                  
            } else if ( is_year() ) {
                  
                // Display year archive
                echo '<strong class="breadcrumb-current breadcrumb-current-' . get_the_time('Y') . '" title="' . get_the_time('Y') . '">' . get_the_time('Y') . esc_html__(' Archives','citybook-add-ons').'</span>';
                  
            } else if ( is_author() ) {
                  
                // Auhor archive
                  
                // Get the author information
                global $author;
                $userdata = get_userdata( $author );
                  
                // Display author name
                echo '<span class="breadcrumb-current breadcrumb-current-' . $userdata->user_nicename . '" title="' . $userdata->display_name . '">' .  esc_html__(' Author: ','citybook-add-ons') . $userdata->display_name . '</span>';
              
            } else if ( get_query_var('paged') ) {
                  
                // Paginated archives
                echo '<a href="#" class="breadcrumb-current breadcrumb-current-' . get_query_var('paged') . '" title="'.esc_html__('Page','citybook-add-ons') . get_query_var('paged') . '">'.esc_html__('Page','citybook-add-ons') . ' ' . get_query_var('paged') . '</a>';
                  
            } else if ( is_search() ) {
              
                // Search results page
                echo '<span class="breadcrumb-current breadcrumb-current-' . get_search_query() . '" title="'.esc_html__('Search results for: ','citybook-add-ons') . get_search_query() . '">'.esc_html__('Search results for: ','citybook-add-ons') . get_search_query() . '</span>';
              
            } elseif ( is_404() ) {
                  
                // 404 page
                echo '<span class="breadcrumb-current breadcrumb-current-404">' . esc_html__('Error 404','citybook-add-ons') . '</span>';
            }
          
            echo '</div>';
              
        }
          
    }
}


// edit listing link
function citybook_addons_edit_listing_link($id = 0){
    if(!$id) $id = get_the_ID();
    if ( !current_user_can( 'edit_post', $id ) ) return;
    
    $edit_page_id = citybook_addons_get_option('edit_page');

    echo '<a href="'.esc_url( add_query_arg( 'listing_id', $id,  get_permalink($edit_page_id) ) ).'">'.esc_html__( 'Edit', 'citybook-add-ons' ).'</a>';
}

function citybook_addons_get_contact_form7_forms(){
    $forms = get_posts( 'post_type=wpcf7_contact_form&posts_per_page=-1' );

    $results = array();
    if ( $forms ) {
        $results[] = __( 'Select A Form', 'citybook-add-ons' );
        foreach ( $forms as $form ) {
            $results[ $form->ID ] = $form->post_title;
        }
        // array_unshift( $results, __( 'Select A Form', 'citybook-add-ons' ) );
        // $results[] = __( 'Select A Form', 'citybook-add-ons' );
    } else {
        $results[] =  __( 'No contact forms found', 'citybook-add-ons' ) ;
    }

    return $results;
}
// echo socials share content
function citybook_addons_echo_socials_share(){
    $widgets_share_names = citybook_addons_get_option('widgets_share_names','facebook, pinterest, googleplus, twitter, linkedin');
    if($widgets_share_names !=''):
    ?>
    <div class="share-holder hid-share">
        <div class="showshare"><span class="share-show"><?php esc_html_e( 'Share ', 'citybook-add-ons' ); ?></span><span class="share-close"><?php esc_html_e( 'Close ', 'citybook-add-ons' ); ?></span><i class="fa fa-share"></i></div>
        <div class="share-container isShare" data-share="<?php echo esc_attr( trim($widgets_share_names, ", \t\n\r\0\x0B") ); ?>"></div>
    </div>
    <?php
    endif;  
}

// for payment
function citybook_addons_get_currency_array(){
    $world_curr = array (
        'ALL' => 'Albania Lek',
        'AFN' => 'Afghanistan Afghani',
        'ARS' => 'Argentina Peso',
        'AWG' => 'Aruba Guilder',
        'AUD' => 'Australia Dollar',
        'AZN' => 'Azerbaijan New Manat',
        'BSD' => 'Bahamas Dollar',
        'BBD' => 'Barbados Dollar',
        'BDT' => 'Bangladeshi taka',
        'BYR' => 'Belarus Ruble',
        'BZD' => 'Belize Dollar',
        'BMD' => 'Bermuda Dollar',
        'BOB' => 'Bolivia Boliviano',
        'BAM' => 'Bosnia and Herzegovina Convertible Marka',
        'BWP' => 'Botswana Pula',
        'BGN' => 'Bulgaria Lev',
        'BRL' => 'Brazil Real',
        'BND' => 'Brunei Darussalam Dollar',
        'KHR' => 'Cambodia Riel',
        'CAD' => 'Canada Dollar',
        'KYD' => 'Cayman Islands Dollar',
        'CLP' => 'Chile Peso',
        'CNY' => 'China Yuan Renminbi',
        'COP' => 'Colombia Peso',
        'CRC' => 'Costa Rica Colon',
        'HRK' => 'Croatia Kuna',
        'CUP' => 'Cuba Peso',
        'CZK' => 'Czech Republic Koruna',
        'DKK' => 'Denmark Krone',
        'DOP' => 'Dominican Republic Peso',
        'XCD' => 'East Caribbean Dollar',
        'EGP' => 'Egypt Pound',
        'SVC' => 'El Salvador Colon',
        'EEK' => 'Estonia Kroon',
        'EUR' => 'Euro Member Countries',
        'FKP' => 'Falkland Islands (Malvinas) Pound',
        'FJD' => 'Fiji Dollar',
        'GHC' => 'Ghana Cedis',
        'GIP' => 'Gibraltar Pound',
        'GTQ' => 'Guatemala Quetzal',
        'GGP' => 'Guernsey Pound',
        'GYD' => 'Guyana Dollar',
        'HNL' => 'Honduras Lempira',
        'HKD' => 'Hong Kong Dollar',
        'HUF' => 'Hungary Forint',
        'ISK' => 'Iceland Krona',
        'INR' => 'India Rupee',
        'IDR' => 'Indonesia Rupiah',
        'IRR' => 'Iran Rial',
        'IMP' => 'Isle of Man Pound',
        'ILS' => 'Israel Shekel',
        'JMD' => 'Jamaica Dollar',
        'JPY' => 'Japan Yen',
        'JEP' => 'Jersey Pound',
        'KZT' => 'Kazakhstan Tenge',
        'KPW' => 'Korea (North) Won',
        'KRW' => 'Korea (South) Won',
        'KGS' => 'Kyrgyzstan Som',
        'LAK' => 'Laos Kip',
        'LVL' => 'Latvia Lat',
        'LBP' => 'Lebanon Pound',
        'LRD' => 'Liberia Dollar',
        'LTL' => 'Lithuania Litas',
        'MKD' => 'Macedonia Denar',
        'MYR' => 'Malaysia Ringgit',
        'MUR' => 'Mauritius Rupee',
        'MXN' => 'Mexico Peso',
        'MNT' => 'Mongolia Tughrik',
        'MZN' => 'Mozambique Metical',
        'NAD' => 'Namibia Dollar',
        'NPR' => 'Nepal Rupee',
        'ANG' => 'Netherlands Antilles Guilder',
        'NZD' => 'New Zealand Dollar',
        'NIO' => 'Nicaragua Cordoba',
        'NGN' => 'Nigeria Naira',
        'NOK' => 'Norway Krone',
        'OMR' => 'Oman Rial',
        'PKR' => 'Pakistan Rupee',
        'PAB' => 'Panama Balboa',
        'PYG' => 'Paraguay Guarani',
        'PEN' => 'Peru Nuevo Sol',
        'PHP' => 'Philippines Peso',
        'PLN' => 'Poland Zloty',
        'QAR' => 'Qatar Riyal',
        'RON' => 'Romania New Leu',
        'RUB' => 'Russia Ruble',
        'SHP' => 'Saint Helena Pound',
        'SAR' => 'Saudi Arabia Riyal',
        'RSD' => 'Serbia Dinar',
        'SCR' => 'Seychelles Rupee',
        'SGD' => 'Singapore Dollar',
        'SBD' => 'Solomon Islands Dollar',
        'SOS' => 'Somalia Shilling',
        'ZAR' => 'South Africa Rand',
        'LKR' => 'Sri Lanka Rupee',
        'SEK' => 'Sweden Krona',
        'CHF' => 'Switzerland Franc',
        'SRD' => 'Suriname Dollar',
        'SYP' => 'Syria Pound',
        'TWD' => 'Taiwan New Dollar',
        'THB' => 'Thailand Baht',
        'TTD' => 'Trinidad and Tobago Dollar',
        'TRY' => 'Turkey Lira',
        'TRL' => 'Turkey Lira',
        'TVD' => 'Tuvalu Dollar',
        'UAH' => 'Ukraine Hryvna',
        'GBP' => 'United Kingdom Pound',
        'UGX' => 'Uganda Shilling',
        'USD' => 'United States Dollar',
        'UYU' => 'Uruguay Peso',
        'UZS' => 'Uzbekistan Som',
        'VEF' => 'Venezuela Bolivar',
        'VND' => 'Viet Nam Dong',
        'YER' => 'Yemen Rial',
        'ZWD' => 'Zimbabwe Dollar',
        'CFA' => 'CFA Franc', 
        'KSH' => 'Kenya shillings',
    );
    $paypal_curr = array(
        "USD" => "US Dollars ($) - Paypal acceptable", 
        "EUR" => "Euros (€) - Paypal acceptable",
        "GBP" => "Pounds Sterling (£) - Paypal acceptable",
        "AUD" => "Australian Dollars ($) - Paypal acceptable",
        "BRL" => "Brazilian Real (R$) - Paypal acceptable",
        "CAD" => "Canadian Dollars ($) - Paypal acceptable",
        "CZK" => "Czech Koruna - Paypal acceptable",
        "DKK" => "Danish Krone - Paypal acceptable",
        "HKD" => "Hong Kong Dollar ($) - Paypal acceptable",
        "HUF" => "Hungarian Forint - Paypal acceptable",
        "ILS" => "Israeli Shekel (₪) - Paypal acceptable",
        "JPY" => "Japanese Yen (¥) - Paypal acceptable",
        "MYR" => "Malaysian Ringgits - Paypal acceptable",
        "MXN" => "Mexican Peso ($) - Paypal acceptable",
        "NZD" => "New Zealand Dollar ($) - Paypal acceptable",
        "NOK" => "Norwegian Krone - Paypal acceptable",
        "PHP" => "Philippine Pesos - Paypal acceptable",
        "PLN" => "Polish Zloty - Paypal acceptable",
        "SGD" => "Singapore Dollar ($) - Paypal acceptable",
        "SEK" => "Swedish Krona - Paypal acceptable",
        "CHF" => "Swiss Franc - Paypal acceptable",
        "TWD" => "Taiwan New Dollars - Paypal acceptable",
        "THB" => "Thai Baht (฿) - Paypal acceptable",
        "INR" => "Indian Rupee (₹) - Paypal acceptable",
        "TRY" => "Turkish Lira (₺) - Paypal acceptable",
        "RIAL" => "Iranian Rial (﷼) - Paypal acceptable",
        "RUB" => "Russian Rubles - Paypal acceptable",

    );

    return array_merge($world_curr, $paypal_curr);
}
function citybook_addons_get_plan_prices($plan_id = 0, $raw_price = 0){
    
    if($raw_price) 
        $price = $raw_price;
    else 
        $price = get_post_meta( $plan_id, '_cth_price', true );
    
    $price = floatval($price);

    $vat_percent = citybook_addons_get_option('vat_tax');

    $tax = floatval($vat_percent) * $price / 100;

    $total = $price + $tax ;

    return array(
        'price' => $price,
        'tax' => $tax,
        'total' => $total,
    );

}
function citybook_addons_get_stripe_amount($amount=0){
    // The amount (in cents) that's shown to the user. Note that you will still have to explicitly include the amount when you create a charge using the API.
    // $20 -> 2000
    return $amount*100;
}
function citybook_addons_get_price_formated($price = 0, $show_currency = true){
    if($price == '') $price = 0;
    $return = number_format( $price, citybook_addons_get_option('decimals','2'), citybook_addons_get_option('decimal_sep','.'), citybook_addons_get_option('thousand_sep',',') );
    if($show_currency){
        $currency = citybook_add_ons_get_currency_symbol(citybook_addons_get_option('currency','USD'));
        $currency_pos = citybook_addons_get_option('currency_pos','left_space');
        switch ($currency_pos) {
            case 'left':
                $return = $currency .$return;
                break;
            case 'right':
                $return .= $currency;
                break;
            case 'right_space':
                $return .= '&nbsp;'. $currency;
                break;
            default:
                $return = $currency . '&nbsp;'. $return;
                break;
        }
        
    }

    return $return;
}


function citybook_addons_get_order_method_text($method = ''){
    $methods = array(
        'free' => __( 'Free', 'citybook-add-ons' ),
        'banktransfer' => __( 'Bank Transfer', 'citybook-add-ons' ),
        'paypal' => __( 'Pay via Paypal', 'citybook-add-ons' ),
        'stripe' => __( 'Pay via Stripe', 'citybook-add-ons' ),
        'woo' => __( 'WooCommerce Integration', 'citybook-add-ons' ),
    );
    if(isset($methods[$method])) return $methods[$method];
    else return $methods['free'];
}

function citybook_addons_get_payment_methods($method = ''){
    $payments = array();
    // banktransfer
    if(citybook_addons_get_option('payments_banktransfer_enable') == 'yes'){
        $payments['banktransfer'] = array(
            'title' => __( 'Bank Transfer', 'citybook-add-ons' ),
            
            'icon' => CITYBOOK_ADD_ONS_DIR_URL.'assets/images/bank-transfer.png',
            'desc' => citybook_addons_get_option('payments_banktransfer_details',''),

            'checkout_text' => __( 'Place Order', 'citybook-add-ons' ),
        );
    }
    // paypal
    if(citybook_addons_get_option('payments_paypal_enable') == 'yes'){
        $payments['paypal'] = array(
            'title' => __( 'Pay via Paypal', 'citybook-add-ons' ),
            'icon' => CITYBOOK_ADD_ONS_DIR_URL.'assets/images/ppcom.png',
            'desc' => citybook_addons_get_option('payments_paypal_desc',''),

            'checkout_text' => __( 'Process to Paypal', 'citybook-add-ons' ),
        );
    }
    // stripe
    if(citybook_addons_get_option('payments_stripe_enable') == 'yes'){
        $payments['stripe'] = array(
            'title' => __( 'Pay via Stripe', 'citybook-add-ons' ),
            'icon' => CITYBOOK_ADD_ONS_DIR_URL.'assets/images/stripe.png',
            'desc' => citybook_addons_get_option('payments_stripe_desc',''),

            'checkout_text' => __( 'Pay Now', 'citybook-add-ons' ),
        );
    }
    // payfast
    if(citybook_addons_get_option('payments_payfast_enable') == 'yes'){
        $payments['payfast'] = array(
            'title' => __( 'Pay via Payfast', 'citybook-add-ons' ),
            'icon' => CITYBOOK_ADD_ONS_DIR_URL.'assets/images/payfast.png',
            'desc' => citybook_addons_get_option('payments_payfast_desc',''),

            'checkout_text' => __( 'Process to Payfast', 'citybook-add-ons' ),
        );
    }
    if(isset($payments[$method])) return $payments[$method];
    else return $payments;
}

// convert PDT (Paypal time to UTC) --> NOTE: need to return to local date
function citybook_add_ons_payment_date($date ='', $format = 'Y-m-d H:i:s'){

    // $dateObj = new DateTime($date, new DateTimeZone('America/Los_Angeles'));
    $dateObj = new DateTime($date);
    
    // $tz = new DateTimeZone('Europe/London');04:31:57+Apr+21,+2018+PDT04:31:57+Apr+21,+2018+PDT
    $tz = new DateTimeZone('UTC');
    $dateObj->setTimezone($tz);

    // $stamp = $dateObj->format('U');
    // $zone = $tz->getTransitions($stamp, $stamp);
    // if(!$zone[0]['isdst']) $dateObj->modify('+1 hour');

    // return $dateObj->format($format); // --> this will return gmt date

    return get_date_from_gmt( $dateObj->format('Y-m-d H:i:s'), $format );


    // $dateObj = new DateTime($date, new DateTimeZone('America/Los_Angeles'));
    // // echo "The time in Los Angeles is " . $dateObj->format('Y-m-d H:i:s') . "<br>";
    // $dateObj->setTimezone(new DateTimeZone('Europe/London'));
    // // echo "The time in London is " . $dateObj->format('Y-m-d H:i:s') . "<br>";

    // return $dateObj->format('Y-m-d H:i:s');



    // $tz = new DateTimeZone('America/Los_Angeles');  
    // $dateObj = new DateTime($date);
    // $dateObj->setTimezone($tz);
    // $stamp = $dateObj->format('U');
    // $zone = $tz->getTransitions($stamp, $stamp);
    // if(!$zone[0]['isdst']) $dateObj->modify('+1 hour');
    // return $dateObj->format('Y-m-d H:i:s');
}

// convert Unix epoch timestamp to UTC (Stripe time to UTC) --> Note this return local time not UTC
function citybook_add_ons_charge_date($timestamp ='', $format = 'Y-m-d H:i:s'){
    $dateObj = new DateTime();
    $dateObj->setTimestamp($timestamp);
    
    return $dateObj->format($format);
}

function citybook_addons_date_format($date ='', $time = false){
    if($date == 'NEVER') return $date;
    $dateObj = new DateTime($date);

    $format = get_option('date_format');
    if($time) $format .= ' '.get_option( 'time_format' );
    
    return $dateObj->format($format);
}

function citybook_add_ons_cal_next_date($date = '', $period = 'day', $interval = 0, $format = 'Y-m-d H:i:s'){
    $dateObj = new DateTime($date);

    if($interval){
        switch ($period) {
            case 'day':
                citybook_add_ons_add_days($dateObj, $interval);
                break;
            case 'week':
                citybook_add_ons_add_weeks($dateObj, $interval);
                break;
            case 'month':
                citybook_add_ons_add_months($dateObj, $interval);
                break;
            case 'year':
                citybook_add_ons_add_years($dateObj, $interval);
                break;
            
        }
    }

    return $dateObj->format($format);
}
// for changing data base on plan period
function citybook_add_ons_add_months($date,$months = 0){
     
    $init=clone $date;
    $modifier=$months.' months';
    $back_modifier =-$months.' months';
    
    $date->modify($modifier);
    $back_to_init= clone $date;
    $back_to_init->modify($back_modifier);
    
    while($init->format('m')!=$back_to_init->format('m')){
    $date->modify('-1 day')    ;
    $back_to_init= clone $date;
    $back_to_init->modify($back_modifier);    
    }
    
    /*
    if($months<0&&$date->format('m')>$init->format('m'))
    while($date->format('m')-12-$init->format('m')!=$months%12)
    $date->modify('-1 day');
    else
    if($months>0&&$date->format('m')<$init->format('m'))
    while($date->format('m')+12-$init->format('m')!=$months%12)
    $date->modify('-1 day');
    else
    while($date->format('m')-$init->format('m')!=$months%12)
    $date->modify('-1 day');
    */
    
}
 
function citybook_add_ons_add_years($date,$years = 0){
    
    $init=clone $date;
    $modifier=$years.' years';
    $date->modify($modifier);
    
    while($date->format('m')!=$init->format('m'))
    $date->modify('-1 day');
    
    
} 
function citybook_add_ons_add_weeks($date, $weeks = 0){
    // $init=clone $date;
    $modifier=$weeks.' weeks';
    $date->modify($modifier);
}
function citybook_add_ons_add_days($date, $days = 0){
    // $init=clone $date;
    $modifier= $days.' days';
    $date->modify($modifier);
}
// end changing date function

function citybook_add_ons_get_plan_period_text($interval = 1, $period = 'month'){
    $period_texts = array(
        'hour'          => esc_html__( 'hour', 'citybook-add-ons' ),
        'day'           => esc_html__( 'day', 'citybook-add-ons' ),
        'week'          => esc_html__( 'week', 'citybook-add-ons' ),
        'month'         => esc_html__( 'month', 'citybook-add-ons' ),
        'year'          => esc_html__( 'year', 'citybook-add-ons' ),
    );
    if($interval){
        $formatted_period = $period_texts[$period];
        if($interval > 1) $formatted_period = sprintf(__( '%d %ss', 'citybook-add-ons' ), $interval, $period_texts[$period] );
        return sprintf(__( '<span class="period-per">Per</span> %s', 'citybook-add-ons' ), $formatted_period);
    }

    return __( '', 'citybook-add-ons' );

    // $formatted_period = _n( $period_texts[$period], '%s '.$period_texts[$period], $interval, 'citybook-add-ons' );


    
}

function citybook_add_ons_get_plan_trial_text($interval = 1, $period = 'month'){
    $period_texts = array(
        'hour'          => esc_html__( 'hour', 'citybook-add-ons' ),
        'day'           => esc_html__( 'day', 'citybook-add-ons' ),
        'week'          => esc_html__( 'week', 'citybook-add-ons' ),
        'month'         => esc_html__( 'month', 'citybook-add-ons' ),
        'year'          => esc_html__( 'year', 'citybook-add-ons' ),
    );
    if($interval){
        $formatted_period = $period_texts[$period];
        if($interval > 1) $formatted_period = sprintf(__( '%d %ss', 'citybook-add-ons' ), $interval, $period_texts[$period] );
        return sprintf(__( '<span class="trial-per">for</span> %s', 'citybook-add-ons' ), $formatted_period);
    }

    return __( '', 'citybook-add-ons' );
}

function citybook_add_ons_get_currency_symbol($currency = 'USD'){

    $world_curr = array (
        'ALL' => _x('Albania Lek', 'currency symbol', 'citybook-add-ons' ), 
        'AFN' => _x('Afghanistan Afghani', 'currency symbol', 'citybook-add-ons' ), 
        'ARS' => _x('Argentina Peso', 'currency symbol', 'citybook-add-ons' ), 
        'AWG' => _x('Aruba Guilder', 'currency symbol', 'citybook-add-ons' ), 
        'AUD' => _x('Australia Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'AZN' => _x('Azerbaijan New Manat', 'currency symbol', 'citybook-add-ons' ), 
        'BSD' => _x('Bahamas Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'BBD' => _x('Barbados Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'BDT' => _x('Bangladeshi taka', 'currency symbol', 'citybook-add-ons' ), 
        'BYR' => _x('Belarus Ruble', 'currency symbol', 'citybook-add-ons' ), 
        'BZD' => _x('Belize Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'BMD' => _x('Bermuda Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'BOB' => _x('Bolivia Boliviano', 'currency symbol', 'citybook-add-ons' ), 
        'BAM' => _x('Bosnia and Herzegovina Convertible Marka', 'currency symbol', 'citybook-add-ons' ), 
        'BWP' => _x('Botswana Pula', 'currency symbol', 'citybook-add-ons' ), 
        'BGN' => _x('Bulgaria Lev', 'currency symbol', 'citybook-add-ons' ), 
        'BRL' => _x('Brazil Real', 'currency symbol', 'citybook-add-ons' ), 
        'BND' => _x('Brunei Darussalam Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'KHR' => _x('Cambodia Riel', 'currency symbol', 'citybook-add-ons' ), 
        'CAD' => _x('Canada Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'KYD' => _x('Cayman Islands Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'CLP' => _x('Chile Peso', 'currency symbol', 'citybook-add-ons' ), 
        'CNY' => _x('China Yuan Renminbi', 'currency symbol', 'citybook-add-ons' ), 
        'COP' => _x('Colombia Peso', 'currency symbol', 'citybook-add-ons' ), 
        'CRC' => _x('Costa Rica Colon', 'currency symbol', 'citybook-add-ons' ), 
        'HRK' => _x('Croatia Kuna', 'currency symbol', 'citybook-add-ons' ), 
        'CUP' => _x('Cuba Peso', 'currency symbol', 'citybook-add-ons' ), 
        'CZK' => _x('Czech Republic Koruna', 'currency symbol', 'citybook-add-ons' ), 
        'DKK' => _x('Denmark Krone', 'currency symbol', 'citybook-add-ons' ), 
        'DOP' => _x('Dominican Republic Peso', 'currency symbol', 'citybook-add-ons' ), 
        'XCD' => _x('East Caribbean Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'EGP' => _x('Egypt Pound', 'currency symbol', 'citybook-add-ons' ), 
        'SVC' => _x('El Salvador Colon', 'currency symbol', 'citybook-add-ons' ), 
        'EEK' => _x('Estonia Kroon', 'currency symbol', 'citybook-add-ons' ), 
        'EUR' => _x('Euro Member Countries', 'currency symbol', 'citybook-add-ons' ), 
        'FKP' => _x('Falkland Islands (Malvinas) Pound', 'currency symbol', 'citybook-add-ons' ), 
        'FJD' => _x('Fiji Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'GHC' => _x('Ghana Cedis', 'currency symbol', 'citybook-add-ons' ), 
        'GIP' => _x('Gibraltar Pound', 'currency symbol', 'citybook-add-ons' ), 
        'GTQ' => _x('Guatemala Quetzal', 'currency symbol', 'citybook-add-ons' ), 
        'GGP' => _x('Guernsey Pound', 'currency symbol', 'citybook-add-ons' ), 
        'GYD' => _x('Guyana Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'HNL' => _x('Honduras Lempira', 'currency symbol', 'citybook-add-ons' ), 
        'HKD' => _x('Hong Kong Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'HUF' => _x('Hungary Forint', 'currency symbol', 'citybook-add-ons' ), 
        'ISK' => _x('Iceland Krona', 'currency symbol', 'citybook-add-ons' ), 
        'INR' => _x('India Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'IDR' => _x('Indonesia Rupiah', 'currency symbol', 'citybook-add-ons' ), 
        'IRR' => _x('Iran Rial', 'currency symbol', 'citybook-add-ons' ), 
        'IMP' => _x('Isle of Man Pound', 'currency symbol', 'citybook-add-ons' ), 
        'ILS' => _x('Israel Shekel', 'currency symbol', 'citybook-add-ons' ), 
        'JMD' => _x('Jamaica Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'JPY' => _x('Japan Yen', 'currency symbol', 'citybook-add-ons' ), 
        'JEP' => _x('Jersey Pound', 'currency symbol', 'citybook-add-ons' ), 
        'KZT' => _x('Kazakhstan Tenge', 'currency symbol', 'citybook-add-ons' ), 
        'KPW' => _x('Korea (North) Won', 'currency symbol', 'citybook-add-ons' ), 
        'KRW' => _x('Korea (South) Won', 'currency symbol', 'citybook-add-ons' ), 
        'KGS' => _x('Kyrgyzstan Som', 'currency symbol', 'citybook-add-ons' ), 
        'LAK' => _x('Laos Kip', 'currency symbol', 'citybook-add-ons' ), 
        'LVL' => _x('Latvia Lat', 'currency symbol', 'citybook-add-ons' ), 
        'LBP' => _x('Lebanon Pound', 'currency symbol', 'citybook-add-ons' ), 
        'LRD' => _x('Liberia Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'LTL' => _x('Lithuania Litas', 'currency symbol', 'citybook-add-ons' ), 
        'MKD' => _x('Macedonia Denar', 'currency symbol', 'citybook-add-ons' ), 
        'MYR' => _x('Malaysia Ringgit', 'currency symbol', 'citybook-add-ons' ), 
        'MUR' => _x('Mauritius Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'MXN' => _x('Mexico Peso', 'currency symbol', 'citybook-add-ons' ), 
        'MNT' => _x('Mongolia Tughrik', 'currency symbol', 'citybook-add-ons' ), 
        'MZN' => _x('Mozambique Metical', 'currency symbol', 'citybook-add-ons' ), 
        'NAD' => _x('Namibia Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'NPR' => _x('Nepal Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'ANG' => _x('Netherlands Antilles Guilder', 'currency symbol', 'citybook-add-ons' ), 
        'NZD' => _x('New Zealand Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'NIO' => _x('Nicaragua Cordoba', 'currency symbol', 'citybook-add-ons' ), 
        'NGN' => _x('Nigeria Naira', 'currency symbol', 'citybook-add-ons' ), 
        'NOK' => _x('Norway Krone', 'currency symbol', 'citybook-add-ons' ), 
        'OMR' => _x('Oman Rial', 'currency symbol', 'citybook-add-ons' ), 
        'PKR' => _x('Pakistan Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'PAB' => _x('Panama Balboa', 'currency symbol', 'citybook-add-ons' ), 
        'PYG' => _x('Paraguay Guarani', 'currency symbol', 'citybook-add-ons' ), 
        'PEN' => _x('Peru Nuevo Sol', 'currency symbol', 'citybook-add-ons' ), 
        'PHP' => _x('Philippines Peso', 'currency symbol', 'citybook-add-ons' ), 
        'PLN' => _x('Poland Zloty', 'currency symbol', 'citybook-add-ons' ), 
        'QAR' => _x('Qatar Riyal', 'currency symbol', 'citybook-add-ons' ), 
        'RON' => _x('Romania New Leu', 'currency symbol', 'citybook-add-ons' ), 
        'RUB' => _x('Russia Ruble', 'currency symbol', 'citybook-add-ons' ), 
        'SHP' => _x('Saint Helena Pound', 'currency symbol', 'citybook-add-ons' ), 
        'SAR' => _x('Saudi Arabia Riyal', 'currency symbol', 'citybook-add-ons' ), 
        'RSD' => _x('Serbia Dinar', 'currency symbol', 'citybook-add-ons' ), 
        'SCR' => _x('Seychelles Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'SGD' => _x('Singapore Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'SBD' => _x('Solomon Islands Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'SOS' => _x('Somalia Shilling', 'currency symbol', 'citybook-add-ons' ), 
        'ZAR' => _x('South Africa Rand', 'currency symbol', 'citybook-add-ons' ), 
        'LKR' => _x('Sri Lanka Rupee', 'currency symbol', 'citybook-add-ons' ), 
        'SEK' => _x('Sweden Krona', 'currency symbol', 'citybook-add-ons' ), 
        'CHF' => _x('Switzerland Franc', 'currency symbol', 'citybook-add-ons' ), 
        'SRD' => _x('Suriname Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'SYP' => _x('Syria Pound', 'currency symbol', 'citybook-add-ons' ), 
        'TWD' => _x('Taiwan New Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'THB' => _x('Thailand Baht', 'currency symbol', 'citybook-add-ons' ), 
        'TTD' => _x('Trinidad and Tobago Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'TRY' => _x('Turkey Lira', 'currency symbol', 'citybook-add-ons' ), 
        'TRL' => _x('Turkey Lira', 'currency symbol', 'citybook-add-ons' ), 
        'TVD' => _x('Tuvalu Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'UAH' => _x('Ukraine Hryvna', 'currency symbol', 'citybook-add-ons' ), 
        'GBP' => _x('United Kingdom Pound', 'currency symbol', 'citybook-add-ons' ), 
        'UGX' => _x('Uganda Shilling', 'currency symbol', 'citybook-add-ons' ), 
        'USD' => _x('United States Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'UYU' => _x('Uruguay Peso', 'currency symbol', 'citybook-add-ons' ), 
        'UZS' => _x('Uzbekistan Som', 'currency symbol', 'citybook-add-ons' ), 
        'VEF' => _x('Venezuela Bolivar', 'currency symbol', 'citybook-add-ons' ), 
        'VND' => _x('Viet Nam Dong', 'currency symbol', 'citybook-add-ons' ), 
        'YER' => _x('Yemen Rial', 'currency symbol', 'citybook-add-ons' ), 
        'ZWD' => _x('Zimbabwe Dollar', 'currency symbol', 'citybook-add-ons' ), 
        'CFA' => _x('CFA Franc', 'currency symbol', 'citybook-add-ons' ), 
        'KSH' => _x('Kenya shillings', 'currency symbol', 'citybook-add-ons' ), 
    );
    $currency_symbols = array (
        'USD'          => esc_html__( '$', 'citybook-add-ons' ),
        'EUR'          => esc_html__( '€', 'citybook-add-ons' ),
        'GBP'          => esc_html__( '£', 'citybook-add-ons' ),
        'AUD'          => esc_html__( '$', 'citybook-add-ons' ),
        'BRL'          => esc_html__( 'R$', 'citybook-add-ons' ),
        'CAD'          => esc_html__( '$', 'citybook-add-ons' ),
        'HKD'          => esc_html__( '$', 'citybook-add-ons' ),
        'ILS'          => esc_html__( '₪', 'citybook-add-ons' ),
        'JPY'          => esc_html__( '¥', 'citybook-add-ons' ),
        'MXN'          => esc_html__( '$', 'citybook-add-ons' ),
        'NZD'          => esc_html__( '$', 'citybook-add-ons' ),
        'SGD'          => esc_html__( '$', 'citybook-add-ons' ),
        'THB'          => esc_html__( '฿', 'citybook-add-ons' ),
        'INR'          => esc_html__( '₹', 'citybook-add-ons' ),
        'TRY'           => esc_html__( '₺', 'citybook-add-ons' ),
        'RIAL'          => esc_html__( '﷼', 'citybook-add-ons' ),
        'VND'           => esc_html__( '₫', 'citybook-add-ons' ),
        'RUB'           => esc_html__( '&#x20bd;', 'citybook-add-ons' ),
        'ZAR'           => esc_html__( 'R', 'citybook-add-ons' ),
    );

    
    $currency_symbols = array_merge($world_curr, $currency_symbols);

    if(isset($currency_symbols[$currency])) return $currency_symbols[$currency];

    return $currency;
    
}

function citybook_addons_get_google_contry_codes($country = ''){

    $countries = array(
        'af' => __("Afghanistan", 'citybook-add-ons'),
        'al' => __("Albania", 'citybook-add-ons'),
        'dz' => __("Algeria", 'citybook-add-ons'),
        'as' => __("American Samoa", 'citybook-add-ons'),
        'ad' => __("Andorra", 'citybook-add-ons'),
        'ao' => __("Angola", 'citybook-add-ons'),
        'ai' => __("Anguilla", 'citybook-add-ons'),
        'aq' => __("Antarctica", 'citybook-add-ons'),
        'ag' => __("Antigua and Barbuda", 'citybook-add-ons'),
        'ar' => __("Argentina", 'citybook-add-ons'),
        'am' => __("Armenia", 'citybook-add-ons'),
        'aw' => __("Aruba", 'citybook-add-ons'),
        'au' => __("Australia", 'citybook-add-ons'),
        'at' => __("Austria", 'citybook-add-ons'),
        'az' => __("Azerbaijan", 'citybook-add-ons'),
        'bs' => __("Bahamas", 'citybook-add-ons'),
        'bh' => __("Bahrain", 'citybook-add-ons'),
        'bd' => __("Bangladesh", 'citybook-add-ons'),
        'bb' => __("Barbados", 'citybook-add-ons'),
        'by' => __("Belarus", 'citybook-add-ons'),
        'be' => __("Belgium", 'citybook-add-ons'),
        'bz' => __("Belize", 'citybook-add-ons'),
        'bj' => __("Benin", 'citybook-add-ons'),
        'bm' => __("Bermuda", 'citybook-add-ons'),
        'bt' => __("Bhutan", 'citybook-add-ons'),
        'bo' => __("Bolivia", 'citybook-add-ons'),
        'ba' => __("Bosnia and Herzegovina", 'citybook-add-ons'),
        'bw' => __("Botswana", 'citybook-add-ons'),
        'bv' => __("Bouvet Island", 'citybook-add-ons'),
        'br' => __("Brazil", 'citybook-add-ons'),
        'io' => __("British Indian Ocean Territory", 'citybook-add-ons'),
        'bn' => __("Brunei Darussalam", 'citybook-add-ons'),
        'bg' => __("Bulgaria", 'citybook-add-ons'),
        'bf' => __("Burkina Faso", 'citybook-add-ons'),
        'bi' => __("Burundi", 'citybook-add-ons'),
        'kh' => __("Cambodia", 'citybook-add-ons'),
        'cm' => __("Cameroon", 'citybook-add-ons'),
        'ca' => __("Canada", 'citybook-add-ons'),
        'cv' => __("Cape Verde", 'citybook-add-ons'),
        'ky' => __("Cayman Islands", 'citybook-add-ons'),
        'cf' => __("Central African Republic", 'citybook-add-ons'),
        'td' => __("Chad", 'citybook-add-ons'),
        'cl' => __("Chile", 'citybook-add-ons'),
        'cn' => __("China", 'citybook-add-ons'),
        'cx' => __("Christmas Island", 'citybook-add-ons'),
        'cc' => __("Cocos (Keeling) Islands", 'citybook-add-ons'),
        'co' => __("Colombia", 'citybook-add-ons'),
        'km' => __("Comoros", 'citybook-add-ons'),
        'cg' => __("Congo", 'citybook-add-ons'),
        'cd' => __("Congo, the Democratic Republic of the", 'citybook-add-ons'),
        'ck' => __("Cook Islands", 'citybook-add-ons'),
        'cr' => __("Costa Rica", 'citybook-add-ons'),
        'ci' => __("Cote D'ivoire", 'citybook-add-ons'),
        'hr' => __("Croatia", 'citybook-add-ons'),
        'cu' => __("Cuba", 'citybook-add-ons'),
        'cy' => __("Cyprus", 'citybook-add-ons'),
        'cz' => __("Czech Republic", 'citybook-add-ons'),
        'dk' => __("Denmark", 'citybook-add-ons'),
        'dj' => __("Djibouti", 'citybook-add-ons'),
        'dm' => __("Dominica", 'citybook-add-ons'),
        'do' => __("Dominican Republic", 'citybook-add-ons'),
        'ec' => __("Ecuador", 'citybook-add-ons'),
        'eg' => __("Egypt", 'citybook-add-ons'),
        'sv' => __("El Salvador", 'citybook-add-ons'),
        'gq' => __("Equatorial Guinea", 'citybook-add-ons'),
        'er' => __("Eritrea", 'citybook-add-ons'),
        'ee' => __("Estonia", 'citybook-add-ons'),
        'et' => __("Ethiopia", 'citybook-add-ons'),
        'fk' => __("Falkland Islands (Malvinas)", 'citybook-add-ons'),
        'fo' => __("Faroe Islands", 'citybook-add-ons'),
        'fj' => __("Fiji", 'citybook-add-ons'),
        'fi' => __("Finland", 'citybook-add-ons'),
        'fr' => __("France", 'citybook-add-ons'),
        'gf' => __("French Guiana", 'citybook-add-ons'),
        'pf' => __("French Polynesia", 'citybook-add-ons'),
        'tf' => __("French Southern Territories", 'citybook-add-ons'),
        'ga' => __("Gabon", 'citybook-add-ons'),
        'gm' => __("Gambia", 'citybook-add-ons'),
        'ge' => __("Georgia", 'citybook-add-ons'),
        'de' => __("Germany", 'citybook-add-ons'),
        'gh' => __("Ghana", 'citybook-add-ons'),
        'gi' => __("Gibraltar", 'citybook-add-ons'),
        'gr' => __("Greece", 'citybook-add-ons'),
        'gl' => __("Greenland", 'citybook-add-ons'),
        'gd' => __("Grenada", 'citybook-add-ons'),
        'gp' => __("Guadeloupe", 'citybook-add-ons'),
        'gu' => __("Guam", 'citybook-add-ons'),
        'gt' => __("Guatemala", 'citybook-add-ons'),
        'gn' => __("Guinea", 'citybook-add-ons'),
        'gw' => __("Guinea-Bissau", 'citybook-add-ons'),
        'gy' => __("Guyana", 'citybook-add-ons'),
        'ht' => __("Haiti", 'citybook-add-ons'),
        'hm' => __("Heard Island and Mcdonald Islands", 'citybook-add-ons'),
        'va' => __("Holy See (Vatican City State)", 'citybook-add-ons'),
        'hn' => __("Honduras", 'citybook-add-ons'),
        'hk' => __("Hong Kong", 'citybook-add-ons'),
        'hu' => __("Hungary", 'citybook-add-ons'),
        'is' => __("Iceland", 'citybook-add-ons'),
        'in' => __("India", 'citybook-add-ons'),
        'id' => __("Indonesia", 'citybook-add-ons'),
        'ir' => __("Iran, Islamic Republic of", 'citybook-add-ons'),
        'iq' => __("Iraq", 'citybook-add-ons'),
        'ie' => __("Ireland", 'citybook-add-ons'),
        'il' => __("Israel", 'citybook-add-ons'),
        'it' => __("Italy", 'citybook-add-ons'),
        'jm' => __("Jamaica", 'citybook-add-ons'),
        'jp' => __("Japan", 'citybook-add-ons'),
        'jo' => __("Jordan", 'citybook-add-ons'),
        'kz' => __("Kazakhstan", 'citybook-add-ons'),
        'ke' => __("Kenya", 'citybook-add-ons'),
        'ki' => __("Kiribati", 'citybook-add-ons'),
        'kp' => __("Korea, Democratic People's Republic of", 'citybook-add-ons'),
        'kr' => __("Korea, Republic of", 'citybook-add-ons'),
        'kw' => __("Kuwait", 'citybook-add-ons'),
        'kg' => __("Kyrgyzstan", 'citybook-add-ons'),
        'la' => __("Lao People's Democratic Republic", 'citybook-add-ons'),
        'lv' => __("Latvia", 'citybook-add-ons'),
        'lb' => __("Lebanon", 'citybook-add-ons'),
        'ls' => __("Lesotho", 'citybook-add-ons'),
        'lr' => __("Liberia", 'citybook-add-ons'),
        'ly' => __("Libyan Arab Jamahiriya", 'citybook-add-ons'),
        'li' => __("Liechtenstein", 'citybook-add-ons'),
        'lt' => __("Lithuania", 'citybook-add-ons'),
        'lu' => __("Luxembourg", 'citybook-add-ons'),
        'mo' => __("Macao", 'citybook-add-ons'),
        'mk' => __("Macedonia, the Former Yugosalv Republic of", 'citybook-add-ons'),
        'mg' => __("Madagascar", 'citybook-add-ons'),
        'mw' => __("Malawi", 'citybook-add-ons'),
        'my' => __("Malaysia", 'citybook-add-ons'),
        'mv' => __("Maldives", 'citybook-add-ons'),
        'ml' => __("Mali", 'citybook-add-ons'),
        'mt' => __("Malta", 'citybook-add-ons'),
        'mh' => __("Marshall Islands", 'citybook-add-ons'),
        'mq' => __("Martinique", 'citybook-add-ons'),
        'mr' => __("Mauritania", 'citybook-add-ons'),
        'mu' => __("Mauritius", 'citybook-add-ons'),
        'yt' => __("Mayotte", 'citybook-add-ons'),
        'mx' => __("Mexico", 'citybook-add-ons'),
        'fm' => __("Micronesia, Federated States of", 'citybook-add-ons'),
        'md' => __("Moldova, Republic of", 'citybook-add-ons'),
        'mc' => __("Monaco", 'citybook-add-ons'),
        'mn' => __("Mongolia", 'citybook-add-ons'),
        'ms' => __("Montserrat", 'citybook-add-ons'),
        'ma' => __("Morocco", 'citybook-add-ons'),
        'mz' => __("Mozambique", 'citybook-add-ons'),
        'mm' => __("Myanmar", 'citybook-add-ons'),
        'na' => __("Namibia", 'citybook-add-ons'),
        'nr' => __("Nauru", 'citybook-add-ons'),
        'np' => __("Nepal", 'citybook-add-ons'),
        'nl' => __("Netherlands", 'citybook-add-ons'),
        'an' => __("Netherlands Antilles", 'citybook-add-ons'),
        'nc' => __("New Caledonia", 'citybook-add-ons'),
        'nz' => __("New Zealand", 'citybook-add-ons'),
        'ni' => __("Nicaragua", 'citybook-add-ons'),
        'ne' => __("Niger", 'citybook-add-ons'),
        'ng' => __("Nigeria", 'citybook-add-ons'),
        'nu' => __("Niue", 'citybook-add-ons'),
        'nf' => __("Norfolk Island", 'citybook-add-ons'),
        'mp' => __("Northern Mariana Islands", 'citybook-add-ons'),
        'no' => __("Norway", 'citybook-add-ons'),
        'om' => __("Oman", 'citybook-add-ons'),
        'pk' => __("Pakistan", 'citybook-add-ons'),
        'pw' => __("Palau", 'citybook-add-ons'),
        'ps' => __("Palestinian Territory, Occupied", 'citybook-add-ons'),
        'pa' => __("Panama", 'citybook-add-ons'),
        'pg' => __("Papua New Guinea", 'citybook-add-ons'),
        'py' => __("Paraguay", 'citybook-add-ons'),
        'pe' => __("Peru", 'citybook-add-ons'),
        'ph' => __("Philippines", 'citybook-add-ons'),
        'pn' => __("Pitcairn", 'citybook-add-ons'),
        'pl' => __("Poland", 'citybook-add-ons'),
        'pt' => __("Portugal", 'citybook-add-ons'),
        'pr' => __("Puerto Rico", 'citybook-add-ons'),
        'qa' => __("Qatar", 'citybook-add-ons'),
        're' => __("Reunion", 'citybook-add-ons'),
        'ro' => __("Romania", 'citybook-add-ons'),
        'ru' => __("Russian Federation", 'citybook-add-ons'),
        'rw' => __("Rwanda", 'citybook-add-ons'),
        'sh' => __("Saint Helena", 'citybook-add-ons'),
        'kn' => __("Saint Kitts and Nevis", 'citybook-add-ons'),
        'lc' => __("Saint Lucia", 'citybook-add-ons'),
        'pm' => __("Saint Pierre and Miquelon", 'citybook-add-ons'),
        'vc' => __("Saint Vincent and the Grenadines", 'citybook-add-ons'),
        'ws' => __("Samoa", 'citybook-add-ons'),
        'sm' => __("San Marino", 'citybook-add-ons'),
        'st' => __("Sao Tome and Principe", 'citybook-add-ons'),
        'sa' => __("Saudi Arabia", 'citybook-add-ons'),
        'sn' => __("Senegal", 'citybook-add-ons'),
        'cs' => __("Serbia and Montenegro", 'citybook-add-ons'),
        'sc' => __("Seychelles", 'citybook-add-ons'),
        'sl' => __("Sierra Leone", 'citybook-add-ons'),
        'sg' => __("Singapore", 'citybook-add-ons'),
        'sk' => __("Slovakia", 'citybook-add-ons'),
        'si' => __("Slovenia", 'citybook-add-ons'),
        'sb' => __("Solomon Islands", 'citybook-add-ons'),
        'so' => __("Somalia", 'citybook-add-ons'),
        'za' => __("South Africa", 'citybook-add-ons'),
        'gs' => __("South Georgia and the South Sandwich Islands", 'citybook-add-ons'),
        'es' => __("Spain", 'citybook-add-ons'),
        'lk' => __("Sri Lanka", 'citybook-add-ons'),
        'sd' => __("Sudan", 'citybook-add-ons'),
        'sr' => __("Suriname", 'citybook-add-ons'),
        'sj' => __("Svalbard and Jan Mayen", 'citybook-add-ons'),
        'sz' => __("Swaziland", 'citybook-add-ons'),
        'se' => __("Sweden", 'citybook-add-ons'),
        'ch' => __("Switzerland", 'citybook-add-ons'),
        'sy' => __("Syrian Arab Republic", 'citybook-add-ons'),
        'tw' => __("Taiwan, Province of China", 'citybook-add-ons'),
        'tj' => __("Tajikistan", 'citybook-add-ons'),
        'tz' => __("Tanzania, United Republic of", 'citybook-add-ons'),
        'th' => __("Thailand", 'citybook-add-ons'),
        'tl' => __("Timor-Leste", 'citybook-add-ons'),
        'tg' => __("Togo", 'citybook-add-ons'),
        'tk' => __("Tokelau", 'citybook-add-ons'),
        'to' => __("Tonga", 'citybook-add-ons'),
        'tt' => __("Trinidad and Tobago", 'citybook-add-ons'),
        'tn' => __("Tunisia", 'citybook-add-ons'),
        'tr' => __("Turkey", 'citybook-add-ons'),
        'tm' => __("Turkmenistan", 'citybook-add-ons'),
        'tc' => __("Turks and Caicos Islands", 'citybook-add-ons'),
        'tv' => __("Tuvalu", 'citybook-add-ons'),
        'ug' => __("Uganda", 'citybook-add-ons'),
        'ua' => __("Ukraine", 'citybook-add-ons'),
        'ae' => __("United Arab Emirates", 'citybook-add-ons'),
        'uk' => __("United Kingdom", 'citybook-add-ons'),
        'us' => __("United States", 'citybook-add-ons'),
        'um' => __("United States Minor Outlying Islands", 'citybook-add-ons'),
        'uy' => __("Uruguay", 'citybook-add-ons'),
        'uz' => __("Uzbekistan", 'citybook-add-ons'),
        'vu' => __("Vanuatu", 'citybook-add-ons'),
        've' => __("Venezuela", 'citybook-add-ons'),
        'vn' => __("Viet Nam", 'citybook-add-ons'),
        'vg' => __("Virgin Islands, British", 'citybook-add-ons'),
        'vi' => __("Virgin Islands, U.S.", 'citybook-add-ons'),
        'wf' => __("Wallis and Futuna", 'citybook-add-ons'),
        'eh' => __("Western Sahara", 'citybook-add-ons'),
        'ye' => __("Yemen", 'citybook-add-ons'),
        'zm' => __("Zambia", 'citybook-add-ons'),
        'zw' => __("Zimbabwe", 'citybook-add-ons'),
    );
    
    if($country !='' && isset($countries[$country])) return $countries[$country];

    return $countries;
}

// for subscription plan
function citybook_add_ons_get_subscription_duration_units($unit = ''){
    $duration_units = array(
        // 'hour'          => esc_html__( 'Hour', 'citybook-add-ons' ),
        'day'           => esc_html__( 'Days', 'citybook-add-ons' ),
        'week'          => esc_html__( 'Weeks', 'citybook-add-ons' ),
        'month'         => esc_html__( 'Months', 'citybook-add-ons' ),
        'year'          => esc_html__( 'Years', 'citybook-add-ons' ),
    );
    if( !empty($unit) && isset( $duration_units[$unit] ) ) return $duration_units[$unit];

    return $duration_units;
}
//
function citybook_add_ons_get_paypal_duration_unit($unit = ''){
    /*
    D. Days. Valid range for p3 is 1 to 90.
    W. Weeks. Valid range for p3 is 1 to 52.
    M. Months. Valid range for p3 is 1 to 24.
    Y. Years. Valid range for p3 is 1 to 5.
    */

    $default = array(
        'day' => 'D',
        'week' => 'W',
        'month' => 'M',
        'year' => 'Y',
    );

    if( !empty($unit) && isset( $default[$unit] ) ) return $default[$unit];

    return $default['month'];
}
function citybook_add_ons_get_paypal_duration($duration = '', $unit = ''){
    if($duration){
        $duration_unit = citybook_add_ons_get_paypal_duration_unit($unit);
        switch ($duration_unit) {
            case 'D':
                if((int)$duration > 90) return 90;
                return (int)$duration;
                break;
            case 'W':
                if((int)$duration > 52) return 52;
                return (int)$duration;
                break;
            case 'M':
                if((int)$duration > 24) return 24;
                return (int)$duration;
                break;
            case 'Y':
                if((int)$duration > 5) return 5;
                return (int)$duration;
                break;
            
        }
    }

    return 1;

}
function citybook_add_ons_get_stripe_duration($duration = '', $unit = ''){
    if($duration){
        switch ($unit) {
            case 'day':
                return (int)$duration;
                break;
            case 'week':
                return 7*$duration;
                break;
            case 'month':
                return 30*$duration;
                break;
            case 'year':
                return 365*$duration;
                break;
            
        }
    }
    return 1;

}
function citybook_addons_get_current_subscription($user_ID = 0, $per_listing = false){
    if(!$user_ID){
        // return false when no user
        if(!is_user_logged_in()) return false;
        $user_ID = get_current_user_id();
    }

    $per_listing_sub = $per_listing ? 'yes' : 'no';

    $args = array(
        'posts_per_page'   => 1,
        'orderby'          => 'date',
        'order'            => 'DESC',
        // 'meta_key'         => P_META_PREFIX.'user_id',
        // 'meta_value'       => $user_ID,

        'post_author'       => $user_ID,
        'post_type'        => 'lorder',
        'post_status'      => 'publish',

        'meta_query' => array(
            'relation'  => 'AND',
            array(
                'relation'  => 'OR',
                array(
                    'key' => P_META_PREFIX.'status',
                    'value' => 'completed',
                ),
                array(
                    'key' => P_META_PREFIX.'status',
                    'value' => 'trialing',
                ),
            ),
            array(
                'key' => P_META_PREFIX.'user_id',
                'value' => $user_ID,
            ),
            array(
                'relation'  => 'OR',
                array(
                    'key'     => P_META_PREFIX.'end_date',
                    'value'   => 'NEVER',
                ),
                array(
                    'key'     => P_META_PREFIX.'end_date',
                    'value'   => current_time('mysql', 1),
                    'compare' => '>=',
                    'type'    => 'DATETIME',
                ),
            ),
            array(
                'key'     => P_META_PREFIX.'is_per_listing_sub',
                'value'   => $per_listing_sub,
            ),
        )

    );
    $posts_array = get_posts( $args );

    if(count($posts_array)){
        $order = $posts_array[0];
        $order_listings = get_post_meta( $order->ID, P_META_PREFIX.'listings', true );
        $order_limit = get_post_meta( $order->ID, P_META_PREFIX.'plan_llimit', true );
        return array(
            'id'            => $order->ID,
            'plan_id'       => get_post_meta( $order->ID, P_META_PREFIX.'plan_id', true ),
            'end_date'      => get_post_meta( $order->ID, P_META_PREFIX.'end_date', true ),
            // listings attached to the subscription
            'listings'      => $order_listings,
            'plan_llimit'   => $order_limit, // unlimited or number

            'valid'         => count((array)$order_listings) < (int)$order_limit
        );
    }


    return false;


}
// for listing claim
function citybook_add_ons_get_claim_status($status = ''){
    $defaults = array(
        'pending'                   => esc_html__( 'Pending', 'citybook-add-ons' ),
        'asked_charge'              => esc_html__( 'Asked charge fee', 'citybook-add-ons' ),
        'paid'                      => esc_html__( 'Paid', 'citybook-add-ons' ),
        'approved'                  => esc_html__( 'Appproved', 'citybook-add-ons' ),
        'decline'                   => esc_html__( 'Decline', 'citybook-add-ons' ),
    );

    if($status != '' && isset($defaults[$status])) return $defaults[$status];

    return $defaults;
    
}

// for user notification
function citybook_addons_user_add_notification( $user_id = 0, $message = array() ){
    $user = get_user_by('ID', $user_id);
    if(!$user) return;

    if(!isset($message['type']) || !isset($message['message'])) return;

    $notifications = get_user_meta( $user->ID, P_META_PREFIX.'notifications', true );
    if(empty($notifications)) $notifications = array();

    $notifications[uniqid($message['type'])] = $message['message'];

    update_user_meta( $user->ID, P_META_PREFIX.'notifications', $notifications );

}
function citybook_addons_get_notification_type($key){

    if(strpos($key, 'listing_publish') !== false){
        return 'listing_publish';
    }elseif(strpos($key, 'role_change') !== false){
        return 'role_change';
    }elseif(strpos($key, 'order_completed') !== false){
        return 'order_completed';
    }elseif(strpos($key, 'plan_change') !== false){
        return 'plan_change';
    }elseif(strpos($key, 'listing_submitted') !== false){
        return 'listing_submitted';
    }elseif(strpos($key, 'listing_edit') !== false){
        return 'listing_edit';
    }elseif(strpos($key, 'listing_deleted') !== false){
        return 'listing_deleted';
    }elseif(strpos($key, 'new_bookmarks') !== false){ // for listing author
        return 'new_bookmarks';
    }elseif(strpos($key, 'bookmarked') !== false){ // for user bookmarks
        return 'bookmarked';
    }elseif(strpos($key, 'review') !== false){
        return 'review';
    }elseif(strpos($key, 'delete_listing') !== false){
        return 'delete_listing';
    }elseif(strpos($key, 'new_invoice') !== false){
        return 'new_invoice';
    }elseif(strpos($key, 'ad_completed') !== false){
        return 'ad_completed';
    }elseif(strpos($key, 'edit_profile') !== false){
        return 'edit_profile';
    }elseif(strpos($key, 'password_changed') !== false){
        return 'password_changed';
    }elseif(strpos($key, 'booked') !== false){
        return 'booked';
    }elseif(strpos($key, 'new_booking') !== false){
        return 'new_booking';
    }elseif(strpos($key, 'booking_approved') !== false){
        return 'booking_approved';
    }elseif(strpos($key, 'listing_expired') !== false){
        return 'listing_expired';
    }elseif(strpos($key, 'ad_expired') !== false){
        return 'ad_expired';
    }

    
    return 'no_type';
}

// for user notification
function citybook_addons_reset_user_notification_type( $type = '', $user_id = 0 ){
    if(is_user_logged_in()){
        $user_id = get_current_user_id();
    }

    if(!empty($type)){
        $notifications = get_user_meta( $user_id, P_META_PREFIX.'notifications', true );
        if(!empty($notifications) && is_array($notifications)){
            $type_keys = array();
            foreach ($notifications as $key => $msg) {
                if(strpos($key, $type) !== false) $type_keys[] = $key;
            }
            if(!empty($type_keys)){
                foreach ($type_keys as $tkey) {
                    unset($notifications[$tkey]);
                }
                update_user_meta( $user_id, P_META_PREFIX.'notifications', $notifications );
            }
        }
    }
        
}



function citybook_addons_get_post_status($status){
    $statuses = array(
        'publish' => __( 'Publish', 'citybook-add-ons' ),
        'pending' => __( 'Pending', 'citybook-add-ons' ),
        'draft' => __( 'Draft', 'citybook-add-ons' ),
        'auto-draft' => __( 'Auto Draft', 'citybook-add-ons' ),
        'future' => __( 'Future', 'citybook-add-ons' ),
        'private' => __( 'Private', 'citybook-add-ons' ),
        'inherit' => __( 'Inherit', 'citybook-add-ons' ),
        'trash' => __( 'Trash', 'citybook-add-ons' ),
    );

    if(!empty($status) && isset($statuses[$status])) return $statuses[$status];

    return $statuses;

}
// display pacakge status - depends on backend order status and its expired date
function citybook_addons_get_package_status( $status ) {
    $statuses = array(
        'completed_in_time' => __( 'Active', 'citybook-add-ons' ),
        'completed_expired' => __( 'Expired', 'citybook-add-ons' ),
        'pending_in_time' => __( 'Pending', 'citybook-add-ons' ),
        'pending_expired' => __( 'Pending - Expired', 'citybook-add-ons' ),

        'trialing_in_time' => __( 'Trialing', 'citybook-add-ons' ),
        'trialing_expired' => __( 'Trialing - Expired', 'citybook-add-ons' ),
        
    );
    if(!empty($status) && isset($statuses[$status])) return $statuses[$status];

    return $statuses['pending_in_time'];
}
function citybook_addons_get_package_time_status($post_ID){
    $end_date = get_post_meta( $post_ID, P_META_PREFIX.'end_date', true );
    $current_date = current_time( 'mysql' , 1);
    if($end_date >= $current_date)
        return 'in_time';
    else
        return 'expired';
}
// get order/package/membership payment type - One Time or Recurring
function citybook_addons_get_order_type($meta = ''){
    if($meta == 'on'){
        // on is because using cmb2
        return __( 'Recurring', 'citybook-add-ons' );
    }

    return __( 'One Time', 'citybook-add-ons' );
}

function citybook_addons_get_post_orderby($order = ''){
    $orders = array(
        'none'  => __( 'No order', 'citybook-add-ons' ),
        'ID'  => __( 'Order by post id', 'citybook-add-ons' ),
        'author'  => __( 'Order by author', 'citybook-add-ons' ),
        'title'  => __( 'Order by post title', 'citybook-add-ons' ),
        'name'  => __( 'Order by post slug', 'citybook-add-ons' ),
        'type'  => __( 'Order by post type', 'citybook-add-ons' ),
        'date'  => __( 'Order by date', 'citybook-add-ons' ),
        'modified'  => __( 'Order by last modified date', 'citybook-add-ons' ),
        'parent'  => __( 'Order by post parent id', 'citybook-add-ons' ),
        'rand'  => __( 'Random order', 'citybook-add-ons' ),
        'comment_count'  => __( 'Order by number of comments', 'citybook-add-ons' ),
        'relevance'  => __( 'Order by search terms', 'citybook-add-ons' ),
        'menu_order'  => __( 'Order by Page Order', 'citybook-add-ons' ),
        'listing_featured'  => __( 'Listing Featured', 'citybook-add-ons' ),
        'event_start_date'  => __( 'Event Start Date', 'citybook-add-ons' ),
    );

    if(!empty($order) && isset($orders[$order])) return $orders[$order];

    return $orders;
}

function citybook_addons_get_listing_content_order_default(){
    return array('promo_video','content','gallery','slider','faqs','speaker');
}
function citybook_addons_get_listing_widget_order_default(){
    return array('wkhour','countdown','price_range','booking','weather','contacts','author','moreauthor','addfeas');
}

function citybook_addons_display_recaptcha($ele_id){
    if( citybook_addons_get_option('enable_g_recaptcah') == 'yes' && citybook_addons_get_option('g_recaptcha_site_key') != '' ) 
        echo '<div id="'.$ele_id.'" class="cth-recaptcha mt-20"></div>';
}

function citybook_addons_verify_recaptcha(){
        
    if( citybook_addons_get_option('enable_g_recaptcah') == 'yes' && citybook_addons_get_option('g_recaptcha_secret_key') != '' ){
        if( !isset( $_POST['g-recaptcha-response'] ) || empty( $_POST['g-recaptcha-response'] ) ) return false;
        $response = wp_remote_get( 
            add_query_arg( 
                array(
                    'secret'   => citybook_addons_get_option('g_recaptcha_secret_key'),
                    'response' => isset($_POST['g-recaptcha-response']) ? $_POST['g-recaptcha-response'] : '',
                    'remoteip' => isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : $_SERVER['REMOTE_ADDR']
                ), 
                'https://www.google.com/recaptcha/api/siteverify' 
            ) 
        );

        if( is_wp_error( $response ) || empty($response['body']) || ! ($json = json_decode( $response['body'] )) || ! $json->success ) {
            //return new WP_Error( 'validation-error',  __('reCAPTCHA validation failed. Please try again.' ) );
            return false;
        }

        return true;
    }

    return true;
}
// https://stackoverflow.com/questions/10808109/script-tag-async-defer
function citybook_addons_add_async_forscript($url)
{
    if(is_admin()){
        return str_replace(array('#cthasync','#cthdefer'), '', $url);
    }else{
        if(strpos($url, '#cthasync') !== false) $url = str_replace('#cthasync', '', $url)."' async='async"; 
        if(strpos($url, '#cthdefer') !== false) $url = str_replace('#cthdefer', '', $url)."' defer='defer"; 
    }

    return $url;


    // if (strpos($url, '#cthasync')===false)
    //     return $url;
    // else if (is_admin())
    //     return str_replace('#cthasync', '', $url);
    // else
    //     return str_replace('#cthasync', '', $url)."' async='async"; 
}
add_filter('clean_url', 'citybook_addons_add_async_forscript', 11, 1);


function citybook_addons_check_package_field($field_name='', $is_single = false, $user_ID = 0){
    // if( citybook_addons_get_option('all_info_for_admin') == 'yes' && citybook_addons_get_user_role() == 'administrator' ) return false;
    if($field_name!=''){
        if($is_single){
            if($plan_id = get_post_meta( get_the_ID(), P_META_PREFIX.'plan_id', true ) ){
                return get_post_meta( $plan_id, P_META_PREFIX.$field_name, true );
            }elseif( $order_id = get_post_meta( get_the_ID(), P_META_PREFIX.'order_id', true ) ){
                return get_post_meta( get_post_meta( $order_id, P_META_PREFIX.'plan_id', true ), P_META_PREFIX.$field_name, true );
            }elseif( citybook_addons_get_user_role(get_the_author_meta('ID')) == 'administrator' ){ // get default plan for admin
                return get_post_meta( citybook_addons_get_option( 'admin_lplan' ), P_META_PREFIX.$field_name, true );
            }else{
                // return free plan value
                return get_post_meta( citybook_addons_get_option( 'free_lplan' ), P_META_PREFIX.$field_name, true );
            }
        }
        if(citybook_addons_get_user_role($user_ID) == 'administrator') 
            return get_post_meta( citybook_addons_get_option( 'admin_lplan' ), P_META_PREFIX.$field_name, true );
        $user_current_subscription = citybook_addons_get_current_subscription( $user_ID );
        if( false == $user_current_subscription || false == $user_current_subscription['valid'] ){
            // return free plan value
            return get_post_meta( citybook_addons_get_option( 'free_lplan' ), P_META_PREFIX.$field_name, true );
        }else{
            // get package setting field
            return get_post_meta( $user_current_subscription['plan_id'], P_META_PREFIX.$field_name, true );
        }
    }
    return false;

}

function citybook_addons_check_package_single_field($field_name='', $listing_ID = 0){
    // show all for listings from administrator
    // if( citybook_addons_get_option('all_info_for_admin') == 'yes' && citybook_addons_get_user_role(get_the_author_meta('ID')) == 'administrator' ) return false;
    if($field_name!=''){
        if(empty($listing_ID)){
            $listing_ID = get_the_ID();
        }
        if($plan_id = get_post_meta( $listing_ID, P_META_PREFIX.'plan_id', true ) ){
            return get_post_meta( $plan_id, P_META_PREFIX.$field_name, true );
        }elseif( $order_id = get_post_meta( $listing_ID, P_META_PREFIX.'order_id', true ) ){
            return get_post_meta( get_post_meta( $order_id, P_META_PREFIX.'plan_id', true ), P_META_PREFIX.$field_name, true );
        }elseif( citybook_addons_get_user_role(get_the_author_meta('ID')) == 'administrator' ){ // get default plan for admin
            return get_post_meta( citybook_addons_get_option( 'admin_lplan' ), P_META_PREFIX.$field_name, true );
        }else{
            return get_post_meta( citybook_addons_get_option( 'free_lplan' ), P_META_PREFIX.$field_name, true );
        }
    }
    return false;
}
function citybook_addons_get_active_plan_ids(){

    $post_args = array(
        'fields'            => 'ids',
        'post_type'         => 'lplan',
        'posts_per_page'    => -1,
        'post_status'       => 'publish'
    );

    return get_posts($post_args);

}

// handle image upload with multiple files
function citybook_addons_handle_image_multiple_upload($field_name, $post_id = 0){
    $return_array = array();

    if($field_name != '' && isset($_FILES[$field_name])){
        $process_files = array();
        $field_name_files = $_FILES[$field_name];  
        foreach ($field_name_files['name'] as $key => $value) {            
            if ($field_name_files['name'][$key]) {
                $file = array( 
                    'name' => $field_name_files['name'][$key],
                    'type' => $field_name_files['type'][$key], 
                    'tmp_name' => $field_name_files['tmp_name'][$key], 
                    'error' => $field_name_files['error'][$key],
                    'size' => $field_name_files['size'][$key]
                ); 
                $process_files[] = $file;
                
            }
        } 

        

        foreach ($process_files as $key => $file) {
                
            $movefile = citybook_addons_handle_image_upload($file);

            if(is_array($movefile)){

                // https://wordpress.stackexchange.com/questions/40301/how-do-i-set-a-featured-image-thumbnail-by-image-url-when-using-wp-insert-post
                // https://codex.wordpress.org/Function_Reference/wp_insert_attachment
                // Prepare an array of post data for the attachment.
                $attachment = array(
                    // 'guid'           => $wp_upload_dir['url'] . '/' . basename( $filename ), 
                    'post_mime_type' => $movefile['type'],
                    'post_title'     => sanitize_file_name(basename($movefile['file'])),
                    'post_content'   => '',
                    'post_status'    => 'inherit'
                );

                // // Insert the attachment.
                $attach_id = wp_insert_attachment( $attachment, $movefile['file'], $post_id );

                if($attach_id != 0){
                    // Make sure that this file is included, as wp_generate_attachment_metadata() depends on it.
                    require_once( ABSPATH . 'wp-admin/includes/image.php' );

                    // Generate the metadata for the attachment, and update the database record.
                    $attach_data = wp_generate_attachment_metadata( $attach_id, $movefile['file'] );
                    // return value from update_post_meta -  https://codex.wordpress.org/Function_Reference/update_post_meta
                    // Returns meta_id if the meta doesn't exist, otherwise returns true on success and false on failure. NOTE: If the meta_value passed to this function is the same as the value that is already in the database, this function returns false.
                    wp_update_attachment_metadata( $attach_id, $attach_data );
                    // Post meta ID on success, false on failure.
                    // $json['data']['meta_id'] = set_post_thumbnail( $listing_id, $attach_id );

                    // $headerimgsMeta[] = array( $attach_id , wp_get_attachment_url( $attach_id ) );
                    $return_array[$attach_id] = wp_get_attachment_url( $attach_id ) ;
                }

            }

        }

        

    }
    // end if check

    return $return_array;
}

// https://codex.wordpress.org/Function_Reference/wp_handle_upload
function citybook_addons_handle_image_upload($uploadedfile){
    if ( ! function_exists( 'wp_handle_upload' ) ) {
        require_once( ABSPATH . 'wp-admin/includes/file.php' );
    }

    // check to make sure its a successful upload
    if ($uploadedfile['error'] !== UPLOAD_ERR_OK) return 'No file was uploaded.';
    // $uploadedfile = $_FILES['file'];
    if( $uploadedfile['size']/1024/1024 > citybook_addons_get_option('submit_media_limit_size') ){
        if(CTH_DEBUG) error_log(date('[Y-m-d H:i e] '). "File uploaded is too large. " . $uploadedfile['size']/1024/1024 . PHP_EOL, 3, CTH_LOG_FILE);
        return 'File uploaded is too large';
    }

    $upload_overrides = array( 'test_form' => false );

    $movefile = wp_handle_upload( $uploadedfile, $upload_overrides );

    if ( $movefile && ! isset( $movefile['error'] ) ) {
        // echo "File is valid, and was successfully uploaded.\n";
        // var_dump( $movefile );
        return $movefile;
    } else {
        /**
         * Error generated by _wp_handle_upload()
         * @see _wp_handle_upload() in wp-admin/includes/file.php
         */
        return $movefile['error'];
    }
}
function citybook_addons_limit_upload_size( $file ) {

    // Set the desired file size limit
    $file_size_limit = citybook_addons_get_option('submit_media_limit_size'); // in MB
    // exclude admins
    if ( ! current_user_can( 'manage_options' ) ) {

        $current_size = $file['size'];
        $current_size = $current_size / 1024 / 1024; //get size in MB

        if ( $current_size > $file_size_limit ) {
            $file['error'] = sprintf( __( 'ERROR: File size limit is %d MB.', 'citybook-add-ons' ), $file_size_limit );
        }

    }
    return $file;
}
add_filter ( 'wp_handle_upload_prefilter', 'citybook_addons_limit_upload_size', 10, 1 );


function citybook_addons_post_nav( $tax = 'category' ) {
    
    if( citybook_addons_get_option('single_post_nav' ) != 'yes' ) return ;

    $prev_post = get_adjacent_post( citybook_addons_get_option('single_same_term' ) , '', true, $tax );
    $next_post = get_adjacent_post( citybook_addons_get_option('single_same_term' ) , '', false, $tax );

    if ( is_a( $prev_post, 'WP_Post' ) || is_a( $next_post, 'WP_Post' ) ) :
?>
<div class="post-nav single-post-nav listing-post-nav fl-wrap">
<?php
    if ( is_a( $prev_post, 'WP_Post' ) ) :
    ?>
    <a href="<?php echo get_permalink( $prev_post->ID ); ?>" class="post-link prev-post-link" title="<?php echo get_the_title($prev_post->ID ); ?>"><i class="fa fa-angle-left"></i><?php esc_html_e('Prev','citybook-add-ons' );?><span class="clearfix"><?php echo get_the_title($prev_post->ID ); ?></span></a>
    <?php 
    endif ; ?>
<?php
    if ( is_a( $next_post, 'WP_Post' ) ) :
    ?>
    <a href="<?php echo get_permalink( $next_post->ID ); ?>" class="post-link next-post-link" title="<?php echo get_the_title($next_post->ID ); ?>"><i class="fa fa-angle-right"></i><?php esc_html_e('Next','citybook-add-ons' );?><span class="clearfix"><?php echo get_the_title($next_post->ID ); ?></span></a>
    <?php 
    endif ; ?>
</div>
<?php
    endif;
}


