<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



function citybook_addons_get_average_ratings($postID) {
    $rating_average = get_post_meta($postID, P_META_PREFIX.'rating_average', true);
    if( empty($rating_average)){
        return false;
    }else{
        return array( 
            'count'=> get_post_meta($postID, P_META_PREFIX.'rating_count', true),
            'rating'=> $rating_average 
        );
    }
}


function citybook_addons_get_average_ratings_old($postID) {
    $comment_array = get_approved_comments($postID);
    // $count = 1;

    // $return = array();
 
    if ($comment_array) {
        $i = 0;
        $total = 0;
        foreach($comment_array as $comment){
            $rate = get_comment_meta($comment->comment_ID, 'rating');
            if(isset($rate[0]) && $rate[0] !== '') {
                $i++;
                $total += $rate[0];
            }
        }
 
        if($i == 0)
            return false;
        else
            return array( 'count'=>$i,'rating'=>round($total/$i, 1, PHP_ROUND_HALF_UP) );
    } else {
        return false;
    }
}



// http://oscardias.com/development/php/wordpress/how-to-add-a-rate-field-to-wordpress-comments/
add_action('comment_post','citybook_addons_comment_ratings', 10, 2);
 
function citybook_addons_comment_ratings($comment_id, $approved) {
    if(isset($_POST['rating'])) add_comment_meta($comment_id, 'rating', $_POST['rating']);
    // allow comment images
    $comment_post_ID = 0;
    $comment = get_comment($comment_id);
    if( citybook_addons_get_option('allow_rating_imgs') == 'yes' ){
        if(!empty($comment)){
            $comment_post_ID = $comment->comment_post_ID;
        }
        $images = citybook_addons_handle_image_multiple_upload( 'rating_imgs', $comment_post_ID);
        if( !empty( $images ) ) add_comment_meta($comment_id, 'rating_imgs', $images );
    }
    if( !empty($comment) && $approved === 1){
        citybook_addons_comment_unapproved_to_approved($comment);
    }

}

// update listing rating for sort
add_action( 'comment_unapproved_to_approved', 'citybook_addons_comment_unapproved_to_approved' );
function citybook_addons_comment_unapproved_to_approved($comment){
    $rated = get_comment_meta($comment->comment_ID, 'rating', true);
    if(!empty($rated) && is_numeric($rated)){
        $postID = $comment->comment_post_ID;

        $rating_key = P_META_PREFIX.'rating_average';
        $count_key = P_META_PREFIX.'rating_count';
        $rating_average = get_post_meta($postID, $rating_key, true);
        if($rating_average == ''){
            update_post_meta($postID, $rating_key, $rated);
            update_post_meta($postID, $count_key, 1);
        }else{
            $rating_count = get_post_meta($postID, $count_key, true);
            $rating_average = ($rating_average * $rating_count + $rated)/($rating_count+1);
            update_post_meta($postID, $rating_key, round($rating_average, 1, PHP_ROUND_HALF_UP) );
            update_post_meta($postID, $count_key, $rating_count+1);
        }

    }
}
add_action( 'comment_approved_to_unapproved', 'citybook_addons_comment_approved_to_unapproved' );
function citybook_addons_comment_approved_to_unapproved($comment){
    $rated = get_comment_meta($comment->comment_ID, 'rating', true);
    if(!empty($rated) && is_numeric($rated)){
        $postID = $comment->comment_post_ID;

        $rating_key = P_META_PREFIX.'rating_average';
        $count_key = P_META_PREFIX.'rating_count';
        $rating_average = get_post_meta($postID, $rating_key, true);
        if($rating_average == ''){
            update_post_meta($postID, $rating_key, 0);
            update_post_meta($postID, $count_key, 0);
        }else{
            $rating_count = get_post_meta($postID, $count_key, true);
            if($rating_count > 1){
                $rating_average = ($rating_average * $rating_count - $rated)/($rating_count-1);
            }else{
                $rating_average = 0;
                $rating_count = 1;
            }
            
            update_post_meta($postID, $rating_key, round($rating_average, 1, PHP_ROUND_HALF_UP));
            update_post_meta($postID, $count_key, $rating_count-1);
        }

    }
}
// delete comment
add_action( 'delete_comment', function($comment_ID, $comment){
    citybook_addons_comment_approved_to_unapproved( $comment );
}, 10, 2 );


// modify comment template for listing post
add_filter( 'comments_template', function ( $template ) {
    $queried_object = get_queried_object();
    if (isset($queried_object->post_type) && $queried_object->post_type == 'listing') {
        return CITYBOOK_ADD_ONS_DIR .'inc/comments.php';
    }
    return $template;
});

function citybook_addons_move_comment_field_to_bottom( $fields ) {
    $queried_object = get_queried_object();
    if (isset($queried_object->post_type) && $queried_object->post_type == 'listing') {
        $comment_field = $fields['comment'];
        unset( $fields['comment'] );
        $fields['comment'] = $comment_field;
        return $fields;
    }
    return $fields;
}
 
add_filter( 'comment_form_fields', 'citybook_addons_move_comment_field_to_bottom' );

function citybook_addons_change_submit_button( $submit_button ) {
    $queried_object = get_queried_object();
    if (isset($queried_object->post_type) && $queried_object->post_type == 'listing') {
        return '<button class="btn big-btn color-bg flat-btn" type="submit">'.__( 'Submit Review <i class="fa fa-paper-plane-o" aria-hidden="true"></i>', 'citybook-add-ons' ).'</button>';
    }
    return $submit_button;
}
 
add_filter( 'comment_form_submit_button', 'citybook_addons_change_submit_button');

function citybook_addons_comment_rating_field(){
    
    if(!citybook_addons_get_option('single_show_rating')) return;
    $queried_object = get_queried_object();
    if (isset($queried_object->post_type) && $queried_object->post_type == 'listing') {
    ?>
    <div class="leave-rating-wrap clearfix">
        <span class="leave-rating-title"><?php _e( 'Your rating  for this listing : ', 'citybook-add-ons' ); ?></span>
        <?php 
        $rating_base = (int)citybook_addons_get_option('rating_base'); 
        if($rating_base): ?>
        <div class="leave-rating">
        <?php
            for ($i=$rating_base; $i > 0; $i--) { 
                ?>
                <input type="radio" name="rating" id="rating-<?php echo $i; ?>" value="<?php echo $i; ?>"/>
                <label for="rating-<?php echo $i; ?>" class="fa fa-star-o"></label>
                <?php
            }
            ?>
        </div>
        <?php 
        endif;
        ?>
    </div>
    <?php if( citybook_addons_get_option('allow_rating_imgs') == 'yes' ): ?>
    <div class="leave-rating-imgs-wrap clearfix">
        <?php 
            citybook_addons_get_template_part( 'template-parts/images-upload', false, array( 'is_single'=>false, 'name'=>'rating_imgs[]', 'desc_text' => __( '<i class="fa fa-picture-o"></i> Rating images', 'citybook-add-ons' ) ) );
        ?>
    </div>
    <?php endif; ?>
    <?php
    }
}

add_action('comment_form_before_fields','citybook_addons_comment_rating_field');
add_action('comment_form_logged_in_after','citybook_addons_comment_rating_field');



/**
 * Custom comments list
 *
 * @since CityBook 1.0
 */
if (!function_exists('citybook_addons_comments')) {
    function citybook_addons_comments($comment, $args, $depth) {
        $GLOBALS['comment'] = $comment;
        extract($args, EXTR_SKIP);
        
        if ('div' == $args['style']) {
            $tag = 'div';
            $add_below = 'comment';
        } 
        else {
            $tag = 'li';
            $add_below = 'div-comment';
        }
?>
        <<?php
        echo esc_attr($tag); ?> <?php
        comment_class(empty($args['has_children']) ? 'reviews-comments-item comment-nochild' : 'reviews-comments-item comment-haschild') ?> id="comment-<?php
        comment_ID() ?>">
        <?php
        if ('div' != $args['style']): ?>
        <div id="div-comment-<?php
            comment_ID() ?>" class="comment-body thecomment">
        <?php
        endif; ?>

            <div class="review-comments-avatar">
                <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, $args['avatar_size'], 'https://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s='.$args['avatar_size'], get_comment_author( $comment->comment_ID )); ?>
            </div>
            <div class="reviews-comments-item-text">
                <h4><?php echo get_comment_author_link($comment->comment_ID); ?>
                <?php
                if(is_singular() && $comment->comment_post_ID != get_the_ID()) { 
                    echo esc_html__( ' on ', 'citybook-add-ons' ) . sprintf( '<a href="%1$s" class="reviews-comments-item-link">%2$s</a> ',
                                                        esc_url( get_the_permalink( $comment->comment_post_ID ) ),
                                                        esc_html( get_the_title( $comment->comment_post_ID ) )
                                                    );
                }
                ?>

                </h4>
                <?php 
                $rating = get_comment_meta( $comment->comment_ID, 'rating', true );
                if(citybook_addons_get_option('single_show_rating') && $rating):
                ?>
                <div class="listing-rating card-popup-rainingvis" data-rating="<?php echo esc_attr($rating);?>" data-stars="<?php echo esc_attr( citybook_addons_get_option('rating_base') ); ?>"></div>
                <?php 
                endif;?>
                <div class="clearfix"></div>
                <?php comment_text(); ?>
                <?php 
                $rating_imgs = get_comment_meta( $comment->comment_ID, 'rating_imgs', true );
                if(citybook_addons_get_option('allow_rating_imgs') == 'yes' && !empty($rating_imgs)):
                ?>
                <div class="leave-rating-imgs clearfix lightgallery rating-imgs-<?php echo citybook_addons_get_option('submit_media_limit', 3); ?>">
                    <?php 
                    foreach ( (array)$rating_imgs as $id => $url) {
                        ?>
                        <div class="rating-img">
                            <a class="popup-image" href="<?php echo wp_get_attachment_url( $id ); ?>">
                                <?php echo wp_get_attachment_image( $id, 'thumbnail', false, array('class'=>'resp-img') ); ?>
                            </a>
                        </div>
                        <?php
                    }
                    ?>
                </div>
                <?php 
                endif;?>

                <span class="reviews-comments-item-date"><i class="fa fa-calendar-check-o"></i><?php echo get_comment_date(esc_html__('F j, Y g:i a', 'citybook-add-ons')); ?></span>
                <span class="review-item-reply"><?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?></span>
                <?php
                if ($comment->comment_approved == '0'): ?>
                        <em class="comment-awaiting-moderation alignleft"><?php
                    esc_html_e('The comment is awaiting moderation.', 'citybook-add-ons'); ?></em>
                        <br />
                    <?php
                endif; ?> 
            </div>
            


        
        <?php
        if ('div' != $args['style']): ?>
        </div> 
        <?php
        endif; ?>

    <?php
    }
}

