<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * Disable front-end builder
 */
function citybook_vc_remove_frontend_links() {
    vc_disable_frontend(); // this will disable frontend editor
}
//add_action( 'vc_after_init', 'citybook_vc_remove_frontend_links' );

/**
 * Force Visual Composer to initialize as "built into the theme". This will hide certain tabs under the Settings->Visual Composer page
 */
add_action( 'vc_before_init', 'citybook_vcSetAsTheme' );
if(!function_exists('citybook_vcSetAsTheme')){
    function citybook_vcSetAsTheme() {
        vc_set_as_theme($disable_updater = true);
    }
}

// Add new Param in Row
function citybook_add_ons_add_vc_param(){
    if(function_exists('vc_add_param')){
        vc_add_param(
            'vc_row',
            array(
                "type" => "dropdown",
                "heading" => esc_html__('CityBook Predefined Section Layout', 'citybook-add-ons'),
                "param_name" => "cth_layout",
                "value" => array(   
                                esc_html__('Default', 'citybook-add-ons') => 'default',  
                                esc_html__('CityBook Home (Fullheight) Section', 'citybook-add-ons') => 'citybook_homefullheight_sec',
                                esc_html__('CityBook Page Header Section', 'citybook-add-ons') => 'citybook_head_sec',
                                esc_html__('CityBook Page Section', 'citybook-add-ons') => 'citybook_page_sec',
                                esc_html__('CityBook Background Video', 'citybook-add-ons') => 'citybook_video_bg_sec',

                ),
                "description" => esc_html__("Select one of the pre made page sections or using default", 'citybook-add-ons'), 
                "group" => "CityBook Theme",
            ) 
        );



        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Content Width', 'citybook-add-ons'),
                                "param_name" => "is_fullwidth",
                                "value" => array(   
                                                esc_html__('Fullwidth','citybook-add-ons' ) => 'yes',  
                                                esc_html__('Wide Boxed','citybook-add-ons' ) => 'wide',  
                                                esc_html__('Small Boxed','citybook-add-ons' ) => 'no',   
                                                                                                                                
                                            ),
                                "std" => 'no',
                                

                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'citybook_homefullheight_sec','citybook_head_sec','citybook_page_sec','citybook_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "CityBook Theme",
                            ) 

        );



        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('No Padding', 'citybook-add-ons'),
                                "param_name" => "no_padding",
                                "value" => array(   
                                                esc_html__('Yes', 'citybook-add-ons') => 'yes',  
                                                esc_html__('No', 'citybook-add-ons') => 'no',   
                                                                                                                                
                                            ),
                                "std" => 'no',
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'citybook_page_sec','citybook_head_sec','citybook_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "CityBook Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Background Color', 'citybook-add-ons'),
                                "param_name" => "citybook_bg_color",
                                "value" => array(   
                                                esc_html__( 'Theme Color','citybook-add-ons' ) => 'color-bg',
                                                esc_html__( 'White Color','citybook-add-ons' ) => 'white-color-bg',
                                                esc_html__( 'Dark Color','citybook-add-ons' ) => 'dark-bg',
                                                esc_html__( 'Gray Color','citybook-add-ons' ) => 'gray-bg',
                                                esc_html__( 'Transparent Color','citybook-add-ons' ) => 'transparent-color-bg',
                                                                                                                                
                                            ),
                                "std" => 'white-color-bg',
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array( 'citybook_homefullheight_sec','citybook_head_sec','citybook_page_sec','citybook_video_bg_sec'),
                                    'not_empty' => false,
                                ),
                                "group" => "CityBook Theme",  
                            ) 

        );

        vc_add_param('vc_row',array(
                                
                                "type" => "dropdown",
                                "heading" => esc_html__('Background Video Type', 'citybook-add-ons'),
                                "param_name" => "bg_video_type",
                                "value" => array(   
                                               esc_html__('Youtube Video','citybook-add-ons' ) => 'youtube',  
                                               esc_html__('Vimeo Video','citybook-add-ons' ) => 'vimeo',  
                                               esc_html__('Hosted Video','citybook-add-ons' ) => 'hosted',  
                                                                                                                                
                                            ),
                                "std" => 'hosted',
                                

                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value' => array('citybook_video_bg_sec'),
                                    'not_empty' => false,
                                ),


                                "group" => "CityBook Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                "type" => "textfield",
                                "heading" => esc_html__('Video URL', 'citybook-add-ons'),
                                "param_name" => "bg_video",
                                "value" => "",
                                "description" => esc_html__("Enter your Youtube, Vimeo video ID or URL for hosted video.", 'citybook-add-ons'),
                                'dependency' => array(
                                    'element' => 'cth_layout',
                                    'value'     => array('citybook_video_bg_sec'),
                                    'not_empty' => false,
                                ),
                                "group" => "CityBook Theme",
                            ) 

        );

        vc_add_param('vc_row',array(
                                "type"          => "dropdown",
                                "heading"       => esc_html__('Mute', 'citybook-add-ons'),
                                "param_name"    => "bg_video_mute",
                                "value"         => array(   
                                                    esc_html__('Yes', 'citybook-add-ons') => '1',  
                                                    esc_html__('No', 'citybook-add-ons') => '0',                                                                                
                                ),
                                "std"           =>"1",
                                'dependency' => array(
                                    'element' => 'bg_video',
                                    'not_empty' => true,
                                ),


                                "group" => "CityBook Theme",  
                            )

        );

        vc_add_param('vc_row',array(
                                    "type"          => "dropdown",
                                    "heading"       => esc_html__('Loop', 'citybook-add-ons'),
                                    "param_name"    => "bg_video_loop",
                                    "value"         => array(   
                                                        esc_html__('Yes', 'citybook-add-ons') => '1',  
                                                        esc_html__('No', 'citybook-add-ons') => '0',                                                                                
                                    ),
                                    "std"           =>"1",
                                    'dependency' => array(
                                        'element' => 'bg_video',
                                        'not_empty' => true,
                                    ),


                                    "group" => "CityBook Theme",  
                                )

        );

        vc_add_param('vc_row',array(
                                    "type" => "attach_image",
                                    "heading" => esc_html__('Parallax Background Image', 'citybook-add-ons'),
                                    "param_name" => "parallax_inner",
                                    'dependency' => array(
                                        'element' => 'cth_layout',
                                        'value' => array('citybook_homefullheight_sec','citybook_head_sec', 'citybook_page_sec','citybook_video_bg_sec'),
                                        'not_empty' => false,
                                    ),
                                    "group" => "CityBook Theme",
                                )

        );


        vc_add_param('vc_row', array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__( 'Overlay Background Color', 'citybook-add-ons' ),
                        'param_name' => 'overlay_color',
                        'value'=>'rgba(0,0,0,1)',
                        'description' => esc_html__( 'Select custom background color color.', 'citybook-add-ons' ),
                        'dependency' => array(
                            'element' => 'parallax_inner',
                            'not_empty' => true,
                        ),

                        "group" => "CityBook Theme",
            )
        );

        vc_add_param('vc_row',array(
                                "type" => "textfield",
                                "heading" => esc_html__('Background Parallax Value', 'citybook-add-ons'),
                                "param_name" => "parallax_inner_val",
                                "value" => "",
                                "description" => esc_html__("Parallax CSS style values, separated by comma. Ex: 'translateX': '50px','translateY': '250px' ", 'citybook-add-ons').'<a href="'.esc_url('https://github.com/iprodev/Scrollax.js/blob/master/docs/Markup.md' ).'" target="_blank">'.esc_html__('Scrollax Documentation','citybook-add-ons' ).'</a>',
                                'dependency' => array(
                                    'element' => 'parallax_inner',
                                    'not_empty' => true,
                                ),
                                "group" => "CityBook Theme",
                            ) 

        );

        

    }
}

add_action('init','citybook_add_ons_add_vc_param' );