<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



/* cmb2 dependency field */
function citybook_cmb2_admin_scripts() {
    // Adding custom admin scripts file
    wp_enqueue_script( 'citybook_cmb2_admin', CITYBOOK_ADD_ONS_DIR_URL . 'inc/assets/depends_cmb2.js', array( 'jquery' ));

    // Registering and adding custom admin css
    wp_register_style( 'citybook_cmb2_admin', CITYBOOK_ADD_ONS_DIR_URL . 'inc/assets/depends_cmb2.css', false, '1.0.0' );
    wp_enqueue_style( 'citybook_cmb2_admin' ); 
}

add_action( 'admin_enqueue_scripts', 'citybook_cmb2_admin_scripts' );





add_action( 'cmb2_admin_init', 'citybook_cmb2_sample_metaboxes' );
/**
 * Define the metabox and field configurations.
 */
function citybook_cmb2_sample_metaboxes() {

    // Start with an underscore to hide fields from custom fields list
    $prefix = '_cth_';

    /**
     * Initiate Post metabox
     */
    $post_cmb = new_cmb2_box( array(
        'id'            => 'post_options',
        'title'         => esc_html__( 'Post Format Options', 'citybook-add-ons' ),
        'object_types'  => array( 'post'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $post_cmb->add_field( array(
        'name' => esc_html__('Post Slider and Gallery Images', 'citybook-add-ons' ),
        'id'   => $prefix . 'post_slider_images',
        'type' => 'file_list',
        'preview_size' => array( 150, 150 ), // Default: array( 50, 50 )
    ) );

    $post_cmb->add_field( array(
        'name' => esc_html__('Gallery Columns', 'citybook-add-ons' ),
        'desc' => esc_html__('For Gallery post format only.','citybook-add-ons'),
        'id'   => $prefix . 'gallery_cols',
        'type'    => 'select',
        'default'=>'three',
        'options' => array(
            'one' => esc_html__( 'One column', 'citybook-add-ons' ),
            'two'   => esc_html__( 'Two columns', 'citybook-add-ons' ),
            'three'   => esc_html__( 'Three columns', 'citybook-add-ons' ),
            'four'   => esc_html__( 'Four columns', 'citybook-add-ons' ),
            'five'   => esc_html__( 'Five columns', 'citybook-add-ons' ),
            
        ),
    ) );

    $post_cmb->add_field( array(
        'name'       => esc_html__('oEmbed for Post Format', 'citybook-add-ons' ),
        'desc'       => wp_kses(__('Enter a youtube, twitter, or instagram URL. Supports services listed at <a href="http://codex.wordpress.org/Embeds">http://codex.wordpress.org/Embeds</a>.', 'citybook-add-ons' ),array('a'=>array('href'=>array()))),
        'id'   => $prefix . 'embed_video',
        'type' => 'oembed',
    ) );

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Initiate Post metabox 2
     */
    $post2_cmb = new_cmb2_box( array(
        'id'            => 'post_layout_options',
        'title'         => esc_html__( 'Post Layout Options', 'citybook-add-ons' ),
        'object_types'  => array( 'post'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

   

    $post2_cmb->add_field( array(
        'name' => esc_html__('Show Post Header', 'citybook-add-ons' ),
        'id'   => $prefix . 'show_page_header',
        'type'    => 'radio_inline',
        'default'=>'yes',
        'options' => array(
            'yes' => esc_html__( 'Yes', 'citybook-add-ons' ),
            'no'   => esc_html__( 'No', 'citybook-add-ons' ),
            
        ),
    ) );

    $post2_cmb->add_field( array(
        'name' => esc_html__('Header Image Background', 'citybook-add-ons' ),
        'id'   => $prefix . 'page_header_bg',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
            
        ),
    ) );

    $post2_cmb->add_field( array(
        'name' => esc_html__('Show Post Title in header', 'citybook-add-ons' ),
        'id'   => $prefix . 'show_page_title',
        'type'    => 'radio_inline',
        'default'=>'yes',
        'options' => array(
            'yes' => esc_html__( 'Yes', 'citybook-add-ons' ),
            'no'   => esc_html__( 'No', 'citybook-add-ons' ),
            
        ),
    ) );



    // $post2_cmb->add_field( array(
    //     'name' => esc_html__('Header Subtitle', 'citybook-add-ons' ),
    //     'id'   => $prefix . 'page_header_sub',
    //     'type' => 'text'
    // ) );

    $post2_cmb->add_field( array(
        'name' => esc_html__('Header Additional Info', 'citybook-add-ons' ),
        'id'   => $prefix . 'page_header_intro',
        'type' => 'textarea_small'
    ) );



////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Initiate Post featured
     */
    $post3_cmb = new_cmb2_box( array(
        'id'            => 'post_featured_options',
        'title'         => esc_html__( 'Featured', 'citybook-add-ons' ),
        'object_types'  => array( 'post'), // Post type
        'context'       => 'side',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $post3_cmb->add_field( array(
        'name' => esc_html__( 'Is Featured post', 'citybook-add-ons' ),
        'id' => $prefix . 'is_featured',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => 'no',
        'options'          => array(
            'no' => esc_html__( 'No', 'citybook-add-ons' ),
            'yes' => esc_html__( 'Yes', 'citybook-add-ons' ),
        ),
    ) );


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Initiate Portfolio metabox
     */
    // $listing_media_cmb = new_cmb2_box( array(
    //     'id'            => 'listing_contacts',
    //     'title'         => esc_html__('Media', 'citybook-add-ons' ),
    //     'object_types'  => array( 'listing'), // Post type
    //     'context'       => 'normal',// normal, side and advanced
    //     'priority'      => 'high',// default, high and low - core
    //     'show_names'    => true, // Show field names on the left
    // ) );
    // $listing_media_cmb->add_field( array(
    //     'name' => 'Images',
    //     'desc' => '',
    //     'id'   => $prefix . 'headerimgs',
    //     'type' => 'file_list', // https://github.com/CMB2/CMB2/wiki/Field-Types#file_list
    //     // 'preview_size' => array( 100, 100 ), // Default: array( 50, 50 )
    //     'query_args' => array( 'type' => 'image' ), // Only images attachment
    //     // Optional, override default text strings
    //     // 'text' => array(
    //     //     'add_upload_files_text' => 'Replacement', // default: "Add or Upload Files"
    //     //     'remove_image_text' => 'Replacement', // default: "Remove Image"
    //     //     'file_text' => 'Replacement', // default: "File:"
    //     //     'file_download_text' => 'Replacement', // default: "Download"
    //     //     'remove_text' => 'Replacement', // default: "Remove"
    //     // ),
    // ) );

    
/////////////////////////////////////////////

    /**
     * Initiate Plan metabox
     */
    $plan_sub_cmb = new_cmb2_box( array(
        'id'            => 'lplan_submit_fields',
        'title'         => esc_html__('Show/Hide Submit Fields', 'citybook-add-ons' ),
        'object_types'  => array( 'lplan'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $plan_sub_cmb->add_field( array(
        'name'          => __('Hide Tags', 'citybook-add-ons'),
        'desc'          => __('Check this to hide <strong>Tags</strong> field on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_tags',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Header Background Image type', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide header <strong>Background Image</strong> type on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_head_background',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Header Carousel type', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide header <strong>Carousel</strong> type on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_head_carousel',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Header Video Background type', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide header <strong>Video Background</strong> type on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_head_video',
        'type'          => 'checkbox'
    ) );

    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Promo Video', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Promo Video</strong> option on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_content_video',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Thumbnails Gallery', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Thumbnails Gallery</strong> option on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_content_gallery',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Slider', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Slider</strong> option on submit page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_content_slider',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Price Options', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Price Options</strong> option on submit/listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_price_opt',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide FAQs', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Frequently Asked Questions</strong> option on submit/listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_faqs_opt',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Event Counter', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Event Counter</strong> option on submit/listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_counter_opt',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Working Hours', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Working Hours</strong> option on submit/listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_workinghours_opt',
        'type'          => 'checkbox'
    ) );
    $plan_sub_cmb->add_field( array(
        'name'          => esc_html__('Hide Socials', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Socials</strong> option on submit/listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_socials_opt',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb = new_cmb2_box( array(
        'id'            => 'lplan_single_fields',
        'title'         => esc_html__('Show/Hide Single Content', 'citybook-add-ons' ),
        'object_types'  => array( 'lplan'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    // for listing single view
    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Contact Details', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Contact Details</strong> on header/location widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_contacts_info',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Author Info', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide listing author info on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_author_info',
        'type'          => 'checkbox'
    ) );

    // single widgets
    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Working Hours', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Working Hours</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_wkhour_widget',
        'type'          => 'checkbox'
    ) );
    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Event Counter', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Event Counter</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_counter_widget',
        'type'          => 'checkbox'
    ) );
    
    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Price Range', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Price Range</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_pricerange_widget',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Booking Form', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Booking Form</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_booking_form_widget',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Weather', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Weather</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_weather_widget',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Additional Features', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Additional Features</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_addfeatures_widget',
        'type'          => 'checkbox'
    ) );
    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Location / Contacts', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Location / Contacts</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_contacts_widget',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide Listing Author', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>Listing Author</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_author_widget',
        'type'          => 'checkbox'
    ) );

    $plan_single_cmb->add_field( array(
        'name'          => esc_html__('Hide More from Author', 'citybook-add-ons' ),
        'desc'          => __('Check this to hide <strong>More from Author</strong> widget on listing page.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'hide_moreauthor_widget',
        'type'          => 'checkbox'
    ) );

///////////////////////////////////////////// 
    /**
     * Initiate Plan metabox
     */
    $plan_cmb = new_cmb2_box( array(
        'id'            => 'lplan_fields',
        'title'         => esc_html__('Plan Options', 'citybook-add-ons' ),
        'object_types'  => array( 'lplan'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Subtitle', 'citybook-add-ons' ),
        // 'desc'          => esc_html__('', 'citybook-add-ons' ),
        'default'       => '',
        'id'            => $prefix . 'subtitle',
        'type'          => 'text'
    ) );
    

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Price', 'citybook-add-ons' ),
        'desc'          => esc_html__('Value 0 for free.', 'citybook-add-ons' ),
        'default'       => '49',
        'id'            => $prefix . 'price',
        'type'          => 'text_small',
        // 'before_field'  => '$',
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__( 'Period', 'citybook-add-ons' ),
        'desc'          => esc_html__( 'Expired period', 'citybook-add-ons' ),
        'id'            => $prefix . 'period',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => 'month',
        'options'       => citybook_add_ons_get_subscription_duration_units(),

        // array(
        //     // 'hour'          => esc_html__( 'Hour', 'citybook-add-ons' ),
        //     'day'           => esc_html__( 'Days', 'citybook-add-ons' ),
        //     'week'          => esc_html__( 'Weeks', 'citybook-add-ons' ),
        //     'month'         => esc_html__( 'Months', 'citybook-add-ons' ),
        //     'year'          => esc_html__( 'Years', 'citybook-add-ons' ),
        // ),
        
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Interval', 'citybook-add-ons' ),
        'desc'          => esc_html__('Numbers of PERIOD value which listing will be expired', 'citybook-add-ons' ),
        'default'       => '1',
        'id'            => $prefix . 'interval',
        'type'          => 'text_small'
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('No Expire', 'citybook-add-ons' ),
        'desc'          => esc_html__('Check this if subscription never expire.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'lnever_expire',
        'type'          => 'checkbox'
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Listing Submission Limit', 'citybook-add-ons' ),
        'desc'          => esc_html__('Numbers of listing who subscribe for this plan can submit.', 'citybook-add-ons' ),
        'default'       => '1',
        'id'            => $prefix . 'llimit',
        'type'          => 'text_small'
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Unlimited Listing Submission', 'citybook-add-ons' ),
        'desc'          => esc_html__('Check this if this plan has unlimited listing submission.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'lunlimited',
        'type'          => 'checkbox'
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Featured Listings', 'citybook-add-ons' ),
        'desc'          => esc_html__('Numbers of featured listings for this plan.', 'citybook-add-ons' ),
        'default'       => '1',
        'id'            => $prefix . 'lfeatured',
        'type'          => 'text_small'
    ) );

    $plan_cmb->add_field( array(
        'name'          => esc_html__('Is Recurring', 'citybook-add-ons' ),
        'desc'          => esc_html__('Check this if this plan required recurring payment.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'is_recurring',
        'type'          => 'checkbox'
    ) );


    

    ///////
    $plan_recurring_cmb = new_cmb2_box( array(
        'id'            => 'lplan_recurring_fields',
        'title'         => esc_html__('Recurring Options', 'citybook-add-ons' ),
        'object_types'  => array( 'lplan'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $plan_recurring_cmb->add_field( array(
        'name'          => esc_html__('Trial Interval', 'citybook-add-ons' ),
        'desc'          => esc_html__('Value O for disable.', 'citybook-add-ons' ),
        'default'       => '0',
        'id'            => $prefix . 'trial_interval',
        'type'          => 'text_small'
    ) );

    $plan_recurring_cmb->add_field( array(
        'name'          => esc_html__( 'Trial Period', 'citybook-add-ons' ),
        // 'desc'          => esc_html__( 'Trial Expired period', 'citybook-add-ons' ),
        'id'            => $prefix . 'trial_period',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => 'day',
        'options'       => citybook_add_ons_get_subscription_duration_units(),
        
    ) );

    ///////
    // $plan_woo_cmb = new_cmb2_box( array(
    //     'id'            => 'lplan_woo_fields',
    //     'title'         => esc_html__('WooCommerce Integration', 'citybook-add-ons' ),
    //     'object_types'  => array( 'lplan'), // Post type
    //     'context'       => 'normal',// normal, side and advanced
    //     'priority'      => 'high',// default, high and low - core
    //     'show_names'    => true, // Show field names on the left
    // ) );


    // $plan_woo_cmb->add_field( array(
    //     'name'          => esc_html__('Sell with WooCommerce', 'citybook-add-ons' ),
    //     'desc'          => esc_html__('Check this if you want to sell this membership package with WooCommerce payments. Currently support One-Time payment only.', 'citybook-add-ons' ),
    //     'default'       => '0',
    //     'id'            => $prefix . 'sell_with_woo',
    //     'type'          => 'checkbox'
    // ) );


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    /**
     * Initiate Page metabox
     */
    $page_cmb = new_cmb2_box( array(
        'id'            => 'des_header',
        'title'         => esc_html__('Page Layout Options - For normal page template only', 'citybook-add-ons' ),
        'object_types'  => array( 'page'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

   

    $page_cmb->add_field( array(
        'name' => esc_html__('Show Post Header', 'citybook-add-ons' ),
        'id'   => $prefix . 'show_page_header',
        'type'    => 'radio_inline',
        'default'=>'yes',
        'options' => array(
            'yes' => esc_html__( 'Yes', 'citybook-add-ons' ),
            'no'   => esc_html__( 'No', 'citybook-add-ons' ),
            
        ),
    ) );

    $page_cmb->add_field( array(
        'name' => esc_html__('Header Image Background', 'citybook-add-ons' ),
        'id'   => $prefix . 'page_header_bg',
        'type'    => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
            
        ),
    ) );

    $page_cmb->add_field( array(
        'name' => esc_html__('Show Post Title in header', 'citybook-add-ons' ),
        'id'   => $prefix . 'show_page_title',
        'type'    => 'radio_inline',
        'default'=>'yes',
        'options' => array(
            'yes' => esc_html__( 'Yes', 'citybook-add-ons' ),
            'no'   => esc_html__( 'No', 'citybook-add-ons' ),
            
        ),
    ) );


    $page_cmb->add_field( array(
        'name' => esc_html__('Header Additional Info', 'citybook-add-ons' ),
        'id'   => $prefix . 'page_header_intro',
        'type' => 'textarea_small'
    ) );

    

//////////////////////////////////////////////////////////////////////////////////////


    $member_cmb2 = new_cmb2_box( array(
        'id'            => 'member_additional_mtb',
        'title'         => esc_html__('Social Links', 'citybook-add-ons' ),
        'object_types'  => array( 'member'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );


    $member_cmb2->add_field( array(
        'name' => esc_html__( 'Facebook URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'facebookurl',
        'type' => 'text_url',
    ) );

    $member_cmb2->add_field( array(
        'name' => esc_html__( 'Twitter URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'twitterurl',
        'type' => 'text_url',
    ) );
    $member_cmb2->add_field( array(
        'name' => esc_html__( 'Google+ URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'googleplusurl',
        'type' => 'text_url',
    ) );
    $member_cmb2->add_field( array(
       'name' => esc_html__( 'Linkedin URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'linkedinurl',
        'type' => 'text_url',
    ) );
    $member_cmb2->add_field( array(
       'name' => esc_html__( 'Instagram URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'instagramurl',
        'type' => 'text_url',
    ) );
    $member_cmb2->add_field( array(
       'name' => esc_html__( 'Tumblr URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'tumblrurl',
        'type' => 'text_url',
    ) );

    $member_cmb2->add_field( array(
       'name' => esc_html__( 'Behance URL', 'citybook-add-ons' ),
        'id'   => $prefix . 'behanceurl',
        'type' => 'text_url',
    ) );


    /**
     * Initiate Resumes metabox
     */
    $resume_cmb = new_cmb2_box( array(
        'id'            => 'resumes_mtb',
        'title'         => esc_html__('Resume Options', 'citybook-add-ons' ),
        'object_types'  => array( 'cth_resume'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $resume_cmb->add_field( array(
        'name' => esc_html__( 'Resume Date', 'citybook-add-ons' ),
        'id' => $prefix . 'resume_date',
        'type'             => 'text',
        'default'          => '2017',
    ) );

    /**
     * Initiate Testimonials metabox
     */
    $testim_cmb = new_cmb2_box( array(
        'id'            => 'testimonial_mtb',
        'title'         => esc_html__('Testimonial Meta Options', 'citybook-add-ons' ),
        'object_types'  => array( 'cth_testimonial'), // Post type
        'context'       => 'normal',// normal, side and advanced
        'priority'      => 'high',// default, high and low - core
        'show_names'    => true, // Show field names on the left
    ) );

    $testim_cmb->add_field( array(
        'name' => esc_html__( 'Rating Stars', 'citybook-add-ons' ),
       
        'id' => $prefix . 'testim_rate',
        'type'             => 'select',
        'show_option_none' => false,
        'default'          => 'five',
        'options' => array(
            'no' => esc_html__( 'Not Rate', 'citybook-add-ons' ),
            '1' => esc_html__( '1 Star', 'citybook-add-ons' ),
            '1.5' => esc_html__( '1.5 Stars', 'citybook-add-ons' ),
            '2' => esc_html__( '2 Stars', 'citybook-add-ons' ),
            '2.5' => esc_html__( '2.5 Stars', 'citybook-add-ons' ),
            '3' => esc_html__( '3 Stars', 'citybook-add-ons' ),
            '3.5' => esc_html__( '3.5 Stars', 'citybook-add-ons' ),
            '4' => esc_html__( '4 Stars', 'citybook-add-ons' ),
            '4.5' => esc_html__( '4.5 Stars', 'citybook-add-ons' ),
            '5' => esc_html__( '5 Stars', 'citybook-add-ons' ),
            
        ),
    ) );


}