<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



/* tweet feeds widget action */
add_action('wp_ajax_nopriv_citybook_get_tweets', 'citybook_add_ons_get_tweets_callback');
add_action('wp_ajax_citybook_get_tweets', 'citybook_add_ons_get_tweets_callback');

require_once( CITYBOOK_ADD_ONS_DIR . "inc/twitter-api/twitteroauth/twitteroauth.php");
/**
 * Gets connection with user Twitter account
 * @param  String $cons_key     Consumer Key
 * @param  String $cons_secret  Consumer Secret Key
 * @param  String $oauth_token  Access Token
 * @param  String $oauth_secret Access Secrete Token
 * @return Object               Twitter Session
 */
function citybook_add_ons_getConnectionWithToken($cons_key, $cons_secret, $oauth_token, $oauth_secret)
{
    $connection = new CTH_TwitterOAuth($cons_key, $cons_secret, $oauth_token, $oauth_secret);
  
    return $connection;
}

function citybook_add_ons_get_tweets_callback(){

    
    // Cache Settings
    define('CACHE_ENABLED', false);
    define('CACHE_LIFETIME', 3600); // in seconds
    define('HASH_SALT', md5(CITYBOOK_ADD_ONS_DIR."inc/twitter-api/"));

    $consumer_key = citybook_addons_get_option('consumer_key');
    $consumer_secret = citybook_addons_get_option('consumer_secret');
    $access_token = citybook_addons_get_option('access_token');
    $access_token_secret = citybook_addons_get_option('access_token_secret');

    // var_dump($consumer_key);
    // var_dump($consumer_secret);
    // var_dump($access_token);
    // var_dump($access_token_secret);

    // wp_send_json( array(
    //     'consumer_key' => $consumer_key,
    //     'consumer_secret' => $consumer_secret,
    //     'access_token' => $access_token,
    //     'access_token_secret' => $access_token_secret,
    // ) );

    // Check if keys are in place
    if ($consumer_key == '' || $consumer_secret == '' || $access_token == '' || $access_token_secret == '') {
        wp_send_json( esc_html__( 'You need a consumer key and secret keys. Get one from','citybook-add-ons' ).'<a href="'.esc_url('https://apps.twitter.com/' ).'" target="_blank">apps.twitter.com</a>' ) ;
    }

    // If count of tweets is not fall back to default setting
    $username = filter_input(INPUT_GET, 'username', FILTER_SANITIZE_SPECIAL_CHARS);
    $number = filter_input(INPUT_GET, 'count', FILTER_SANITIZE_NUMBER_INT);
    $exclude_replies = filter_input(INPUT_GET, 'exclude_replies', FILTER_SANITIZE_SPECIAL_CHARS);
    $list_slug = filter_input(INPUT_GET, 'list', FILTER_SANITIZE_SPECIAL_CHARS);
    $hashtag = filter_input(INPUT_GET, 'hashtag', FILTER_SANITIZE_SPECIAL_CHARS);
    
    
    // Connect
    $connection = citybook_add_ons_getConnectionWithToken($consumer_key, $consumer_secret, $access_token, $access_token_secret);
    
    // Get Tweets
    if (!empty($list_slug)) {
      $params = array(
          'owner_screen_name' => $username,
          'slug' => $list_slug,
          'per_page' => $number
      );

      $url = '/lists/statuses';
    } else if($hashtag) {
      $params = array(
          'count' => $number,
          'q' => '#'.$hashtag
      );

      $url = '/search/tweets';
    } else {
      $params = array(
          'count' => $number,
          'exclude_replies' => $exclude_replies,
          'screen_name' => $username
      );

      $url = '/statuses/user_timeline';
    }

    $tweets = $connection->get($url, $params);

    wp_send_json($tweets);

}
add_action('wp_ajax_nopriv_citybook_mailchimp', 'citybook_mailchimp_subscribe_callback');
add_action('wp_ajax_citybook_mailchimp', 'citybook_mailchimp_subscribe_callback');

/*
 *  @desc   Register user
*/
require_once CITYBOOK_ADD_ONS_DIR .'inc/classes/Drewm/CTHMailChimp.php';
function citybook_mailchimp_subscribe_callback() {
    $output = array();
    $output['success'] = 'no';



    if ( ! isset( $_POST['_nonce'] ) || ! wp_verify_nonce( $_POST['_nonce'], 'citybook_mailchimp' ) ){
        $output['message'] = esc_html__('Sorry, your nonce did not verify.','citybook-add-ons' );
        wp_send_json( $output );
    }
    if(isset($_POST['_list_id'])&& $_POST['_list_id']){
        $list_id = $_POST['_list_id'];
    }else{
        $list_id = citybook_addons_get_option('mailchimp_list_id'); 
    }

    /*
     * ------------------------------------
     * Mailchimp Email Configuration
     * ------------------------------------
     */
    $MailChimp = new CTH_MailChimp( citybook_addons_get_option('mailchimp_api') );

    $result = $MailChimp->post("lists/$list_id/members", array(
        'email_address' => $_POST['email'],
        'status'        => 'subscribed'
    ) );

    if ($MailChimp->success()) {
        $output['success'] = 'yes';
        $output['message'] = esc_html__('Almost finished. Please check your email and verify.','citybook-add-ons' );
        $output['last_response'] = $MailChimp->getLastResponse();
    } else {
        $output['message'] = esc_html__('Oops. Something went wrong!','citybook-add-ons' );
        $output['last_response'] = $MailChimp->getLastResponse();
    }

    wp_send_json( $output );
}

add_action('wp_ajax_nopriv_citybook_get_vc_attach_images', 'citybook_get_vc_attach_images_callback');
add_action('wp_ajax_citybook_get_vc_attach_images', 'citybook_get_vc_attach_images_callback');

function citybook_get_vc_attach_images_callback() {
    $images = $_POST['images'];
    $html = $images;
    if($images != '') {
        $images = explode(",", $images);
        if(count($images)){
            $html = '';
            foreach ($images as $key => $img) {
                $html .= wp_get_attachment_image( $img, 'thumbnail', '', array('class'=>'citybook-ele-attach-thumb') );
            }
        }
    }
    wp_send_json($html );
}


/* Login Ajax Action */
add_action( 'wp_ajax_nopriv_citybook-login', 'citybook_addons_login_callback' );
add_action( 'wp_ajax_citybook-login', 'citybook_addons_login_callback' );
/*
 *  @desc   Process theme login
 */
function citybook_addons_login_callback() {

    $json = array(
        'success' => false,
        'data' => array(
            '_POST'=>$_POST
        )
    );

    // wp_send_json($json );

    // verify google reCAPTCHA
    if( citybook_addons_verify_recaptcha() === false ){
        $json['success'] = false;
        $json['data']['login_err'] = esc_html__( 'reCAPTCHA failed, please try again.', 'citybook-add-ons' ) ;
    }

    $nonce = $_POST['_loginnonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-login' ) ){
        $json['success'] = false;
        $json['data']['login_err'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }
    // https://codex.wordpress.org/Function_Reference/wp_signon
    // NOTE: If you don't provide $credentials, wp_signon uses the $_POST variable (the keys being "log", "pwd" and "rememberme").
    
    // set the WP login cookie
    $secure_cookie = is_ssl() ? true : false;
    $user = wp_signon( NULL, $secure_cookie );

    if ( is_wp_error($user) ) {
        $json['success'] = false;
        $json['data']['login_err'] = $user->get_error_message();
    } else {
        $json['success'] = true;
        // $json['data']['citybook_addons_do_wp_mail'] =  citybook_addons_do_wp_mail( 'cththemes@gmail.com', 'User Login', 'There is an user login success');
        
        do_action( 'citybook_addons_user_login' );
        // citybook_addons_auto_login_new_user( $user->ID );

        $json['data']['userID'] = $user->ID;
        if( isset($_POST['redirection']) ) $json['data']['redirection'] =  esc_url($_POST['redirection']); 

        $json['data']['login_msg'] = __( 'Login success.', 'citybook-add-ons' );
    }

    wp_send_json($json );
}

add_action( 'wp_ajax_nopriv_citybook-register', 'citybook_addons_registration_callback' );
add_action( 'wp_ajax_citybook-register', 'citybook_addons_registration_callback' );

/*
 *  @desc   Register user
 */
function citybook_addons_registration_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            '_POST'=>$_POST
        )
    );

    if( get_option( 'users_can_register' ) != 1){
        $json['data']['reg_err'] = esc_html__( 'User registration feature is disabled.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    // wp_send_json($json );

    // verify google reCAPTCHA
    if( citybook_addons_verify_recaptcha() === false ){
        $json['success'] = false;
        $json['data']['reg_err'] = esc_html__( 'reCAPTCHA failed, please try again.', 'citybook-add-ons' ) ;
    }

    $nonce = $_POST['_regnonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-register' ) ){
        $json['success'] = false;
        $json['data']['reg_err'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    // check for corrent email
    if ( !is_email( $_POST['email'] ) ) {
        $json['success'] = false;
        $json['data']['reg_err'] = esc_html__( 'Invalid email address.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    $new_user_data = array(
        'user_login' => $_POST['username'],
        'first_name' => $_POST['username'],
        'user_pass'  => wp_generate_password( 12, false ), // $_POST['password'], // // When creating an user, `user_pass` is expected.
        'user_email' => $_POST['email'],
        // 'role'       => 'l_customer' //'subscriber'
    );
    if(isset($_POST['password'])){
        $new_user_data['user_pass'] = $_POST['password'];
    }

    $user_id = wp_insert_user( $new_user_data );

    //On success
    if ( ! is_wp_error( $user_id ) ) {
        $json['success'] = true;
        // echo "User created : ". $user_id;
        // send login
        if(citybook_addons_get_option('new_user_email') != 'none') wp_new_user_notification( $user_id, null, citybook_addons_get_option('new_user_email') );

        $json['data']['user_id'] = $user_id;

        if(citybook_addons_get_option('register_auto_login') == 'yes') citybook_addons_auto_login_new_user( $user_id );
        
        do_action( 'citybook_addons_register_user', $user_id, false );

        // // Set the global user object
        // $current_user = get_user_by( 'id', $user_id );

        // // set the WP login cookie
        // $secure_cookie = is_ssl() ? true : false;

        // wp_set_auth_cookie( $user_id, true, $secure_cookie ); // This function does not return a value.

        if( citybook_addons_get_option('register_no_redirect') != 'yes' && isset($_POST['redirection']) ) $json['data']['redirection'] =  esc_url($_POST['redirection']); 

        
        $json['data']['reg_msg'] = __( 'Successfully registered. Check your email address for the password.', 'citybook-add-ons' );

    }else{
        $json['success'] = false;
        $json['data']['reg_err'] = $user_id->get_error_message() ;
        $json['data']['new_user_data'] = $new_user_data ;
        // $json['data']['at_pos'] = strpos("@", $_POST['user_email']);
        // $json['data']['substr'] = substr($_POST['user_email'], 0, strpos($_POST['user_email'], "@") );

        

    }

    wp_send_json( $json );

}

// reset password callback
add_action('wp_ajax_nopriv_citybook_addons_reset_password', 'citybook_addons_reset_password_callback');
add_action('wp_ajax_citybook_addons_reset_password', 'citybook_addons_reset_password_callback');

function citybook_addons_reset_password_callback() {
    $json = array(
        'success' => false,
        'data' => array(
            'POST'=>$_POST,
        )
    );
    

    $nonce = $_POST['_nonce'];
    
    if ( ! wp_verify_nonce( $nonce, 'citybook-add-ons' ) ){
        $json['data']['error'] = esc_html__( 'Security checked!, Cheatn huh?', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if ( empty( $_POST['user_login'] ) || ! is_string( $_POST['user_login'] ) ) {
        $json['data']['error'] = esc_html__( 'Enter a username or email address.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    } elseif ( strpos( $_POST['user_login'], '@' ) ) {
        $user_data = get_user_by( 'email', trim( wp_unslash( $_POST['user_login'] ) ) );
        if ( empty( $user_data ) ){
            $json['data']['error'] = esc_html__( 'There is no user registered with that email address.', 'citybook-add-ons' ) ;
            wp_send_json($json );
        }
    } else {
        $login = trim($_POST['user_login']);
        $user_data = get_user_by('login', $login);
    }

    if ( !$user_data ) {
        $json['data']['error'] = esc_html__( 'Invalid username or email.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    // Redefining user_login ensures we return the right case in the email.
    $user_login = $user_data->user_login;
    $user_email = $user_data->user_email;
    $key = get_password_reset_key( $user_data );

    if ( is_wp_error( $key ) ) {
        $json['data']['error'] = esc_html__( 'There is something wrong. Please try again.', 'citybook-add-ons' ) ;
        wp_send_json($json );
    }

    if ( is_multisite() ) {
        $site_name = get_network()->site_name;
    } else {
        /*
         * The blogname option is escaped with esc_html on the way into the database
         * in sanitize_option we want to reverse this for the plain text arena of emails.
         */
        $site_name = wp_specialchars_decode( get_option( 'blogname' ), ENT_QUOTES );
    }

    $message = __( 'Someone has requested a password reset for the following account:','citybook-add-ons' ) . "\r\n\r\n";
    /* translators: %s: site name */
    $message .= sprintf( __( 'Site Name: %s','citybook-add-ons'), $site_name ) . "\r\n\r\n";
    /* translators: %s: user login */
    $message .= sprintf( __( 'Username: %s','citybook-add-ons'), $user_login ) . "\r\n\r\n";
    $message .= __( 'If this was a mistake, just ignore this email and nothing will happen.' ,'citybook-add-ons') . "\r\n\r\n";
    $message .= __( 'To reset your password, visit the following address:' ,'citybook-add-ons') . "\r\n\r\n";
    $message .= '<' . network_site_url( "wp-login.php?action=rp&key=$key&login=" . rawurlencode( $user_login ), 'login' ) . ">\r\n";

    /* translators: Password reset email subject. %s: Site name */
    $title = sprintf( __( '[%s] Password Reset' ,'citybook-add-ons'), $site_name );

    
    if ( $message && !wp_mail( $user_email, wp_specialchars_decode( $title ), $message ) ){
        $json['data']['error'] = esc_html__( 'The email could not be sent.', 'citybook-add-ons' ) ;
        wp_send_json($json );

    }

    $json['success'] = true;
    $json['data']['message'] = apply_filters( 'citybook_addons_reset_password_message', __( 'Your Password is reset. Check your email to complete the action.', 'citybook-add-ons' ) );



    // if(function_exists('retrieve_password')){
    //     $errors = retrieve_password();
    //     if ( !is_wp_error($errors) ) {
    //         $json['success'] = true;
    //         $json['data']['message'] = apply_filters( 'citybook_addons_reset_password_message', __( 'Please check your email to complete the action.', 'citybook-add-ons' ) );
    //     }
    // }else{
    //     $json['data']['error'] = esc_html__( 'The retrieve_password function doesn\'t exists', 'citybook-add-ons' ) ;
    // }

    wp_send_json($json );

}

function file_get_contents_stream($fn, $content_type = '') { 
    $opts = array( 
        'http' => array( 
            'method'=>"GET", 
            'header'=>"Content-Type: text/html;" 
        ) 
    ); 
    if($content_type != '') $opts['http']['header'] = "Content-Type: {$content_type};";

    $context = stream_context_create($opts); 
    $result = @file_get_contents($fn, false, $context); 
    return $result; 
}   
add_action('wp_ajax_nopriv_fetch_weather', 'citybook_addons_fetch_weather_callback');
add_action('wp_ajax_fetch_weather', 'citybook_addons_fetch_weather_callback');
function citybook_addons_fetch_weather_callback(){

        $json = array(
            'success' => false,
            'data' => array(
                'POST'=>$_POST,
            ),
        );

        

        $locale = get_locale();
        if($locale == '') $locale = 'en_US';
        $locale = strtolower($locale);
        if($locale != 'zh_cn' || $locale != 'zh_tw') $locale = preg_replace('/_.+$/m', '', trim($locale));
        
        $params = array(
            'appid'             => citybook_addons_get_option('weather_api'),
            // 'appid'                =>   'dba2268d1da306d9cd0933da05cfee06',
            // 'q'              => isset($_POST['location']) ? $_POST['location'] : '',
            // 'lat'               => '35',
            // 'lon'               => '139',
            'units'             => 'metric',
            'lang'              => $locale,
        );

        if(isset($_POST['lat']) && isset($_POST['lon'])){
            $params['lat'] = $_POST['lat'];
            $params['lon'] = $_POST['lon'];
        }else{
            $params['q'] = isset($_POST['location']) ? trim($_POST['location'], " ,") : '';
        }

        $params = http_build_query($params, null, '&', PHP_QUERY_RFC3986);

        // $weather_api = easybook_addons_get_option('weather_api');

        // $api_url = "https://api.openweathermap.org/data/2.5/weather?lat=35&lon=139&appid={$weather_api}"; // -> https://prntscr.com/m3z1hb

        $api_url = "https://api.openweathermap.org/data/2.5/forecast?{$params}"; // -> http://prntscr.com/m3z59g

        if(isset($_POST['view']) && $_POST['view'] == 'simple') $api_url = "https://api.openweathermap.org/data/2.5/weather?{$params}"; // -> https://prntscr.com/m3z1hb

        // $json['url'] = $api_url;

        $result = file_get_contents_stream($api_url, 'application/json'); // JSON - Content-Type: application/json | JSONP = Content-Type: application/javascript
        
        // if( CTH_DEBUG ) error_log(date('[Y-m-d H:i e] - '). "openweathermap - current: " . $result . PHP_EOL, 3, './openweathermap-current.log');
        // if( CTH_DEBUG ) error_log(date('[Y-m-d H:i e] - '). "openweathermap - forecast: " . $result . PHP_EOL, 3, './openweathermap-forecast.log');

        if($result === false){
            $json['error'] = __( 'Weather request error. Please make sure that your api is entered.', 'citybook-add-ons' );
        }
        else{
            $json['success'] = true;
            $json['result'] = json_decode($result);
        }

        // $json['yahoo'] = self::featch_yahoo_weather(); // current return false
        // 'success' => false,
        wp_send_json( $json );


    }   





