<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Section_Title extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'section_title';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Section Title', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'fa fa-font';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.0
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Featured Categories',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'over_title',
            [
                'label' => __( 'Overlay Title', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Catalog of Categories',
                'label_block' => true,
                // 'separator' => 'before'
                
            ]
        );

        $this->add_control(
            'show_sep',
            [
                'label' => __( 'Show Separator', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'citybook-add-ons' ),
                'label_off' => __( 'Hide', 'citybook-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __( 'Sub-Title', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '<p>Explore some of the best tips from around the city from our partners and friends.</p>',
                // 'show_label' => false,
            ]
        );

        

        

        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();
        ?>
        <div class="section-title">
            <?php if(!empty($settings['title'])) echo '<h2>'.$settings['title'].'</h2>'; ?>
            <?php 
                // var_dump(get_post_meta( 1892, '_cth_contact_infos_address', true ));
                // var_dump(get_user_meta( 1 , 'custom_avatar', true ));
                // var_dump(file_exists('C:\wamp64\www\dev_server\citybook\wp-content\plugins\citybook-add-ons/templates-inner/add-widget.php'));
                // var_dump(wp_lostpassword_url( string $redirect = 'local.ser/citybook' ));
            ?>
            <?php if(!empty($settings['over_title'])) echo '<div class="section-subtitle">'.$settings['over_title'].'</div>'; ?>
            <?php 
            if($settings['show_sep'] == 'yes') echo '<span class="section-separator"></span>'; ?>
            <?php echo $settings['sub_title'];?> 
        </div>
        <?php

    }

    protected function _content_template() {
        ?>
        <div class="section-title">
            <# if(settings.title){ #><h2>{{{settings.title}}}</h2><# } #>
            <# if(settings.over_title){ #><div class="section-subtitle">{{{settings.over_title}}}</div><# } #>
            <# if(settings.show_sep == 'yes'){ #><span class="section-separator"></span><# } #>
            {{{settings.sub_title}}}
        </div>
        <?php

    }

   
   

}

// Plugin::instance()->widgets_manager->register_widget( 'Elementor\Widget_Header_Search' );

// Plugin::$instance->elements_manager->create_element_instance

