<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Membership_Plans extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'membership_plans';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Membership Plans', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'eicon-gallery-justified';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.0
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Plans Query', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Plan IDs', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Plan ids to show, separated by a comma. Leave empty to show all.", 'citybook-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Plan IDs to Exclude', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter plan ids to exclude, separated by a comma (,). Use if the field above is empty.", 'citybook-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'citybook-add-ons'), 
                    'ID' => esc_html__('ID', 'citybook-add-ons'), 
                    'author' => esc_html__('Author', 'citybook-add-ons'), 
                    'title' => esc_html__('Title', 'citybook-add-ons'), 
                    'modified' => esc_html__('Modified', 'citybook-add-ons'),
                    'rand' => esc_html__('Random', 'citybook-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'citybook-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'citybook-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'citybook-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'citybook-add-ons'), 
                    'DESC' => esc_html__('Descending', 'citybook-add-ons'), 
                ],
                'default' => 'ASC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Plans to show', 'citybook-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '3',
                'description' => esc_html__("Number of plans to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Plans Layout', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'citybook-add-ons'), 
                    'two' => esc_html__('Two Columns', 'citybook-add-ons'), 
                    'three' => esc_html__('Three Columns', 'citybook-add-ons'), 
                    'four' => esc_html__('Four Columns', 'citybook-add-ons'), 
                    'five' => esc_html__('Five Columns', 'citybook-add-ons'), 
                    'six' => esc_html__('Six Columns', 'citybook-add-ons'), 
                    
                ],
                'default' => 'three',
                
                
            ]
        );


        $this->add_control(
            'best_price_item',
            [
                'label' => __( 'Best Price Item', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '1',
                'description' => esc_html__("Best price item number. 0 for first item. Leave empty for none.", 'citybook-add-ons'),
            ]
        );

        $this->add_control(
            'best_price_icon',
            [
                'label' => __( 'Best Price Icon', 'citybook-add-ons' ),
                'type' => Controls_Manager::ICON,
                'default' => 'fa fa-check',
                'label_block' => true,
            ]
        );
        $this->add_control(
            'best_price_text',
            [
                'label' => __( 'Best Price Recommended Text', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Recommended',
                'label_block' => true,
                
            ]
        );



        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        
        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'lplan',
                
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }




        $css_classes = array(
            'membership-plans-wrap clearfix',
            // $settings['space'].'-pad',
            $settings['columns_grid'].'-cols',
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <div class="<?php echo esc_attr($css_class );?>">
        <?php 
            $checkout_page_id = citybook_addons_get_option('checkout_page');

            $posts_query = new \WP_Query($post_args);
            if($posts_query->have_posts()) : ?>
                <?php 
                $idx = 0;
                $best_price_item = $settings['best_price_item'];
                while($posts_query->have_posts()) : $posts_query->the_post(); ?>
                    <!-- plan-item -->
                    <div class="price-item<?php if($best_price_item == $idx) echo ' best-price';?>">
                        <div class="price-head op1">
                            <h3><?php the_title(); ?></h3>
                            <?php if(get_post_meta( get_the_ID(), P_META_PREFIX.'subtitle', true ) != '') echo '<h4>'.get_post_meta( get_the_ID(), P_META_PREFIX.'subtitle', true ).'</h4>'; ?>
                        </div>
                        <div class="price-content fl-wrap">
                        <?php if( get_post_meta( get_the_ID(), P_META_PREFIX.'price', true ) ): ?>
                            <div class="price-num fl-wrap">
                                <span class="curen"><?php echo citybook_add_ons_get_currency_symbol(citybook_addons_get_option('currency','USD')); ?></span>
                                <span class="price-num-item"><?php echo get_post_meta( get_the_ID(), P_META_PREFIX.'price', true ); ?></span>
                                <div class="price-num-desc"><?php echo citybook_add_ons_get_plan_period_text( get_post_meta( get_the_ID(), P_META_PREFIX.'interval', true ), get_post_meta( get_the_ID(), P_META_PREFIX.'period', true ) ); ?></div>
                                
                            </div>
                        <?php else: ?>
                            <div class="price-num fl-wrap">
                               
                                <span class="price-num-item"><?php _e( 'Free', 'citybook-add-ons' ); ?></span>
                                <div class="price-num-desc"><?php echo citybook_add_ons_get_plan_period_text( get_post_meta( get_the_ID(), P_META_PREFIX.'interval', true ), get_post_meta( get_the_ID(), P_META_PREFIX.'period', true ) ); ?></div>
                                
                            </div>
                        <?php endif; ?>
                            <div class="price-desc fl-wrap">
                                <?php the_content(); ?>
                                    
                                <?php if(is_user_logged_in()) : ?>
                                <form action="<?php echo esc_url(get_permalink($checkout_page_id));?>" method="post">
                                    
                                    <input class="price-link" type="submit" name="lplan_select" value="<?php echo sprintf(__( 'Choose %s', 'citybook-add-ons' ), get_the_title()); ?>">
                                    <input type="hidden" name="plan_id" value="<?php echo esc_attr( get_the_ID() );?>">
                                    <input type="hidden" name="_wpnonce" value="<?php echo wp_create_nonce( 'listing-checkout' ); ?>">
                                </form>
                                <?php else : ?>
                                <a href="#" class="price-link logreg-modal-open" data-message="<?php esc_attr_e( 'You must be logged in to order a membership plan.', 'citybook-add-ons' ); ?>"><?php echo sprintf(__( 'Choose %s', 'citybook-add-ons' ), get_the_title()); ?></a>
                                <?php endif; ?>
                                <?php if($best_price_item == $idx){ ?>
                                <div class="recomm-price">
                                    <?php if($settings['best_price_icon'] !='') echo '<i class="'.$settings['best_price_icon'].'"></i>'; ?>
                                    <?php if($settings['best_price_text'] !='') echo '<span class="recomm-text">'.$settings['best_price_text'].'</span>'; ?>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <!-- plan-item end  -->

                <?php 
                $idx++;
                endwhile; ?>
            <?php endif; ?> 

        </div>
        <?php wp_reset_postdata();?>
        <?php

    }

    protected function _content_template() {}

   
    

}



