<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Members_Grid extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'members_grid';
    }

    // public function get_id() {
    //      return 'header-search';
    // }

    public function get_title() {
        return __( 'Team Members Grid', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'eicon-gallery-justified';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.0
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Members Query', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Member IDs', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Member ids to show, separated by a comma. Leave empty to show all.", 'citybook-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Member IDs to Exclude', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter member ids to exclude, separated by a comma (,). Use if the field above is empty.", 'citybook-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'citybook-add-ons'), 
                    'ID' => esc_html__('ID', 'citybook-add-ons'), 
                    'author' => esc_html__('Author', 'citybook-add-ons'), 
                    'title' => esc_html__('Title', 'citybook-add-ons'), 
                    'modified' => esc_html__('Modified', 'citybook-add-ons'),
                    'rand' => esc_html__('Random', 'citybook-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'citybook-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'citybook-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'citybook-add-ons'),
                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'citybook-add-ons'), 
                    'DESC' => esc_html__('Descending', 'citybook-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Members to show', 'citybook-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '3',
                'description' => esc_html__("Number of members to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Posts Layout', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'citybook-add-ons'), 
                    'two' => esc_html__('Two Columns', 'citybook-add-ons'), 
                    'three' => esc_html__('Three Columns', 'citybook-add-ons'), 
                    'four' => esc_html__('Four Columns', 'citybook-add-ons'), 
                    'five' => esc_html__('Five Columns', 'citybook-add-ons'), 
                    'six' => esc_html__('Six Columns', 'citybook-add-ons'), 
                    'seven' => esc_html__('Seven Columns', 'citybook-add-ons'), 
                    'eight' => esc_html__('Eight Columns', 'citybook-add-ons'), 
                    'nine' => esc_html__('Nine Columns', 'citybook-add-ons'), 
                    'ten' => esc_html__('Ten Columns', 'citybook-add-ons'), 
                ],
                'default' => 'three',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );



        $this->add_control(
            'space',
            [
                'label' => __( 'Space', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'exbig' => esc_html__('Extra Big', 'citybook-add-ons'), 
                    'mbig' => esc_html__('Bigger', 'citybook-add-ons'), 
                    'big' => esc_html__('Big', 'citybook-add-ons'), 
                    'medium' => esc_html__('Medium', 'citybook-add-ons'), 
                    'small' => esc_html__('Small', 'citybook-add-ons'), 
                    'extrasmall' => esc_html__('Extra Small', 'citybook-add-ons'), 
                    'no' => esc_html__('None', 'citybook-add-ons'), 
                    
                ],
                'default' => 'medium',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        

        $this->add_control(
            'view_all_link',
            [
                'label' => __( 'View All URL', 'citybook-add-ons' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => '',
                ],
                'show_external' => true, // Show the 'open in new tab' button.
            ]
        );


        $this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Show', 'citybook-add-ons' ),
                'label_off' => __( 'Hide', 'citybook-add-ons' ),
                'return_value' => 'yes',
            ]
        );


        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        if(is_front_page()) {
            $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        } else {
            $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        }

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'member',
                'paged' => $paged,
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }




        $css_classes = array(
            'items-grid-holder section-team',
            $settings['space'].'-pad',
            $settings['columns_grid'].'-cols',
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <div class="<?php echo esc_attr($css_class );?>">
        <?php 
            $posts_query = new \WP_Query($post_args);
            if($posts_query->have_posts()) : ?>
                <?php while($posts_query->have_posts()) : $posts_query->the_post(); ?>
                    <!-- team-item -->
                    <div id="member-<?php the_ID(); ?>" <?php post_class('items-grid-item team-box'); ?>>
                        <?php
                        if(has_post_thumbnail( )){ ?>
                        <div class="team-photo">
                        <?php the_post_thumbnail('citybook-featured-image',array('class'=>'respimg') ); ?>
                        </div>
                        <?php } ?>
                        <div class="team-info">
                            <?php
                            the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
                            ?>
                            <?php the_excerpt(); ?>
                            <ul class="team-social">
                                <?php if(get_post_meta(get_the_ID(), '_cth_twitterurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Follow on Twitter','citybook-add-ons');?>" href="<?php echo esc_url( get_post_meta(get_the_ID(), '_cth_twitterurl' ,true) ); ?>" target="_blank"><i class="fa fa-twitter"></i></a></li>
                                <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), '_cth_facebookurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Like on Facebook','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_facebookurl' ,true)); ?>" target="_blank"><i class="fa fa-facebook"></i></a></li>
                                <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), '_cth_googleplusurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Circle on Google Plus','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_googleplusurl' ,true)) ;?>" target="_blank"><i class="fa fa-google-plus"></i></a></li>
                                <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), '_cth_linkedinurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Be Friend on Linkedin','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_linkedinurl' ,true) ); ?>" target="_blank"><i class="fa fa-linkedin"></i></a></li>
                                <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), '_cth_instagramurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Follow on Instagram','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_instagramurl' ,true) ); ?>" target="_blank"><i class="fa fa-instagram"></i></a></li>
                                <?php } ?>
                                <?php if(get_post_meta(get_the_ID(), '_cth_tumblrurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('Follow on  Tumblr','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_tumblrurl' ,true) ); ?>" target="_blank"><i class="fa fa-tumblr"></i></a></li>
                                <?php } ?>  
                                <?php if(get_post_meta(get_the_ID(), '_cth_behanceurl' ,true)!=''){ ?>
                                    <li><a title="<?php esc_html_e('View Behance profile','citybook-add-ons');?>" href="<?php echo esc_url(get_post_meta(get_the_ID(), '_cth_behanceurl' ,true) ); ?>" target="_blank"><i class="fa fa-behance"></i></a></li>
                                <?php } ?>
                            </ul>
                        </div>
                    </div>
                    <!-- team-item end  -->

                <?php endwhile; ?>
            <?php endif; ?> 

        </div>
        <?php
        if($settings['show_pagination'] == 'yes') citybook_addons_custom_pagination($posts_query->max_num_pages,$range = 2, $posts_query) ;
        ?>
        <?php
            $url = $settings['view_all_link']['url'];
            $target = $settings['view_all_link']['is_external'] ? 'target="_blank"' : '';
            if($url != '') echo '<div class="all-members-link"><a href="' . $url . '" ' . $target .' class="btn big-btn circle-btn dec-btn color-bg flat-btn">'.__('View All','citybook-add-ons').'<i class="fa fa-eye"></i></a></div>';
        ?>
        <?php wp_reset_postdata();?>
        <?php

    }

    protected function _content_template() {}

   
    

}



