<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Listings_Grid extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'listings_grid';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Listings Grid', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'eicon-gallery-justified';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.10
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Listings Query', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'cat_ids',
            [
                'label' => __( 'Categories to get listings', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'loc_ids',
            [
                'label' => __( 'Locations to get listings', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_locations_hierarchy_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        


        // $this->add_control(
        //     'cat_ids',
        //     [
        //         'label' => __( 'Post Category IDs to include', 'citybook-add-ons' ),
        //         'type' => Controls_Manager::TEXT,
        //         'default' => '',
        //         'label_block' => true,
        //         'description' => __("Enter post category ids to include, separated by a comma. Leave empty to get posts from all categories.", 'citybook-add-ons')
                
        //     ]
        // );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Post IDs', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Post ids to show, separated by a comma. Leave empty to show all.", 'citybook-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Post IDs to Exclude', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter post ids to exclude, separated by a comma (,). Use if the field above is empty.", 'citybook-add-ons')
                
            ]
        );

        $this->add_control(
            'order_by',
            [
                'label' => __( 'Order by', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'date' => esc_html__('Date', 'citybook-add-ons'), 
                    'ID' => esc_html__('ID', 'citybook-add-ons'), 
                    'author' => esc_html__('Author', 'citybook-add-ons'), 
                    'title' => esc_html__('Title', 'citybook-add-ons'), 
                    'modified' => esc_html__('Modified', 'citybook-add-ons'),
                    'rand' => esc_html__('Random', 'citybook-add-ons'),
                    'comment_count' => esc_html__('Comment Count', 'citybook-add-ons'),
                    'menu_order' => esc_html__('Menu Order', 'citybook-add-ons'),
                    'post__in' => esc_html__('ID order given (post__in)', 'citybook-add-ons'),
                    'listing_featured' => esc_html__('Listing Featured', 'citybook-add-ons'),

                ],
                'default' => 'date',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'citybook-add-ons'), 
                    'DESC' => esc_html__('Descending', 'citybook-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Posts to show', 'citybook-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
                'min' => -1,
                'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Listings Layout', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __( 'Title Text', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => 'Results For : <span>All Listings</span>',
                'label_block' => true,
                
            ]
        );

        

        $this->add_control(
            'map_pos',
            [
                'label' => __( 'Map Position', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'top' => esc_html__('Top', 'citybook-add-ons'), 
                    'left' => esc_html__('Left', 'citybook-add-ons'), 
                    'right' => esc_html__('Right', 'citybook-add-ons'), 
                    'hide' => esc_html__('Hide', 'citybook-add-ons'), 
                ],
                'default' => 'right',
                'description' => esc_html__("Select Google Map position", 'citybook-add-ons'), 
            ]
        );

        $this->add_control(
            'filter_pos',
            [
                'label' => __( 'Filter Position', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'top' => esc_html__('Top', 'citybook-add-ons'), 
                    'left' => esc_html__('Left', 'citybook-add-ons'), 
                    'right' => esc_html__('Right', 'citybook-add-ons'), 
                    'left_col' => esc_html__('Column Left', 'citybook-add-ons'), 
                ],
                'default' => 'top',
                // 'condition' => [
                //     'map_pos' => ['top','hide'],
                // ],
                'description' => esc_html__("Select Listing Filter position", 'citybook-add-ons'), 
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'citybook-add-ons'), 
                    'two' => esc_html__('Two Columns', 'citybook-add-ons'), 
                    'three' => esc_html__('Three Columns', 'citybook-add-ons'), 
                    'four' => esc_html__('Four Columns', 'citybook-add-ons'), 
                    'five' => esc_html__('Five Columns', 'citybook-add-ons'), 
                    'six' => esc_html__('Six Columns', 'citybook-add-ons'), 
                ],
                'default' => 'three',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        

        // $this->add_control(
        //     'read_all_link',
        //     [
        //         'label' => __( 'Read All URL', 'citybook-add-ons' ),
        //         'type' => Controls_Manager::URL,
        //         'default' => [
        //             'url' => 'http://',
        //             'is_external' => '',
        //         ],
        //         'show_external' => true, // Show the 'open in new tab' button.
        //     ]
        // );


        $this->add_control(
            'show_pagination',
            [
                'label' => __( 'Show Pagination', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'citybook-add-ons' ),
                'label_off' => __( 'Hide', 'citybook-add-ons' ),
                'return_value' => 'yes',
            ]
        );


        


        $this->end_controls_section();

    }

    protected function render( ) {

        $settings = $this->get_settings();

        // if(is_front_page()) {
        //     $paged = (get_query_var('page')) ? get_query_var('page') : 1;
        // } else {
        //     $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
        // }

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'listing',
                'paged' => 1,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],
                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'listing',
                'paged' => 1,
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'listing',
                'paged' => 1,
                'posts_per_page'=> $settings['posts_per_page'],
                'orderby'=> $settings['order_by'],
                'order'=> $settings['order'],

                'post_status' => 'publish'
            );
        }

        $filter_args = array(
            'posts_per_page'=> $settings['posts_per_page'],
            'orderby'=> $settings['order_by'],
            'order'=> $settings['order'],
        );

        if($settings['order_by'] == 'listing_featured'){
            $post_args['meta_key'] = P_META_PREFIX.'featured';
            $post_args['orderby'] = 'meta_value_num';
            
            $filter_args['meta_key'] = P_META_PREFIX.'featured';
            $filter_args['orderby'] = 'meta_value_num';
        }



        $tax_queries = array();

        
        if(!empty($settings['cat_ids'])){
            $tax_queries[] =    array(
                                    'taxonomy' => 'listing_cat',
                                    'field'    => 'term_id',
                                    'terms'    => $settings['cat_ids'],
                                );
        }
        if(!empty($settings['loc_ids'])){
            $tax_queries[] =    array(
                                    'taxonomy' => 'listing_location',
                                    'field'    => 'term_id',
                                    'terms'    => $settings['loc_ids'],
                                );
        }

        if(!empty($tax_queries)){
            // if( count($tax_queries) > 1 ) $tax_queries['relation'] = 'AND';
            $post_args['tax_query'] = $tax_queries;
        } 

        // listing meta search
        $meta_queries = array();
        // check for membership expired
        // if(citybook_addons_get_option('membership_package_expired_hide') == 'yes'){
        //     $meta_queries['relation'] = 'OR';
        //     $meta_queries[] = array(
        //         'key'     => P_META_PREFIX.'expire_date',
        //         'value'   => current_time('mysql', 1),
        //         'compare' => '>=',
        //         'type'    => 'DATETIME',
        //     );
        //     $meta_queries[] = array(
        //         'key'     => P_META_PREFIX.'expire_date',
        //         'value'   => 'NEVER',
        //         'compare' => '=',
        //     );

        // }

        if(!empty($meta_queries)) $post_args['meta_query'] = $meta_queries;



        $css_classes = array(
            'listings-grid-wrap clearfix',
            $settings['columns_grid'].'-cols'
        );

        $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

        ?>
        <!-- carousel -->
        <div class="<?php echo esc_attr( $css_class );?>">
        <?php 
        $filter_wrap_cl = '';
        switch ($settings['map_pos']) {
            case 'left':
                $map_wrap_cl = 'listings-has-map column-map left-pos-map';
                $list_wrap_cl = 'right-list';
                $filter_wrap_cl = 'right-filter';
                break;
            case 'right':
                $map_wrap_cl = 'listings-has-map column-map right-pos-map';
                $list_wrap_cl = 'left-list';
                break;
            case 'top':
                $map_wrap_cl = 'listings-has-map fw-map top-post-map';
                $list_wrap_cl = 'fh-col-list-wrap left-list';
                break;
            default:
                $map_wrap_cl = 'listings-has-map column-map right-pos-map';
                $list_wrap_cl = 'fh-col-list-wrap left-list';
                break;
                }
        
        if($settings['filter_pos'] == 'left_col'){
            $map_wrap_cl .= ' map-lcol-filter';
            $list_wrap_cl .= ' list-lcol-filter';
        }
        ?>
        <?php 
        if($settings['map_pos'] != 'hide'): ?>

            <div class="map-container <?php echo esc_attr( $map_wrap_cl ); ?>">
                <?php if(citybook_addons_get_option('use_osm_map') == 'yes'): ?>
                <div id="map-osm-main"></div>
                <?php else: ?>
                <div id="map-main"></div>
                <?php endif; ?>
                <ul class="mapnavigation">
                    <li><a href="#" class="prevmap-nav"><?php esc_html_e( 'Prev', 'citybook-add-ons' ); ?></a></li>
                    <li><a href="#" class="nextmap-nav"><?php esc_html_e( 'Next', 'citybook-add-ons' ); ?></a></li>
                </ul>
            </div>
            <!-- Map end -->  
        <?php endif; ?>        
        <?php if($settings['filter_pos'] == 'left_col'): ?>
        <div class="col-filter-wrap <?php echo esc_attr( $filter_wrap_cl ); ?>">
            <div class="container">
                
                <div class="fl-wrap listing-search-sidebar listsearch-options">
                    <?php citybook_addons_get_template_part('templates/filter_form', '', $filter_args); ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <!--col-list-wrap -->   
            <div class="col-list-wrap <?php echo esc_attr( $list_wrap_cl ); ?>">
                <?php if($settings['filter_pos'] == 'top'): ?>
                <div class="listsearch-options fl-wrap" id="lisfw" >
                    <div class="container">
                        <div class="listsearch-header fl-wrap">
                            <?php if($settings['title'] != '') echo '<h1>'.$settings['title'].'</h1>'; ?>
                            
                            <div class="listing-view-layout">
                                <ul>
                                    <li><a class="grid<?php if(citybook_addons_get_option('listings_grid_layout')=='grid') echo ' active';?>" href="#"><i class="fa fa-th-large"></i></a></li>
                                    <li><a class="list<?php if(citybook_addons_get_option('listings_grid_layout')=='list') echo ' active';?>" href="#"><i class="fa fa-list-ul"></i></a></li>
                                    <?php if($settings['map_pos'] == 'left'||$settings['map_pos'] == 'right'): ?>
                                    <li><a href="#" class="expand-listing-view"><i class="fa fa-expand"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="listing-term-desc"></div>
                        <?php citybook_addons_get_template_part( 'templates/filter_form', '', $filter_args ); ?>
                    </div>
                </div>
                <?php elseif($settings['filter_pos'] == 'left_col'): ?>
                <div class="listsearch-options fl-wrap" id="lisfw">
                    <div class="container">
                        <div class="listsearch-header fl-wrap">
                            <?php if($settings['title'] != '') echo '<h1>'.$settings['title'].'</h1>'; ?>
                            
                            <div class="listing-view-layout">
                                <ul>
                                    <li><a class="grid<?php if(citybook_addons_get_option('listings_grid_layout')=='grid') echo ' active';?>" href="#"><i class="fa fa-th-large"></i></a></li>
                                    <li><a class="list<?php if(citybook_addons_get_option('listings_grid_layout')=='list') echo ' active';?>" href="#"><i class="fa fa-list-ul"></i></a></li>
                                    <?php if($settings['map_pos'] == 'left'||$settings['map_pos'] == 'right'): ?>
                                    <li><a href="#" class="expand-listing-view"><i class="fa fa-expand"></i></a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                        <div class="listing-term-desc"></div>
                    </div>
                    
                </div>
                <?php endif; ?>
                <!-- list-main-wrap-->
                <div class="list-main-wrap fl-wrap card-listing">
                    <a class="custom-scroll-link back-to-filters btf-l" href="#lisfw"><i class="fa fa-angle-double-up"></i><span><?php esc_html_e( 'Back to Filters', 'citybook-add-ons' ); ?></span></a> 
                    <div class="container"> 
                        <div class="row">
                            <?php 
                            if($settings['filter_pos'] == 'left'):?>
                            <div class="col-md-4">
                                <div class="fl-wrap listing-search-sidebar listsearch-options">
                                    <?php citybook_addons_get_template_part('templates/filter_form', '', $filter_args ); ?>
                                </div>
                            </div>
                            <?php endif;?>
                            <?php 
                            if($settings['filter_pos'] == 'left'||$settings['filter_pos'] == 'right'):?>
                            <div class="col-md-8">
                                <div class="listsearch-header fl-wrap listsearch-header-sidebar">
                                    <?php if($settings['title'] != '') echo '<h1>'.$settings['title'].'</h1>'; ?>
                                    
                                    <div class="listing-view-layout">
                                        <ul>
                                            <li><a class="grid active" href="#"><i class="fa fa-th-large"></i></a></li>
                                            <li><a class="list" href="#"><i class="fa fa-list-ul"></i></a></li>
                                            <?php if($settings['map_pos'] == 'left'||$settings['map_pos'] == 'right'): ?>
                                            <li><a href="#" class="expand-listing-view"><i class="fa fa-expand"></i></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                                <div class="listing-term-desc"></div>
                            <?php else : ?>
                            <div class="col-md-12">
                            <?php endif;?>

                                <div id="listing-items" class="listing-items clearfix">
                                <?php
                                $action_args = array(
                                    'gmap_listings' => array()
                                );
                                // https://codex.wordpress.org/Function_Reference/do_action_ref_array
                                do_action_ref_array( 'citybook_addons_elementor_listings_grid_before', array(&$action_args) );

                                $posts_query = new \WP_Query($post_args);
                                if($posts_query->have_posts()) :
                                    /* Start the Loop */
                                    while($posts_query->have_posts()) : $posts_query->the_post(); 
                                        citybook_addons_get_template_part('template-parts/listing');
                                        $action_args['gmap_listings'][] = citybook_addons_get_listing_post_data();

                                    endwhile;

                                elseif(empty($action_args['gmap_listings'])):

                                    citybook_addons_get_template_part('template-parts/search-no');

                                endif;
                                    ?>
                                </div>
                                <?php
                                if($settings['show_pagination'] == 'yes'){
                                ?>
                                <div class="listings-pagination-wrap">
                                    <?php
                                    citybook_addons_ajax_pagination($posts_query->max_num_pages,$range = 2, $posts_query);
                                    ?>
                                </div>
                                <?php
                                }
                                // end if has_posts
                                wp_localize_script( 'citybook-addons', '_citybook_add_ons_locs', $action_args['gmap_listings']);
                                // wp_localize_script( 'citybook-addons', '_citybook_add_ons_eqv', $posts_query->query_vars);

              
                                ?>
                            </div>
                            <!-- end col-md-8 -->
                            <?php 
                            if($settings['filter_pos'] == 'right'):?>
                            <div class="col-md-4">
                                <div class="fl-wrap listing-search-sidebar listsearch-options">
                                    <?php citybook_addons_get_template_part('templates/filter_form', '', $filter_args ); ?>
                                </div>
                            </div>
                            <?php endif;?>

                        </div> 
                        <!-- end row -->
                    </div>
                    <!-- end container -->
                </div>
                <!-- list-main-wrap end-->
            </div>
            <!--col-list-wrap -->  
            <!-- <div class="limit-box fl-wrap"></div> -->
        </div>
        <!--  listings-grid-wrap end-->

        <div class="limit-box fl-wrap"></div>
        
        <?php citybook_addons_get_template_part('templates/tmpls'); ?>

        <?php wp_reset_postdata();?>
        <?php

    }

    protected function _content_template() {}

   
    

}
