<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Listing_Categories extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'listing_categories';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Listing Categories', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'eicon-gallery-justified';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.10
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_query',
            [
                'label' => __( 'Categories Query', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'cat_ids',
            [
                'label' => __( 'Select Categories to include (Leave empty for ALL)', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'cat_ids_not',
            [
                'label' => __( 'Or Categories to exclude (Leave empty for ALL)', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                // 'description' => esc_html__("Select how to sort retrieved posts. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label' => __( 'Order by', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'name' => esc_html__('Name', 'citybook-add-ons'), 
                    'slug' => esc_html__('Slug', 'citybook-add-ons'), 
                    'term_group' => esc_html__('Term Group', 'citybook-add-ons'), 
                    'term_id' => esc_html__('Term ID', 'citybook-add-ons'), 
                    'description' => esc_html__('Description', 'citybook-add-ons'),
                    'parent' => esc_html__('Parent', 'citybook-add-ons'),
                    'count' => esc_html__('Term Count', 'citybook-add-ons'),
                    'include' => esc_html__('For Include above', 'citybook-add-ons'),
                ],
                'default' => 'name',
                'separator' => 'before',
                'description' => esc_html__("Select how to sort retrieved categories. More at ", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __( 'Sort Order', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'ASC' => esc_html__('Ascending', 'citybook-add-ons'), 
                    'DESC' => esc_html__('Descending', 'citybook-add-ons'), 
                ],
                'default' => 'DESC',
                'separator' => 'before',
                'description' => esc_html__("Select Ascending or Descending order. More at", 'citybook-add-ons').'<a href="http://codex.wordpress.org/Class_Reference/WP_Query#Order_.26_Orderby_Parameters" target="_blank">WordPress codex</a>.', 
            ]
        );

        $this->add_control(
            'hide_empty',
            [
                'label' => __( 'Hide Empty', 'citybook-add-ons' ),
                'description' => esc_html__('Whether to hide categories not assigned to any listings', 'citybook-add-ons'),
                'type' => Controls_Manager::SWITCHER,
                'default' => '1',
                'label_on' => __( 'Yes', 'citybook-add-ons' ),
                'label_off' => __( 'No', 'citybook-add-ons' ),
                'return_value' => '1',
            ]
        );


        $this->add_control(
            'number',
            [
                'label' => __( 'Number of Categories to show', 'citybook-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '0',
                'description' => esc_html__("Number of Categories to show (0 for all).", 'citybook-add-ons'),
                'min'     => 0,
                'step'     => 1,
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_layout',
            [
                'label' => __( 'Categories Layout', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'columns_grid',
            [
                'label' => __( 'Columns Grid', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'one' => esc_html__('One Column', 'citybook-add-ons'), 
                    'two' => esc_html__('Two Columns', 'citybook-add-ons'), 
                    'three' => esc_html__('Three Columns', 'citybook-add-ons'), 
                    'four' => esc_html__('Four Columns', 'citybook-add-ons'), 
                    'five' => esc_html__('Five Columns', 'citybook-add-ons'), 
                    'six' => esc_html__('Six Columns', 'citybook-add-ons'), 
                    'seven' => esc_html__('Seven Columns', 'citybook-add-ons'), 
                    'eight' => esc_html__('Eight Columns', 'citybook-add-ons'), 
                    'nine' => esc_html__('Nine Columns', 'citybook-add-ons'), 
                    'ten' => esc_html__('Ten Columns', 'citybook-add-ons'), 
                ],
                'default' => 'three',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        $this->add_control(
            'items_width',
            [
                'label' => __( 'Categories Items Width', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,

                'label_block' => true,
                // 'default' => 'date',
                // 'separator' => 'before',
                'description' => esc_html__('Defined category width. Available values are x1(default),x2(x2 width),x3(x3 width), and separated by comma. Ex: x1,x1,x2,x1,x1,x1', 'citybook-add-ons')
            ]
        );

        $this->add_control(
            'space',
            [
                'label' => __( 'Space', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'big' => esc_html__('Big', 'citybook-add-ons'), 
                    'medium' => esc_html__('Medium', 'citybook-add-ons'), 
                    'small' => esc_html__('Small', 'citybook-add-ons'), 
                    'extrasmall' => esc_html__('Extra Small', 'citybook-add-ons'), 
                    'no' => esc_html__('None', 'citybook-add-ons'), 
                    
                ],
                'default' => 'big',
                // 'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        $this->add_control(
            'view_all_link',
            [
                'label' => __( 'View All Link', 'citybook-add-ons' ),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '',
                    'is_external' => '',
                ],
                'description' => __( 'Listing archive page: ', 'citybook-add-ons' ). get_post_type_archive_link( 'listing' ),
                'show_external' => true, // Show the 'open in new tab' button.
            ]
        );

        // $this->add_control(
        //     'show_author',
        //     [
        //         'label' => __( 'Show Author', 'citybook-add-ons' ),
        //         'type' => Controls_Manager::SWITCHER,
        //         'default' => 'yes',
        //         'label_on' => __( 'Show', 'citybook-add-ons' ),
        //         'label_off' => __( 'Hide', 'citybook-add-ons' ),
        //         'return_value' => 'yes',
        //     ]
        // );

       
        


        


        


        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        $term_args = array(
            'taxonomy' => 'listing_cat',
            'hide_empty' => (bool)$settings['hide_empty'],
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'number' => $settings['number'],
        );

        if(!empty($settings['cat_ids'])) $term_args['include']  = $settings['cat_ids'];
        elseif(!empty($settings['cat_ids_not'])) $term_args['exclude']  = $settings['cat_ids_not'];
        
        $listing_terms = get_terms( $term_args );

        

        if ( ! empty( $listing_terms ) && ! is_wp_error( $listing_terms ) ){
            
        

            $css_classes = array(
                'gallery-items fl-wrap mr-bot spad',
                $settings['columns_grid'] .'-columns',
                $settings['space'] .'-pad'
            );

            $css_class = preg_replace( '/\s+/', ' ', implode( ' ', array_filter( $css_classes ) ) );

            ?>
            <div class="<?php echo esc_attr( $css_class );?>">
                <div class="grid-sizer"></div>
                <?php 
                $items_width = explode(',',$settings['items_width']);
                // $items_width = array_filter($items_width);
                $key = 0;
                foreach ($listing_terms as $term) { 
                    
                    $imgid = '';
                    $term_meta = get_term_meta( $term->term_id, P_META_PREFIX.'term_meta', true );
                    if(isset($term_meta['featured_img']) && !empty($term_meta['featured_img'])){
                       $imgid = $term_meta['featured_img']['id'];
                    }

                    $tnsize = 'citybook-lcat-one';

                    $item_cls = 'gallery-item';
                    if(isset($items_width[$key])){
                        switch ($items_width[$key]) {
                            case 'x2':
                                $item_cls .= ' gallery-item-second';
                                $tnsize = 'citybook-lcat-two';
                                break;
                            case 'x3':
                                $item_cls .= ' gallery-item-three';
                                $tnsize = 'citybook-lcat-three';
                                break;
                        }
                    }
                    ?>
                    <!-- gallery-item-->
                    <div id="listing_cat-<?php echo esc_attr( $term->term_id );?>" class="<?php echo esc_attr( $item_cls ); ?>">
                        <div class="grid-item-holder">
                            <div class="listing-item-grid">
                                <?php if($imgid != '') echo '<a href="'.esc_url( get_term_link( $term ) ).'" class="listing-cat-link">' . wp_get_attachment_image( $imgid, $tnsize ) .'</a>'; ?>
                                <div class="listing-counter"><span><?php echo esc_html($term->count) ?> </span> <?php esc_html_e( 'Locations', 'citybook-add-ons' ); ?></div>
                                <div class="listing-item-cat">
                                    <h3><a href="<?php echo esc_url( get_term_link( $term ) ) ?>"><?php echo esc_html($term->name); ?></a></h3>
                                    <div class="listing-term-desc"><?php echo term_description( $term->term_id, 'listing_cat' ); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- gallery-item end-->
                <?php
                    $key++;
                }
                // end foreach

                ?>
            </div>
            <?php
                $url = $settings['view_all_link']['url'];
                $target = $settings['view_all_link']['is_external'] ? 'target="_blank"' : '';
                if($url != '') echo '<div class="view-all-cats"><a href="' . $url . '" ' . $target .' class="btn big-btn circle-btn dec-btn color-bg flat-btn">'.__('View All','citybook-add-ons').'<i class="fa fa-eye"></i></a></div>';
            ?>
        <?php
        }
        // end if  ! empty( $listing_terms ) && ! is_wp_error( $listing_terms )


        

    }

    protected function _content_template() {}

   
    

}

