<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Hero_Section_Map extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'hero_section_map';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Hero Section Map', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'fa fa-trophy';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.10
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => __( 'Content', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => __( 'Content', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '',
                'show_label' => false,
            ]
        );

        

        $this->add_control(
            'show_search',
            [
                'label' => __( 'Show Search Form', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'label_on' => __( 'Show', 'citybook-add-ons' ),
                'label_off' => __( 'Hide', 'citybook-add-ons' ),
                'return_value' => 'yes',
            ]
        );

        $this->add_control(
            'hide_text_field',
            [
                'label' => __( 'Hide Text Field', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Show', 'citybook-add-ons' ),
                'label_off' => __( 'Hide', 'citybook-add-ons' ),
                'return_value' => 'yes',
                'condition' => [
                    'show_search' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'use_pre_locs',
            [
                'label' => __( 'Use Added Locations', 'citybook-add-ons' ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'label_on' => __( 'Yes', 'citybook-add-ons' ),
                'label_off' => __( 'No', 'citybook-add-ons' ),
                'return_value' => 'yes',
                'condition' => [
                    'show_search' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'content_after',
            [
                'label' => __( 'Content After Search', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXTAREA, // WYSIWYG,
                'default' => '',
                'show_label' => false,
            ]
        );

        $this->add_control(
            'cats',
            [
                'label' => __( 'Categories List', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                'default'   => ''
            ]
        );
        

        $this->add_control(
            'scroll_url',
            [
                'label' => __( 'Scroll button URL', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                
            ]
        );

        

        $this->end_controls_section();

        $this->start_controls_section(
            'section_background',
            [
                'label' => __( 'Listings Map Data', 'citybook-add-ons' ),
            ]
        );

        

        $this->add_control(
            'cat_ids',
            [
                'label' => __( 'Categories to get listings', 'citybook-add-ons' ),
                'type' => Controls_Manager::SELECT2,
                'options' => citybook_addons_get_listing_categories_select2(),
                'multiple' => true,
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'ids',
            [
                'label' => __( 'Enter Post IDs', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter Post ids to show, separated by a comma. Leave empty to show all.", 'citybook-add-ons')
                
            ]
        );
        $this->add_control(
            'ids_not',
            [
                'label' => __( 'Or Post IDs to Exclude', 'citybook-add-ons' ),
                'type' => Controls_Manager::TEXT,
                'default' => '',
                'label_block' => true,
                'description' => __("Enter post ids to exclude, separated by a comma (,). Use if the field above is empty.", 'citybook-add-ons')
                
            ]
        );
        $this->add_control(
            'posts_per_page',
            [
                'label' => __( 'Posts to show', 'citybook-add-ons' ),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
                'min' => -1,
                'description' => esc_html__("Number of posts to show (-1 for all).", 'citybook-add-ons'),
                
            ]
        );

        $this->end_controls_section();


    }

    protected function render( ) {

        $settings = $this->get_settings();

        if(!empty($settings['ids'])){
            $ids = explode(",", $settings['ids']);
            $post_args = array(
                'post_type' => 'listing',
                'posts_per_page'=> $settings['posts_per_page'],
                'post__in' => $ids,
                'post_status' => 'publish'
            );
        }elseif(!empty($settings['ids_not'])){
            $ids_not = explode(",", $settings['ids_not']);
            $post_args = array(
                'post_type' => 'listing',
                'posts_per_page'=> $settings['posts_per_page'],
                'post__not_in' => $ids_not,
                'post_status' => 'publish'
            );
        }else{
            $post_args = array(
                'post_type' => 'listing',
                'posts_per_page'=> $settings['posts_per_page'],
                'post_status' => 'publish'
            );
        }





        if(!empty($settings['cat_ids'])) $post_args['tax_query'] =  array(
                                                                        array(
                                                                            'taxonomy' => 'listing_cat',
                                                                            'field'    => 'term_id',
                                                                            'terms'    => $settings['cat_ids'],
                                                                        ),
                                                                    );

        $gmap_listing = array();
        $posts_query = new \WP_Query($post_args);
        if($posts_query->have_posts()) { 
            while($posts_query->have_posts()){ 
                $posts_query->the_post();
                $gmap_listing[] = citybook_addons_get_listing_post_data();
            }
        }
        wp_localize_script( 'citybook-addons', '_citybook_add_ons_locs', $gmap_listing);
        ?>
        <!-- home-map--> 
        <div class="home-map fl-wrap">
            <!-- Map -->
            <div class="map-container fw-map">
                <?php if(citybook_addons_get_option('use_osm_map') == 'yes'): ?>
                <div id="map-osm-main"></div>
                <?php else: ?>
                <div id="map-main"></div>
                <?php endif; ?>
            </div>
            <!-- Map end --> 
            <div class="absolute-main-search-input">
                <div class="container">
                    <?php 
                    if(!empty($settings['content'])): ?>
                    <div class="intro-item fl-wrap">
                        <?php echo $settings['content'];?>
                    </div>
                    <?php 
                    endif;?>
                    <?php  if($settings['show_search'] == 'yes') citybook_addons_get_template_part('templates/hero_search_form', '', array('hide_text_field' => $settings['hide_text_field'], 'use_pre_locs' => $settings['use_pre_locs'] ) ); ?>
                    
                    <?php 
                    if(!empty($settings['content_after'])): ?>
                    <div class="intro-item-after fl-wrap">
                        <?php echo $settings['content_after'];?>
                    </div>
                    <?php 
                    endif;?>

                    <?php 
                    if(is_array($settings['cats']) && !empty($settings['cats'])){ ?>
                    <div class="box-cat-container box-cat-new">
                    <?php
                        foreach ($settings['cats'] as $cat) {
                            $term = get_term( $cat, 'listing_cat');
                            if ( empty( $term ) || is_wp_error( $term ) ) continue;
                            $term_meta = get_term_meta( $term->term_id, P_META_PREFIX.'term_meta', true );
                            
                        ?>
                        <!--box-cat-->
                        <a href="<?php echo esc_url( get_term_link( $term ) ) ?>" class="box-cat color-bg">
                            <?php if(isset($term_meta['icon_class'])) echo '<i class="'.$term_meta['icon_class'].'"></i>'; ?>
                            <h4><?php echo esc_html($term->name) ?></h4>
                        </a>
                        <!--box-cat end-->
                        <?php
                        } ?>
                    </div>
                    <!-- end box-cat-container -->
                    <?php
                    }


                    ?>

                </div>
            </div>
            <!-- home-map end-->   
            <?php 
            if(!empty($settings['scroll_url'])): ?>
            <div class="header-sec-link">
                <a href="<?php echo $settings['scroll_url'];?>" class="custom-scroll-link"><?php _e( 'Let\'s Start',  'citybook-add-ons' );?></a>
            </div>
            <?php 
            endif;?>
        </div>
        <!-- section end -->
        <?php citybook_addons_get_template_part('templates/tmpls'); ?>
        <?php
    }

}


