<?php
/**
 * @package CityBook Add-Ons
 * @description A custom plugin for CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */



namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class CTH_Collage_Images extends Widget_Base {

    /**
    * Get widget name.
    *
    * Retrieve alert widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
    public function get_name() {
        return 'collage_images';
    }

    // public function get_id() {
    //    	return 'header-search';
    // }

    public function get_title() {
        return __( 'Collage Images', 'citybook-add-ons' );
    }

    public function get_icon() {
        // Icon name from the Elementor font file, as per http://dtbaker.net/web-development/creating-your-own-custom-elementor-widgets/
        return 'eicon-gallery-justified';
    }

    /**
    * Get widget categories.
    *
    * Retrieve the widget categories.
    *
    * @since 1.0.10
    * @access public
    *
    * @return array Widget categories.
    */
    public function get_categories() {
        return [ 'citybook-elements' ];
    }

    protected function _register_controls() {

        $this->start_controls_section(
            'section_images',
            [
                'label' => __( 'Content', 'citybook-add-ons' ),
            ]
        );

        $this->add_control(
            'title',
            [
                'label'       => __( 'Title', 'citybook-add-ons' ),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => 'City<span>Book</span>',
                'label_block' => true,
                
            ]
        );

        $this->add_control(
            'images',
            [
                'label' => __( 'Images', 'citybook-add-ons' ),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'title' => 'Main Image - Avatar 1',
                        'image' => array(
                            'id'=>'1970',
                            'url' => Utils::get_placeholder_image_src(),
                        ),
                        'left_pos' => '',
                        'top_pos' => '',
                        'zindex' => '',
                        'use_animation' => '',
                    ],
                    [
                        'title' => 'Image 2 - Avatar 2',
                        'image' => array(
                            'id'=>'1971',
                            'url' => Utils::get_placeholder_image_src(),
                        ),
                        'left_pos' => '23',
                        'top_pos' => '10',
                        'zindex' => '2',
                        'use_animation' => '',
                    ],
                    [
                        'title' => 'Image 3 - Avatar 4',
                        'image' => array(
                            'id'=>'1973',
                            'url' => Utils::get_placeholder_image_src(),
                        ),
                        'left_pos' => '62',
                        'top_pos' => '54',
                        'zindex' => '5',
                        'use_animation' => '',
                    ],
                    [
                        'title' => 'Image 4 - Avatar 6',
                        'image' => array(
                            'id'=>'1975',
                            'url' => Utils::get_placeholder_image_src(),
                        ),
                        'left_pos' => '18',
                        'top_pos' => '70',
                        'zindex' => '11',
                        'use_animation' => 'yes',
                    ],
                    [
                        'title' => 'Image 5 - Avatar 5',
                        'image' => array(
                            'id'=>'1974',
                            'url' => Utils::get_placeholder_image_src(),
                        ),
                        'left_pos' => '37',
                        'top_pos' => '90',
                        'zindex' => '1',
                        'use_animation' => '',
                    ],
                ],
                'fields' => [ //,1971,1973,1975,1974
                    [
                        'name' => 'title',
                        'label' => __( 'Image Title', 'citybook-add-ons' ),
                        'type' => Controls_Manager::TEXT,
                        'default' => 'Image Title',
                        'label_block' => true,
                        'description' => __( 'For editing only', 'citybook-add-ons' ),
                    ],
                    [
                        'name' => 'image',
                        'label' => __( 'Image', 'citybook-add-ons' ),
                        'type' => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                         ],
                    ],
                    [
                        'name' => 'left_pos',
                        'label' => __( 'Left Position', 'citybook-add-ons' ),
                        'type' => Controls_Manager::NUMBER,
                        'default' => '23',
                        'description' => __( 'Left position (%) related to element (top-left corner) ', 'citybook-add-ons' ),
                    ],
                    [
                        'name' => 'top_pos',
                        'label' => __( 'Top Position', 'citybook-add-ons' ),
                        'type' => Controls_Manager::NUMBER,
                        'default' => '10',
                        'description' => __( 'Left position (%) related to element (top-left corner) ', 'citybook-add-ons' ),
                    ],
                    [
                        'name' => 'zindex',
                        'label' => __( 'Zindex', 'citybook-add-ons' ),
                        'type' => Controls_Manager::NUMBER,
                        'default' => '0',
                        'description' => __( 'Use to control image displaying in Z axis.', 'citybook-add-ons' ),
                    ],
                    [
                        'name' => 'use_animation',
                        'label' => __( 'Animation Image?', 'citybook-add-ons' ),
                        'type' => Controls_Manager::SWITCHER,
                        'default' => '',
                        'label_on' => __( 'Yes', 'citybook-add-ons' ),
                        'label_off' => __( 'No', 'citybook-add-ons' ),
                        'return_value' => 'yes',
                    ]
                ],
                'title_field' => '{{{ title }}}',
            ]
        );



        

        $this->end_controls_section();

    }

    protected function render( ) {
        $settings = $this->get_settings();
        if(is_array($settings['images']) && !empty($settings['images']) ):
            
        ?>
        <div class="images-collage fl-wrap">
            <div class="images-collage-title"><?php echo $settings['title']; ?></div>
            <?php 
            foreach ($settings['images'] as $key => $image) {
                $img_class = 'images-collage-item' . ($key == 0 ? ' images-collage-main' : ' images-collage-other');
                if($image['use_animation'] == 'yes') $img_class .= ' anim-col';
                $img_datas = '';
                if($image['left_pos']) $img_datas .= ' data-position-left="'.$image['left_pos'].'"';
                if($image['top_pos']) $img_datas .= ' data-position-top="'.$image['top_pos'].'"';
                if($image['zindex']) $img_datas .= ' data-zindex="'.$image['zindex'].'"';

                $img_size = ($key == 0 ? array(160,160) : array(90,90));
                ?>
                <div class="<?php echo esc_attr( $img_class ); ?>" <?php echo $img_datas; ?>><?php echo wp_get_attachment_image( $image['image']['id'],  $img_size );?></div>
            <?php
            }
            ?>
        </div>
        <?php
        endif;
    }

    protected function _content_template() {
        ?>
        <# if(_.isArray(settings.images) && settings.images.length){ #>
        <div class="images-collage fl-wrap">
            <div class="images-collage-title">{{{settings.title}}}</div>
            <# _.each(settings.images,function(image,index){ 
            
                var cls = 'images-collage-item' + (index == 0? ' images-collage-main':' images-collage-other');
                if(image.use_animation == 'yes') cls += ' anim-col';
                
                var img_datas = '';
                if(image.left_pos) img_datas += ' data-position-left="'+image.left_pos+'"';
                if(image.top_pos) img_datas += ' data-position-top="'+image.top_pos+'"';
                if(image.zindex) img_datas += ' data-zindex="'+image.zindex+'"';
            #>
                <div class="{{cls}}"{{{img_datas}}}><img src="{{image.image.url}}" alt="{{image.image.title}}"></div>
            <# }) #>
        </div>
        <# } #>
        <?php
    }
    // end _content_template



}
