<?php
/**
Plugin Name: CityBook Add-Ons
Plugin URI: https://citybook.cththemes.com/
Description: A custom plugin for CityBook - Directory Listing WordPress Theme
Version: 1.3.5
Author: CTHthemes
Author URI: http://themeforest.net/user/cththemes
Text Domain: citybook-add-ons
Domain Path: /languages/
Copyright: ( C ) 2014 cththemes.com . All rights reserved.
License: GNU General Public License version 3.0
License URI: http://www.gnu.org/licenses/gpl-3.0.html
 */


if ( ! defined('ABSPATH') ) {
    die('Please do not load this file directly!');
}
define( 'CITYBOOK_ADD_ONS_VERSION', '1.3.5' );

// Define CITYBOOK_ADD_ONS_PLUGIN_FILE.
if ( ! defined( 'CITYBOOK_ADD_ONS_PLUGIN_FILE' ) ) {
    define( 'CITYBOOK_ADD_ONS_PLUGIN_FILE', __FILE__ );
}
define ('CITYBOOK_ADD_ONS_DIR',plugin_dir_path(__FILE__ ));
define ('CITYBOOK_ADD_ONS_DIR_URL',plugin_dir_url(__FILE__ ));
define ('P_META_PREFIX','_cth_');

// for debug plugin
if( !defined('CTH_DEBUG') ) define("CTH_DEBUG", true);
if( !defined('CTH_LOG_FILE') ) define("CTH_LOG_FILE", "./cthdev.log");

/* plugin options */
require_once CITYBOOK_ADD_ONS_DIR . 'plugin_options.php';
// for listing post type
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-listing.php';
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/search.php';
// for listing pricing lplan
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-plan.php';
// for listing membership - users screen columns
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-membership.php';
// for listing lorder type
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-order.php';
// for listing cthinvoice type
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-invoice.php';
// for listing lbooking type
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-booking.php';
// for listing lmessage type
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-message.php';
// for listing claim
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-claim.php';
// for listing ads
require_once CITYBOOK_ADD_ONS_DIR .'posttypes/citybook-ads.php';

require_once CITYBOOK_ADD_ONS_DIR . 'posttypes/emails.php';
require_once CITYBOOK_ADD_ONS_DIR . 'posttypes/payments.php';
require_once CITYBOOK_ADD_ONS_DIR . 'posttypes/ads.php';
// new message system
require_once CITYBOOK_ADD_ONS_DIR . 'posttypes/citybook-chat.php';

// for user location using ipinfodb.com
// require_once CITYBOOK_ADD_ONS_DIR . 'inc/classes/IP-User-Location/usage.php';
// extract google country codes
// require_once CITYBOOK_ADD_ONS_DIR . 'inc/classes/Google/country-codes.php';

if ( ! class_exists( 'CTB_Update' ) ) {
    include_once CITYBOOK_ADD_ONS_DIR . 'includes/class-ctb-update.php';
}

require_once CITYBOOK_ADD_ONS_DIR . 'includes/expire.php';
require_once CITYBOOK_ADD_ONS_DIR . 'includes/woo.php';

function cth_register_cpt_Cth_Testimonial() {
    
    $labels = array( 
        'name' => __( 'Testimonial', 'citybook-add-ons' ),
        'singular_name' => __( 'Testimonial', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Testimonial', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Testimonial', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Testimonial', 'citybook-add-ons' ),
        'new_item' => __( 'New Testimonial', 'citybook-add-ons' ),
        'view_item' => __( 'View Testimonial', 'citybook-add-ons' ),
        'search_items' => __( 'Search Testimonials', 'citybook-add-ons' ),
        'not_found' => __( 'No Testimonials found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Testimonials found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Testimonial:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Testimonials', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Testimonials',
        'supports' => array( 'title', 'editor', 'thumbnail'/*,'comments', 'post-formats'*/),
        'public' => false,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 25,
        'menu_icon' => 'dashicons-format-chat', 
        'show_in_nav_menus' => false,
        'publicly_queryable' => true,
        'exclude_from_search' => true,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => array( 'slug' => __('cth_testimonial','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'cth_testimonial', $args );
}
// Register Service 
add_action( 'init', 'cth_register_cpt_Cth_Testimonial' );
if(!function_exists('cth_testimonial_columns_head')){
    function cth_testimonial_columns_head($defaults) {
        $defaults['cth_testimonial_thumbnail'] = 'Thumbnail';
        $defaults['cth_testimonial_rating'] = 'Rating';
        $defaults['cth_testimonial_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('cth_testimonial_columns_content')){
    // CUSTOM POSTS
    function cth_testimonial_columns_content($column_name, $post_ID) {
        if ($column_name == 'cth_testimonial_id') {
            echo $post_ID;
        }
        if ($column_name == 'cth_testimonial_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }
        if ($column_name == 'cth_testimonial_rating') {
            $rated = get_post_meta($post_ID, '_cth_testim_rate', true );
            if($rated != '' && $rated != 'no'){
                $ratedval = floatval($rated);
                echo '<ul class="star-rating">';
                for ($i=1; $i <= 5; $i++) { 
                    if($i <= $ratedval){
                        echo '<li><i class="testimfa testimfa-star"></i></li>';
                    }else{
                        if($i - 0.5 == $ratedval){
                            echo '<li><i class="testimfa testimfa-star-half"></i></li>';
                        }
                    }
                    
                }
                echo '</ul>';
            }else{
                esc_html_e('Not Rated','citybook-add-ons' );
            }
        }
    }
}

add_filter('manage_cth_testimonial_posts_columns', 'cth_testimonial_columns_head', 10);
add_action('manage_cth_testimonial_posts_custom_column', 'cth_testimonial_columns_content', 10, 2);


//notice mobile app is available
function citybook_mobile_app_available(){
    echo '<div class="notice notice-error is-dismissible">
        <p>CityBook react-native <strong>Mobile Apps</strong> is now available. <a href="https://cththemes.com/" target="_blank">Get it</a></p> 
    </div>';
}
add_action('admin_notices', 'citybook_mobile_app_available');

//register Team Member post type
function CityBook_Add_ons_register_cpt_CityBook_Member() {
    
    $labels = array( 
        'name' => __( 'Members', 'citybook-add-ons' ),
        'singular_name' => __( 'Member', 'citybook-add-ons' ),
        'add_new' => __( 'Add New Member', 'citybook-add-ons' ),
        'add_new_item' => __( 'Add New Member', 'citybook-add-ons' ),
        'edit_item' => __( 'Edit Member', 'citybook-add-ons' ),
        'new_item' => __( 'New Member', 'citybook-add-ons' ),
        'view_item' => __( 'View Member', 'citybook-add-ons' ),
        'search_items' => __( 'Search Members', 'citybook-add-ons' ),
        'not_found' => __( 'No Members found', 'citybook-add-ons' ),
        'not_found_in_trash' => __( 'No Members found in Trash', 'citybook-add-ons' ),
        'parent_item_colon' => __( 'Parent Member:', 'citybook-add-ons' ),
        'menu_name' => __( 'Listing Members', 'citybook-add-ons' ),
    );

    $args = array( 
        'labels' => $labels,
        'hierarchical' => true,
        'description' => 'List Members',
        'supports' => array( 'title', 'editor', 'thumbnail','excerpt'/*,'comments', 'post-formats'*/),
        'public' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'menu_position' => 25,
        'menu_icon' =>  'dashicons-groups',
        'show_in_nav_menus' => true,
        'publicly_queryable' => true,
        'exclude_from_search' => false,
        'has_archive' => false,
        'query_var' => true,
        'can_export' => true,
        'rewrite' => array( 'slug' => __('member','citybook-add-ons') ),
        'capability_type' => 'post'
    );

    register_post_type( 'member', $args );
}
// Register Member 
add_action( 'init', 'CityBook_Add_ons_register_cpt_CityBook_Member' );
if(!function_exists('citybook_member_columns_head')){
    function citybook_member_columns_head($defaults) {
        $defaults['citybook_member_thumbnail'] = 'Thumbnail';
        $defaults['citybook_member_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('citybook_member_columns_content')){
    // CUSTOM POSTS
    function citybook_member_columns_content($column_name, $post_ID) {
        if ($column_name == 'citybook_member_id') {
            echo $post_ID;
        }
        if ($column_name == 'citybook_member_thumbnail') {
            echo get_the_post_thumbnail( $post_ID, 'thumbnail', array('style'=>'width:100px;height:auto;') );
        }
    }
}

add_filter('manage_member_posts_columns', 'citybook_member_columns_head', 10);
add_action('manage_member_posts_custom_column', 'citybook_member_columns_content', 10, 2);

// Page ID
if(!function_exists('citybook_page_columns_head')){
    function citybook_page_columns_head($defaults) {
        $defaults['page_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('citybook_page_columns_content')){
    // CUSTOM POSTS
    function citybook_page_columns_content($column_name, $post_ID) {
        if ($column_name == 'page_id') {
            echo $post_ID;
        }
    }
}

add_filter('manage_page_posts_columns', 'citybook_page_columns_head', 10);
add_action('manage_page_posts_custom_column', 'citybook_page_columns_content', 10, 2);

// Post ID
if(!function_exists('citybook_post_columns_head')){
    function citybook_post_columns_head($defaults) {
        $defaults['post_id'] = 'ID';
        return $defaults;
    }
}
if(!function_exists('citybook_post_columns_content')){
    // CUSTOM POSTS
    function citybook_post_columns_content($column_name, $post_ID) {
        if ($column_name == 'post_id') {
            echo $post_ID;
        }
    }
}

add_filter('manage_post_posts_columns', 'citybook_post_columns_head', 10);
add_action('manage_post_posts_custom_column', 'citybook_post_columns_content', 10, 2);
//CMB2
require_once CITYBOOK_ADD_ONS_DIR .'inc/cmb2/functions.php';


require_once CITYBOOK_ADD_ONS_DIR .'inc/rating.php';

/**
 * Implement Post views
 *
 * @since CityBook 1.0
 */
require_once CITYBOOK_ADD_ONS_DIR . 'inc/post_views.php';
/**
 * Implement Like Post
 *
 * @since CityBook 1.0
 */
require_once CITYBOOK_ADD_ONS_DIR . 'inc/post_like.php';

/**
 * Implement Ajax requests
 *
 * @since CityBook 1.0
 */
require_once CITYBOOK_ADD_ONS_DIR . 'inc/ajax.php';

/**
 * Visual Composer plugin integration
 *
 * @since CityBook 1.0
 */
// require_once CITYBOOK_ADD_ONS_DIR . '/inc/cth_for_vc.php';
require_once CITYBOOK_ADD_ONS_DIR . 'inc/vc_shortcodes.php';
require_once CITYBOOK_ADD_ONS_DIR . 'inc/template_tags.php';

require_once CITYBOOK_ADD_ONS_DIR . 'inc/elementor.php';





//widgets
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_recent_posts.php';
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_about_author.php';
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_banner.php';
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_banner_video.php';
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_instagram_feed.php';
require_once CITYBOOK_ADD_ONS_DIR .'widgets/citybook_twitter_feed.php';

function citybook_add_ons_register_widgets() {
    
    register_widget( 'CityBook_About_Author' );
    register_widget( 'CityBook_Recent_Posts' );
    register_widget( 'CityBook_Instagram_Feed' );
    register_widget( 'CityBook_Banner' );
    register_widget( 'CityBook_Banner_Video' );
    register_widget( 'CityBook_Twitter_Feed' );
    


}

add_action( 'widgets_init', 'citybook_add_ons_register_widgets' );


// Apply filter
add_filter('body_class', 'citybook_addons_body_classes');

function citybook_addons_body_classes($classes) {
    $classes[] = 'body-citybook';
    return $classes;
}


function cth_citybook_plugins_init() {
    $plugin_dir = basename(dirname(__FILE__));
    load_plugin_textdomain( 'citybook-add-ons', false, $plugin_dir . '/languages' );
}
add_action('plugins_loaded', 'cth_citybook_plugins_init');


function citybook_addons_activation_hook_callback() {
    $result = add_role( 
                    'l_customer', 
                    __( 'Listing Customer', 'citybook-add-ons'),
                    array(
                        'level_0'                => true, // Subscriber
                        'read' => true, 
                    )
                    
                );
    if($result === null) echo  __('Oh... the l_customer role already exists.','citybook-add-ons'); 
   

    $result =   add_role( 
                    'listing_author', 
                    __( 'Listing Author', 'citybook-add-ons'),
                    array(
                        'level_2'                => true, // Author
                        'level_1'                => true, // Contributor
                        'level_0'                => true, // Subscriber

                        'delete_posts'         => true,  // true allows this capability // Use false to explicitly deny
                        'delete_published_posts'   => true,
                        'edit_posts' => true, 
                        'edit_published_posts' => true, 
                        // 'edit_private_posts' => true,
                        'publish_posts' => false, 
                        'read' => true, 
                        'upload_files' => true, 
                    )
                    
                );
    if($result === null) echo  __('Oh... the listing_author role already exists.','citybook-add-ons'); 
    // add submit_listing cap to administrator and listing_author role
    global $wp_roles;
    if ( ! isset( $wp_roles ) ) {
        $wp_roles = new WP_Roles();
    }
    $wp_roles->add_cap( 'listing_author', 'submit_listing' );
    $wp_roles->add_cap( 'administrator', 'submit_listing' );
    // if need admin can edit each other posts
    // $wp_roles->add_cap( 'administrator', 'edit_others_posts' );

    

    // http://www.wpexplorer.com/wordpress-page-templates-plugin/
    $exists_options = get_option( 'citybook-addons-options', array() );
    // add new pages
    // - page args
    $_p = array();
    // $_p['post_content']   = '';
    $_p['post_status']    = 'publish';
    $_p['post_type']      = 'page';
    $_p['comment_status'] = 'closed';
    $_p['ping_status']    = 'closed';

    $_p['page_template']    = 'home-page.php';

    // - dashboard page
    $dashboard_page_title = __('Dashboard','citybook-add-ons');
    $dashboard_page = get_page_by_title($dashboard_page_title);
    if (!$dashboard_page){
        $_p['post_title']     = $dashboard_page_title;

        $_p['post_content']   = '[listing_dashboard_page]';
        // Insert the post into the database
        $exists_options['dashboard_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
        // if(!is_wp_error($dashboard_page_id)){
        //   //the post is valid
        // }else{
        //   //there was an error in the post insertion, 
        //   echo $dashboard_page_id->get_error_message();
        // }

    }else{
        // the plugin may have been previously active and the page may just be trashed...
        // $dashboard_page_id = $dashboard_page->ID;

        //make sure the page is not trashed...
        $dashboard_page->post_status = 'publish';
        $dashboard_page->post_content = '[listing_dashboard_page]';
        // $dashboard_page->page_template = 'home-page.php';

        $exists_options['dashboard_page'] = wp_update_post($dashboard_page); // return post Id or 0 if not success
    }

    // - submit page
    $submit_page_title = __('Submit Listing','citybook-add-ons');
    $submit_page = get_page_by_title($submit_page_title);
    if (!$submit_page){
        $_p['post_title']     = $submit_page_title;
        $_p['post_content']   = '[listing_submit_page]';
        // Insert the post into the database
        $exists_options['submit_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
    }else{
        //make sure the page is not trashed...
        $submit_page->post_status = 'publish';
        $submit_page->post_content = '[listing_submit_page]';
        // $submit_page->page_template = 'home-page.php';
        $exists_options['submit_page'] = wp_update_post($submit_page); // return post Id or 0 if not success
    }
    // - edit listing page
    $page_title = __('Edit Listing','citybook-add-ons');
    $page_post = get_page_by_title($page_title);
    if (!$page_post){
        $_p['post_title']     = $page_title;
        $_p['post_content']   = '[listing_edit_page]';
        // Insert the post into the database
        $exists_options['edit_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
    }else{
        //make sure the page is not trashed...
        $page_post->post_status = 'publish';
        $page_post->post_content = '[listing_edit_page]';
        // $edit_page->page_template = 'home-page.php';
        $exists_options['edit_page'] = wp_update_post($page_post); // return post Id or 0 if not success
    }

    // - edit payment page
    // $page_title = __('Listing Payment','citybook-add-ons');
    // $page_post = get_page_by_title($page_title);
    // if (!$page_post){
    //     $_p['post_title']     = $page_title;
    //     // Insert the post into the database
    //     $exists_options['payment_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
    // }else{
    //     //make sure the page is not trashed...
    //     $page_post->post_status = 'publish';
    //     // $edit_page->page_template = 'home-page.php';
    //     $exists_options['payment_page'] = wp_update_post($page_post); // return post Id or 0 if not success
    // }

    // - checkout page
    $page_title = __('Listing Checkout','citybook-add-ons');
    $page_post = get_page_by_title($page_title);
    if (!$page_post){
        $_p['post_title']     = $page_title;
        $_p['post_content']   = '[listing_checkout_page]';
        // Insert the post into the database
        $exists_options['checkout_page'] = wp_insert_post($_p); // return post Id or 0 or WP_Error if not success
    }else{
        //make sure the page is not trashed...
        $page_post->post_status = 'publish';
        $page_post->post_content = '[listing_checkout_page]';
        $exists_options['checkout_page'] = wp_update_post($page_post); // return post Id or 0 if not success
    }
    

    // update plugin options
    $return = update_option( 'citybook-addons-options', $exists_options );

    // var_dump($return);
    $fresh_installed = false;
    if( get_option( 'citybook-addons-version', 'fresh_installed' ) == 'fresh_installed' ){
        $citybook_addons_version = '1.3.0';
        $fresh_installed = true;
    }else{
        $citybook_addons_version = get_option( 'citybook-addons-version');
    }
    // $citybook_addons_version = get_option( 'citybook-addons-version', '1.2.8' );

    // do version 1.0.3 update
    if( version_compare($citybook_addons_version, '1.0.3', '<') ){
        // update listing posts for support address and near me search

        // die();

        $args = array( 
            'post_type' => 'listing',
            'post_status'   => 'any' , // array( 'publish', 'pending', 'draft', 'future' ),

            'posts_per_page' => -1,
        );
        //$active_msgs = array();
        $listing_posts = new WP_Query( $args );
        if($listing_posts->have_posts()){
            while($listing_posts->have_posts()) : $listing_posts->the_post();

                $contact_infos = get_post_meta( get_the_ID(), P_META_PREFIX.'contact_infos', true );
                if(!empty($contact_infos)){
                    foreach ((array)$contact_infos as $key => $value) {
                        if ( !update_post_meta( get_the_ID(), P_META_PREFIX.'contact_infos_'.$key,  $value  ) ) {
                            //$active_msgs[] = sprintf(__('Insert listing %s meta failure or existing meta value','citybook-add-ons'),$key);
                        }
                    }
                }
                //$active_msgs[] = get_the_ID();

                // error_log( get_the_ID() . PHP_EOL, 3, CTH_LOG_FILE );

                // delete listing old contact info for test only
                delete_post_meta( get_the_ID(), P_META_PREFIX.'contact_infos');
                
                
            endwhile;
        }
        wp_reset_postdata();
    }
    // end update version 3

    // do version 1.0.5 update
    if( version_compare($citybook_addons_version, '1.0.5', '<') ){
        // update listing posts for support listing expiration date
        $args = array( 
            'post_type' => 'listing',
            'post_status'   => 'any' , // array( 'publish', 'pending', 'draft', 'future' ),

            'posts_per_page' => -1,
        );
        $listing_posts = new WP_Query( $args );
        if($listing_posts->have_posts()){
            while($listing_posts->have_posts()) : $listing_posts->the_post();
                if(get_post_meta( get_the_ID(), P_META_PREFIX.'expire_date', true ) == ''){
                    update_post_meta( get_the_ID(), P_META_PREFIX.'expire_date',  'NEVER'  );
                }

                // add price range widget
                update_post_meta( get_the_ID(), P_META_PREFIX.'widget_price_range',  'yes'  );
                // update listing price for woo cart support later
                $old_price = get_post_meta( get_the_ID(), '_price', true );
                $price_from = get_post_meta( get_the_ID(), P_META_PREFIX.'price_from', true );
                if($old_price != $price_from) update_post_meta( get_the_ID(), '_price',  $price_from );
        
                
            endwhile;
        }
        wp_reset_postdata();


        // update lorder posts invoices
        $args = array( 
            'post_type' => 'lorder',
            'post_status'   => 'any' , // array( 'publish', 'pending', 'draft', 'future' ),

            'posts_per_page' => -1,
        );
        $lorder_posts = new WP_Query( $args );
        if($lorder_posts->have_posts()){
            while($lorder_posts->have_posts()) : $lorder_posts->the_post();

                $order_transactions = get_post_meta( get_the_ID(), P_META_PREFIX.'transactions', true );
                if(!empty($order_transactions)){
                    if(is_array($order_transactions)){
                        // $current_key = current(array_keys($order_transactions));
                        $first_value = reset($order_transactions);
                        if( $first_value && !is_array($first_value) ){
                            $order_transactions_new = $order_transactions;
                        }
                    }else{
                        $order_transactions_new = (array) $order_transactions;
                    }
                    if(!empty($order_transactions_new)){
                        $new_transactions = array();
                        foreach ($order_transactions_new as $key => $value) {
                            $new_transactions[$value] = array(
                                'txn_id' => $value,
                                'quantity' => get_post_meta( get_the_ID(), P_META_PREFIX.'quantity', true ),
                                'amount' => get_post_meta( get_the_ID(), P_META_PREFIX.'amount', true ),
                                'plan_id' => get_post_meta( get_the_ID(), P_META_PREFIX.'plan_id', true ),
                            );
                        }

                        update_post_meta( get_the_ID(), P_META_PREFIX.'transactions',  $new_transactions  );
                    }
                }


                // update to check per listing or package subscription
                if(get_post_meta( get_the_ID(), P_META_PREFIX.'is_per_listing_sub', true ) == ''){
                    update_post_meta( get_the_ID(), P_META_PREFIX.'is_per_listing_sub',  'no'  );
                }

                if(get_post_meta( get_the_ID(), P_META_PREFIX.'listings', true ) == ''){
                    update_post_meta( get_the_ID(), P_META_PREFIX.'listings',  array() ); // update order listings to empty array
                }
                
                
            endwhile;
        }
        wp_reset_postdata();
    }
    // end update version 5

    // do version 1.0.8 update
    if( version_compare($citybook_addons_version, '1.0.8', '<') ){

        // update lorder posts invoices
        $args = array( 
            'post_type' => 'lorder',
            'post_status'   => 'any' , // array( 'publish', 'pending', 'draft', 'future' ),

            'posts_per_page' => -1,
        );
        $lorder_posts = new WP_Query( $args );
        if($lorder_posts->have_posts()){
            while($lorder_posts->have_posts()) : $lorder_posts->the_post();

                $order_transactions = get_post_meta( get_the_ID(), P_META_PREFIX.'transactions', true );
                if(!empty($order_transactions)){
                    $order_transactions_new = array();
                    if(is_array($order_transactions)){
                        foreach ($order_transactions as $txn_id => $value) {
                            
                            
                            $required_data = array(
                                'order_id'  => get_the_ID(),
                                'user_id'  => get_post_meta( get_the_ID(), P_META_PREFIX.'user_id', true ),
                                'user_name'  => __( 'No user', 'citybook-add-ons' ),
                                'user_email'  => __( 'No user email', 'citybook-add-ons' ),
                                'from_date'  => get_post_meta( get_the_ID(), P_META_PREFIX.'from_date', true ),
                                'end_date'  => get_post_meta( get_the_ID(), P_META_PREFIX.'end_date', true ),
                                'payment'  => get_post_meta( get_the_ID(), P_META_PREFIX.'payment_method', true ),
                                'txn_id'  => $txn_id,

                                'plan_title'  => get_the_title( get_post_meta( get_the_ID(), P_META_PREFIX.'plan_id', true ) ),
                                'quantity'  => get_post_meta( get_the_ID(), P_META_PREFIX.'quantity', true ),
                                'amount'  => get_post_meta( get_the_ID(), P_META_PREFIX.'amount', true ),
                                'tax'  => 0, // maybe change in the future
                                'charged_to'  => '', // maybe change in the future
                            );
                            $user_datas = get_user_by( 'ID', get_post_meta( get_the_ID(), P_META_PREFIX.'user_id', true ) );
                            if( $user_datas ){
                                $required_data['user_name'] = $user_datas->display_name;
                                $required_data['user_email'] = $user_datas->user_email;
                                $required_data['charged_to'] = $user_datas->user_email;
                            }
                            $new_invoice = citybook_addons_create_invoice($required_data);

                            if($new_invoice != false){
                                $order_transactions_new[] = $new_invoice;
                            }

                        }
                    }

                    update_post_meta( get_the_ID(), P_META_PREFIX.'transactions',  $order_transactions_new  );

                }
                
            endwhile;
        }
        wp_reset_postdata();
    }
    // end update version 1.0.8
    if( version_compare($citybook_addons_version, '1.2.0', '<') ){
        $args = array(
            'status'   => 'approve',
            'meta_query' => array(
                array(
                    'key'     => 'rating',
                    'compare' => 'EXISTS',
                ),
            ),
        );
        $comments = get_comments($args);
        foreach($comments as $comment) :
            $rated = get_comment_meta($comment->comment_ID, 'rating', true);
            if(isset($rated) && !empty($rated) && is_numeric($rated)){
                $postID = $comment->comment_post_ID;

                $rating_key = P_META_PREFIX.'rating_average';
                $count_key = P_META_PREFIX.'rating_count';
                $rating_average = get_post_meta($postID, $rating_key, true);
                if($rating_average == ''){
                    update_post_meta($postID, $rating_key, $rated);
                    update_post_meta($postID, $count_key, 1);
                }else{
                    $rating_count = get_post_meta($postID, $count_key, true);
                    $rating_average = ($rating_average * $rating_count + $rated)/($rating_count+1);
                    update_post_meta($postID, $rating_key, round($rating_average, 1, PHP_ROUND_HALF_UP));
                    update_post_meta($postID, $count_key, $rating_count+1);
                }
            }

        endforeach;
    }
    // end update for version 1.2.0
    if( version_compare($citybook_addons_version, '1.2.1', '<') ){
        $levent_date_metas = citybook_addons_get_meta_values( P_META_PREFIX.'levent_date', 'listing', array('publish', 'pending') );
        if(is_array($levent_date_metas) && count($levent_date_metas)){
            foreach ($levent_date_metas as $l_ID => $meta_value) {
                if($meta_value != ''){
                    $new_val = citybook_addons_re_format_date($meta_value, 'Y-m-d');
                    update_post_meta($l_ID, P_META_PREFIX.'levent_date', $new_val);
                }
            }
        }

    }

    // update images data for reorder
    if( version_compare($citybook_addons_version, '1.2.4', '<') ){
        $headerimgs_metas = citybook_addons_get_meta_values( P_META_PREFIX.'headerimgs', 'listing', array('publish', 'pending') );
        if(is_array($headerimgs_metas) && count($headerimgs_metas)){
            foreach ($headerimgs_metas as $l_ID => $meta_value) {
                $new_values = array();
                $meta_value = unserialize($meta_value);
                if(is_array($meta_value) && count($meta_value)){
                    foreach ($meta_value as $id => $url) {
                        if(!is_numeric($url)) $new_values[] = $id;
                    }
                }
                if(!empty($new_values)) update_post_meta($l_ID, P_META_PREFIX.'headerimgs', $new_values);
            }
        }

        $promo_bg_metas = citybook_addons_get_meta_values( P_META_PREFIX.'promo_bg', 'listing', array('publish', 'pending') );
        if(is_array($promo_bg_metas) && count($promo_bg_metas)){
            foreach ($promo_bg_metas as $l_ID => $meta_value) {
                $new_values = array();
                $meta_value = unserialize($meta_value);
                if(is_array($meta_value) && count($meta_value)){
                    foreach ($meta_value as $id => $url) {
                        if(!is_numeric($url)) $new_values[] = $id;
                    }
                }
                if(!empty($new_values)) update_post_meta($l_ID, P_META_PREFIX.'promo_bg', $new_values);
            }
        }

        $gallery_imgs_metas = citybook_addons_get_meta_values( P_META_PREFIX.'gallery_imgs', 'listing', array('publish', 'pending') );
        if(is_array($gallery_imgs_metas) && count($gallery_imgs_metas)){
            foreach ($gallery_imgs_metas as $l_ID => $meta_value) {
                $new_values = array();
                $meta_value = unserialize($meta_value);
                if(is_array($meta_value) && count($meta_value)){
                    foreach ($meta_value as $id => $url) {
                        if(!is_numeric($url)) $new_values[] = $id;
                    }
                }
                if(!empty($new_values)) update_post_meta($l_ID, P_META_PREFIX.'gallery_imgs', $new_values);
            }
        }

        $slider_imgs_metas = citybook_addons_get_meta_values( P_META_PREFIX.'slider_imgs', 'listing', array('publish', 'pending') );
        if(is_array($slider_imgs_metas) && count($slider_imgs_metas)){
            foreach ($slider_imgs_metas as $l_ID => $meta_value) {
                $new_values = array();
                $meta_value = unserialize($meta_value);
                if(is_array($meta_value) && count($meta_value)){
                    foreach ($meta_value as $id => $url) {
                        if(!is_numeric($url)) $new_values[] = $id;
                    }
                }
                if(!empty($new_values)) update_post_meta($l_ID, P_META_PREFIX.'slider_imgs', $new_values);
            }
        }
    }

    

    // update working hours data
    if( version_compare($citybook_addons_version, '1.2.6', '<') ){
        $featured_metas = citybook_addons_get_meta_values( P_META_PREFIX.'featured', 'listing', array('publish') );
        if(is_array($featured_metas) && count($featured_metas)){
            foreach ($featured_metas as $l_ID => $meta_value) {
                update_post_meta($l_ID, P_META_PREFIX.'featured', ($meta_value == 'YES'? '1':'0'));
            }
        }

        $wk_hours_meta = citybook_addons_get_meta_values( P_META_PREFIX.'working_hours', 'listing', array('publish', 'pending') );
        if(is_array($wk_hours_meta) && count($wk_hours_meta)){

            foreach ($wk_hours_meta as $l_ID => $meta_value) {
                
                $meta_value = unserialize($meta_value);
                citybook_addons_do_update_listing_working_hours( $l_ID, $meta_value );
                
                
            }// end foreach $wk_hours_meta
        }// end if $wk_hours_meta

        citybook_addons_update_message_system();
    }
    
    if( version_compare($citybook_addons_version, '1.2.9', '<') ) citybook_addons_update_to_version_1_2_9();
    if( !$fresh_installed && version_compare($citybook_addons_version, '1.3.0', '<') ) citybook_addons_update_to_version_1_3_0();

    if($fresh_installed){
        citybook_addons_update_message_system();
    }
    
    // end update working hours data
    update_option( 'citybook-addons-version', CITYBOOK_ADD_ONS_VERSION );
        

}
register_activation_hook( __FILE__, 'citybook_addons_activation_hook_callback' );

function citybook_addons_print_admin_notices($messages = array()){

    add_action( 'admin_notices', function() use ($messages) {
        ?>
        <div class="updated notice is-dismissible">
            <?php echo implode("<br>", $messages); ?>
        </div>
        <?php
    } );
}

function citybook_addons_deactivation_hook_callback() {
    // remove submit_listing cap to administrator and listing_author role
    global $wp_roles;
    if ( ! isset( $wp_roles ) ) {
        $wp_roles = new WP_Roles();
    }
    $wp_roles->remove_cap( 'listing_author', 'submit_listing' );
    $wp_roles->remove_cap( 'administrator', 'submit_listing' );

    if( get_role('listing_author') ){
        remove_role( 'listing_author' );
    }
    if( get_role('l_customer') ){
        remove_role( 'l_customer' );
    }
    
    // move pages to trash
    $force_delete = false;
    // trash listing pages
    $exists_options = get_option( 'citybook-addons-options', array() );
    if(isset($exists_options['dashboard_page'])){
        wp_delete_post($exists_options['dashboard_page'], $force_delete);
    }
    if(isset($exists_options['submit_page'])){
        wp_delete_post($exists_options['submit_page'], $force_delete);
    }
    if(isset($exists_options['edit_page'])){
        wp_delete_post($exists_options['edit_page'], $force_delete);
    }
    // if(isset($exists_options['payment_page'])){
    //     wp_delete_post($exists_options['payment_page'], $force_delete);
    // }
    if(isset($exists_options['checkout_page'])){
        wp_delete_post($exists_options['checkout_page'], $force_delete);
    }

    // delete_option( 'citybook-addons-version');
    
}
register_deactivation_hook( __FILE__, 'citybook_addons_deactivation_hook_callback' );


/* Enable shortcode in widget text content */
add_filter('widget_text', 'do_shortcode');

if(!function_exists('faicon_sc')) {

    function faicon_sc( $atts, $content="" ) {
    
        extract(shortcode_atts(array(
               'name' =>"magic",
               'class'=>'',
         ), $atts));

        $name = str_replace(array("fa fa-","fa-"), "", $name);

        $classes = 'fa fa-'.$name;
        if(!empty($class)){
            $classes .= ' '.$class;
        }
        
        return '<i class="'.$classes.'"></i>'. $content;
     
    }
        
    add_shortcode( 'faicon', 'faicon_sc' ); //Icon
}
if(!function_exists('citybook_instagram_sc')){
    function citybook_instagram_sc($atts, $content = ''){

        extract(shortcode_atts(array(
               'limit' =>"6",
               'get'=>'user',//tagged
               'clientid'=>'5d9aa6ad29704bcb9e7e151c9b7afcbc',
               'access'=>'3075034521.5d9aa6a.284ff8339f694dbfac8f265bf3e93c8a',
               'userid'=>'3075034521',
               'tagged'=>'citybook-add-ons',
               'resolution'=>'thumbnail',
               'columns'=>'3'
         ), $atts));

        if($get == 'tagged'){
            $getval = $tagged;
        }else if($get == 'user'){
            $getval = $userid;
        }else {
            $getval = 'popular';
        }

        ob_start();

        ?>

        <div class="cththemes-instafeed grid-cols-<?php echo esc_attr($columns );?>" data-limit="<?php echo esc_attr($limit );?>" data-get="<?php echo esc_attr($get );?>" data-getval="<?php echo esc_attr($getval );?>" data-client="<?php echo esc_attr($clientid );?>" data-access="<?php echo esc_attr($access );?>" data-res="<?php echo esc_attr($resolution );?>"><div class='cth-insta-thumb'><ul class="cththemes-instafeed-ul" id="<?php echo uniqid('cththemes-instafeed');?>"></ul></div></div>

        <?php

        $output = ob_get_clean();

        return $output;

    }

    //add_shortcode( 'citybook_instagram', 'citybook_instagram_sc' ); 
}

if(!function_exists('citybook_subscribe_callback')) {

    function citybook_subscribe_callback( $atts, $content="" ) {
        
        extract(shortcode_atts(array(
           'class'=>'',
           // 'title'=>'Newsletter',
           'message'=>__( '<p>Want to be notified when we launch a new template or an udpate. Just  send you a notification by email.</p>', 'citybook-add-ons' ),
           'placeholder'=>__( 'Your Email', 'citybook-add-ons' ),
           'button'=>__( 'Submit', 'citybook-add-ons' ),
           'list_id' => '',
        ), $atts));

        $return = '';

        ob_start();
        ?>
        
        <div class="subscribe-form <?php echo esc_attr( $class ); ?>">
            <?php echo $message; ?>
            <form class="citybook_mailchimp-form">
                <input class="enteremail" id="subscribe-email" name="email" placeholder="<?php echo esc_attr( $placeholder ); ?>" type="email" required="required">
                <button type="submit" class="subscribe-button"><i class="fa fa-rss"></i> <?php echo esc_html( $button ); ?></button>
                <label for="subscribe-email" class="subscribe-message"></label>
                <?php if ( function_exists( 'wp_create_nonce' ) ) { ?>
                <input type="hidden" name="_nonce" value="<?php echo wp_create_nonce( 'citybook_mailchimp' ) ?>">
                <?php } 
                if($list_id !=''){ ?>
                <input type="hidden" name="_list_id" value="<?php echo esc_attr( $list_id ); ?>">
                <?php } ?>
            </form>
        </div>
        <?php  
        return ob_get_clean();
            
    }
        
    add_shortcode( 'citybook_subscribe', 'citybook_subscribe_callback' ); //Mailchimp

}

if(!function_exists('citybook_tweets_sc')){
    function citybook_tweets_sc($atts, $content = ''){

        extract(shortcode_atts(array(
               'username' =>'',
               'list'=>'',
               'hashtag'=>'',
               'count'=>'3',
               'list_ticker'=>'no',
               'follow_url' => '',
               'extraclass'=>''
         ), $atts));

        if ( $count =='')
            $count = 3;

        ob_start();

        ?>
        <div class="tweet citybook-tweet tweet-count-<?php echo esc_attr($count );?> tweet-ticker-<?php echo esc_attr($list_ticker );?>" data-username="<?php echo esc_attr($username );?>" data-list="<?php echo esc_attr($list );?>" data-hashtag="<?php echo esc_attr($hashtag );?>" data-ticker="<?php echo esc_attr($list_ticker );?>" data-count="<?php echo esc_attr($count );?>"></div>
        <?php 
        if($follow_url != '') : ?>
        <div class="follow-wrap">
            <a  href="<?php echo esc_url( $follow_url );?>" target="_blank" class="twiit-button"><i class="fa fa-twitter"></i><?php _e(' Follow Us','citybook-add-ons');?></a>  
        </div>
        <?php endif;?>
        <?php

        $output = ob_get_clean();

        return $output;

    }

    add_shortcode( 'citybook_tweets', 'citybook_tweets_sc' ); 
}