<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * Template part for displaying image posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

?>
<!-- article> --> 
<article id="post-<?php the_ID(); ?>" <?php post_class('fl-wrap ptype-content-image fw-post'); ?>>
	<?php
	if(has_post_thumbnail( )){ ?>
	<div class="list-single-main-media fl-wrap">
        <a href="<?php the_permalink( ); ?>" class="blog-thumb-link">
        	<?php the_post_thumbnail('citybook-featured-image',array('class'=>'respimg') ); ?>
        </a>
    </div>
	<?php } ?>

    <div class="list-single-main-item fl-wrap">
        <div class="list-single-main-item-title fl-wrap">
        	<?php 
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
			citybook_edit_link( get_the_ID() );
			?>
        </div>
        <?php the_excerpt();?>
        <?php
			wp_link_pages( array(
			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'citybook' ) . '</span>',
			'after'       => '</div>',
			'link_before' => '<span>',
			'link_after'  => '</span>',
			) );
		?>
		<?php if( citybook_get_option( 'blog_author') ):?>
		<div class="post-author">
			<?php 
                echo get_avatar(get_the_author_meta('user_email'), '80', 'http://0.gravatar.com/avatar/ad516503a11cd5ca435acc9bb6523536?s=80', get_the_author_meta( 'display_name' ) );
            ?>
            <?php esc_html_e( 'By, ',  'citybook' ) ; the_author_posts_link( );?>
        </div>
		<?php endif;?>


		<?php if( citybook_get_option( 'blog_date' )  || citybook_get_option( 'blog_cats' ) || citybook_get_option( 'blog_comments' )  ):?>
	    <div class="post-opt">
	    	<ul class="blog-title-opt">
		        <?php if( citybook_get_option( 'blog_date') ) :?>
				<li><i class="fa fa-calendar-check-o"></i><span><?php the_time(get_option('date_format'));?></span></li>
				<?php endif;?>
				
				<?php if( function_exists('citybook_addons_get_post_views') ) :?>
				<li><i class="fa fa-eye"></i> <span><?php echo citybook_addons_get_post_views(get_the_ID());?></span></li>
				<?php endif;?>

		        <?php if( citybook_get_option( 'blog_cats' ) ) :?>
					<?php if(get_the_category( )) { ?>
					<li><i class="fa fa-tags"></i><?php the_category( ' , ' ); ?></li>	
					<?php } ?>	
				<?php endif;?>

				<?php if( citybook_get_option( 'blog_comments' ) ):?>
				<li><i class="fa fa-comments"></i> <?php comments_popup_link( esc_html_x('0 comment','comment counter None format' ,'citybook'), esc_html_x('1 comment','comment counter One format', 'citybook'), esc_html_x('% comments','comment counter Plural format', 'citybook') ); ?></li>
				<?php endif;?>

		    </ul>
		</div>
		<?php endif;?>
        
        <?php if( citybook_get_option( 'blog_tags' ) && get_the_tags( ) ) :?>
        <span class="fw-separator"></span>
		<div class="list-single-main-item-title fl-wrap">
            <h3><?php esc_html_e( 'Tags', 'citybook' ); ?></h3>
        </div>
		<div class="list-single-tags tags-stylwrap blog-tags">
            <?php the_tags('','','');?>                                                                          
        </div>
	    <?php endif;?>
        <span class="fw-separator"></span>
        <div class="readmore-post"><a href="<?php the_permalink();?>" class="btn transparent-btn float-btn"><?php esc_html_e('Read more ','citybook' );?><i class="fa fa-eye"></i></a></div>
    </div>
</article>
<!-- article end -->       
<span class="section-separator"></span>
