<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */
$show_page_title = get_post_meta(get_the_ID(),'_cth_show_page_title',true );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="list-single-main-item-title fl-wrap">
		<?php if($show_page_title != 'yes') the_title( '<h3 class="entry-title">', '</h3>' ); ?>
		<?php citybook_edit_link( get_the_ID() ); ?>
	</div><!-- .list-single-main-item-title-->
	<div class="entry-content clearfix">
		<?php
			the_content();
		?>
	</div><!-- .entry-content -->
	<?php
		wp_link_pages( array(
			'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'citybook' ),
			'after'  => '</div>',
		) );
	?>
</article><!-- #post-## -->
