<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


// remove default woo sidebar
remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );


//add action woo before main content
add_action( 'woocommerce_before_main_content', function(){
    ?>
    <!--section -->
    <section class="parallax-section cth-woo-head" data-scrollax-parent="true">
        <div class="bg par-elem"  data-bg="<?php echo esc_url( citybook_get_option('blog_header_image' ) );?>" data-scrollax="properties: { translateY: '30%' }"></div>
        <div class="overlay"></div>
        <div class="container">
            <div class="section-title center-align">
                <h1 class="head-sec-title"><span><?php woocommerce_page_title(); ?></span></h1>
                <?php do_action( 'citybook_shop_header'); ?>
                <span class="section-separator"></span>
            </div>
        </div>
        <div class="header-sec-link">
            <div class="container"><a href="#sec1" class="custom-scroll-link"><?php esc_html_e( 'Let\'s Start', 'citybook' ); ?></a></div>
        </div>
    </section>
    <!-- section end -->
    <?php
},2 );

add_filter( 'woocommerce_page_title', function($title){
    if(is_single()) $title = single_post_title('',false);
    return $title;
});

// change single title
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
add_action( 'woocommerce_single_product_summary', function(){
    the_title( '<h2 class="product_title entry-title">', '</h2>' );
}, 5 );


// function citybook_change_breadcrumb_home_text( $defaults ) {
//     // Change the breadcrumb home text from 'Home' to 'Apartment'
//     $defaults['home'] = '<i class="fa fa-home"></i>';
//     return $defaults;
// }

// //Change home text breadcrumb default
// add_filter( 'woocommerce_breadcrumb_defaults', 'citybook_change_breadcrumb_home_text',20 );


// function citybook_change_breadcrumb_delimiter( $defaults ) {
//     // Change the breadcrumb delimeter from '/' to '>'
//     $defaults['delimiter'] = ' ';
//     return $defaults;
// }
// //change delimiter bredcrumb defaults
// add_filter( 'woocommerce_breadcrumb_defaults', 'citybook_change_breadcrumb_delimiter', 20 );


// function citybook_change_breadcrumb_before_after($default)
// {
//     # code...
//     $default['before'] = '<div>';
//     $default['after'] = '</div>';
//     return $default;
// }
// //add filter change before after breadcrumb defaults
// add_filter( 'woocommerce_breadcrumb_defaults', 'citybook_change_breadcrumb_before_after', 20 );




// add woo shop layout
add_action( 'woocommerce_before_main_content', function(){
    $sb_w = citybook_get_option('blog-sidebar-width','4');
    add_action( 'citybook_shop_sidebar', 'woocommerce_get_sidebar' );
    ?>
    <section class="gray-section cth-shop-sec" id="sec1">
        <div class="container">
            <div class="row">
                <div class="col-md-<?php echo (12 - $sb_w);?> col-wrap">
    <?php
},5);

//add action woo after main content
add_action( 'woocommerce_after_main_content', function(){
    $sb_w = citybook_get_option('blog-sidebar-width','4');
    ?>
                </div>
                <!-- end col-md-9 -->
                <?php //if(citybook_get_option('blog_layout_citybook') =='right_sidebar'): ?>
                    <?php //if(!is_singular('product')): ?>
                        <div class="col-md-<?php echo esc_attr($sb_w );?> shop-sidebar-column">
                            <div class="shop-sidebar box-widget-wrap fl-wrap right-sidebar">
                                <?php do_action( 'citybook_shop_sidebar' ); ?>                
                            </div>
                        </div>
                    <?php //endif; ?>
                <?php //endif; ?>
            </div>
            <!-- end row -->
        </div>
        <!-- end container -->
    </section>
    <!-- end gray-section cth-shop-sec -->
    <?php
}, 30 );

// remove link open
// remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
// remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );

remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10 );


add_action( 'woocommerce_before_shop_loop_item', function(){
    ?>
    <div class="cth-woo-item-wrap">
        <div class="cth-woo-img"><?php do_action( 'cth-woo-product-top' ); ?></div><!-- .cth-woo-img -->
        <div class="cth-woo-content">
    <?php
}, 1 );

add_action( 'woocommerce_after_shop_loop_item', function(){
    ?>
        </div>
        <!-- .cth-woo-content -->
    </div>
    <!-- .cth-woo-item-wrap -->
    <?php
}, 99 );

// add_action('cth-woo-product-top', 'woocommerce_template_loop_product_link_open', 5);
// add_action('cth-woo-product-top', 'woocommerce_template_loop_product_link_close', 50);

add_action('cth-woo-product-top', 'woocommerce_template_loop_product_link_open', 5);
add_action('cth-woo-product-top', 'woocommerce_show_product_loop_sale_flash', 10);
add_action('cth-woo-product-top', 'woocommerce_template_loop_product_thumbnail', 10);
add_action('cth-woo-product-top', function(){
    echo '<div class="overlay"></div>';
}, 20);
add_action('cth-woo-product-top', 'woocommerce_template_loop_product_link_close', 30);


// //remove action after shop loop item tittle 5
// remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating',5 );
// //add action after shop loop item title 15
// add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating',15);

// define the woocommerce_pagination_args callback 
function citybook_woocommerce_pagination_args( $array ) { 
    // make filter magic happen here... 
    $array = array(
        'prev_text' => '<i class="fa fa-caret-left"></i>', 
        'next_text' => '<i class="fa fa-caret-right"></i>',
    );
    return $array; 
}; 
         
// add the filter 
add_filter( 'woocommerce_pagination_args', 'citybook_woocommerce_pagination_args', 10, 1 ); 


//remove action
remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
//add action woo breadcrumb
add_action( 'citybook_shop_header', 'woocommerce_breadcrumb');




