<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


//http://proteusthemes.github.io/one-click-demo-import/
//https://wordpress.org/plugins/one-click-demo-import/

function citybook_import_files() {
    return array(
        array(
            'import_file_name'             => esc_html__('CityBook theme - Full Demo Content (widgets included)','citybook' ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'inc/demo_data_files/all-content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . 'inc/demo_data_files/widgets.wie',
            'import_notice'                => esc_html__( 'CityBook theme - Full Demo Content (widgets included). After you import this demo, you will have to setup the front-page from Settings -> Reading screen and menu from Appearance -> Menus screen.', 'citybook' ),
        ),

    );
}
add_filter( 'pt-ocdi/import_files', 'citybook_import_files' );