<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * CityBook back compat functionality
 *
 * Prevents CityBook from running on WordPress versions prior to 4.7,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.7.
 *
 */

/**
 * Prevent switching to CityBook on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 * @since CityBook 1.0
 */
function citybook_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'citybook_upgrade_notice' );
}
add_action( 'after_switch_theme', 'citybook_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * CityBook on WordPress versions prior to 4.7.
 *
 * @since CityBook 1.0
 *
 * @global string $wp_version WordPress version.
 */
function citybook_upgrade_notice() {
	$message = sprintf( esc_html__( 'CityBook requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'citybook' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 *
 * @since CityBook 1.0
 *
 * @global string $wp_version WordPress version.
 */
function citybook_customize() {
	wp_die( sprintf( esc_html__( 'CityBook requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'citybook' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'citybook_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 *
 * @since CityBook 1.0
 *
 * @global string $wp_version WordPress version.
 */
function citybook_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'CityBook requires at least WordPress version 4.7. You are running version %s. Please upgrade and try again.', 'citybook' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'citybook_preview' );
