<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 */

                do_action( 'citybook_footer_before');
?>
    		

                </div>
                <!-- Content end -->
            </div>
            <!-- wrapper end -->
            <!--footer -->
            <footer class="citybook-footer main-footer dark-footer  ">
                <?php 
                $footer_widgets = citybook_get_option('footer_widgets',array());
                $has_active_fw = false;
                if ($footer_widgets ) {
                ?>
                <div class="container">
                    <div class="row fwids-row"><?php
                        foreach ($footer_widgets as $widget) {
                            if($widget['title']&&$widget['classes']){

                                $wgid = sanitize_title_with_dashes($widget['title']);

                                if(is_active_sidebar($wgid)){
                                
                                    echo '<div class="dynamic-footer-widget '.esc_attr($widget['classes'] ).'">';

                                        dynamic_sidebar($wgid);

                                    echo '</div>';

                                    $has_active_fw = true;

                                }

                            }
                        }
                    ?></div>
                </div>
                <?php
                }
                ?>
                
                <div class="sub-footer fl-wrap<?php echo ($has_active_fw)? ' has-fwids':' no-fwids';?>">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-4">
                                <?php
                                $footer_logo = citybook_get_option('footer_logo','');
                                if($footer_logo != ''):
                                ?>
                                <div class="about-widget">
                                    <?php echo wp_get_attachment_image( $footer_logo, 'full' ) ;?>
                                </div>
                                <?php 
                                endif;
                                ?>
                            </div>
                            <div class="col-md-4">
                                <?php 
                                get_template_part( 'template-parts/footer/site', 'info' );
                                ?>
                            </div>
                            <div class="col-md-4">
                                <?php
                                get_template_part( 'template-parts/footer/footer', 'socials' );
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!--footer end  -->
            
		
            <a class="to-top"><i class="fa fa-angle-up"></i></a>
        </div>
        <!-- Main end -->
        <?php wp_footer(); ?>
    </body>
</html>
