<?php
/**
 * @package CityBook - Directory Listing WordPress Theme
 * @author CTHthemes - http://themeforest.net/user/cththemes
 * @date 26-06-2019
 * @since 1.3.5
 * @version 1.3.5
 * @copyright Copyright ( C ) 2014 cththemes.com . All rights reserved.
 * @license GNU General Public License version 3 or later; see LICENSE
 */


/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 */


get_header(); 

?>
<!--  section  --> 
<section class="parallax-section" data-scrollax-parent="true" id="sec1">
    <div class="bg par-elem "  data-bg="<?php echo esc_url(citybook_get_option('error404_bg'));?>" data-scrollax="properties: { translateY: '30%' }"></div>
    <div class="overlay"></div>
    <div class="bubble-bg"></div>
    <div class="container">
        <div class="error-wrap">
            <h2><?php esc_html_e( '404','citybook' ); ?></h2>
            <?php echo citybook_get_option('error404_msg');?>
            <div class="clearfix"></div>
            <?php get_search_form();?>
            <div class="clearfix"></div>
            <?php 
            if (citybook_get_option('error404_btn')) : 
            ?>
                <p><?php esc_html_e( 'Or', 'citybook' );?></p>
                <a href="<?php echo esc_url( home_url() );?>" class="btn big-btn color-bg flat-btn" ><?php esc_html_e( 'Back to Home Page', 'citybook' ); ?> <i class="fa fa-angle-right"></i></a> 
            <?php 
            endif; ?>
        </div>
    </div>
</section>
<!--  section  end--> 

<div class="limit-box"></div>

<?php get_footer();
