<?php 
/* import_addon_php */

function citybook_import_addon_socials($prefix = '',$citybook_import_addon){
	// global $citybook_import_addon;

	$socials = citybook_addons_get_socials_list();

	$fields = array();
	foreach ($socials as $val => $lbl) {
		$fields[] = $citybook_import_addon->add_field( $prefix.'_'.$val, $lbl, 'text', null, '' );
    }

	return $fields;
}


function citybook_import_addon_working_hours($prefix = '',$citybook_import_addon){
	// global $citybook_import_addon;

	$fields = array(
		$citybook_import_addon->add_field(
			$prefix.'tz', 
			__( 'Timezone String. Default is your site timezone. Ex: America/New_York.<br><a href="http://php.net/manual/en/timezones.php" target="_blank">Available values</a>', 'citybook-import-addon' ), 
			'text', 
			array(), 
			'', 
			true, 
			get_option( 'timezone_string', 'Europe/London' )
		)
	);
	foreach (citybook_addons_get_working_days_array() as $dayname => $lbl) {
		$fields[] = $citybook_import_addon->add_field(
				$prefix.'status_'.$dayname, 
				sprintf(__( '%s - Status', 'citybook-import-addon' ), $lbl ), 
				'radio', 
				array(
					'enterHours' => __( 'Enter Hours', 'citybook-import-addon' ),
					'openAllDay' => __( 'Open all day', 'citybook-import-addon' ),
					'closeAllDay' => __( 'Close all day', 'citybook-import-addon' ),
				), 
				'', 
				true, 
				'enterHours'
			);
		$fields[] = $citybook_import_addon->add_field(
				$prefix.'hours_'.$dayname, 
				sprintf(__( '%s - Hours ( Format: open_hour-close_hour and multiple hours are separated by a space.<br>Ex: 8:00-18:00 or 8:00-12:00 13:30-18:00)', 'citybook-import-addon' ), $lbl ), 
				'text', 
				array(), 
				'', 
				true, 
				'8:00-12:00 13:30-18:00'
			);

    }

	return $fields;

}

function citybook_addons_get_listing_header_types($citybook_import_addon){
	// global $citybook_import_addon;

	return array(
		'bgimage' => 	__( 'Background Image', 'citybook-import-addon' ),
		'bgvideo' => 	array(
	                        __( 'Background Video', 'citybook-import-addon' ),
	                        $citybook_import_addon->add_field( 'headerbg_youtube', __( 'Youtube Video ID. Ex: Hg5iNVSp2z8', 'citybook-import-addon' ), 'text' ),
	                        $citybook_import_addon->add_field( 'headerbg_vimeo', __( 'Or Vimeo Video ID. Ex: 97871257', 'citybook-import-addon' ), 'text' ),
	                        $citybook_import_addon->add_field( 'headerbg_mp4', __( 'Or Vimeo URL (.MP4)', 'citybook-import-addon' ), 'text' ),
		                ),
		'carousel' => 	__( 'Carousel', 'citybook-import-addon' ),
		

	);
}
// header images action
// this action callback is automatically call by WP ALL IMPORT for pmxi__cth_listing_header_imgs action with pmxi_ prefix
function _cth_listing_header_imgs($post_id,$attachment_id,$attachment_path,$action_type){
	global $citybook_import_addon;
	// $action_type = 'update_images'
	$meta_field = '_cth_headerimgs';

	$meta_val = get_post_meta( $post_id, $meta_field, true );
	if( is_array($meta_val) ){
		$meta_val[] = $attachment_id;
		$meta_val = implode(",", $meta_val);
	}else{
		$meta_val .= ','.$attachment_id;
	}

	$meta_val = trim($meta_val, " ,");

	update_post_meta( $post_id, $meta_field, $meta_val );

}
// listing slider images
// callback for pmxi__cth_listing_header_imgs
function _cth_listing_slider_imgs($post_id,$attachment_id,$attachment_path,$action_type){
	global $citybook_import_addon;
	// $action_type = 'update_images'
	$meta_field = '_cth_slider_imgs';

	$meta_val = get_post_meta( $post_id, $meta_field, true );
	if( is_array($meta_val) ){
		$meta_val[] = $attachment_id;
		$meta_val = implode(",", $meta_val);
	}else{
		$meta_val .= ','.$attachment_id;
	}

	$meta_val = trim($meta_val, " ,");

	update_post_meta( $post_id, $meta_field, $meta_val );
	

}
// listing gallery images
// callback for pmxi__cth_listing_gallery_imgs
function _cth_listing_gallery_imgs($post_id,$attachment_id,$attachment_path,$action_type){
	global $citybook_import_addon;
	// $action_type = 'update_images'
	$meta_field = '_cth_gallery_imgs';

	$meta_val = get_post_meta( $post_id, $meta_field, true );
	if( is_array($meta_val) ){
		$meta_val[] = $attachment_id;
		$meta_val = implode(",", $meta_val);
	}else{
		$meta_val .= ','.$attachment_id;
	}

	$meta_val = trim($meta_val, " ,");

	update_post_meta( $post_id, $meta_field, $meta_val );
	

}


function listing_coordinates($citybook_import_addon){
	// global $citybook_import_addon;

	return 
        array(
                'search_by_address' => array(
                        __( 'Search by Address', 'citybook-import-addon' ),
                        $citybook_import_addon->add_field(
                                'google_api_key',
                                __( 'Google Developers API Key - Required services: Google Maps Geocoding API. And set your Google Application Restrictions to None: http://prntscr.com/kp1xhc', 'citybook-import-addon' ),
                                'text',
                                array(),
                                ''
                        ) 
                ), // end Search by Address radio field
                'enter_coordinates' => array(
                        __( 'Enter Coordinates', 'citybook-import-addon' ),
                        $citybook_import_addon->add_field( '_cth_latitude', __( 'Latitude', 'citybook-import-addon' ), 'text' ),
                        $citybook_import_addon->add_field( '_cth_longitude', __( 'Longitude', 'citybook-import-addon' ), 'text' )
                )
        );
}
